/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.File;
import java.io.PrintWriter;

public final class VUTrace {
    private boolean _init = false;
    private static ThreadLocal _threadNestingCount = new ThreadLocal();
    private static String _vuTraceFile = null;
    private static File _traceFile = null;
    private static PrintWriter _out = null;
    private String _package = null;
    private TraceComponent _tc = null;
    private int _vuEntryExitTrace = 0;
    private int _vuInformationalTrace = 0;
    private static final int ENTRY = 0;
    private static final int EXIT = 1;
    private static final int INFORMATION = 2;
    private static final char[] dotChar = new char[]{'{', '}'};

    public VUTrace(TraceComponent traceComponent, String string) {
        if (!this._init) {
            this._package = string;
            this._tc = traceComponent;
            this._init = true;
        }
    }

    public int getEntryExitIndicator() {
        return this._vuEntryExitTrace;
    }

    public int getInformationalIndicator() {
        return this._vuInformationalTrace;
    }

    public void entry(Object object, String string, String string2) {
        if (this._tc.isEntryEnabled()) {
            String string3 = new String("[static]");
            if (object != null) {
                Class<?> clazz = object.getClass();
                string3 = clazz.getName();
            }
            this.entry(string3, string, string2);
        }
    }

    public void entry(String string, String string2, String string3) {
        if (this._tc.isEntryEnabled()) {
            Tr.entry(this._tc, string + "." + string2 + ": " + string3);
        }
    }

    public void exception(Object object, String string, String string2) {
        this.information(object, "!!!Exception: " + string2, true);
        this.exit(object, string, "");
    }

    public void exception(String string, String string2, String string3) {
        this.information(string, "!!!Exception: " + string3, true);
        this.exit(string, string2, "");
    }

    public void exit(Object object, String string, String string2) {
        if (this._tc.isEntryEnabled()) {
            String string3 = new String("[static]");
            if (object != null) {
                Class<?> clazz = object.getClass();
                string3 = clazz.getName();
            }
            this.exit(string3, string, string2);
        }
    }

    public void exit(String string, String string2, String string3) {
        if (this._tc.isEntryEnabled()) {
            Tr.exit(this._tc, string + "." + string2 + ": " + string3);
        }
    }

    public void information(Object object, String string, String string2) {
        if (this._tc.isDebugEnabled()) {
            String string3 = new String("[static]");
            if (object != null) {
                Class<?> clazz = object.getClass();
                string3 = clazz.getName();
            }
            this.information(string3, string, string2, false);
        }
    }

    private void information(String string, String string2, String string3) {
        this.information(string, string2, string3, false);
    }

    public void information(Object object, String string, String string2, boolean bl) {
        if (this._tc.isDebugEnabled()) {
            String string3 = new String("[static]");
            if (object != null) {
                Class<?> clazz = object.getClass();
                string3 = clazz.getName();
            }
            this.information(string3, string, string2, bl);
        }
    }

    public void information(Object object, String string) {
        if (this._tc.isDebugEnabled()) {
            String string2 = new String("[static]");
            if (object != null) {
                Class<?> clazz = object.getClass();
                string2 = clazz.getName();
            }
            this.information(string2, string, false);
        }
    }

    private void information(String string, String string2) {
        this.information(string, string2, false);
    }

    public void information(Object object, String string, boolean bl) {
        if (this._tc.isDebugEnabled() || this._tc.isEventEnabled()) {
            String string2 = new String("[static]");
            if (object != null) {
                Class<?> clazz = object.getClass();
                string2 = clazz.getName();
            }
            this.information(string2, string, bl);
        }
    }

    private void information(String string, String string2, boolean bl) {
        if (bl) {
            if (this._tc.isEventEnabled()) {
                Tr.event(this._tc, string2);
            }
        } else if (this._tc.isDebugEnabled()) {
            Tr.debug(this._tc, string + " : " + string2);
        }
    }

    public void information(String string, String string2, String string3, boolean bl) {
        if (this._tc.isDebugEnabled()) {
            Tr.debug(this._tc, string + "." + string2 + " : " + string3);
        }
    }

    public void message(String string) {
        Tr.error(this._tc, string);
    }

    public void message(String string, Object object) {
        Tr.error(this._tc, string, object);
    }
}

