/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import java.util.HashMap;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class Dialog
extends Window {
    public static final String DLG_IMG_ERROR = "dialog_error_image";
    public static final String DLG_IMG_INFO = "dialog_info_image";
    public static final String DLG_IMG_QUESTION = "dialog_question_image";
    public static final String DLG_IMG_WARNING = "dialog_warning_image";
    public static final String DLG_IMG_MESSAGE_INFO = "dialog_messasge_info_image";
    public static final String DLG_IMG_MESSAGE_WARNING = "dialog_messasge_warning_image";
    public static final String DLG_IMG_MESSAGE_ERROR = "dialog_message_error_image";
    protected Control dialogArea;
    protected Control buttonBar;
    private HashMap buttons = new HashMap();
    private FontMetrics fontMetrics;
    private static final int HORIZONTAL_DIALOG_UNIT_PER_CHAR = 4;
    private static final int VERTICAL_DIALOG_UNITS_PER_CHAR = 8;
    static /* synthetic */ Class class$0;

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.dialogs.Dialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        reg.put(DLG_IMG_INFO, ImageDescriptor.createFromFile(clazz, "images/inform.gif"));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.jface.dialogs.Dialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        reg.put(DLG_IMG_QUESTION, ImageDescriptor.createFromFile(clazz2, "images/question.gif"));
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.jface.dialogs.Dialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        reg.put(DLG_IMG_WARNING, ImageDescriptor.createFromFile(clazz3, "images/warning.gif"));
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("org.eclipse.jface.dialogs.Dialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        reg.put(DLG_IMG_ERROR, ImageDescriptor.createFromFile(clazz4, "images/error.gif"));
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("org.eclipse.jface.dialogs.Dialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        reg.put(DLG_IMG_MESSAGE_INFO, ImageDescriptor.createFromFile(clazz5, "images/message_info.gif"));
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("org.eclipse.jface.dialogs.Dialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        reg.put(DLG_IMG_MESSAGE_WARNING, ImageDescriptor.createFromFile(clazz6, "images/message_warning.gif"));
        Class<?> clazz7 = class$0;
        if (clazz7 == null) {
            try {
                clazz7 = class$0 = Class.forName("org.eclipse.jface.dialogs.Dialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        reg.put(DLG_IMG_MESSAGE_ERROR, ImageDescriptor.createFromFile(clazz7, "images/message_error.gif"));
    }

    public static int convertHeightInCharsToPixels(FontMetrics fontMetrics, int chars) {
        return fontMetrics.getHeight() * chars;
    }

    public static int convertHorizontalDLUsToPixels(FontMetrics fontMetrics, int dlus) {
        return (fontMetrics.getAverageCharWidth() * dlus + 2) / 4;
    }

    public static int convertVerticalDLUsToPixels(FontMetrics fontMetrics, int dlus) {
        return (fontMetrics.getHeight() * dlus + 4) / 8;
    }

    public static int convertWidthInCharsToPixels(FontMetrics fontMetrics, int chars) {
        return fontMetrics.getAverageCharWidth() * chars;
    }

    protected Dialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(67680);
        this.setBlockOnOpen(true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okPressed();
        } else if (1 == buttonId) {
            this.cancelPressed();
        }
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        this.close();
    }

    protected void constrainShellSize() {
        super.constrainShellSize();
        Shell shell = this.getShell();
        Point size = shell.getSize();
        Rectangle bounds = shell.getDisplay().getClientArea();
        Point loc = shell.getLocation();
        int x = Math.max(bounds.x, Math.min(loc.x, bounds.x + bounds.width - size.x));
        int y = Math.max(bounds.y, Math.min(loc.y, bounds.y + bounds.height - size.y));
        shell.setLocation(x, y);
    }

    protected int convertHeightInCharsToPixels(int chars) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels(this.fontMetrics, chars);
    }

    protected int convertHorizontalDLUsToPixels(int dlus) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return Dialog.convertHorizontalDLUsToPixels(this.fontMetrics, dlus);
    }

    protected int convertVerticalDLUsToPixels(int dlus) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return Dialog.convertVerticalDLUsToPixels(this.fontMetrics, dlus);
    }

    protected int convertWidthInCharsToPixels(int chars) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return Dialog.convertWidthInCharsToPixels(this.fontMetrics, chars);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Shell shell;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setData((Object)new Integer(id));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Dialog.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        button.setFont(parent.getFont());
        this.buttons.put(new Integer(id), button);
        this.setButtonLayoutData(button);
        return button;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(132);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setFont(JFaceResources.getDialogFont());
    }

    protected void initializeBounds() {
        Button defaultButton;
        Shell shell;
        String platform = SWT.getPlatform();
        if ("carbon".equals(platform) && (shell = this.getShell()) != null && (defaultButton = shell.getDefaultButton()) != null && this.isContained(this.buttonBar, (Control)defaultButton)) {
            defaultButton.moveBelow(null);
        }
        super.initializeBounds();
    }

    private boolean isContained(Control container, Control c) {
        Composite parent;
        while ((parent = c.getParent()) != null) {
            if (parent == container) {
                return true;
            }
            c = parent;
        }
        return false;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)composite);
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        return composite;
    }

    protected Button getButton(int id) {
        return (Button)this.buttons.get(new Integer(id));
    }

    protected Control getButtonBar() {
        return this.buttonBar;
    }

    protected Button getCancelButton() {
        return this.getButton(1);
    }

    protected Control getDialogArea() {
        return this.dialogArea;
    }

    public static Image getImage(String key) {
        return JFaceResources.getImageRegistry().get(key);
    }

    protected Button getOKButton() {
        return this.getButton(0);
    }

    protected void initializeDialogUnits(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    protected void okPressed() {
        this.setReturnCode(0);
        this.close();
    }

    protected void setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
    }

    protected void setButtonLayoutFormData(Button button) {
        FormData data = new FormData();
        data.height = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.width = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
    }

    public boolean close() {
        boolean returnValue = super.close();
        if (returnValue) {
            this.buttons = new HashMap();
            this.buttonBar = null;
            this.dialogArea = null;
        }
        return returnValue;
    }

    public static void applyDialogFont(Control control) {
        if (control == null) {
            return;
        }
        Font dialogFont = JFaceResources.getDialogFont();
        Font defaultFont = JFaceResources.getDefaultFont();
        Dialog.applyDialogFont(control, dialogFont, defaultFont);
    }

    private static void applyDialogFont(Control control, Font dialogFont, Font defaultFont) {
        if (control.getFont().equals((Object)defaultFont)) {
            control.setFont(dialogFont);
        }
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length) {
                Dialog.applyDialogFont(children[i], dialogFont, defaultFont);
                ++i;
            }
        }
    }
}

