/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;

public class StructuredSelection
implements IStructuredSelection {
    private Object[] elements;
    public static final StructuredSelection EMPTY = new StructuredSelection();

    public StructuredSelection() {
    }

    public StructuredSelection(Object[] elements) {
        this.elements = new Object[elements.length];
        System.arraycopy(elements, 0, this.elements, 0, elements.length);
    }

    public StructuredSelection(Object element) {
        Assert.isNotNull(element);
        this.elements = new Object[]{element};
    }

    public StructuredSelection(List elements) {
        Assert.isNotNull(elements);
        this.elements = elements.toArray();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StructuredSelection)) {
            return false;
        }
        StructuredSelection s2 = (StructuredSelection)o;
        if (this.elements == null) {
            return s2.elements == null;
        }
        if (s2.elements == null) {
            return false;
        }
        int myLen = this.elements.length;
        if (myLen != s2.elements.length) {
            return false;
        }
        int i = 0;
        while (i < myLen) {
            if (!this.elements[i].equals(s2.elements[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object getFirstElement() {
        return this.isEmpty() ? null : this.elements[0];
    }

    public boolean isEmpty() {
        return this.elements == null || this.elements.length == 0;
    }

    public Iterator iterator() {
        return Arrays.asList(this.elements == null ? new Object[]{} : this.elements).iterator();
    }

    public int size() {
        return this.elements == null ? 0 : this.elements.length;
    }

    public Object[] toArray() {
        return this.elements == null ? new Object[]{} : (Object[])this.elements.clone();
    }

    public List toList() {
        return Arrays.asList(this.elements == null ? new Object[]{} : this.elements);
    }

    public String toString() {
        return this.isEmpty() ? JFaceResources.getString("<empty_selection>") : this.toList().toString();
    }
}

