/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import com.ibm.ejs.util.Bucket;
import com.ibm.ejs.util.Element;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class FastHashtable
extends Dictionary {
    protected Bucket[] buckets;
    protected int size = 0;

    public FastHashtable(int n) {
        this.buckets = new Bucket[n];
        for (int i = 0; i < n; ++i) {
            this.buckets[i] = new Bucket();
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object getLock(Object object) {
        return this.getBucketForKey(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        Bucket bucket;
        Bucket bucket2 = bucket = this.getBucketForKey(object);
        synchronized (bucket2) {
            Element element = bucket.findByKey(object);
            return element != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        Bucket bucket;
        Bucket bucket2 = bucket = this.getBucketForKey(object);
        synchronized (bucket2) {
            Element element = bucket.findByKey(object);
            return element != null ? element.object : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        Bucket bucket = this.getBucketForKey(object);
        Element element = null;
        Object object2 = bucket;
        synchronized (object2) {
            element = bucket.removeByKey(object);
        }
        if (element != null) {
            object2 = this;
            synchronized (object2) {
                --this.size;
            }
            return element.object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        Object object3 = this;
        synchronized (object3) {
            ++this.size;
        }
        Object object4 = object3 = this.getBucketForKey(object);
        synchronized (object4) {
            Element element = ((Bucket)object3).replaceByKey(object, object2);
            return element != null ? element.object : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object object, Object object2) {
        Object object3 = this;
        synchronized (object3) {
            ++this.size;
        }
        Object object4 = object3 = this.getBucketForKey(object);
        synchronized (object4) {
            ((Bucket)object3).addByKey(object, object2);
        }
    }

    public final Enumeration elements() {
        return new ObjectEnumerator();
    }

    public final Enumeration keys() {
        return new KeyEnumerator();
    }

    public synchronized void clear() {
        this.size = 0;
        this.buckets = new Bucket[this.buckets.length];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new Bucket();
        }
    }

    protected final Bucket getBucketForKey(Object object) {
        return this.buckets[(object.hashCode() & Integer.MAX_VALUE) % this.buckets.length];
    }

    public Object get(Object object, Object object2) {
        Element element = ((Bucket)object).findByKey(object2);
        return element != null ? element.object : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2, Object object3) {
        Object object4 = this;
        synchronized (object4) {
            ++this.size;
        }
        object4 = ((Bucket)object).replaceByKey(object2, object3);
        return object4 != null ? ((Element)object4).object : null;
    }

    class KeyEnumerator
    extends ElementEnumerator {
        KeyEnumerator() {
        }

        public Object nextElement() {
            return ((Element)super.nextElement()).key;
        }
    }

    class ObjectEnumerator
    extends ElementEnumerator {
        ObjectEnumerator() {
        }

        public Object nextElement() {
            return ((Element)super.nextElement()).object;
        }
    }

    class ElementEnumerator
    implements Enumeration {
        private int bucketIndex = 0;
        private Enumeration bucketContents;

        ElementEnumerator() {
        }

        public boolean hasMoreElements() {
            if (this.bucketContents != null && this.bucketContents.hasMoreElements()) {
                return true;
            }
            return this.findNextBucket();
        }

        public Object nextElement() {
            if (!(this.bucketContents != null && this.bucketContents.hasMoreElements() || this.findNextBucket())) {
                throw new NoSuchElementException();
            }
            while (true) {
                try {
                    return this.bucketContents.nextElement();
                }
                catch (NoSuchElementException noSuchElementException) {
                    FFDCFilter.processException((Throwable)noSuchElementException, "com.ibm.ejs.util.FastHashtable.nextElement", "267", this);
                    if (this.findNextBucket()) continue;
                    throw new NoSuchElementException();
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean findNextBucket() {
            this.bucketContents = null;
            while (this.bucketIndex < FastHashtable.this.buckets.length) {
                Bucket bucket;
                Bucket bucket2 = bucket = FastHashtable.this.buckets[this.bucketIndex++];
                synchronized (bucket2) {
                    if (bucket.size() > 0) {
                        this.bucketContents = bucket.elements();
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

