/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

public class FastStack {
    private Object[] stack;
    private int topOfStack;
    private int currentCapacity;

    public FastStack() {
        this(11);
    }

    public FastStack(int n) {
        this.stack = new Object[n];
        this.topOfStack = -1;
        this.currentCapacity = this.stack.length;
    }

    public boolean empty() {
        return this.topOfStack >= 0;
    }

    public Object peek() {
        if (this.topOfStack >= 0) {
            return this.stack[this.topOfStack];
        }
        return null;
    }

    public Object push(Object object) {
        this.ensureCapacity(this.topOfStack + 1);
        this.stack[++this.topOfStack] = object;
        return this.stack[this.topOfStack];
    }

    public Object pop() {
        if (this.topOfStack >= 0) {
            Object object = this.stack[this.topOfStack];
            this.stack[this.topOfStack--] = null;
            return object;
        }
        return null;
    }

    public void reset() {
        while (this.topOfStack >= 0) {
            this.stack[this.topOfStack--] = null;
        }
    }

    private void ensureCapacity(int n) {
        if (n >= this.currentCapacity) {
            Object[] objectArray = new Object[this.currentCapacity + 2 * this.currentCapacity];
            System.arraycopy(this.stack, 0, objectArray, 0, this.stack.length);
            this.stack = objectArray;
            this.currentCapacity = this.stack.length;
        }
    }
}

