/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import java.text.SimpleDateFormat;
import java.util.Date;

public class MathUtil {
    public static final int MAX_PRIME_INTEGER = 2147482661;

    private MathUtil() {
    }

    public static int findNextPrime(int n) {
        if (n <= 2) {
            return 2;
        }
        if (MathUtil.isEven(n)) {
            ++n;
        }
        if (n > 2147482661) {
            return n;
        }
        for (int i = n; i < n + 1000; i += 2) {
            if (!MathUtil.isPrime(i)) continue;
            return i;
        }
        return n;
    }

    public static boolean isPrime(int n) {
        if (n == 2 || n == 3 || n == 5 || n == 7 || n == 11 || n == 13 || n == 17 || n == 19) {
            return true;
        }
        if (n % 2 == 0 || n % 3 == 0 || n % 5 == 0 || n % 7 == 0 || n % 11 == 0 || n % 13 == 0 || n % 17 == 0 || n % 19 == 0) {
            return false;
        }
        long l = n - 1;
        long l2 = 0L;
        long l3 = l;
        while (MathUtil.isEven(l3)) {
            l3 /= 2L;
            ++l2;
        }
        long l4 = l3;
        for (int i = 2; i <= 5; ++i) {
            if (i == 4) continue;
            long l5 = 1L;
            long l6 = i;
            for (l3 = l4; l3 > 0L; l3 /= 2L) {
                if (MathUtil.isOdd(l3)) {
                    l5 = l5 * l6 % (long)n;
                }
                l6 = l6 * l6 % (long)n;
            }
            if (l5 == 1L || l5 == l) continue;
            for (long j = 1L; j <= l2 && (l5 = l5 * l5 % (long)n) != l; ++j) {
            }
            if (l5 == l) continue;
            return false;
        }
        return n != 25326001 && n != 161304001 && n != 960946321 && n != 1157839381;
    }

    public static boolean isOdd(int n) {
        return MathUtil.isOdd((long)n);
    }

    public static boolean isOdd(long l) {
        return l % 2L != 0L;
    }

    public static boolean isEven(int n) {
        return MathUtil.isEven((long)n);
    }

    public static boolean isEven(long l) {
        return l % 2L == 0L;
    }

    public static void main(String[] stringArray) {
        System.out.println("Testing out findNextPrime()....................");
        Date date = new Date();
        int n = 0;
        int n2 = 100008;
        int n3 = 9;
        int[] nArray = new int[n3];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            n = MathUtil.findNextPrime(n);
            n4 = i % n3;
            nArray[n4] = n;
            if (n4 == n3 - 1) {
                String string = "Primes[" + (i + 1) + "] : ";
                for (int j = 0; j < n3; ++j) {
                    string = string + nArray[j];
                    if (j >= n3 - 1) continue;
                    string = string + ", ";
                }
                System.out.println(string);
            }
            switch (i + 1) {
                case 100: {
                    if (n == 541) break;
                    System.out.println("ERROR - findNextPrime not working!!!!!!!!!!!!!");
                    System.out.println("100th prime is 541, but found " + n);
                    System.exit(-1);
                    break;
                }
                case 1000: {
                    if (n == 7919) break;
                    System.out.println("ERROR - findNextPrime not working!!!!!!!!!!!!!");
                    System.out.println("1,000th prime is 7919, but found " + n);
                    System.exit(-1);
                    break;
                }
                case 10000: {
                    if (n == 104729) break;
                    System.out.println("ERROR - findNextPrime not working!!!!!!!!!!!!!");
                    System.out.println("10,000th prime is 104729, but found " + n);
                    System.exit(-1);
                    break;
                }
                case 100008: {
                    if (n == 1299827) break;
                    System.out.println("ERROR - findNextPrime not working!!!!!!!!!!!!!");
                    System.out.println("100,008th prime is 1299827, but found " + n);
                    System.exit(-1);
                }
            }
            ++n;
        }
        Date date2 = new Date();
        long l = date2.getTime() - date.getTime();
        Date date3 = new Date(l);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("mm:ss:SS");
        String string = simpleDateFormat.format(date3);
        System.out.println("Time to find " + n2 + " primes : " + string);
        System.exit(0);
    }
}

