/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import com.ibm.ejs.util.QueueElement;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Queue {
    protected QueueElement head = null;
    protected QueueElement tail = null;
    protected int numElements = 0;

    private static final void checkElementFree(QueueElement queueElement) {
    }

    public void addToHead(QueueElement queueElement) {
        Queue.checkElementFree(queueElement);
        if (this.head == null) {
            this.head = queueElement;
            this.tail = queueElement;
        } else {
            queueElement.previous = null;
            queueElement.next = this.head;
            this.head.previous = queueElement;
            this.head = queueElement;
        }
        queueElement.queue = this;
        ++this.numElements;
    }

    public void addToTail(QueueElement queueElement) {
        Queue.checkElementFree(queueElement);
        if (this.head == null) {
            this.head = queueElement;
            this.tail = queueElement;
            queueElement.queue = this;
        } else {
            queueElement.previous = this.tail;
            queueElement.next = null;
            this.tail.next = queueElement;
            this.tail = queueElement;
        }
        queueElement.queue = this;
        ++this.numElements;
    }

    public QueueElement removeHead() {
        if (this.head == null) {
            return null;
        }
        QueueElement queueElement = this.head;
        if (queueElement.next == null) {
            this.head = null;
            this.tail = null;
        } else {
            this.head = queueElement.next;
            this.head.previous = null;
        }
        queueElement.previous = null;
        queueElement.next = null;
        queueElement.queue = null;
        --this.numElements;
        return queueElement;
    }

    public QueueElement removeTail() {
        if (this.head == null) {
            return null;
        }
        QueueElement queueElement = this.tail;
        if (queueElement.previous == null) {
            this.head = null;
            this.tail = null;
        } else {
            this.tail = queueElement.previous;
            this.tail.next = null;
        }
        queueElement.previous = null;
        queueElement.next = null;
        queueElement.queue = null;
        --this.numElements;
        return queueElement;
    }

    public void remove(QueueElement queueElement) {
        if (this.head == queueElement) {
            this.removeHead();
        } else if (this.tail == queueElement) {
            this.removeTail();
        } else {
            queueElement.previous.next = queueElement.next;
            queueElement.next.previous = queueElement.previous;
            queueElement.previous = null;
            queueElement.next = null;
            queueElement.queue = null;
            --this.numElements;
        }
    }

    public int size() {
        return this.numElements;
    }

    public Enumeration elements() {
        return new QueueEnumeration(this.head);
    }

    class QueueEnumeration
    implements Enumeration {
        QueueElement current;

        public QueueEnumeration(QueueElement queueElement) {
            this.current = queueElement;
        }

        public boolean hasMoreElements() {
            return this.current != null;
        }

        public Object nextElement() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            QueueElement queueElement = this.current;
            this.current = this.current.next;
            return queueElement;
        }
    }
}

