/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;

public final class Util {
    static final String digits = "0123456789abcdef";
    public static Class[] noParameters = new Class[0];

    public static String identity(Object object) {
        if (object == null) {
            return "" + object;
        }
        return object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    public static boolean sameByteArray(byte[] byArray, byte[] byArray2) {
        return Util.equal(byArray, byArray2);
    }

    public static boolean equal(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] byteArray(String string) {
        return Util.byteArray(string, false);
    }

    public static byte[] byteArray(String string, boolean bl) {
        byte[] byArray = new byte[string.length() * (bl ? 2 : 1)];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = bl ? (byte)(string.charAt(i / 2) >> (i & 1) * 8) : (byte)string.charAt(i);
        }
        return byArray;
    }

    public static String toString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(digits.charAt(byArray[i] >> 4 & 0xF));
            stringBuffer.append(digits.charAt(byArray[i] & 0xF));
        }
        return stringBuffer.toString();
    }

    public static byte[] fromHexString(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)((digits.indexOf(string.charAt(2 * i)) << 4) + digits.indexOf(string.charAt(2 * i + 1)));
        }
        return byArray;
    }

    public static void Assert(boolean bl) {
        if (!bl) {
            throw new Fatal("assertion failure");
        }
    }

    public static void Exception() {
    }

    public static void Warning(String string) {
        System.out.println("TRAN WARNING: " + string);
    }

    public static void apply(Object[] objectArray, Executor executor) {
        Util.apply(objectArray, null, executor);
    }

    public static void apply(Object[] objectArray, Object object, Executor executor) {
        if (objectArray == null) {
            return;
        }
        executor.setContext(object);
        for (int i = 0; i < objectArray.length; ++i) {
            executor.execute(objectArray[i]);
        }
    }

    public static void apply(Vector vector, Executor executor) {
        Util.apply(vector, null, executor);
    }

    public static void apply(Vector vector, Object object, Executor executor) {
        if (vector == null) {
            return;
        }
        executor.setContext(object);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            executor.execute(enumeration.nextElement());
        }
    }

    public static Object[] extend(Object[] objectArray, Object[] objectArray2, Object object) {
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray[i] = objectArray2[i];
        }
        objectArray[objectArray2.length] = object;
        return objectArray;
    }

    public static Object extend(Object[] objectArray, Object object) {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Object object2 = Array.newInstance(object.getClass(), objectArray.length + 1);
        System.arraycopy(objectArray, 0, object2, 0, objectArray.length);
        ((Object[])object2)[objectArray.length] = object;
        return object2;
    }

    private static void println(String string) {
        System.out.println(string);
    }

    public static String dump(Object object, boolean bl, String string) {
        try {
            Class<?> clazz = object.getClass();
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl2 = true;
            do {
                Field[] fieldArray = clazz.getDeclaredFields();
                for (int i = 0; i < fieldArray.length; ++i) {
                    if (!bl2) {
                        stringBuffer.append(string);
                    }
                    stringBuffer.append(fieldArray[i].getName());
                    stringBuffer.append('=');
                    bl2 = false;
                    try {
                        Object object2 = fieldArray[i].get(object);
                        stringBuffer.append(object2 == null ? "null" : object2.toString());
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        FFDCFilter.processException(illegalAccessException, "com.ibm.ejs.util.Util.dump", "150");
                        try {
                            Method method = clazz.getDeclaredMethod(fieldArray[i].getName(), noParameters);
                            Object object3 = method.invoke(object, (Object[])noParameters);
                            stringBuffer.append(object3 == null ? "null" : object3.toString());
                            continue;
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ejs.util.Util.dump", "156");
                            stringBuffer.append("<inaccessible>");
                        }
                    }
                }
            } while (!bl || (clazz = clazz.getSuperclass()) != null);
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.util.Util.dump", "165");
            return "<exception " + throwable.toString() + ">";
        }
    }

    public class Executor {
        private Object context;

        final void setContext(Object object) {
            this.context = object;
        }

        final Object getContext() {
            return this.context;
        }

        void execute(Object object) {
        }
    }

    static class Fatal
    extends Error {
        Fatal(String string) {
            try {
                System.out.println("Fatal error: " + string);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.util.Util.Fatal", "85", this);
            }
        }
    }

    public static interface Dumpable {
        public String dump();
    }
}

