/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.archive.impl.ArchiveURIConverterImpl;
import com.ibm.ws.exception.WsRuntimeException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.xmi.ClassNotFoundException;
import org.eclipse.emf.ecore.xmi.FeatureNotFoundException;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.emf.ecore.xmi.UnresolvedReferenceException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MOFErrorHandler {
    private static TraceComponent tc = Tr.register("ConfigError", null, "com.ibm.ws.config.config");
    protected URI uri;
    protected Resource r;
    protected ArrayList errors = new ArrayList();
    protected ArrayList warnings = new ArrayList();

    public MOFErrorHandler(URI uRI) {
        this.uri = uRI;
    }

    public void startDocument(Resource resource) {
        this.r = resource;
    }

    public void warning(Exception exception) {
        this.warnings.add(exception);
    }

    public void error(Exception exception) {
        this.errors.add(exception);
    }

    public void fatalError(Exception exception) throws Exception {
        this.errors.add(exception);
        this.endDocument();
    }

    public void endDocument() {
        if (this.errors.size() > 0 || this.warnings.size() > 0) {
            int n;
            URIConverter uRIConverter = this.r.getResourceSet().getURIConverter();
            String string = null;
            if (uRIConverter instanceof ArchiveURIConverterImpl) {
                try {
                    string = ((ArchiveURIConverterImpl)uRIConverter).getArchive().getAbsolutePath();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            string = string + File.separator + this.uri.toFileString();
            this.logInfo("WSVR0300I", string);
            for (n = 0; n < this.errors.size(); ++n) {
                this.handleError(string, (Exception)this.errors.get(n));
            }
            for (n = 0; n < this.warnings.size(); ++n) {
                this.handleWarning(string, (Exception)this.warnings.get(n));
            }
            throw new WsRuntimeException("Parse failures for " + string);
        }
    }

    protected void handleWarning(String string, Exception exception) {
        if (exception instanceof ClassNotFoundException) {
            this.handleClassNotFoundWarning((ClassNotFoundException)exception);
        } else if (exception instanceof UnresolvedReferenceException) {
            this.handleUnresolvedReferenceWarning((UnresolvedReferenceException)exception);
        } else if (exception instanceof FeatureNotFoundException) {
            this.handleFeatureNotFoundWarning((FeatureNotFoundException)exception);
        } else if (exception instanceof PackageNotFoundException) {
            this.handlePackageNotFoundWarning((PackageNotFoundException)exception);
        } else if (exception instanceof SAXParseException) {
            this.handleSAXParseWarning(string, (SAXParseException)exception);
        } else if (exception instanceof SAXException) {
            this.handleSAXWarning(string, (SAXException)exception);
        } else {
            this.handleUnknownWarning(exception);
        }
    }

    protected void handleError(String string, Exception exception) {
        if (exception instanceof SAXParseException) {
            this.handleSAXParseError(string, (SAXParseException)exception);
        } else if (exception instanceof SAXException) {
            this.handleSAXError(string, (SAXException)exception);
        } else {
            this.handleUnknownError(exception);
        }
    }

    public void handleUnknownWarning(Exception exception) {
        this.logWarning("WSVR0311W", exception);
    }

    public void handleUnknownError(Exception exception) {
        this.logError("WSVR0312E", exception);
    }

    public void handleClassNotFoundWarning(ClassNotFoundException classNotFoundException) {
        this.logWarning("WSVR0303W", new Object[]{classNotFoundException.getName(), new Integer(classNotFoundException.getLine())});
    }

    public void handleFeatureNotFoundWarning(FeatureNotFoundException featureNotFoundException) {
        this.logWarning("WSVR0305W", new Object[]{featureNotFoundException.getName(), new Integer(featureNotFoundException.getLine())});
    }

    public void handlePackageNotFoundWarning(PackageNotFoundException packageNotFoundException) {
        this.logWarning("WSVR0308W", new Object[]{packageNotFoundException.uri(), new Integer(packageNotFoundException.getLine())});
    }

    public void handlePackageNotRegisteredError(PackageNotFoundException packageNotFoundException) {
        this.logError("WSVR0309E");
    }

    public void handleUnresolvedReferenceWarning(UnresolvedReferenceException unresolvedReferenceException) {
        this.logWarning("WSVR0310W", new Object[]{unresolvedReferenceException.getReference(), new Integer(unresolvedReferenceException.getLine())});
    }

    public void handleSAXParseWarning(String string, SAXParseException sAXParseException) {
        this.logWarning("WSVR0314E", new Object[]{string, new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()), sAXParseException});
    }

    public void handleSAXParseError(String string, SAXParseException sAXParseException) {
        this.logError("WSVR0314E", new Object[]{string, new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()), sAXParseException});
    }

    public void handleSAXWarning(String string, SAXException sAXException) {
        this.logWarning("WSVR0314E", new Object[]{string, "?", "?", sAXException});
    }

    public void handleSAXError(String string, SAXException sAXException) {
        this.logError("WSVR0314E", new Object[]{string, "?", "?", sAXException});
    }

    public void logInfo(String string) {
        Tr.info(tc, string);
    }

    public void logInfo(String string, Object object) {
        Tr.info(tc, string, object);
    }

    public void logWarning(String string) {
        Tr.warning(tc, string);
    }

    public void logWarning(String string, Object object) {
        Tr.warning(tc, string, object);
    }

    public void logError(String string) {
        Tr.error(tc, string);
    }

    public void logError(String string, Object object) {
        Tr.error(tc, string, object);
    }
}

