/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.HttpException;
import com.ibm.ws.http.HttpRequest;
import com.ibm.ws.http.HttpResponse;
import com.ibm.ws.http.HttpServer;
import com.ibm.ws.http.HttpTransport;
import com.ibm.ws.http.Logger;
import com.ibm.ws.io.ReadStream;
import com.ibm.ws.io.Stream;
import com.ibm.ws.io.WriteStream;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.TransportLogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.security.PrivilegedAction;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;

public class HttpConnection
implements Runnable {
    protected HttpRequest request = this.createHttpRequest();
    protected HttpResponse response = this.createHttpResponse();
    private static TraceComponent tc = Tr.register((class$com$ibm$ws$http$HttpConnection == null ? (class$com$ibm$ws$http$HttpConnection = HttpConnection.class$("com.ibm.ws.http.HttpConnection")) : class$com$ibm$ws$http$HttpConnection).getName(), "HTTP_Transport");
    private HttpServer httpServer = null;
    private HttpTransport transport = null;
    private InputStream inStream = null;
    private OutputStream outStream = null;
    private Stream stream = new Stream();
    private ReadStream readStream = new ReadStream();
    private WriteStream writeStream = new WriteStream();
    private Socket socket = null;
    private boolean allowKeepAlive;
    private boolean isKeptAlive;
    private boolean shouldStayAlive;
    private int curKeepAliveRequests;
    Logger logger;
    HttpServer httpserver;
    private boolean broken = false;
    static /* synthetic */ Class class$com$ibm$ws$http$HttpConnection;

    public void init(HttpTransport httpTransport, Socket socket) {
        this.transport = httpTransport;
        this.socket = socket;
        this.setFlushMode(false);
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    public HttpTransport getHttpTransport() {
        return this.transport;
    }

    public HttpRequest getHttpRequest() {
        return this.request;
    }

    public HttpResponse getHttpResponse() {
        return this.response;
    }

    public String getConnectionScheme() {
        return this.transport.getScheme();
    }

    public String getConnectionServerName() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return HttpConnection.this.socket.getLocalAddress().getHostName();
            }
        });
        if (string == null || string.equalsIgnoreCase("localhost")) {
            string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return InetAddress.getLocalHost().getHostName();
                    }
                    catch (Throwable throwable) {
                        HttpServer cfr_ignored_0 = HttpConnection.this.httpserver;
                        if (!HttpServer.errorLogDisable) {
                            Logger cfr_ignored_1 = HttpConnection.this.logger;
                            HttpServer cfr_ignored_2 = HttpConnection.this.httpserver;
                            Logger.log(1, "HTTP0400E Could not get Connection Server Name");
                        }
                        return null;
                    }
                }
            });
        }
        return string;
    }

    public int getConnectionServerPort() {
        return this.socket.getLocalPort();
    }

    public String getConnectionRemoteHost() {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return HttpConnection.this.socket.getInetAddress().getHostName();
            }
        });
    }

    public String getConnectionRemoteAddr() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public boolean isConnectionSecure() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Determining if Connection is Secure");
        }
        return this.transport.isSecure();
    }

    public java.security.cert.X509Certificate[] getConnectionPeerCertificates() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Getting Connection Peer Certificates (Client Certificates");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionPeerCertificates");
        }
        try {
            java.security.cert.X509Certificate[] x509CertificateArray = null;
            if (this.isConnectionSecure() && this.sslSocket().getNeedClientAuth()) {
                X509Certificate[] x509CertificateArray2 = null;
                try {
                    x509CertificateArray2 = this.sslSocket().getSession().getPeerCertificateChain();
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    if (!HttpServer.errorLogDisable) {
                        Logger.log(1, "HTTP0200E Could not Verify Client Certificate");
                    }
                    Tr.error(tc, "unverified client certificate", sSLPeerUnverifiedException);
                }
                if (x509CertificateArray2 != null) {
                    if (x509CertificateArray2 instanceof X509Certificate[]) {
                        if (HttpServer.debugEnabled) {
                            Logger.log(4, "HttpConnection: Client Certificate is instance of javax.security.cert.X509Certificate");
                        }
                        x509CertificateArray = this.convertCertificateChain(x509CertificateArray2);
                    } else {
                        x509CertificateArray = (java.security.cert.X509Certificate[])x509CertificateArray2;
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnectionPeerCertificates", x509CertificateArray);
            }
            if (HttpServer.debugEnabled) {
                Logger.log(4, "HttpConnection: Client Certificate Chain");
            }
            return x509CertificateArray;
        }
        catch (Exception exception) {
            if (!HttpServer.errorLogDisable) {
                Logger.log(1, "HTTP0201E Peer Ceritificate is Invalid");
            }
            Tr.error(tc, "invalid peer certificate: " + exception.getMessage());
            return null;
        }
    }

    private java.security.cert.X509Certificate[] convertCertificateChain(X509Certificate[] x509CertificateArray) throws Exception {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Converting Certificate Chain - inChain");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertCertificateChain", x509CertificateArray);
        }
        java.security.cert.X509Certificate[] x509CertificateArray2 = new java.security.cert.X509Certificate[x509CertificateArray.length];
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            x509CertificateArray2[i] = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(x509CertificateArray[i].getEncoded()));
        }
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Converted Certificate Chain-outChain");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertCertificateChain", x509CertificateArray2);
        }
        return x509CertificateArray2;
    }

    public String getConnectionCipherSuite() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionCipherSuite");
        }
        String string = null;
        if (this.isConnectionSecure()) {
            string = ((SSLSocket)this.socket).getSession().getCipherSuite();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionCipherSuite", string);
        }
        if (!HttpServer.errorLogDisable) {
            Logger.log(3, "HTTP0203I Connection Cipher Suite = " + string);
        }
        return string;
    }

    public Integer getAlgorithmBitSize() {
        Integer n = null;
        String string = this.getConnectionCipherSuite();
        if (string != null) {
            // empty if block
        }
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Cipher Suite Algorithm Bitsize = " + n);
        }
        return n;
    }

    public byte[] getConnectionSessionId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionSessionId");
        }
        byte[] byArray = null;
        if (this.isConnectionSecure()) {
            byArray = ((SSLSocket)this.socket).getSession().getId();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionSessionId", byArray);
        }
        return byArray;
    }

    private SSLSocket sslSocket() {
        return (SSLSocket)this.socket;
    }

    public boolean shouldSignalClose() {
        if (!(this.transport.isAlive() && this.transport.isKeepAlive() && this.allowKeepAlive && this.request.wantsToStayAlive())) {
            this.shouldStayAlive = false;
            return true;
        }
        int n = this.transport.getMaxKeepAliveRequests();
        if (n != 0 && ++this.curKeepAliveRequests > n) {
            this.shouldStayAlive = false;
            return true;
        }
        if (!this.isKeptAlive) {
            this.isKeptAlive = this.allowKeepAlive = this.httpServer.allocateKeepAlive();
            if (!this.allowKeepAlive) {
                this.shouldStayAlive = false;
                return true;
            }
        }
        return false;
    }

    public boolean getAllowKeepAlive() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Determine if allowing Keepalive");
        }
        return this.allowKeepAlive;
    }

    public void setAllowKeepAlive(boolean bl) {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Setting allowing Keepalive");
        }
        this.allowKeepAlive = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block83: {
            Throwable throwable2222;
            int n;
            String string;
            block74: {
                block73: {
                    boolean bl;
                    if (HttpServer.debugEnabled) {
                        Logger.log(4, "HttpConnection: Running Connection");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "run");
                    }
                    string = "unknown";
                    n = -1;
                    if (!HttpServer.errorLogDisable) {
                        Logger.log(3, "HTTP0400I Initializing Socket Input/Output Stream");
                    }
                    if (TransportLogger.debugEnabled()) {
                        TransportLogger.debug("HttpConnection.run(): thread started: " + Thread.currentThread().getName());
                        string = this.socket.getInetAddress().getHostAddress();
                        n = this.socket.getPort();
                        TransportLogger.debug("HttpConnection.run(): remoteAddress: " + string);
                        TransportLogger.debug("HttpConnection.run(): remotePort: " + n);
                    }
                    this.httpServer = this.transport.getHttpServer();
                    this.inStream = this.socket.getInputStream();
                    this.outStream = this.socket.getOutputStream();
                    this.stream.init(this.inStream, this.outStream);
                    this.readStream.init(this.stream);
                    this.writeStream.init(this.stream);
                    this.readStream.setDisableClose(true);
                    this.writeStream.setDisableClose(true);
                    this.request.init(this.readStream);
                    this.response.init(this.writeStream);
                    int n2 = this.transport.getConnectionIOTimeout();
                    int n3 = this.transport.getConnectionKeepAliveTimeout();
                    this.socket.setTcpNoDelay(this.transport.getTcpNoDelay());
                    this.socket.setSoTimeout(n2);
                    this.socket.setSoLinger(this.transport.getUseSoLinger(), this.transport.getSoLingerValue());
                    this.allowKeepAlive = true;
                    this.isKeptAlive = false;
                    this.shouldStayAlive = true;
                    this.curKeepAliveRequests = 0;
                    this.readAndHandleRequest(true);
                    boolean bl2 = bl = n2 != n3;
                    while (this.shouldStayAlive) {
                        if (bl) {
                            this.socket.setSoTimeout(n3);
                        }
                        if (this.readStream.read() != -1) {
                            this.readStream.unread();
                            if (bl) {
                                this.socket.setSoTimeout(n2);
                            }
                            this.readAndHandleRequest(false);
                            continue;
                        }
                        if (!HttpServer.errorLogDisable) {
                            Logger.log(2, "HTTP0400W error Reading data - Connection is being closed");
                        }
                        this.shouldStayAlive = false;
                    }
                    Object var7_10 = null;
                    if (TransportLogger.debugEnabled()) {
                        TransportLogger.debug("HttpConnection.run(): socket closed: remotePort=[" + n + "] remoteAddress=[" + string + "]");
                    }
                    try {
                        this.writeStream.setDisableClose(false);
                        this.writeStream.close();
                        this.outStream.close();
                    }
                    catch (Throwable throwable2222) {
                        if (HttpServer.errorLogDisable) break block73;
                        Logger.log(2, "HTTP0402W Could not Close Output Stream");
                    }
                }
                try {
                    this.readStream.setDisableClose(false);
                    this.readStream.close();
                    this.inStream.close();
                }
                catch (Throwable throwable2222) {
                    if (HttpServer.errorLogDisable) break block74;
                    Logger.log(2, "HTTP0403W Could not Close Input Stream");
                }
            }
            try {
                if (HttpServer.debugEnabled) {
                    Logger.log(4, "HttpConnection: Closing Socket");
                }
                this.socket.close();
            }
            catch (Throwable throwable2222) {
                if (!HttpServer.errorLogDisable) {
                    Logger.log(1, "HTTP0401E Could not Close Socket");
                }
            }
            finally {
                this.socket = null;
            }
            this.inStream = null;
            this.outStream = null;
            if (this.isKeptAlive) {
                try {
                    this.httpServer.freeKeepAlive();
                }
                catch (Throwable throwable2222) {
                    // empty catch block
                }
            }
            try {
                if (this.httpServer.freeConnection(this)) {
                    this.cleanup();
                }
            }
            catch (Throwable throwable2222) {
                // empty catch block
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
            break block83;
            {
                catch (IOException iOException) {
                    Throwable throwable32222;
                    block79: {
                        block78: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, iOException.getMessage(), iOException);
                            }
                            Object var7_11 = null;
                            if (TransportLogger.debugEnabled()) {
                                TransportLogger.debug("HttpConnection.run(): socket closed: remotePort=[" + n + "] remoteAddress=[" + string + "]");
                            }
                            try {
                                this.writeStream.setDisableClose(false);
                                this.writeStream.close();
                                this.outStream.close();
                            }
                            catch (Throwable throwable32222) {
                                if (HttpServer.errorLogDisable) break block78;
                                Logger.log(2, "HTTP0402W Could not Close Output Stream");
                            }
                        }
                        try {
                            this.readStream.setDisableClose(false);
                            this.readStream.close();
                            this.inStream.close();
                        }
                        catch (Throwable throwable32222) {
                            if (HttpServer.errorLogDisable) break block79;
                            Logger.log(2, "HTTP0403W Could not Close Input Stream");
                        }
                    }
                    try {
                        if (HttpServer.debugEnabled) {
                            Logger.log(4, "HttpConnection: Closing Socket");
                        }
                        this.socket.close();
                        this.socket = null;
                    }
                    catch (Throwable throwable32222) {
                        try {}
                        catch (Throwable throwable4) {
                            this.socket = null;
                            throw throwable4;
                        }
                        if (!HttpServer.errorLogDisable) {
                            Logger.log(1, "HTTP0401E Could not Close Socket");
                        }
                        this.socket = null;
                    }
                    this.inStream = null;
                    this.outStream = null;
                    if (this.isKeptAlive) {
                        try {
                            this.httpServer.freeKeepAlive();
                        }
                        catch (Throwable throwable32222) {
                            // empty catch block
                        }
                    }
                    try {
                        if (this.httpServer.freeConnection(this)) {
                            this.cleanup();
                        }
                    }
                    catch (Throwable throwable32222) {
                        // empty catch block
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "run");
                    }
                    break block83;
                }
                catch (Throwable throwable5) {
                    Throwable throwable62222;
                    block85: {
                        block84: {
                            String string2 = "HttpConnection.run: " + throwable5;
                            Tr.error(tc, string2);
                            throwable5.printStackTrace(System.out);
                            if (!this.response.isCommitted()) {
                                try {
                                    this.response.sendError(new HttpException(500, string2));
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace(System.out);
                                }
                            }
                            Object var7_12 = null;
                            if (TransportLogger.debugEnabled()) {
                                TransportLogger.debug("HttpConnection.run(): socket closed: remotePort=[" + n + "] remoteAddress=[" + string + "]");
                            }
                            try {
                                this.writeStream.setDisableClose(false);
                                this.writeStream.close();
                                this.outStream.close();
                            }
                            catch (Throwable throwable62222) {
                                if (HttpServer.errorLogDisable) break block84;
                                Logger.log(2, "HTTP0402W Could not Close Output Stream");
                            }
                        }
                        try {
                            this.readStream.setDisableClose(false);
                            this.readStream.close();
                            this.inStream.close();
                        }
                        catch (Throwable throwable62222) {
                            if (HttpServer.errorLogDisable) break block85;
                            Logger.log(2, "HTTP0403W Could not Close Input Stream");
                        }
                    }
                    try {
                        if (HttpServer.debugEnabled) {
                            Logger.log(4, "HttpConnection: Closing Socket");
                        }
                        this.socket.close();
                        this.socket = null;
                    }
                    catch (Throwable throwable62222) {
                        try {}
                        catch (Throwable throwable7) {
                            this.socket = null;
                            throw throwable7;
                        }
                        if (!HttpServer.errorLogDisable) {
                            Logger.log(1, "HTTP0401E Could not Close Socket");
                        }
                        this.socket = null;
                    }
                    this.inStream = null;
                    this.outStream = null;
                    if (this.isKeptAlive) {
                        try {
                            this.httpServer.freeKeepAlive();
                        }
                        catch (Throwable throwable62222) {
                            // empty catch block
                        }
                    }
                    try {
                        if (this.httpServer.freeConnection(this)) {
                            this.cleanup();
                        }
                    }
                    catch (Throwable throwable62222) {
                        // empty catch block
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "run");
                    }
                }
            }
            catch (Throwable throwable8) {
                Throwable throwable92222;
                block90: {
                    block89: {
                        Object var7_13 = null;
                        if (TransportLogger.debugEnabled()) {
                            TransportLogger.debug("HttpConnection.run(): socket closed: remotePort=[" + n + "] remoteAddress=[" + string + "]");
                        }
                        try {
                            this.writeStream.setDisableClose(false);
                            this.writeStream.close();
                            this.outStream.close();
                        }
                        catch (Throwable throwable92222) {
                            if (HttpServer.errorLogDisable) break block89;
                            Logger.log(2, "HTTP0402W Could not Close Output Stream");
                        }
                    }
                    try {
                        this.readStream.setDisableClose(false);
                        this.readStream.close();
                        this.inStream.close();
                    }
                    catch (Throwable throwable92222) {
                        if (HttpServer.errorLogDisable) break block90;
                        Logger.log(2, "HTTP0403W Could not Close Input Stream");
                    }
                }
                try {
                    if (HttpServer.debugEnabled) {
                        Logger.log(4, "HttpConnection: Closing Socket");
                    }
                    this.socket.close();
                    this.socket = null;
                }
                catch (Throwable throwable92222) {
                    try {}
                    catch (Throwable throwable10) {
                        this.socket = null;
                        throw throwable10;
                    }
                    if (!HttpServer.errorLogDisable) {
                        Logger.log(1, "HTTP0401E Could not Close Socket");
                    }
                    this.socket = null;
                }
                this.inStream = null;
                this.outStream = null;
                if (this.isKeptAlive) {
                    try {
                        this.httpServer.freeKeepAlive();
                    }
                    catch (Throwable throwable92222) {
                        // empty catch block
                    }
                }
                try {
                    if (this.httpServer.freeConnection(this)) {
                        this.cleanup();
                    }
                }
                catch (Throwable throwable92222) {
                    // empty catch block
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "run");
                }
                throw throwable8;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readAndHandleRequest(boolean bl) throws IOException {
        boolean bl2;
        block45: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "readAndHandleRequest");
            }
            bl2 = true;
            String string = "unknown";
            int n = -1;
            this.request.start();
            this.response.start();
            if (TransportLogger.debugEnabled()) {
                string = this.socket.getInetAddress().getHostAddress();
                n = this.socket.getPort();
                TransportLogger.debug("HttpConnection.readAndHandleRequest(): about to read request remotePort=[" + n + "] remoteAddress=[" + string + "]");
            }
            if (this.request.readRequest()) {
                if (TransportLogger.debugEnabled()) {
                    TransportLogger.debug("HttpConnection.readAndHandleRequest(): started dispatch to uri: " + this.request.getURI());
                }
                if (bl && this.request.getURI().equals("/_WS/EH")) {
                    this.response.sendExtendedHandshake();
                    this.request.start();
                    this.request.readRequest();
                }
                this.response.setStatus(200);
                this.handleRequest();
                if (!HttpServer.accessLogDisable) {
                    String string2 = this.request.version == 1001 ? "HTTP/1.1" : "HTTP/1.0";
                    String string3 = this.getConnectionRemoteAddr() + " \"" + this.request.method + " " + this.request.uri + " " + string2 + "\" " + this.response.status + " " + this.response.contentLengthString;
                    Logger.log(5, string3);
                }
                break block45;
            }
            this.request.setVersion(1001);
            if (TransportLogger.debugEnabled()) {
                TransportLogger.debug("HttpConnection.readAndHandleRequest(): Connection timed out while reading request ");
            }
            this.response.sendError(408, "Connection timed out while reading request");
            this.shouldStayAlive = false;
        }
        Object var8_10 = null;
        if (TransportLogger.debugEnabled()) {
            if (this.request.getURI() != null) {
                TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: " + this.request.getURI());
            } else {
                TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: NOT_AVAILABLE");
            }
            TransportLogger.debug("HttpConnection.readAndHandleRequest() status code: " + this.response.getStatus());
            TransportLogger.debug("HttpConnection.readAndHandleRequest() shouldStayAlive: " + this.shouldStayAlive);
        }
        try {
            this.response.finish(bl2);
        }
        finally {
            this.request.finish();
        }
        {
            catch (HttpException httpException) {
                if (!HttpServer.errorLogDisable) {
                    Logger.log(2, "HTTP0405W Could not Read Request - Closing Connection");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HTTP Exception", httpException);
                }
                this.response.sendError(httpException);
                this.shouldStayAlive = false;
                Object var8_11 = null;
                if (TransportLogger.debugEnabled()) {
                    if (this.request.getURI() != null) {
                        TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: " + this.request.getURI());
                    } else {
                        TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: NOT_AVAILABLE");
                    }
                    TransportLogger.debug("HttpConnection.readAndHandleRequest() status code: " + this.response.getStatus());
                    TransportLogger.debug("HttpConnection.readAndHandleRequest() shouldStayAlive: " + this.shouldStayAlive);
                }
                try {
                    this.response.finish(bl2);
                }
                finally {
                    this.request.finish();
                }
            }
            catch (IOException iOException) {
                if (!HttpServer.errorLogDisable) {
                    Logger.log(2, "HTTP0406W I/O exception has occurred");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, iOException.getMessage(), iOException);
                }
                this.shouldStayAlive = false;
                Object var8_12 = null;
                if (TransportLogger.debugEnabled()) {
                    if (this.request.getURI() != null) {
                        TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: " + this.request.getURI());
                    } else {
                        TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: NOT_AVAILABLE");
                    }
                    TransportLogger.debug("HttpConnection.readAndHandleRequest() status code: " + this.response.getStatus());
                    TransportLogger.debug("HttpConnection.readAndHandleRequest() shouldStayAlive: " + this.shouldStayAlive);
                }
                try {
                    this.response.finish(bl2);
                }
                finally {
                    this.request.finish();
                }
            }
            catch (Throwable throwable) {
                this.shouldStayAlive = false;
                Tr.error(tc, "Unable to read and handle request: " + throwable.getMessage());
                throwable.printStackTrace(System.out);
                Object var8_13 = null;
                if (TransportLogger.debugEnabled()) {
                    if (this.request.getURI() != null) {
                        TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: " + this.request.getURI());
                    } else {
                        TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: NOT_AVAILABLE");
                    }
                    TransportLogger.debug("HttpConnection.readAndHandleRequest() status code: " + this.response.getStatus());
                    TransportLogger.debug("HttpConnection.readAndHandleRequest() shouldStayAlive: " + this.shouldStayAlive);
                }
                try {
                    this.response.finish(bl2);
                }
                finally {
                    this.request.finish();
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            if (TransportLogger.debugEnabled()) {
                if (this.request.getURI() != null) {
                    TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: " + this.request.getURI());
                } else {
                    TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: NOT_AVAILABLE");
                }
                TransportLogger.debug("HttpConnection.readAndHandleRequest() status code: " + this.response.getStatus());
                TransportLogger.debug("HttpConnection.readAndHandleRequest() shouldStayAlive: " + this.shouldStayAlive);
            }
            try {
                this.response.finish(bl2);
            }
            finally {
                this.request.finish();
            }
            throw throwable;
        }
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Read and Handle Request Complete");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readAndHandleRequest");
        }
    }

    protected void handleRequest() throws HttpException, IOException {
        String string = this.request.getURI();
        this.response.setStatus(200);
        PrintWriter printWriter = this.response.getWriter();
        printWriter.print("<HTML><BODY><p>This is a do nothing handler for uri '" + string + "'</BODY></HTML>");
        printWriter.print("<HTML><BODY><p>This handleRequest method should be overridden!</BODY></HTML>");
    }

    protected void cleanup() {
    }

    protected HttpRequest createHttpRequest() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Creating HTTP Request");
        }
        return new HttpRequest(this);
    }

    protected HttpResponse createHttpResponse() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Creating HTTP Response");
        }
        return new HttpResponse(this);
    }

    public boolean isBroken() {
        return this.broken;
    }

    public void setBroken() {
        this.broken = true;
    }

    public void setFlushMode(boolean bl) {
        this.response.setFlushMode(bl);
    }

    public void setshouldStayAlive(boolean bl) {
        this.shouldStayAlive = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Connection should stay alive = ", new Boolean(this.shouldStayAlive));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

