/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.ChunkedInputStream;
import com.ibm.ws.http.ContentLengthInputStream;
import com.ibm.ws.http.HttpConnection;
import com.ibm.ws.http.HttpException;
import com.ibm.ws.http.HttpServer;
import com.ibm.ws.http.HttpTransport;
import com.ibm.ws.http.Logger;
import com.ibm.ws.http.MutableString;
import com.ibm.ws.io.ReadStream;
import com.ibm.ws.util.CharBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;

public class HttpRequest {
    public static final int HTTP_VERSION_09 = 9;
    public static final int HTTP_VERSION_10 = 1000;
    public static final int HTTP_VERSION_11 = 1001;
    public static final int DEFAULT_LIMIT_REQUEST_LINE = 8190;
    public static final int DEFAULT_LIMIT_REQUEST_FIELDSIZE = 8190;
    public static final int DEFAULT_LIMIT_REQUEST_FIELDS = 500;
    Logger logger;
    HttpServer httpserver;
    private static TraceComponent tc = Tr.register((class$com$ibm$ws$http$HttpRequest == null ? (class$com$ibm$ws$http$HttpRequest = HttpRequest.class$("com.ibm.ws.http.HttpRequest")) : class$com$ibm$ws$http$HttpRequest).getName(), "HTTP_Transport");
    private final Hashtable hdrNamesByMutableString = new Hashtable();
    private final Hashtable toLower = new Hashtable();
    private HttpConnection conn = null;
    private HttpTransport transport = null;
    private ReadStream rawStream = null;
    private ReadStream filterStream = new ReadStream();
    private ContentLengthInputStream contentLengthStream = null;
    private ChunkedInputStream chunkedInputStream = new ChunkedInputStream();
    private final MutableString mutableString = new MutableString();
    private boolean hasInputStream;
    protected String scheme;
    protected String method;
    protected String uri;
    protected String queryString;
    protected int version;
    protected String serverName;
    protected int serverPort;
    protected boolean wantToStayAlive;
    protected ArrayList headerKeys = new ArrayList();
    protected ArrayList headerValues = new ArrayList();
    private CharBuffer buffer = new CharBuffer(8190);
    static /* synthetic */ Class class$com$ibm$ws$http$HttpRequest;

    public HttpRequest(HttpConnection httpConnection) {
        this.conn = httpConnection;
        this.contentLengthStream = new ContentLengthInputStream(httpConnection);
    }

    public void init(ReadStream readStream) {
        this.rawStream = readStream;
    }

    public void start() {
        this.hasInputStream = false;
        this.scheme = null;
        this.method = null;
        this.uri = null;
        this.queryString = null;
        this.version = -1;
        this.serverName = null;
        this.serverPort = -1;
        this.wantToStayAlive = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "start");
        }
    }

    public void finish() throws IOException {
        this.headerKeys.clear();
        this.headerValues.clear();
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpRequest: Cleaning up - Finished Receiving Request");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "finish");
        }
    }

    public HttpConnection getHttpConnection() {
        return this.conn;
    }

    public HttpTransport getHttpTransport() {
        return this.conn.getHttpTransport();
    }

    public InputStream getInputStream() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInputStream");
        }
        if (!this.hasInputStream) {
            String string;
            this.hasInputStream = true;
            int n = this.getContentLength();
            if (HttpServer.debugEnabled) {
                Logger.log(4, "HttpRequest: Content Length = " + n);
            }
            if (n < 0 && this.getVersion() >= 1001 && (string = this.getHeader("Transfer-Encoding")) != null) {
                if (HttpServer.debugEnabled) {
                    Logger.log(4, "HttpRequest: Using HTTP Version 1.1 or higher");
                }
                this.chunkedInputStream.init(this, this.rawStream);
                this.filterStream.init(this.chunkedInputStream);
            } else {
                this.contentLengthStream.init((InputStream)this.rawStream, n);
                this.filterStream.init(this.contentLengthStream);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInputStream");
        }
        return this.filterStream;
    }

    public boolean isProxied() {
        return false;
    }

    public String getScheme() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpRequest: getScheme = " + this.uri);
        }
        return this.scheme;
    }

    public String getMethod() {
        return this.method;
    }

    public String getURI() {
        return this.uri;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getProtocol() {
        if (this.version >= 1001) {
            return "HTTP/1.1";
        }
        return "HTTP/1.0";
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean wantsToStayAlive() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpRequest: StayAlive = " + this.wantToStayAlive);
        }
        return this.wantToStayAlive;
    }

    public int getContentLength() {
        String string = this.getHeader("Content-Length");
        int n = -1;
        if (string != null) {
            int n2 = string.lastIndexOf(",");
            if (n2 != -1) {
                string = string.substring(n2 + 1);
            }
            n = Integer.parseInt(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getContentLength", new Integer(n));
        }
        return n;
    }

    public void setContentLength(int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setContentLength", new Integer(n));
        }
        this.setHeader("Content-Length", String.valueOf(n));
    }

    public String getHeader(String string) {
        String string2;
        int n = this.headerKeys.indexOf(this.toLower(string));
        String string3 = string2 = n != -1 ? (String)this.headerValues.get(n) : null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeader", new Object[]{string, string2});
        }
        return string2;
    }

    protected void setHeader(String string, String string2) {
        int n = this.headerKeys.indexOf(string = this.toLower(string));
        if (n == -1) {
            this.headerKeys.add(string);
            this.headerValues.add(string2);
        } else {
            this.headerValues.set(n, string2);
        }
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpRequest: setHeader= " + new Object[]{string, string2});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader", new Object[]{string, string2});
        }
    }

    protected void addHeader(String string, String string2) throws HttpException {
        this.headerKeys.add(string);
        this.headerValues.add(string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addHeader", new Object[]{string, string2});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean readRequest() throws HttpException {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpRequest: Reading Request");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readRequest");
        }
        try {
            try {
                this.readRequestLine();
                this.readHeaders();
            }
            catch (IOException iOException) {
                if (iOException instanceof HttpException) {
                    throw (HttpException)iOException;
                }
                boolean bl = false;
                Object var4_2 = null;
                if (!tc.isEntryEnabled()) return bl;
                Tr.exit(tc, "readRequest");
                return bl;
            }
            Object var4_1 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "readRequest");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return true;
        Tr.exit(tc, "readRequest");
        return true;
    }

    private void readRequestLine() throws HttpException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readRequestLine");
        }
        this.buffer.setLength(0);
        int n = this.rawStream.read();
        while (n == 13 || n == 10) {
            n = this.rawStream.read();
        }
        while (n >= 0 && n != 32 && n != 10) {
            if (n >= 97 && n <= 122) {
                n = n - 97 + 65;
            }
            this.buffer.append((char)n);
            n = this.rawStream.read();
        }
        if (n == -1 || this.buffer.length() == 0) {
            if (!HttpServer.errorLogDisable) {
                Logger.log(1, "HTTP0402E Invalid Request");
            }
            throw new HttpException(400, "Invalid request");
        }
        this.method = this.buffer.toString();
        while (n == 32) {
            n = this.rawStream.read();
        }
        n = this.readUri(this.buffer, n);
        while (n == 32) {
            n = this.rawStream.read();
        }
        n = this.readVersion(n);
        if (this.version == 9) {
            if (!HttpServer.errorLogDisable) {
                Logger.log(1, "HTTP0403E HTTP Version not supported");
            }
            throw new HttpException(505);
        }
        while (n >= 0 && n != 10 && n != 13) {
            n = this.rawStream.read();
        }
        if (n == 13 && (n = this.rawStream.read()) != 10) {
            if (!HttpServer.errorLogDisable) {
                Logger.log(1, "HTTP0404E Bad Request");
            }
            throw new HttpException(400);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readRequestLine");
        }
    }

    private void readHeaders() throws HttpException, IOException {
        String string;
        int n;
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpRequest: readHeaders");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readHeaders");
        }
        int n2 = 0;
        String string2 = null;
        String string3 = "";
        while (true) {
            this.buffer.setLength(0);
            try {
                this.rawStream.readLine(this.buffer);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!HttpServer.errorLogDisable) {
                    Logger.log(1, "HTTP0405E Exceeded size of header field");
                }
                throw new HttpException(400, "Size of header field exceeded.");
            }
            int n3 = this.buffer.length();
            if (n3 == 0) {
                if (string2 == null) break;
                this.addHeader(string2, string3);
                break;
            }
            if (++n2 > 500) {
                if (!HttpServer.errorLogDisable) {
                    Logger.log(1, "HTTP0406E Exceeded number of headers. Default request fields 500");
                }
                throw new HttpException(400, "Number of headers exceeded");
            }
            n = 0;
            char[] cArray = this.buffer.getValue();
            while (cArray[n] == ' ' || cArray[n] == '\t') {
                ++n;
            }
            if (n > 0) {
                string3 = new StringBuffer(string3).append(' ').append(cArray, n, n3 - n).toString();
                continue;
            }
            if (string2 != null) {
                this.addHeader(string2, string3);
                string2 = null;
                string3 = "";
            }
            while (n < n3 && cArray[n] != ':') {
                ++n;
            }
            if (n == n3) {
                if (!HttpServer.errorLogDisable) {
                    Logger.log(1, "HTTP0407E Bad Request");
                }
                throw new HttpException(400);
            }
            int n4 = n++;
            while (cArray[n] == ' ' || cArray[n] == '\t') {
                ++n;
            }
            string2 = this.getHdrName(cArray, n4);
            string3 = new String(cArray, n, n3 - n);
        }
        if ((string = this.getHeader("Host")) != null) {
            n = string.indexOf(58);
            if (n != -1) {
                this.serverName = string.substring(0, n);
                int n5 = string.length();
            } else {
                this.serverName = string;
            }
        }
        if (this.version >= 1001) {
            if (string == null) {
                this.conn.setAllowKeepAlive(false);
                if (!HttpServer.errorLogDisable) {
                    Logger.log(1, "HTTP0408E Missing Host header");
                }
                throw new HttpException(400, "Missing Host header");
            }
            String string4 = this.getHeader("Expect");
            if (string4 != null && string4.length() > 0) {
                if (string4.equalsIgnoreCase("100-continue")) {
                    if (this.rawStream.available() <= 0) {
                        this.conn.getHttpResponse().sendContinue();
                    }
                } else {
                    if (!HttpServer.errorLogDisable) {
                        Logger.log(1, "HTTP0409E invalid Expect header value: " + string4);
                    }
                    throw new HttpException(417, "invalid Expect header value: " + string4);
                }
            }
        }
        this.wantToStayAlive = true;
        if (!this.isProxied()) {
            if (this.version >= 1001) {
                String string5 = this.getHeader("Connection");
                if (string5 != null && string5.equalsIgnoreCase("close")) {
                    this.wantToStayAlive = false;
                }
            } else {
                this.wantToStayAlive = false;
            }
        }
        if (this.scheme == null) {
            this.scheme = this.conn.getConnectionScheme();
        }
        if (this.serverName == null) {
            this.serverName = this.conn.getConnectionServerName();
        }
        if (this.serverPort == -1) {
            this.serverPort = this.conn.getConnectionServerPort();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readHeaders");
        }
    }

    private int readUri(CharBuffer charBuffer, int n) throws HttpException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readUri");
        }
        charBuffer.setLength(0);
        while (n != 47) {
            if (n < 0 || n == 32 || n == 9 || n == 10 || n == 13) {
                if (!HttpServer.errorLogDisable) {
                    Logger.log(1, "HTTP0410E Bad Request");
                }
                throw new HttpException(400);
            }
            charBuffer.append((char)n);
            n = this.rawStream.read();
        }
        int n2 = this.rawStream.read();
        if (n2 == 47 && charBuffer.length() > 0 && charBuffer.charAt(charBuffer.length() - 1) == ':') {
            this.scheme = charBuffer.substring(0, charBuffer.length() - 1);
            n = this.readHost(charBuffer);
            charBuffer.setLength(0);
        } else {
            charBuffer.append('/');
            n = n2;
        }
        while (n != 63 && !this.isWhitespace(n) && n >= 0) {
            charBuffer.append((char)n);
            n = this.rawStream.read();
        }
        if (charBuffer.length() == 0) {
            throw new HttpException(400);
        }
        this.uri = charBuffer.toString();
        if (n == 63) {
            return this.readQuery(charBuffer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readUri");
        }
        return n;
    }

    private int readHost(CharBuffer charBuffer) throws IOException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readHost");
        }
        charBuffer.setLength(0);
        block5: while ((n = this.rawStream.read()) >= 0) {
            switch (n) {
                case -1: 
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (!HttpServer.errorLogDisable) {
                        Logger.log(1, "HTTP0412E Bad Request");
                    }
                    throw new HttpException(400);
                }
                case 58: {
                    break block5;
                }
                case 47: {
                    break block5;
                }
                default: {
                    charBuffer.append((char)n);
                    continue block5;
                }
            }
        }
        this.serverName = charBuffer.toString();
        if (n == 58) {
            return this.readPort(charBuffer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readHost");
        }
        return n;
    }

    private int readPort(CharBuffer charBuffer) throws IOException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readPort");
        }
        this.serverPort = 0;
        while ((n = this.rawStream.read()) >= 0) {
            if (n == 47) {
                return n;
            }
            if (n >= 48 && n <= 57) {
                this.serverPort = this.serverPort * 10 + n - 48;
                continue;
            }
            if (!HttpServer.errorLogDisable) {
                Logger.log(1, "HTTP0413E Bad Request");
            }
            throw new HttpException(400);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readPort");
        }
        return n;
    }

    private int readQuery(CharBuffer charBuffer) throws IOException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readQuery");
        }
        charBuffer.setLength(0);
        while ((n = this.rawStream.read()) >= 0 && !this.isWhitespace(n)) {
            charBuffer.append((char)n);
        }
        this.queryString = charBuffer.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readQuery");
        }
        return n;
    }

    private char readUrlEscape() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readUrlEscape");
        }
        int n = this.toHex(this.rawStream.read());
        int n2 = this.toHex(this.rawStream.read());
        char c = (char)((n << 4) + n2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readUrlEscape", new Character(c));
        }
        return c;
    }

    private int toHex(int n) {
        if (n >= 48 && n <= 57) {
            return n - 48;
        }
        if (n >= 97 && n <= 102) {
            return n - 97 + 10;
        }
        if (n >= 65 && n <= 70) {
            return n - 65 + 10;
        }
        return -1;
    }

    private int readVersion(int n) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readVersion");
        }
        boolean bl = false;
        if (n < 0 || this.isWhitespace(n)) {
            this.version = 9;
            return n;
        }
        this.version = 1000;
        while (n >= 0 && n != 47) {
            n = this.rawStream.read();
        }
        int n2 = 0;
        while ((n = this.rawStream.read()) >= 0) {
            if (n >= 48 && n <= 57) {
                n2 = n2 * 10 + n - 48;
                continue;
            }
            if (n == 46) break;
            return n;
        }
        int n3 = 0;
        while ((n = this.rawStream.read()) >= 0 && n >= 48 && n <= 57) {
            n3 = n3 * 10 + n - 48;
        }
        this.version = n2 * 1000 + n3;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readVersion");
        }
        return n;
    }

    private boolean isWhitespace(int n) {
        return n == 32 || n == 9 || n == 10 || n == 13;
    }

    public void dump(PrintStream printStream) {
        printStream.print("scheme = ");
        printStream.println(this.scheme);
        printStream.print("method = ");
        printStream.println(this.method);
        printStream.print("uri = ");
        printStream.println(this.uri);
        printStream.print("query = ");
        printStream.println(this.queryString);
        printStream.print("version = ");
        printStream.println(this.version);
        printStream.print("serverName = ");
        printStream.println(this.serverName);
        printStream.print("serverPort = ");
        printStream.println(this.serverPort);
        printStream.println("Headers");
        for (int i = 0; i < this.headerKeys.size(); ++i) {
            printStream.print(this.headerKeys.get(i));
            printStream.print(" : ");
            printStream.println(this.headerValues.get(i));
        }
        printStream.println("Reading data");
        try {
            int n;
            InputStream inputStream = this.getInputStream();
            while ((n = inputStream.read()) > 0) {
                printStream.print((char)n);
            }
        }
        catch (Throwable throwable) {
            if (!HttpServer.errorLogDisable) {
                Logger.log(1, "HTTP0414E Couldn't get Input Stream");
            }
            throwable.printStackTrace(printStream);
        }
        printStream.println("Headers");
        for (int i = 0; i < this.headerKeys.size(); ++i) {
            printStream.print(this.headerKeys.get(i));
            printStream.print(" : ");
            printStream.println(this.headerValues.get(i));
        }
    }

    public void getHeaders(String[][] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHeaders");
        }
        stringArray[0] = new String[this.headerKeys.size()];
        stringArray[1] = new String[this.headerKeys.size()];
        for (int i = 0; i < this.headerKeys.size(); ++i) {
            stringArray[0][i] = (String)this.headerKeys.get(i);
            stringArray[1][i] = (String)this.headerValues.get(i);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHeaders");
        }
    }

    public String getCookieValue(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCookieValue", string);
        }
        try {
            for (int i = 0; i < this.headerKeys.size(); ++i) {
                String string2;
                int n;
                String string3 = (String)this.headerKeys.get(i);
                if (!string3.equalsIgnoreCase("COOKIE") || (n = (string2 = (String)this.headerValues.get(i)).indexOf(string)) == -1) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ";,");
                String string4 = string + "=";
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken().trim();
                    if (!string5.startsWith(string4)) continue;
                    String string6 = string5.substring(string4.length());
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getCookieValue", string6);
                    }
                    return string6;
                }
            }
        }
        catch (Exception exception) {
            if (!HttpServer.errorLogDisable) {
                Logger.log(1, "HTTP0415E Can't get cookie value for " + string);
            }
            Tr.error(tc, "can't get cookie value for " + string, exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCookieValue", "null");
        }
        return null;
    }

    private String getHdrName(char[] cArray, int n) {
        this.mutableString.init(cArray, 0, n);
        String string = (String)this.hdrNamesByMutableString.get(this.mutableString);
        if (string == null) {
            string = new String(cArray, 0, n).toLowerCase(Locale.US);
            char[] cArray2 = new char[n];
            System.arraycopy(cArray, 0, cArray2, 0, n);
            this.hdrNamesByMutableString.put(new MutableString(cArray2, 0, n), string);
        }
        return string;
    }

    private String toLower(String string) {
        String string2 = (String)this.toLower.get(string);
        if (string2 == null) {
            string2 = string.toLowerCase(Locale.US);
            this.toLower.put(string, string2);
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

