/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException;
import com.ibm.ISecurityUtilityImpl.InvalidPasswordEncodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;

public class SASPropFile {
    public static final String SECURITY_ENABLED_PROPERTY = "com.ibm.CORBA.securityEnabled";
    public static final String AUTHENTICATION_TARGET_PROPERTY = "com.ibm.CORBA.authenticationTarget";
    public static final String AUTHENTICATION_RETRY_ENABLED = "com.ibm.CORBA.authenticationRetryEnabled";
    public static final String AUTHENTICATION_RETRY_COUNT = "com.ibm.CORBA.authenticationRetryCount";
    public static final String VALIDATE_BASIC_AUTH = "com.ibm.CORBA.validateBasicAuth";
    public static final String SECURITY_SERVER_HOST = "com.ibm.CORBA.securityServerHost";
    public static final String SECURITY_SERVER_PORT = "com.ibm.CORBA.securityServerPort";
    public static final String SAS_LOGIN_SOURCE = "com.ibm.CORBA.loginSource";
    public static final String SAS_LOGIN_TIMEOUT = "com.ibm.CORBA.loginTimeout";
    public static final String PRINCIPAL_NAME_PROPERTY = "com.ibm.CORBA.principalName";
    public static final String LOGIN_USERID = "com.ibm.CORBA.loginUserid";
    public static final String LOGIN_PASSWORD = "com.ibm.CORBA.loginPassword";
    public static final String SECURITY_CACHE_TIMEOUT_PROPERTY = "com.ibm.CORBA.securityCacheTimeout";
    public static final String LOCALOS = "LOCALOS";
    public static final String SERVER_ID_SUFFIX = ".server.id";
    public static final String SERVER_PWD_SUFFIX = ".server.pwd";
    public static final String LOCALOS_USERID = "LOCALOS.server.id";
    public static final String LOCALOS_PASSWORD = "LOCALOS.server.pwd";
    public static final String LOCALOS_SERVER_ID = "LOCALOS.server.id";
    public static final String LOCALOS_SERVER_PWD = "LOCALOS.server.pwd";
    public static final String SERVER_SECURITY_ENABLED_PROPERTY = "com.ibm.CORBA.serverSecurityEnabled";
    public static final String RMI_OUTBOUND_LOGIN_ENABLED = "com.ibm.CSI.rmiOutboundLoginEnabled";
    public static final String RMI_OUTBOUND_PROPAGATION_ENABLED = "com.ibm.CSI.rmiOutboundPropagationEnabled";
    public static final String RMI_INBOUND_PROPAGATION_ENABLED = "com.ibm.CSI.rmiInboundPropagationEnabled";
    public static final String WEB_INBOUND_PROPAGATION_ENABLED = "com.ibm.ws.security.webInboundPropagationEnabled";
    public static final String SSO_INTEROP_MODE = "com.ibm.ws.security.ssoInteropModeEnabled";
    public static final String CELL_NODE_SERVER = "com.ibm.CSI.CellNodeServer";
    public static final String RMI_INBOUND_LOGIN_CONFIG = "com.ibm.CSI.rmiInboundLoginConfig";
    public static final String RMI_OUTBOUND_LOGIN_CONFIG = "com.ibm.CSI.rmiOutboundLoginConfig";
    public static final String WEB_INBOUND_LOGIN_CONFIG = "com.ibm.ws.security.webInboundLoginConfig";
    public static final String DEFAULT_LOGIN_CONFIG = "com.ibm.ws.security.defaultLoginConfig";
    public static final String SUPPORTED_TARGET_REALMS = "com.ibm.CSI.supportedTargetRealms";
    public static final String AUTHENTICATION_TOKEN_FACTORY = "com.ibm.wsspi.security.token.authenticationTokenFactory";
    public static final String AUTHORIZATION_TOKEN_FACTORY = "com.ibm.wsspi.security.token.authorizationTokenFactory";
    public static final String DEFAULT_TOKEN_FACTORY = "com.ibm.wsspi.security.token.defaultTokenFactory";
    public static final String PROPAGATION_TOKEN_FACTORY = "com.ibm.wsspi.security.token.propagationTokenFactory";
    public static final String SINGLESIGNON_TOKEN_FACTORY = "com.ibm.wsspi.security.token.singleSignonTokenFactory";
    public static final String[] propNames = new String[]{"com.ibm.CORBA.securityEnabled", "com.ibm.CORBA.authenticationTarget", "com.ibm.CORBA.principalName", "com.ibm.CORBA.loginUserid", "com.ibm.CORBA.loginPassword", "com.ibm.CORBA.securityCacheTimeout", "com.ibm.CORBA.serverSecurityEnabled"};
    public static final String[] AuthPropNames = new String[]{"com.ibm.CORBA.authenticationTarget", "com.ibm.CORBA.authenticationRetryEnabled", "com.ibm.CORBA.authenticationRetryCount", "com.ibm.CORBA.validateBasicAuth", "com.ibm.CORBA.securityServerHost", "com.ibm.CORBA.securityServerPort", "com.ibm.CORBA.loginTimeout", "com.ibm.CORBA.loginSource"};
    public static final String[] loginPropNames = new String[]{"com.ibm.CORBA.loginUserid", "com.ibm.CORBA.loginPassword", "com.ibm.CORBA.principalName"};
    public static final String CSI_PROTOCOL = "com.ibm.CSI.protocol";
    public static final String REQUEST_TIMEOUT = "com.ibm.CORBA.requestTimeout";
    public static final String SSL_PREFIX = "com.ibm.ssl.";
    public static final String PROTOCOL = "com.ibm.ssl.protocol";
    public static final String KEY_MANAGER = "com.ibm.ssl.keyManager";
    public static final String KEY_STORE_TYPE = "com.ibm.ssl.keyStoreType";
    public static final String KEY_STORE_PROVIDER = "com.ibm.ssl.keyStoreProvider";
    public static final String KEY_FILE_NAME = "com.ibm.ssl.keyStore";
    public static final String KEY_FILE_PASSWORD = "com.ibm.ssl.keyStorePassword";
    public static final String TRUST_MANAGER = "com.ibm.ssl.trustManager";
    public static final String TRUST_STORE_TYPE = "com.ibm.ssl.trustStoreType";
    public static final String TRUST_STORE_PROVIDER = "com.ibm.ssl.trustStoreProvider";
    public static final String TRUST_FILE_NAME = "com.ibm.ssl.trustStore";
    public static final String TRUST_FILE_PASSWORD = "com.ibm.ssl.trustStorePassword";
    public static final String ENABLED_CIPHER_SUITES = "com.ibm.ssl.enabledCipherSuites";
    public static final String CLIENT_AUTH = "com.ibm.ssl.clientAuthentication";
    public static final String SECURITY_LEVEL = "com.ibm.ssl.securityLevel";
    public static final String TOKEN_TYPE = "com.ibm.ssl.tokenType";
    public static final String TOKEN_SLOT = "com.ibm.ssl.tokenSlot";
    public static final String TOKEN_LIBRARY_FILE = "com.ibm.ssl.tokenLibraryFile";
    public static final String TOKEN_PASSWORD = "com.ibm.ssl.tokenPassword";
    public static final String CONTEXT_PROVIDER = "com.ibm.ssl.contextProvider";
    public static final String CLIENT_KEY_ALIAS = "com.ibm.ssl.keyStoreClientAlias";
    public static final String SERVER_KEY_ALIAS = "com.ibm.ssl.keyStoreServerAlias";
    public static final String[] SSL_PROP_NAMES = new String[]{"com.ibm.ssl.protocol", "com.ibm.ssl.keyManager", "com.ibm.ssl.keyStoreType", "com.ibm.ssl.keyStoreProvider", "com.ibm.ssl.keyStore", "com.ibm.ssl.keyStorePassword", "com.ibm.ssl.trustManager", "com.ibm.ssl.trustStoreType", "com.ibm.ssl.trustStoreProvider", "com.ibm.ssl.trustStore", "com.ibm.ssl.trustStorePassword", "com.ibm.ssl.enabledCipherSuites", "com.ibm.ssl.clientAuthentication", "com.ibm.ssl.securityLevel", "com.ibm.ssl.tokenType", "com.ibm.ssl.tokenLibraryFile", "com.ibm.ssl.tokenPassword", "com.ibm.ssl.contextProvider", "com.ibm.ssl.keyStoreClientAlias", "com.ibm.ssl.keyStoreServerAlias"};
    public static final String[] SSL_PROPERTY_NAMES = new String[]{"com.ibm.ssl.protocol", "com.ibm.ssl.trustStore", "com.ibm.ssl.trustStoreType", "com.ibm.ssl.trustStorePassword", "com.ibm.ssl.keyStore", "com.ibm.ssl.keyStoreType", "com.ibm.ssl.keyStorePassword", "com.ibm.ssl.tokenType", "com.ibm.ssl.tokenSlot", "com.ibm.ssl.tokenLibraryFile", "com.ibm.ssl.tokenPassword", "com.ibm.ssl.keyStoreClientAlias", "com.ibm.ssl.keyStoreServerAlias"};
    public static final String CSI_PERFORM_STATEFUL = "com.ibm.CSI.performStateful";
    public static final String CSI_PERFORM_CLIENT_AUTH_REQ = "com.ibm.CSI.performClientAuthenticationRequired";
    public static final String CSI_PERFORM_CLIENT_AUTH_SUP = "com.ibm.CSI.performClientAuthenticationSupported";
    public static final String CSI_PERFORM_TLC_CLIENT_AUTH_REQ = "com.ibm.CSI.performTLClientAuthenticationRequired";
    public static final String CSI_PERFORM_TLC_CLIENT_AUTH_SUP = "com.ibm.CSI.performTLClientAuthenticationSupported";
    public static final String CSI_PERFORM_TRANSPORT_REQ = "com.ibm.CSI.performTransportAssocSSLTLSRequired";
    public static final String CSI_PERFORM_TRANSPORT_SUP = "com.ibm.CSI.performTransportAssocSSLTLSSupported";
    public static final String CSI_PERFORM_MESSAGE_INT_REQ = "com.ibm.CSI.performMessageIntegrityRequired";
    public static final String CSI_PERFORM_MESSAGE_INT_SUP = "com.ibm.CSI.performMessageIntegritySupported";
    public static final String CSI_PERFORM_MESSAGE_CON_REQ = "com.ibm.CSI.performMessageConfidentialityRequired";
    public static final String CSI_PERFORM_MESSAGE_CON_SUP = "com.ibm.CSI.performMessageConfidentialitySupported";
    public static final String SSL_ORB_CLIENT_QOP = "com.ibm.CORBA.standardPerformQOPModels";
    public static final String SSL_KEYRING_PASSWORD = "com.ibm.CORBA.SSLKeyRingPassword";
    public static final String SSL_CLIENT_KEYRING_PASSWORD = "com.ibm.CORBA.SSLClientKeyRingPassword";
    public static final String SSL_SERVER_KEYRING_PASSWORD = "com.ibm.CORBA.SSLServerKeyRingPassword";
    public static final String SSL_KEY_FILE_PASSWORD = "com.ibm.ssl.keyStorePassword";
    public static final String SSL_TRUST_FILE_PASSWORD = "com.ibm.ssl.trustStorePassword";
    public static final String[] sasPasswordNames = new String[]{"com.ibm.CORBA.loginPassword", "LOCALOS.server.pwd", "LOCALOS.server.pwd", "com.ibm.CORBA.SSLKeyRingPassword", "com.ibm.CORBA.SSLClientKeyRingPassword", "com.ibm.CORBA.SSLServerKeyRingPassword", "com.ibm.ssl.keyStorePassword", "com.ibm.ssl.trustStorePassword", "com.ibm.ssl.tokenPassword"};
    private static final String line_separator = System.getProperty("line.separator");
    private static final String section_1a = "###############################################################################" + line_separator + "#" + line_separator + "#                             SAS Properties File" + line_separator + "#" + line_separator + "#  This file contains properties that are used by the Secure Association" + line_separator + "#  Services (SAS) component of the WebSphere Application Server product." + line_separator + "#  SAS executes on WebSphere java servers and client systems with java" + line_separator + "#  applications that access WebSphere servers." + line_separator + "#" + line_separator + "#  ** SAS/CSIv2 Trace Instructions **" + line_separator + "#" + line_separator + "#  Note:  To enable logging of trace on the application client, add the " + line_separator + "#  following property to the startup script: -DtraceSettingsFile=filename." + line_separator + "#  Do not specify filename as a fully qualified path and filename, just" + line_separator + "#  specify the filename.  The file must exist in the classpath to be loaded." + line_separator + "#  A sample file is provided in <was_root>/properties/TraceSettings.properties." + line_separator + "#" + line_separator + "#  There are two related functions provided by this file:" + line_separator + "#" + line_separator + "#    1.traceFileName property" + line_separator + "#      This should be set to the fully qualified name of a file to which you want" + line_separator + "#\t\toutput written. For example, traceFileName=c:\\MyTraceFile.log. This" + line_separator + "#\t\tproperty must be specified, otherwise no visible output is generated." + line_separator + "#    2.Trace string" + line_separator + "#\t\tTo enable SAS/CSIv2 trace, specify the trace string: SASRas=all=enabled" + line_separator + "#" + line_separator + "#  If you only want to trace specific classes, you can specify a trace filter by" + line_separator + "#  adding the property com.ibm.CORBA.securityTraceFilter=<comma-separated class names>" + line_separator + "#" + line_separator + "#  Example:  com.ibm.CORBA.securityTraceFilter=SecurityConnectionInterceptor, CSIClientRI, SessionManager" + line_separator + "#" + line_separator + "#  ** Encoding Passwords in this File **" + line_separator + "#" + line_separator + "#  The PropFilePasswordEncoder utility may be used to encode passwords in a" + line_separator + "#  properties file. To edit an encoded password, replace the whole password" + line_separator + "#  string (including the encoding tag {...}) with the new password and then" + line_separator + "#  encode the password with the PropFilePasswordEncoder utility. Refer to" + line_separator + "#  product documentation for additional information." + line_separator + "#" + line_separator + "###############################################################################" + line_separator;
    private static final String section_1c = "#  - miscellaneous properties (e.g. customer defined)" + line_separator;
    private static final String clientSecEnable = "------------------------------------------------------------------------------" + line_separator + "# Client Security Enablement" + line_separator + "#" + line_separator + "# - security enabled status  ( false, true [default] )" + line_separator + "#------------------------------------------------------------------------------";
    private static final String rmiiop_auth_proc = "------------------------------------------------------------------------------" + line_separator + "# RMI/IIOP Authentication Protocol (sas, csiv2, both [default])" + line_separator + "#" + line_separator + "# Specify \"both\" when communicating with 5.0x and previous release servers." + line_separator + "# Specify \"csiv2\" when communicating with only 5.0x servers." + line_separator + "# Specify \"sas\" when communicating with only previous release servers" + line_separator + "#------------------------------------------------------------------------------";
    private static final String CSIv2_Config = "------------------------------------------------------------------------------" + line_separator + "# CSIv2 Configuration (see InfoCenter for more information on these properties)." + line_separator + "#" + line_separator + "# This is where you enable SSL client certificate authentication.  Must also" + line_separator + "# specify a valid SSL keyStore below with a personal certificate in it." + line_separator + "#------------------------------------------------------------------------------";
    private static final String stateful_sessions = "# Does this client support stateful sessions?";
    private static final String basicAuth_client_auth = "# Does this client support/require BasicAuth (userid/password) client authentication?";
    private static final String ssl_client_auth = "# Does this client support/require SSL client authentication?";
    private static final String note_both__ba_ssl = "# Note: You can perform BasicAuth (uid/pw) and SSL client authentication (certificate)" + line_separator + "# simultaneously, however, the BasicAuth identity will always take precedence at the server.";
    private static final String ssl_connection = "# Does this client support/require SSL connections?";
    private static final String cipher_40bit = "# Does this client support/require 40-bit cipher suites when using SSL?";
    private static final String cipher_128bit = "# Does this client support/require 128-bit cipher suites when using SSL?";
    private static final String note_ssl = "# Note: This property is only valid when SSL connections are supported or required." + line_separator;
    private static final String sec_auth = "------------------------------------------------------------------------------" + line_separator + "# Authentication Configuration" + line_separator + "#" + line_separator + "# - authenticationTarget       (BasicAuth [default], this is the only supported selection" + line_separator + "#                               on a pure client for this release.  This is for message" + line_separator + "#                               layer authentication only, SSL client certificate authentication" + line_separator + "#                               is configured below under CSIv2 configuration.)" + line_separator + "# - authenticationRetryEnabled (enables authentication retries if login fails when" + line_separator + "#                               loginSource=prompt or stdin)" + line_separator + "# - authenticationRetryCount   (the number of times to retry)" + line_separator + "# - source                     (prompt [default], properties, keyfile, stdin, none)" + line_separator + "# - timeout                    (prompt timeout, specified in seconds, 0 min to 600 max [default 300])" + line_separator + "# - validateBasicAuth          (determines if immediate authentication after uid/pw login," + line_separator + "#                               or wait for method request to send uid/pw to server," + line_separator + "#                               setting this to false gives the previous release behavior.)" + line_separator + "# - securityServerHost         (when validateBasicAuth=true, this property might need to be set" + line_separator + "#                               in order for security code to lookup SecurityServer.  Needs to be set to" + line_separator + "#                               any running WebSphere server host in the cell you are authenticating to." + line_separator + "# - securityServerPort         (when validateBasicAuth=true, this property might need to be set" + line_separator + "#                               in order for security code to lookup SecurityServer.  Needs to be set to" + line_separator + "#                               the bootstrap port of the host chosen above." + line_separator + "# - loginUserid                (must be set if login source is \"properties\" )" + line_separator + "# - loginPassword              (must be set if login source is \"properties\" )" + line_separator + "# - principalName              (format: \"realm/userid\", only needed in cases where realm" + line_separator + "#                               is required. Typically the realm is already provided by the" + line_separator + "#                               server via the IOR and this property is not necessary)." + line_separator + "#" + line_separator + "#------------------------------------------------------------------------------";
    private static final String rmiiop_user_id = "# RMI/IIOP user identity";
    private static final String ssl_op = "------------------------------------------------------------------------------" + line_separator + "# SSL Configuration" + line_separator + "#" + line_separator + "# - protocol  ( SSL [default], SSLv2, SSLv3, TLS, TLSv1 )" + line_separator + "# - keystore type  ( JKS [default], JCEK, PKCS12 )" + line_separator + "# - trustStoreType                              (JKS [default], JCEK, PKCS12)" + line_separator + "# - keyStore and trustStore                     (fully qualified path to file)" + line_separator + "# - keyStoreClientAlias                         (string specifying ssl certificate alias to use from keyStore)" + line_separator + "# - keyStorePassword and trustStorePassword" + line_separator + "# - cipher suites                               (refer to InfoCenter for valid ciphers)" + line_separator + "#" + line_separator + "#    Note: The com.ibm.ssl.enabledCipherSuites property defines the cipher" + line_separator + "#          suites used for the SSL session. If this property is defined, it" + line_separator + "#          overrides the default cipher suites defined for the specified QOP." + line_separator + "#" + line_separator + "#------------------------------------------------------------------------------";
    private static final String perform_qop = "------------------------------------------------------------------------------" + line_separator + "# Quality of Protection for the IBM protocol" + line_separator + "#" + line_separator + "#- perform  ( high [default], medium, low )" + line_separator + "#------------------------------------------------------------------------------";
    private static final String request_timeout = "------------------------------------------------------------------------------" + line_separator + "# CORBA Request Timeout (used when getting NO_RESPONSE exceptions, typically" + line_separator + "#                        during high-stress loads.  Specify on all processes" + line_separator + "#                        involved in the communications.)" + line_separator + "#" + line_separator + "#- timeout  ( specified in seconds [default 180], 0 implies no timeout )" + line_separator + "#" + line_separator + "#    com.ibm.CORBA.requestTimeout=180" + line_separator + "#------------------------------------------------------------------------------";
    private static final String misc = "------------------------------------------------------------------------------" + line_separator + "#Miscellaneous" + line_separator + "#------------------------------------------------------------------------------";
    private static final String section_4 = line_separator + "###############################################################################" + line_separator + "#" + line_separator + "#                           Miscellaneous Properties" + line_separator + "#" + line_separator + "###############################################################################" + line_separator;

    public static void decodeFilePasswords(URL uRL) throws IOException, InvalidPasswordDecodingException {
        if (uRL == null) {
            throw new IOException();
        }
        Properties properties = SASPropFile.loadProperties(uRL);
        if (properties == null) {
            throw new IOException();
        }
        if (SASPropFile.decodePropPasswords(properties)) {
            SASPropFile.saveConfig(properties, uRL);
        }
    }

    public static boolean decodePropPasswords(Properties properties) throws InvalidPasswordDecodingException {
        if (properties == null) {
            throw new InvalidPasswordDecodingException();
        }
        boolean bl = false;
        for (int i = 0; i < sasPasswordNames.length; ++i) {
            String string;
            String string2 = properties.getProperty(sasPasswordNames[i]);
            if (string2 == null || (string = string2.trim()).length() <= 0) continue;
            String string3 = PasswordUtil.passwordDecode((String)string);
            if (string3 == null) {
                throw new InvalidPasswordDecodingException();
            }
            if (string3.equals(string)) continue;
            bl = true;
            properties.put(sasPasswordNames[i], string3);
        }
        return bl;
    }

    public static void encodeFilePasswords(URL uRL, URL uRL2) throws IOException, InvalidPasswordEncodingException {
        if (uRL == null || uRL2 == null) {
            throw new IOException();
        }
        Properties properties = SASPropFile.loadProperties(uRL);
        Properties properties2 = SASPropFile.loadProperties(uRL2);
        if (properties == null || properties2 == null) {
            throw new IOException();
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < sasPasswordNames.length; ++i) {
            String string = null;
            String string2 = null;
            String string3 = null;
            if (properties != null && (string = properties.getProperty(sasPasswordNames[i])) != null && (string = string.trim()).length() > 0) {
                string3 = string;
            }
            if (properties2 != null && (string2 = properties2.getProperty(sasPasswordNames[i])) != null && (string2 = string2.trim()).length() > 0) {
                string3 = string2;
            }
            if (string3 == null) continue;
            String string4 = PasswordUtil.passwordEncode(string3);
            if (string4 == null) {
                throw new InvalidPasswordEncodingException();
            }
            if (string4.equals(string3)) {
                if (string != null && !string.equals(string3)) {
                    bl = true;
                    properties.put(sasPasswordNames[i], string3);
                }
                if (string2 == null || string2.equals(string3)) continue;
                bl2 = true;
                properties2.put(sasPasswordNames[i], string3);
                continue;
            }
            if (properties != null) {
                bl = true;
                properties.put(sasPasswordNames[i], string4);
            }
            if (properties2 == null) continue;
            bl2 = true;
            properties2.put(sasPasswordNames[i], string4);
        }
        if (bl) {
            SASPropFile.saveConfig(properties, uRL);
        }
        if (bl2) {
            SASPropFile.saveConfig(properties2, uRL2);
        }
    }

    public static void encodeFilePasswords(URL uRL) throws IOException, InvalidPasswordEncodingException {
        if (uRL == null) {
            throw new IOException();
        }
        Properties properties = SASPropFile.loadProperties(uRL);
        if (properties == null) {
            throw new IOException();
        }
        if (SASPropFile.encodePropPasswords(properties)) {
            SASPropFile.saveConfig(properties, uRL);
        }
    }

    public static boolean encodePropPasswords(Properties properties) throws InvalidPasswordEncodingException {
        if (properties == null) {
            throw new InvalidPasswordEncodingException();
        }
        boolean bl = false;
        for (int i = 0; i < sasPasswordNames.length; ++i) {
            String string;
            String string2 = properties.getProperty(sasPasswordNames[i]);
            if (string2 == null || (string = string2.trim()).length() <= 0) continue;
            String string3 = PasswordUtil.passwordEncode((String)string);
            if (string3 == null) {
                throw new InvalidPasswordEncodingException();
            }
            if (string3.equals(string)) continue;
            bl = true;
            properties.put(sasPasswordNames[i], string3);
        }
        return bl;
    }

    public static void saveConfig(Properties properties, FileOutputStream fileOutputStream) throws IOException {
        if (properties == null || fileOutputStream == null) {
            throw new IOException();
        }
        SASPropFile.saveConfig(properties, (OutputStream)fileOutputStream);
    }

    public static void saveConfig(Properties properties, URL uRL) throws IOException {
        if (properties == null || uRL == null) {
            throw new IOException();
        }
        OutputStream outputStream = null;
        outputStream = uRL.getProtocol().equals("file") ? new FileOutputStream(uRL.getFile()) : uRL.openConnection().getOutputStream();
        if (outputStream == null) {
            throw new IOException();
        }
        SASPropFile.saveConfig(properties, outputStream);
        outputStream.close();
    }

    private static void copyProperty(Object object, Properties properties, Properties properties2) throws IOException {
        if (object == null || properties == null || properties2 == null) {
            throw new IOException();
        }
        Object object2 = properties.remove(object);
        if (object2 == null) {
            properties2.remove(object);
        } else {
            properties2.put(object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(URL uRL) throws IOException {
        if (uRL == null) {
            throw new IOException();
        }
        Properties properties = new Properties();
        InputStream inputStream = uRL.openStream();
        if (properties == null || inputStream == null) {
            throw new IOException();
        }
        try {
            properties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return properties;
    }

    private static void saveConfig(Properties properties, OutputStream outputStream) throws IOException {
        if (properties == null || outputStream == null) {
            throw new IOException();
        }
        boolean bl = true;
        boolean bl2 = true;
        String string = properties.getProperty(AUTHENTICATION_TARGET_PROPERTY);
        if (string != null) {
            bl2 = false;
            if (string.equalsIgnoreCase("BasicAuth")) {
                bl = false;
            }
        }
        Properties properties2 = new Properties();
        SASPropFile.copyProperty(SECURITY_ENABLED_PROPERTY, properties, properties2);
        Properties properties3 = new Properties();
        SASPropFile.copyProperty(CSI_PROTOCOL, properties, properties3);
        Properties properties4 = new Properties();
        for (int i = 0; i < AuthPropNames.length; ++i) {
            SASPropFile.copyProperty(AuthPropNames[i], properties, properties4);
        }
        Properties properties5 = new Properties();
        for (int i = 0; i < loginPropNames.length; ++i) {
            SASPropFile.copyProperty(loginPropNames[i], properties, properties5);
        }
        Properties properties6 = new Properties();
        SASPropFile.copyProperty(CSI_PERFORM_STATEFUL, properties, properties6);
        Properties properties7 = new Properties();
        SASPropFile.copyProperty(CSI_PERFORM_CLIENT_AUTH_REQ, properties, properties7);
        SASPropFile.copyProperty(CSI_PERFORM_CLIENT_AUTH_SUP, properties, properties7);
        Properties properties8 = new Properties();
        SASPropFile.copyProperty(CSI_PERFORM_TLC_CLIENT_AUTH_REQ, properties, properties8);
        SASPropFile.copyProperty(CSI_PERFORM_TLC_CLIENT_AUTH_SUP, properties, properties8);
        Properties properties9 = new Properties();
        SASPropFile.copyProperty(CSI_PERFORM_TRANSPORT_REQ, properties, properties9);
        SASPropFile.copyProperty(CSI_PERFORM_TRANSPORT_SUP, properties, properties9);
        Properties properties10 = new Properties();
        SASPropFile.copyProperty(CSI_PERFORM_MESSAGE_INT_REQ, properties, properties10);
        SASPropFile.copyProperty(CSI_PERFORM_MESSAGE_INT_SUP, properties, properties10);
        Properties properties11 = new Properties();
        SASPropFile.copyProperty(CSI_PERFORM_MESSAGE_CON_REQ, properties, properties11);
        SASPropFile.copyProperty(CSI_PERFORM_MESSAGE_CON_SUP, properties, properties11);
        Properties properties12 = new Properties();
        for (int i = 0; i < SSL_PROPERTY_NAMES.length; ++i) {
            SASPropFile.copyProperty(SSL_PROPERTY_NAMES[i], properties, properties12);
        }
        Properties properties13 = new Properties();
        SASPropFile.copyProperty(SSL_ORB_CLIENT_QOP, properties, properties13);
        Properties properties14 = new Properties();
        SASPropFile.copyProperty(REQUEST_TIMEOUT, properties, properties14);
        outputStream.write(section_1a.getBytes());
        if (!properties.isEmpty()) {
            outputStream.write(section_1c.getBytes());
        }
        if (!properties2.isEmpty()) {
            outputStream.write(line_separator.getBytes());
            properties2.store(outputStream, clientSecEnable);
        }
        if (!properties3.isEmpty()) {
            outputStream.write(line_separator.getBytes());
            properties3.store(outputStream, rmiiop_auth_proc);
        }
        if (!properties4.isEmpty()) {
            outputStream.write(line_separator.getBytes());
            properties4.store(outputStream, sec_auth);
        }
        if (!properties5.isEmpty()) {
            outputStream.write(line_separator.getBytes());
            properties5.store(outputStream, rmiiop_user_id);
        }
        if (!properties6.isEmpty()) {
            outputStream.write(line_separator.getBytes());
            properties6.store(outputStream, CSIv2_Config + line_separator + stateful_sessions);
        }
        if (!properties7.isEmpty()) {
            outputStream.write(line_separator.getBytes());
            properties7.store(outputStream, basicAuth_client_auth);
        }
        if (!properties8.isEmpty()) {
            outputStream.write(line_separator.getBytes());
            properties8.store(outputStream, ssl_client_auth);
        }
        outputStream.write(line_separator.getBytes());
        outputStream.write(note_both__ba_ssl.getBytes());
        outputStream.write(line_separator.getBytes());
        if (!properties9.isEmpty()) {
            outputStream.write(line_separator.getBytes());
            properties9.store(outputStream, ssl_connection);
        }
        if (!properties10.isEmpty()) {
            outputStream.write(line_separator.getBytes());
            properties10.store(outputStream, cipher_40bit);
        }
        outputStream.write(note_ssl.getBytes());
        if (!properties11.isEmpty()) {
            outputStream.write(line_separator.getBytes());
            properties11.store(outputStream, cipher_128bit);
        }
        outputStream.write(note_ssl.getBytes());
        if (!properties12.isEmpty()) {
            outputStream.write(line_separator.getBytes());
            properties12.store(outputStream, ssl_op);
        }
        if (!properties13.isEmpty()) {
            outputStream.write(line_separator.getBytes());
            properties13.store(outputStream, perform_qop);
        }
        if (!properties14.isEmpty()) {
            outputStream.write(line_separator.getBytes());
            properties14.store(outputStream, request_timeout);
        }
        if (!properties.isEmpty()) {
            outputStream.write(section_4.getBytes());
            outputStream.write(line_separator.getBytes());
            properties.store(outputStream, misc);
        }
    }
}

