/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.ipc.ssl.CryptoHardwareToken;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.orbssl.WSPKCSInKeyStore;
import com.ibm.ws.security.orbssl.WSPKCSInKeyStoreList;
import com.ibm.ws.security.orbssl.WSX509KeyManager;
import com.ibm.ws.security.util.SASPropFile;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.JSSEProviderFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.emf.common.util.EList;

public class SSLConfig {
    private static TraceComponent tc = Tr.register((class$com$ibm$ws$ssl$SSLConfig == null ? (class$com$ibm$ws$ssl$SSLConfig = SSLConfig.class$("com.ibm.ws.ssl.SSLConfig")) : class$com$ibm$ws$ssl$SSLConfig).getName(), "SSL");
    private static WSPKCSInKeyStoreList pKSL = new WSPKCSInKeyStoreList();
    public static final String PROTOCOL = "com.ibm.ssl.protocol";
    public static final String KEY_MANAGER = "com.ibm.ssl.keyManager";
    public static final String KEY_STORE_TYPE = "com.ibm.ssl.keyStoreType";
    public static final String KEY_STORE_PROVIDER = "com.ibm.ssl.keyStoreProvider";
    public static final String KEY_FILE_NAME = "com.ibm.ssl.keyStore";
    public static final String KEY_FILE_PASSWORD = "com.ibm.ssl.keyStorePassword";
    public static final String TRUST_MANAGER = "com.ibm.ssl.trustManager";
    public static final String TRUST_STORE_TYPE = "com.ibm.ssl.trustStoreType";
    public static final String TRUST_STORE_PROVIDER = "com.ibm.ssl.trustStoreProvider";
    public static final String TRUST_FILE_NAME = "com.ibm.ssl.trustStore";
    public static final String TRUST_FILE_PASSWORD = "com.ibm.ssl.trustStorePassword";
    public static final String ENABLED_CIPHER_SUITES = "com.ibm.ssl.enabledCipherSuites";
    public static final String CLIENT_AUTH = "com.ibm.ssl.clientAuthentication";
    public static final String CONTEXT_PROVIDER = "com.ibm.ssl.contextProvider";
    public static final String SECURITY_LEVEL = "com.ibm.ssl.securityLevel";
    public static final String TOKEN_TYPE = "com.ibm.ssl.tokenType";
    public static final String TOKEN_LIBRARY_FILE = "com.ibm.ssl.tokenLibraryFile";
    public static final String TOKEN_PASSWORD = "com.ibm.ssl.tokenPassword";
    public static final String TOKEN_SLOT = "com.ibm.ssl.tokenSlot";
    public static final String CLIENT_KEY_ALIAS = "com.ibm.ssl.keyStoreClientAlias";
    public static final String SERVER_KEY_ALIAS = "com.ibm.ssl.keyStoreServerAlias";
    public static final String CLIENT_SIDE = "client";
    public static final String SERVER_SIDE = "server";
    public static final String SOCKET_FACTORY = "ssl.SocketFactory.provider";
    public static final String IBMJSSEFIPS_SOCKET_FACTORY = "com.ibm.fips.jsse.JSSESocketFactory";
    public static final String IBMJSSE_SOCKET_FACTORY = "com.ibm.jsse.JSSESocketFactory";
    public static final String[] PROP_NAMES = SASPropFile.SSL_PROP_NAMES;
    private static final SSLConfig defaultServerConfig = new SSLConfig(true);
    private static final SSLConfig defaultClientConfig = new SSLConfig(false);
    private static JSSEProvider jsseProvider = null;
    private boolean isServer;
    private String prefix;
    private SSLConfig parent;
    private SSLSocketFactory socketFactory = null;
    private SSLServerSocketFactory serverSocketFactory = null;
    private final HashMap myProps = new HashMap();
    static /* synthetic */ Class class$com$ibm$ws$ssl$SSLConfig;

    public static SSLConfig getDefaultClientConfig() {
        return defaultClientConfig;
    }

    public static SSLConfig getDefaultServerConfig() {
        return defaultServerConfig;
    }

    public SSLConfig(boolean bl) {
        this.parent = null;
        this.prefix = "";
        this.isServer = bl;
        if (bl) {
            this.setProtocol("SSL");
        } else {
            this.setProtocol("SSLv3");
        }
        this.setKeyManager("IbmX509");
        this.setKeyStoreType("JKS");
        this.setTrustManager("IbmX509");
        this.setTrustStoreType("JKS");
        this.setSecurityLevel("high");
        this.setTokenType("PKCS#11");
        this.setContextProvider("IBMJSSE");
        this.setEnabledCipherSuites(null);
    }

    public SSLConfig(SSLConfig sSLConfig, String string) {
        this.parent = sSLConfig;
        this.prefix = string;
    }

    public void init(Properties properties) throws IllegalArgumentException {
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Object object = properties.get(string2);
            string2 = string2.substring(this.prefix.length());
            this.setValue(string2, object);
            if (SOCKET_FACTORY.equals(string2)) {
                bl = true;
                continue;
            }
            if (!CONTEXT_PROVIDER.equals(string2)) continue;
            bl2 = true;
            string = (String)object;
        }
        if (!bl) {
            if (bl2) {
                if ("IBMJSSE".equals(string)) {
                    this.setValue(SOCKET_FACTORY, IBMJSSE_SOCKET_FACTORY);
                } else if ("IBMJSSEFIPS".equals(string)) {
                    this.setValue(SOCKET_FACTORY, IBMJSSEFIPS_SOCKET_FACTORY);
                } else {
                    Tr.warning(tc, "ContextProvider defined but SocketFactory not defined, Soap connector might fail.");
                }
            } else {
                this.setValue(SOCKET_FACTORY, IBMJSSE_SOCKET_FACTORY);
            }
        }
        jsseProvider = JSSEProviderFactory.getInstance(string);
    }

    public void init(SecureSocketLayer secureSocketLayer) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        if (secureSocketLayer == null) {
            return;
        }
        String string6 = this.checkKeyStoreType(secureSocketLayer.getKeyFileFormat().toString());
        if (!this.hasValue(string6)) {
            string6 = System.getProperty("javax.net.ssl.keyStoreType", string6);
        }
        if (this.hasValue(string6)) {
            this.setKeyStoreType(string6);
        }
        if (!this.hasValue(string5 = secureSocketLayer.getKeyFileName())) {
            string5 = System.getProperty("javax.net.ssl.keyStore", string5);
        }
        if (this.hasValue(string5)) {
            this.setKeyFileName(string5);
        }
        if (!this.hasValue(string4 = secureSocketLayer.getKeyFilePassword())) {
            string4 = System.getProperty("javax.net.ssl.keyStorePassword", string4);
        }
        if (this.hasValue(string4)) {
            this.setKeyFilePassword(string4);
        }
        if (!this.hasValue(string3 = this.checkKeyStoreType(secureSocketLayer.getTrustFileFormat().toString()))) {
            string3 = System.getProperty("javax.net.ssl.trustStoreType", string3);
        }
        if (this.hasValue(string3)) {
            this.setTrustStoreType(string3);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TrustFileFormat was not specified, defualt to KeyFileFormat value");
            }
            this.setTrustStoreType(string6);
        }
        String string7 = secureSocketLayer.getTrustFileName();
        if (!this.hasValue(string7)) {
            string7 = System.getProperty("javax.net.ssl.trustStore", string7);
        }
        if (this.hasValue(string7)) {
            this.setTrustFileName(string7);
        }
        if (!this.hasValue(string2 = secureSocketLayer.getTrustFilePassword())) {
            string2 = System.getProperty("javax.net.ssl.trustStorePassword", string2);
        }
        if (this.hasValue(string2)) {
            this.setTrustFilePassword(string2);
        }
        if (this.hasValue(string = secureSocketLayer.getSecurityLevel().toString())) {
            this.setSecurityLevel(string);
        }
        boolean bl = secureSocketLayer.isClientAuthentication();
        this.setClientAuthentication(new Boolean(bl));
        boolean bl2 = secureSocketLayer.isEnableCryptoHardwareSupport();
        if (bl2) {
            CryptoHardwareToken cryptoHardwareToken = secureSocketLayer.getCryptoHardware();
            if (cryptoHardwareToken.getTokenType() != null) {
                this.setTokenType(cryptoHardwareToken.getTokenType());
            } else {
                this.setTokenType(System.getProperty("javax.net.ssl.tokenType", ""));
            }
            if (cryptoHardwareToken.getLibraryFile() != null) {
                this.setTokenLibraryFile(cryptoHardwareToken.getLibraryFile());
            } else {
                this.setTokenLibraryFile(System.getProperty("javax.net.ssl.tokenLibraryFile", ""));
            }
            if (cryptoHardwareToken.getPassword() != null) {
                this.setTokenPassword(cryptoHardwareToken.getPassword());
            } else {
                this.setTokenPassword(System.getProperty("javax.net.ssl.tokenPassword", ""));
            }
        }
        boolean bl3 = false;
        boolean bl4 = false;
        String string8 = null;
        EList eList = secureSocketLayer.getProperties();
        if (eList != null) {
            for (int i = 0; i < eList.size(); ++i) {
                Property property = (Property)eList.get(i);
                String string9 = property.getValue();
                String string10 = property.getName();
                if (this.hasValue(string9)) {
                    this.setValue(string10, string9);
                    if (SOCKET_FACTORY.equals(string10)) {
                        bl3 = true;
                        continue;
                    }
                    if (!CONTEXT_PROVIDER.equals(string10)) continue;
                    bl4 = true;
                    string8 = string9;
                    continue;
                }
                if (!string10.equals(CLIENT_KEY_ALIAS) && !string10.equals(SERVER_KEY_ALIAS) && !string10.equals(TOKEN_SLOT)) continue;
                int n = string10.lastIndexOf(46);
                this.setValue(string10, System.getProperty("javax.net.ssl" + string10.substring(n), ""));
            }
        }
        if (!bl3) {
            if (bl4) {
                if ("IBMJSSE".equals(string8)) {
                    this.setValue(SOCKET_FACTORY, IBMJSSE_SOCKET_FACTORY);
                } else if ("IBMJSSEFIPS".equals(string8)) {
                    this.setValue(SOCKET_FACTORY, IBMJSSEFIPS_SOCKET_FACTORY);
                } else {
                    Tr.warning(tc, "ContextProvider defined but SocketFactory not defined, Soap connector might fail.");
                }
            } else {
                this.setValue(SOCKET_FACTORY, IBMJSSE_SOCKET_FACTORY);
            }
        }
    }

    public String getProperty(String string) {
        if (KEY_FILE_PASSWORD.equals(string) || TRUST_FILE_PASSWORD.equals(string) || TOKEN_PASSWORD.equals(string)) {
            String string2 = (String)this.getValue(string);
            try {
                string2 = PasswordUtil.decode((String)string2);
            }
            catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.SSLConfig.getProperty", "434", this);
            }
            return string2;
        }
        if (!ENABLED_CIPHER_SUITES.equals(string) && !CLIENT_AUTH.equals(string)) {
            return (String)this.getValue(string);
        }
        if (ENABLED_CIPHER_SUITES.equals(string)) {
            return this.makeString((String[])this.getValue(string));
        }
        return ((Boolean)this.getValue(string)).toString();
    }

    public void setProperty(String string, String string2) throws IllegalArgumentException {
        this.setValue(string, string2);
    }

    private Object getValue(String string) {
        Object v = this.myProps.get(string);
        if (v == null && this.parent != null) {
            return this.parent.getValue(string);
        }
        return v;
    }

    private void setValue(String string, Object stringArray) throws IllegalArgumentException {
        if (string.equals(CLIENT_AUTH) && stringArray instanceof String) {
            stringArray = new Boolean((String)stringArray);
        } else if (string.equals(ENABLED_CIPHER_SUITES) && stringArray instanceof String) {
            stringArray = this.makeStringArray((String)stringArray);
        }
        this.iSetValue(string, stringArray);
    }

    private void iSetValue(String string, Object object) {
        Object v = this.myProps.get(string);
        if (v != null && v.equals(object) || object == null || object instanceof String && ((String)object).length() == 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            if (string.indexOf("Password") != -1) {
                Tr.debug(tc, "SSL property: name=" + string + "; value=" + "*****");
            } else {
                Tr.debug(tc, "SSL property: name=" + string + "; value=" + object);
            }
        }
        this.myProps.put(string, object);
        this.socketFactory = null;
        this.serverSocketFactory = null;
    }

    public boolean isServer() {
        return this.isServer;
    }

    public boolean isClient() {
        return !this.isServer;
    }

    public String getProtocol() {
        return this.getProperty(PROTOCOL);
    }

    public void setProtocol(String string) {
        this.iSetValue(PROTOCOL, string);
    }

    public String getKeyManager() {
        return this.getProperty(KEY_MANAGER);
    }

    public void setKeyManager(String string) {
        this.iSetValue(KEY_MANAGER, string);
    }

    public String getKeyStoreType() {
        return this.getProperty(KEY_STORE_TYPE);
    }

    public void setKeyStoreType(String string) {
        this.iSetValue(KEY_STORE_TYPE, string);
    }

    public String getKeyStoreProvider() {
        return this.getProperty(KEY_STORE_PROVIDER);
    }

    public void setKeyStoreProvider(String string) {
        this.iSetValue(KEY_STORE_PROVIDER, string);
    }

    public String getContextProvider() {
        return this.getProperty(CONTEXT_PROVIDER);
    }

    public void setContextProvider(String string) {
        this.iSetValue(CONTEXT_PROVIDER, string);
    }

    public String getSocketfactory() {
        return this.getProperty(SOCKET_FACTORY);
    }

    public void setSocketFactory(String string) {
        this.iSetValue(SOCKET_FACTORY, string);
    }

    public String getKeyFileName() {
        return this.getProperty(KEY_FILE_NAME);
    }

    public void setKeyFileName(String string) {
        this.iSetValue(KEY_FILE_NAME, string);
    }

    public String getKeyFilePassword() {
        return this.getProperty(KEY_FILE_PASSWORD);
    }

    public void setKeyFilePassword(String string) {
        this.iSetValue(KEY_FILE_PASSWORD, string);
    }

    public String getTrustManager() {
        return this.getProperty(TRUST_MANAGER);
    }

    public void setTrustManager(String string) {
        this.iSetValue(TRUST_MANAGER, string);
    }

    public String getTrustStoreType() {
        return this.getProperty(TRUST_STORE_TYPE);
    }

    public void setTrustStoreType(String string) {
        this.iSetValue(TRUST_STORE_TYPE, string);
    }

    public String getTrustStoreProvider() {
        return this.getProperty(TRUST_STORE_PROVIDER);
    }

    public void setTrustStoreProvider(String string) {
        this.iSetValue(TRUST_STORE_PROVIDER, string);
    }

    public String getTrustFileName() {
        return this.getProperty(TRUST_FILE_NAME);
    }

    public void setTrustFileName(String string) {
        this.iSetValue(TRUST_FILE_NAME, string);
    }

    public String getTrustFilePassword() {
        return this.getProperty(TRUST_FILE_PASSWORD);
    }

    public void setTrustFilePassword(String string) {
        this.iSetValue(TRUST_FILE_PASSWORD, string);
    }

    public Boolean getClientAuthentication() {
        return (Boolean)this.getValue(CLIENT_AUTH);
    }

    public void setClientAuthentication(Boolean bl) {
        this.iSetValue(CLIENT_AUTH, bl);
    }

    public String getKeyStoreClientAlias() {
        return (String)this.getValue(CLIENT_KEY_ALIAS);
    }

    public void setKeyStoreClientAlias(String string) {
        this.iSetValue(CLIENT_KEY_ALIAS, string);
    }

    public String getKeyStoreServerAlias() {
        return (String)this.getValue(SERVER_KEY_ALIAS);
    }

    public void setKeyStoreServerAlias(String string) {
        this.iSetValue(SERVER_KEY_ALIAS, string);
    }

    public String[] getEnabledCipherSuites() {
        String string = this.getSecurityLevel();
        String[] stringArray = (String[])this.getValue(ENABLED_CIPHER_SUITES);
        String[] stringArray2 = null;
        if (stringArray != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "enabledCipherSuites " + stringArray);
            }
            return stringArray;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Use default set of cipher suites for securityLevel " + string);
        }
        stringArray2 = this.getJSSEProvider().getCiphersForSecurityLevel(this.isClient(), string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "defaultCipherSuites " + stringArray2);
        }
        return stringArray2;
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.iSetValue(ENABLED_CIPHER_SUITES, stringArray);
    }

    public String getSecurityLevel() {
        return this.getProperty(SECURITY_LEVEL);
    }

    public void setSecurityLevel(String string) {
        this.iSetValue(SECURITY_LEVEL, string);
    }

    public String getTokenType() {
        return this.getProperty(TOKEN_TYPE);
    }

    public void setTokenType(String string) {
        this.iSetValue(TOKEN_TYPE, string);
    }

    public String getTokenLibraryFile() {
        return this.getProperty(TOKEN_LIBRARY_FILE);
    }

    public void setTokenLibraryFile(String string) {
        this.iSetValue(TOKEN_LIBRARY_FILE, string);
    }

    public String getTokenPassword() {
        return this.getProperty(TOKEN_PASSWORD);
    }

    public void setTokenPassword(String string) {
        this.iSetValue(TOKEN_PASSWORD, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLSocketFactory getSocketFactory() throws Exception {
        if (this.socketFactory == null) {
            SSLConfig sSLConfig = this;
            synchronized (sSLConfig) {
                if (this.socketFactory == null) {
                    this.socketFactory = this.getSSLContext(CLIENT_SIDE).getSocketFactory();
                }
            }
        }
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLServerSocketFactory getServerSocketFactory() throws Exception {
        if (this.serverSocketFactory == null) {
            SSLConfig sSLConfig = this;
            synchronized (sSLConfig) {
                if (this.serverSocketFactory == null) {
                    this.serverSocketFactory = this.getSSLContext(SERVER_SIDE).getServerSocketFactory();
                }
            }
        }
        return this.serverSocketFactory;
    }

    public SSLSocket configure(Socket socket) {
        SSLSocket sSLSocket = (SSLSocket)socket;
        String[] stringArray = this.getEnabledCipherSuites();
        if (stringArray != null) {
            sSLSocket.setEnabledCipherSuites(stringArray);
        }
        return sSLSocket;
    }

    public SSLServerSocket configure(ServerSocket serverSocket) {
        Boolean bl;
        SSLServerSocket sSLServerSocket = (SSLServerSocket)serverSocket;
        String[] stringArray = this.getEnabledCipherSuites();
        if (stringArray != null) {
            sSLServerSocket.setEnabledCipherSuites(stringArray);
        }
        if ((bl = this.getClientAuthentication()) != null) {
            sSLServerSocket.setNeedClientAuth(bl);
        }
        return sSLServerSocket;
    }

    private SSLContext getSSLContext(String string) throws Exception {
        SSLContext sSLContext = null;
        try {
            WSPKCSInKeyStore wSPKCSInKeyStore;
            KeyManager[] keyManagerArray;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getting sslContext with protocol: " + this.getProtocol());
            }
            sSLContext = this.getJSSEProvider().getSSLContextInstance(this.getProtocol());
            String string2 = !this.hasValue(this.getProperty(TOKEN_SLOT)) ? "0" : this.getProperty(TOKEN_SLOT);
            String string3 = this.getTokenLibraryFile();
            String string4 = "";
            String string5 = "";
            Object var7_8 = null;
            Object var8_9 = null;
            int n = -1;
            int n2 = -1;
            if (this.hasValue(string3)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using cryptographic token.");
                }
                string3 = string3 + ":" + string2;
                if (string.equalsIgnoreCase(CLIENT_SIDE)) {
                    string4 = this.getKeyStoreClientAlias();
                    n = Integer.valueOf(string2);
                }
                if (string.equalsIgnoreCase(SERVER_SIDE)) {
                    string5 = this.getKeyStoreServerAlias();
                    n2 = Integer.valueOf(string2);
                    string4 = this.getKeyStoreClientAlias();
                    n = Integer.valueOf(string2);
                }
            }
            TrustManagerFactory trustManagerFactory = null;
            TrustManager[] trustManagerArray = null;
            KeyStore keyStore = null;
            if (this.hasValue(this.getTrustFileName()) && this.hasValue(this.getTrustFilePassword())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using trust store: " + this.getTrustFileName());
                }
                keyStore = this.getKeyStore(this.getTrustStoreType(), this.getTrustStoreProvider(), this.getTrustFileName(), this.getTrustFilePassword());
                trustManagerFactory = this.getJSSEProvider().getTrustManagerFactoryInstance();
                trustManagerFactory.init(keyStore);
            } else if (this.hasValue(string3)) {
                keyManagerArray = pKSL.insert(this.getTokenType(), string3, this.getTokenPassword(), false);
                if (keyManagerArray != null) {
                    keyStore = keyManagerArray.getTS();
                    trustManagerFactory = keyManagerArray.getTMF();
                } else {
                    Tr.error(tc, "Unable to get a PKCS keystore.");
                }
            }
            if (trustManagerFactory != null) {
                trustManagerArray = trustManagerFactory.getTrustManagers();
            }
            keyManagerArray = null;
            KeyStore keyStore2 = null;
            char[] cArray = null;
            KeyManagerFactory keyManagerFactory = null;
            if (this.hasValue(this.getKeyFileName()) && this.hasValue(this.getKeyFilePassword())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using software keystore: " + this.getKeyFileName());
                }
                keyStore2 = this.getKeyStore(this.getKeyStoreType(), this.getKeyStoreProvider(), this.getKeyFileName(), this.getKeyFilePassword());
                keyManagerFactory = this.getJSSEProvider().getKeyManagerFactoryInstance();
                if (this.hasValue(this.getKeyFilePassword())) {
                    cArray = this.getKeyFilePassword().toCharArray();
                }
                try {
                    keyManagerFactory.init(keyStore2, cArray);
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {
                    if (cArray == null) {
                        throw new UnrecoverableKeyException(unrecoverableKeyException.getMessage() + ": unspecified password for file '" + this.getKeyFileName() + "'");
                    }
                    throw new UnrecoverableKeyException(unrecoverableKeyException.getMessage() + ": invalid password for file '" + this.getKeyFileName() + "'");
                }
                keyManagerArray = keyManagerFactory.getKeyManagers();
            } else if (this.hasValue(string3)) {
                wSPKCSInKeyStore = pKSL.insert(this.getTokenType(), string3, this.getTokenPassword(), true);
                if (wSPKCSInKeyStore != null) {
                    keyStore2 = wSPKCSInKeyStore.getKS();
                    keyManagerFactory = wSPKCSInKeyStore.getKMF();
                } else {
                    Tr.error(tc, "Unable to get a PKCS keystore.");
                }
            }
            if (string.equalsIgnoreCase(CLIENT_SIDE)) {
                wSPKCSInKeyStore = new WSX509KeyManager(keyStore2, cArray, keyManagerFactory);
                if (wSPKCSInKeyStore == null || wSPKCSInKeyStore.getX509KeyManager() == null || !this.hasValue(string4)) {
                    KeyManager[] keyManagerArray2 = keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null;
                    sSLContext.init(keyManagerArray2, trustManagerArray, null);
                } else {
                    wSPKCSInKeyStore.setClientAlias(string4, n);
                    KeyManager[] keyManagerArray3 = new KeyManager[]{wSPKCSInKeyStore};
                    sSLContext.init(keyManagerArray3, trustManagerArray, null);
                }
            } else if (string.equalsIgnoreCase(SERVER_SIDE)) {
                wSPKCSInKeyStore = new WSX509KeyManager(keyStore2, cArray, keyManagerFactory);
                if (wSPKCSInKeyStore == null || wSPKCSInKeyStore.getX509KeyManager() == null || !this.hasValue(string5) && !this.hasValue(string4)) {
                    KeyManager[] keyManagerArray4 = keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null;
                    sSLContext.init(keyManagerArray4, trustManagerArray, null);
                } else {
                    if (this.hasValue(string4)) {
                        wSPKCSInKeyStore.setClientAlias(string4, n);
                    }
                    if (this.hasValue(string5)) {
                        wSPKCSInKeyStore.setServerAlias(string5, n2);
                    }
                    KeyManager[] keyManagerArray5 = new KeyManager[]{wSPKCSInKeyStore};
                    sSLContext.init(keyManagerArray5, trustManagerArray, null);
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSL context: " + exception.getMessage(), new Object[]{exception});
            }
            Tr.error(tc, "Unable to get SSL context: ", exception.getLocalizedMessage());
            throw exception;
        }
        return sSLContext;
    }

    private KeyStore getKeyStore(String string, String string2, String string3, String string4) throws Exception {
        KeyStore keyStore = null;
        boolean bl = true;
        int n = 0;
        while (bl) {
            keyStore = this.getJSSEProvider().getKeyStoreInstance(string);
            FileInputStream fileInputStream = new FileInputStream(string3);
            char[] cArray = null;
            if (this.hasValue(string4)) {
                cArray = string4.toCharArray();
            }
            try {
                keyStore.load(fileInputStream, cArray);
                bl = false;
            }
            catch (IOException iOException) {
                if (iOException.getMessage().equalsIgnoreCase("Invalid keystore format") || iOException.getMessage().indexOf("DerInputStream.getLength()") != -1) {
                    Tr.warning(tc, "security.ssl.config.initialization.warning.invalidkeystoretype");
                    if (string.equalsIgnoreCase("JKS")) {
                        string = "JCEKS";
                    } else if (string.equalsIgnoreCase("JCEKS")) {
                        string = "PKCS12";
                    } else if (string.equalsIgnoreCase("PKCS12")) {
                        string = "JCEKS";
                    }
                    if (n++ <= 1) continue;
                    throw iOException;
                }
                throw iOException;
            }
        }
        return keyStore;
    }

    private boolean hasValue(String string) {
        return string != null && string.length() > 0;
    }

    private String[] makeStringArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
            ++n;
        }
        String[] stringArray = new String[n];
        stringTokenizer = new StringTokenizer(string);
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private String makeString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        String string = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string = string + " ";
            string = string + stringArray[i];
        }
        return string;
    }

    private JSSEProvider getJSSEProvider() {
        if (jsseProvider == null) {
            jsseProvider = JSSEProviderFactory.getInstance();
        }
        return jsseProvider;
    }

    public void print() {
        if (tc.isDebugEnabled()) {
            for (int i = 0; i < PROP_NAMES.length; ++i) {
                if (PROP_NAMES[i].equals(KEY_FILE_PASSWORD) || PROP_NAMES[i].equals(TRUST_FILE_PASSWORD) || PROP_NAMES[i].equals(TOKEN_PASSWORD)) continue;
                Tr.debug(tc, PROP_NAMES[i] + " = " + this.getValue(PROP_NAMES[i]));
            }
        }
    }

    private String checkKeyStoreType(String string) {
        if (string != null && string.equalsIgnoreCase("JCEK")) {
            return "JCEKS";
        }
        return string;
    }

    private boolean checkProvider(String string) {
        block11: {
            Provider provider = null;
            if (!this.hasValue(string)) {
                return false;
            }
            try {
                provider = Security.getProvider(string);
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getProvider(" + string + ") exception caught: ", throwable);
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.ssl.SSLConfig.checkProvider", "1175", this);
            }
            try {
                if (provider != null) break block11;
                String string2 = null;
                if (string.equalsIgnoreCase("IBMJSSE") || string.equalsIgnoreCase("JSSE")) {
                    string2 = "com.ibm.jsse.IBMJSSEProvider";
                } else if (string.equalsIgnoreCase("IBMJSSEFIPS")) {
                    string2 = "com.ibm.fips.jsse.IBMJSSEFIPSProvider";
                }
                if (string2 != null) {
                    provider = (Provider)Class.forName(string2).newInstance();
                    Security.addProvider(provider);
                    break block11;
                }
                return false;
            }
            catch (Exception exception) {
                Tr.warning(tc, "security.addprovider.error", new Object[]{exception});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught adding provider: " + string + ", exception caught: ", exception);
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.SSLConfig.checkProvider", "1210", this);
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

