/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.FileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;

public class ExtendedDocumentRootUtils {
    private static TraceComponent tc = Tr.register((class$com$ibm$ws$util$ExtendedDocumentRootUtils == null ? (class$com$ibm$ws$util$ExtendedDocumentRootUtils = ExtendedDocumentRootUtils.class$("com.ibm.ws.util.ExtendedDocumentRootUtils")) : class$com$ibm$ws$util$ExtendedDocumentRootUtils).getName(), "Extended_DocumentRootUtils");
    private static boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    private Vector searchPath = new Vector();
    private InputStream resourceInputStream = null;
    private File matchedFile;
    private boolean useContentLength = false;
    private String fullPath;
    static /* synthetic */ Class class$com$ibm$ws$util$ExtendedDocumentRootUtils;

    public ExtendedDocumentRootUtils(ServletContext servletContext, String string) {
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "constructor: extendedDocumentRoot ", string);
            }
            this.createSearchPath(servletContext, string);
        }
    }

    public ExtendedDocumentRootUtils(String string, String string2) {
        if (string2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "constructor: baseDir ", string);
                Tr.debug(tc, "constructor: extendedDocumentRoot ", string2);
            }
            this.createSearchPath(string, string2);
        }
    }

    public boolean searchPathExists() {
        if (tc.isDebugEnabled()) {
            String string = !this.searchPath.isEmpty() ? "true" : "false";
            Tr.debug(tc, "searchPathExists ", string);
        }
        return !this.searchPath.isEmpty();
    }

    private void createSearchPath(ServletContext servletContext, String string) {
        String string2 = servletContext.getRealPath("/../");
        this.createSearchPath(string2, string);
    }

    private void createSearchPath(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createSearchPath: baseDir ", string);
            Tr.debug(tc, "createSearchPath: extendedDocumentRoot ", string2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                File file;
                String string3 = stringTokenizer.nextToken().trim();
                if (string3 == null) continue;
                if (isWindows && string3.indexOf(":") == 1 || string3.startsWith("/")) {
                    file = new File(string3);
                    this.searchPath.addElement(file.toString());
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "add to searchPath " + file.toString());
                    continue;
                }
                file = new File(string + string3);
                String string4 = file.getCanonicalPath();
                this.searchPath.addElement(string4);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "add to searchPath " + string4);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
            }
        }
    }

    public void handleExtendedDocumentRoots(String string) throws FileNotFoundException, IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleExtendedDocumentRoots: filename " + string);
        }
        Enumeration enumeration = this.searchPath.elements();
        InputStream inputStream = null;
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry;
            Object object;
            String string2 = enumeration.nextElement().toString();
            File file = new File(string2);
            if (file.isDirectory()) {
                object = new File(file, string);
                if (!((File)object).exists()) continue;
                this.setMatchedFile((File)object);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "handleExtendedDocumentRoots: found match in directory" + ((File)object).toString());
                }
                this.setFullPathToResource(((File)object).toString());
                this.handleCaseSensitivityCheck(this.matchedFile.toString(), string);
                inputStream = new FileInputStream(this.matchedFile);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "handleExtendedDocumentRoots: setMatchedFile " + this.matchedFile.toString());
                }
                this.setInputStream(inputStream);
                this.useContentLength = true;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "handleExtendedDocumentRoots: useContentLength " + this.useContentLength);
                break;
            }
            if (!file.exists() || (zipEntry = ((ZipFile)(object = new ZipFile(file))).getEntry(string.substring(1).replace('\\', '/'))) == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handleExtendedDocumentRoots: found match in zip or jar file" + file.toString());
            }
            this.setMatchedFile(file);
            this.setFullPathToResource(file.toString() + "!" + string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handleExtendedDocumentRoots: setFullPathToResource " + this.getFullPathToResource());
            }
            inputStream = ((ZipFile)object).getInputStream(zipEntry);
            this.setInputStream(inputStream);
            break;
        }
        if (inputStream == null || this.matchedFile == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handleExtendedDocumentRoots: unable to locate resource " + string);
            }
            throw new FileNotFoundException(string);
        }
    }

    private void setFullPathToResource(String string) {
        this.fullPath = string;
    }

    public String getFullPathToResource() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getFullPathToResource = [" + this.fullPath + "]");
        }
        return this.fullPath;
    }

    private void setInputStream(InputStream inputStream) {
        this.resourceInputStream = inputStream;
    }

    public InputStream getInputStream() throws FileNotFoundException, IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getInputStream for ExtendedDocumentRoot");
        }
        return this.resourceInputStream;
    }

    private void setMatchedFile(File file) {
        this.matchedFile = file;
    }

    public File getMatchedFile() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getMatchedFile = [" + this.matchedFile + "]");
        }
        return this.matchedFile;
    }

    public long getLastModifiedMatchedFile() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLastModifiedMatchedFile = [" + (this.matchedFile == null ? 0L : this.matchedFile.lastModified()) + "]");
        }
        return this.matchedFile == null ? 0L : this.matchedFile.lastModified();
    }

    public boolean useContentLength() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "useContentLength = [" + this.useContentLength + "]");
        }
        return this.useContentLength;
    }

    private void handleCaseSensitivityCheck(String string, String string2) throws FileNotFoundException, IOException {
        if (FileSystem.isCaseInsensitive) {
            File file;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "file system is case insensitive");
            }
            if (!FileSystem.uriCaseCheck(file = new File(string), string2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "handleCaseSensitivityCheck failed for = [" + string + "]");
                }
                throw new FileNotFoundException(string);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

