/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

public class ImplFactory {
    private static final String PROPERTIES_PATH = "implfactory.properties";
    private static Properties _props;

    public static Object loadImplFromKey(String string) {
        Class clazz = ImplFactory.loadClassFromKey(string);
        return ImplFactory.loadImplFromClass(clazz);
    }

    public static Object loadImplFromKey(Class clazz) {
        return ImplFactory.loadImplFromKey(clazz.getName());
    }

    public static Object loadImplFromClass(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass(string);
            return ImplFactory.loadImplFromClass(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new IllegalStateException(classNotFoundException.getMessage());
        }
    }

    public static Object loadImplFromClass(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.util.ImplFactory.loadImplFromClass", "68");
            throwable.printStackTrace();
            throw new IllegalStateException(clazz.getName() + " is not a valid class.");
        }
    }

    public static Class loadClassFromKey(Class clazz) {
        return ImplFactory.loadClassFromKey(clazz.getName());
    }

    public static Class loadClassFromKey(String string) {
        String string2 = _props.getProperty(string);
        if (string2 == null) {
            throw new NoClassDefFoundError("Invalid Implementation Key, " + string);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return classLoader.loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new IllegalStateException(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            _props = new Properties();
            final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    InputStream inputStream = classLoader.getResourceAsStream(ImplFactory.PROPERTIES_PATH);
                    _props.load(inputStream);
                    inputStream.close();
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.util.ImplFactory", "35");
            System.err.println("Unable to read required resource: implfactory.properties");
            throwable.printStackTrace();
        }
    }
}

