/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.http.HttpTransport;
import com.ibm.ws.util.CaptureServerSocket;
import com.ibm.ws.util.DebugServerSocket;
import com.ibm.ws.util.ReplayServerSocket;
import java.io.File;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.Properties;

public class ServerSocketFactory {
    private static String SOCKET_MODE = "socketMode";
    private static String NORMAL = "normal";
    private static String TRACE = "trace";
    private static String CAPTURE = "capture";
    private static String REPLAY = "replay";
    private static String CAPTURE_FILE = "captureFile";
    private static String MAX_INTERVALS = "maxIntervals";
    private static String MAX_ITERATIONS = "maxIterations";

    public static ServerSocket getInstance(int n, int n2, InetAddress inetAddress, HttpTransport httpTransport, Properties properties) throws Exception {
        String string = properties.getProperty(SOCKET_MODE);
        if (string == null) {
            throw new Exception(SOCKET_MODE + " not specified");
        }
        if (string.equalsIgnoreCase(NORMAL)) {
            return new ServerSocket(n, n2, inetAddress);
        }
        if (string.equalsIgnoreCase(TRACE)) {
            return new DebugServerSocket(n, n2, inetAddress);
        }
        if (string.equalsIgnoreCase(CAPTURE) || string.equalsIgnoreCase(REPLAY)) {
            String string2 = properties.getProperty(CAPTURE_FILE);
            if (string2 == null) {
                throw new Exception(CAPTURE_FILE + " not specified");
            }
            string2 = string2.replace('/', File.separatorChar);
            if (string.equalsIgnoreCase(CAPTURE)) {
                return new CaptureServerSocket(n, n2, inetAddress, string2, true);
            }
            String string3 = properties.getProperty(MAX_ITERATIONS);
            if (string3 == null) {
                throw new Exception(MAX_ITERATIONS + " not specified");
            }
            String string4 = properties.getProperty(MAX_INTERVALS);
            if (string4 == null) {
                string4 = "3";
            }
            int[] nArray = new int[Integer.parseInt(string4)];
            Arrays.fill(nArray, Integer.parseInt(string3));
            return new ReplayServerSocket(httpTransport, string2, nArray);
        }
        throw new Exception("invalid " + SOCKET_MODE);
    }
}

