/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.BoundedBuffer;
import com.ibm.ws.util.ThreadPoolListener;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TooManyListenersException;

public class ThreadPool {
    private static TraceComponent tc = Tr.register(class$com$ibm$ws$util$ThreadPool == null ? (class$com$ibm$ws$util$ThreadPool = ThreadPool.class$("com.ibm.ws.util.ThreadPool")) : class$com$ibm$ws$util$ThreadPool, "Runtime", "com.ibm.ws.runtime.runtime");
    public static final int DEFAULT_MAXIMUMPOOLSIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_MINIMUMPOOLSIZE = 1;
    public static final long DEFAULT_KEEPALIVETIME = 5000L;
    protected int maximumPoolSize_ = Integer.MAX_VALUE;
    protected int minimumPoolSize_ = 1;
    protected int poolSize_ = 0;
    protected int activeThreads = 0;
    protected long keepAliveTime_ = 5000L;
    protected BoundedBuffer requestBuffer;
    protected boolean shutdown_ = false;
    protected final Map threads_;
    protected int threadid = 0;
    protected boolean growasneeded = false;
    protected int threadpriority = 5;
    private static ThreadPoolListener[] ZERO_TP_LISTENERS = new ThreadPoolListener[0];
    protected ThreadPoolListener[] threadPoolListeners;
    protected String name;
    public static final int WAIT_WHEN_QUEUE_IS_FULL = 0;
    public static final int ERROR_WHEN_QUEUE_IS_FULL = 1;
    public static final int EXPAND_WHEN_QUEUE_IS_FULL_ERROR_AT_LIMIT = 2;
    public static final int EXPAND_WHEN_QUEUE_IS_FULL_WAIT_AT_LIMIT = 3;
    private int requestBufferExpansionLimit_;
    private int requestBufferInitialCapacity_;
    private MonitorPlugin monitorPlugin = null;
    private static Field threadLocalsField;
    static Object[] ZERO_OBJECTS;
    static /* synthetic */ Class class$com$ibm$ws$util$ThreadPool;
    static /* synthetic */ Class class$java$lang$Thread;

    public synchronized void setRequestBufferSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("request buffer size must be greater than zero");
        }
        this.requestBuffer = new BoundedBuffer(n);
        this.requestBufferInitialCapacity_ = n;
    }

    public void setRequestBufferExpansionLimit(int n) {
        this.requestBufferExpansionLimit_ = n;
    }

    public synchronized int getRequestBufferSize() {
        return this.requestBuffer.capacity();
    }

    public ThreadPool(int n, int n2, ThreadPoolListener[] threadPoolListenerArray) {
        this(null, n, n2, threadPoolListenerArray);
    }

    public ThreadPool(String string, int n, int n2) {
        this(string, n, n2, null);
    }

    public ThreadPool(String string, int n, int n2, ThreadPoolListener[] threadPoolListenerArray) {
        this.name = string;
        this.maximumPoolSize_ = n2;
        this.minimumPoolSize_ = n;
        this.threads_ = new HashMap();
        this.requestBufferInitialCapacity_ = (n + n2) / 2;
        this.requestBuffer = new BoundedBuffer(this.requestBufferInitialCapacity_);
        this.requestBufferExpansionLimit_ = n2 * 10;
        this.threadPoolListeners = threadPoolListenerArray == null ? ZERO_TP_LISTENERS : (ThreadPoolListener[])threadPoolListenerArray.clone();
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadPoolCreated(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public synchronized int getMaximumPoolSize() {
        return this.maximumPoolSize_;
    }

    public synchronized void setMaximumPoolSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize_ = n;
    }

    public synchronized int getMinimumPoolSize() {
        return this.minimumPoolSize_;
    }

    public synchronized void setMinimumPoolSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.minimumPoolSize_ = n;
    }

    public synchronized int getPoolSize() {
        return this.poolSize_;
    }

    public synchronized long getKeepAliveTime() {
        return this.keepAliveTime_;
    }

    public synchronized void setKeepAliveTime(long l) {
        this.keepAliveTime_ = l;
    }

    protected void addThread(Runnable runnable) {
        Worker worker = new Worker(runnable, this.threadid++);
        this.threads_.put(worker, worker);
        ++this.poolSize_;
        ++this.activeThreads;
        this.fireThreadCreated(this.poolSize_);
        worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createThreads(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (this.poolSize_ < this.maximumPoolSize_) {
                    this.addThread(null);
                    ++n2;
                } else {
                    break;
                }
                continue;
            }
        }
        return n2;
    }

    public synchronized void shutdownNow() {
        this.shutdown_ = true;
        this.maximumPoolSize_ = 0;
        this.minimumPoolSize_ = 0;
        this.interruptAll();
    }

    public synchronized void shutdownAfterProcessingCurrentlyQueuedTasks() {
        this.shutdown_ = true;
        if (this.poolSize_ == 0) {
            this.maximumPoolSize_ = 0;
            this.minimumPoolSize_ = 0;
        }
    }

    public synchronized void interruptAll() {
        Iterator iterator = this.threads_.values().iterator();
        while (iterator.hasNext()) {
            Thread thread = (Thread)iterator.next();
            thread.interrupt();
        }
    }

    public synchronized boolean awaitTerminationAfterShutdown(long l) throws InterruptedException {
        if (!this.shutdown_) {
            throw new IllegalStateException();
        }
        if (this.poolSize_ == 0) {
            return true;
        }
        long l2 = l;
        if (l2 <= 0L) {
            return false;
        }
        long l3 = System.currentTimeMillis();
        do {
            this.wait(l2);
            if (this.poolSize_ != 0) continue;
            return true;
        } while ((l2 = l - (System.currentTimeMillis() - l3)) > 0L);
        return false;
    }

    public synchronized void awaitTerminationAfterShutdown() throws InterruptedException {
        if (!this.shutdown_) {
            throw new IllegalStateException();
        }
        while (this.poolSize_ > 0) {
            this.wait();
        }
    }

    protected synchronized void workerDone(Worker worker, boolean bl) {
        this.threads_.remove(worker);
        if (bl) {
            --this.activeThreads;
            --this.poolSize_;
        }
        if (this.poolSize_ == 0 && this.shutdown_) {
            this.minimumPoolSize_ = 0;
            this.maximumPoolSize_ = 0;
            this.notifyAll();
        }
        this.fireThreadDestroyed(this.poolSize_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Runnable getTask() throws InterruptedException {
        Runnable runnable = null;
        boolean bl = true;
        while (true) {
            long l;
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (bl) {
                    --this.activeThreads;
                }
                if (!(this.poolSize_ <= this.maximumPoolSize_ || this.growasneeded && bl)) {
                    --this.poolSize_;
                    return null;
                }
                l = this.shutdown_ ? 0L : (this.poolSize_ <= this.minimumPoolSize_ ? -1L : this.keepAliveTime_);
            }
            runnable = l >= 0L ? (Runnable)this.requestBuffer.poll(l) : (Runnable)this.requestBuffer.take();
            threadPool = this;
            synchronized (threadPool) {
                if (runnable == null) {
                    runnable = (Runnable)this.requestBuffer.poll(0L);
                }
                if (runnable != null) {
                    ++this.activeThreads;
                    break;
                }
                if (this.poolSize_ > this.minimumPoolSize_) {
                    --this.poolSize_;
                    break;
                }
            }
            bl = false;
        }
        return runnable;
    }

    public void setGrowAsNeeded(boolean bl) {
        this.growasneeded = bl;
    }

    public boolean isGrowAsNeeded() {
        return this.growasneeded;
    }

    public void setThreadPriority(int n) {
        this.threadpriority = n;
    }

    public int getThreadPriority() {
        return this.threadpriority;
    }

    public void execute(Runnable runnable) throws InterruptedException {
        try {
            this.execute(runnable, 0);
        }
        catch (ThreadPoolQueueIsFullException threadPoolQueueIsFullException) {
            FFDCFilter.processException(threadPoolQueueIsFullException, (class$com$ibm$ws$util$ThreadPool == null ? (class$com$ibm$ws$util$ThreadPool = ThreadPool.class$("com.ibm.ws.util.ThreadPool")) : class$com$ibm$ws$util$ThreadPool).getName(), "564");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable runnable, int n) throws InterruptedException, ThreadPoolQueueIsFullException {
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            int n2;
            if (bl2) {
                Thread.yield();
            }
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (!this.shutdown_) {
                    if (!bl) {
                        bl = this.requestBuffer.offer(runnable, 0L);
                    }
                    if (this.growasneeded && !bl && !bl2) {
                        bl2 = true;
                        continue;
                    }
                    n2 = this.poolSize_;
                    if (bl && n2 - this.activeThreads > this.requestBuffer.size()) {
                        return;
                    }
                    if (n2 < this.maximumPoolSize_ || this.growasneeded) {
                        this.addThread(null);
                    }
                    if (bl) {
                        return;
                    }
                }
            }
            if (n == 0) {
                this.requestBuffer.put(runnable, this.requestBufferInitialCapacity_);
                bl = true;
                continue;
            }
            if (n == 1) {
                throw new ThreadPoolQueueIsFullException();
            }
            int n3 = this.requestBuffer.capacity();
            if (n3 == this.requestBufferExpansionLimit_) {
                if (n == 3) {
                    this.requestBuffer.put(runnable);
                    bl = true;
                    continue;
                }
                throw new ThreadPoolQueueIsFullException();
            }
            n2 = Math.min(n3 / 2, this.requestBufferExpansionLimit_ - n3);
            Tr.uncondEvent(tc, "Exanding buffer of ThreadPool " + this.name + " by " + n2);
            this.requestBuffer.expand(n2);
            this.execute(runnable, n);
        }
    }

    public void addThreadPoolListener(ThreadPoolListener threadPoolListener) {
        int n = this.threadPoolListeners.length + 1;
        ThreadPoolListener[] threadPoolListenerArray = new ThreadPoolListener[n];
        System.arraycopy(this.threadPoolListeners, 0, threadPoolListenerArray, 0, n - 1);
        threadPoolListenerArray[n - 1] = threadPoolListener;
        this.threadPoolListeners = threadPoolListenerArray;
    }

    public void removeThreadPoolListener(ThreadPoolListener threadPoolListener) {
        int n;
        for (n = 0; n < this.threadPoolListeners.length && this.threadPoolListeners[n] != threadPoolListener; ++n) {
        }
        if (n < this.threadPoolListeners.length) {
            int n2 = this.threadPoolListeners.length - 1;
            ThreadPoolListener[] threadPoolListenerArray = new ThreadPoolListener[n2];
            System.arraycopy(this.threadPoolListeners, 0, threadPoolListenerArray, 0, n);
            System.arraycopy(this.threadPoolListeners, n + 1, threadPoolListenerArray, n, n2 - n - 1);
            this.threadPoolListeners = threadPoolListenerArray;
        }
    }

    protected void fireThreadCreated(int n) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadCreated(this, n);
        }
    }

    protected void fireThreadStarted(int n, int n2) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadStarted(this, n, n2);
        }
    }

    protected void fireThreadReturned(int n, int n2) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadReturned(this, n, n2);
        }
    }

    protected void fireThreadDestroyed(int n) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadDestroyed(this, n);
        }
    }

    public synchronized boolean areRequestsOutstanding() {
        if (this.poolSize_ == 0) {
            return false;
        }
        Iterator iterator = this.threads_.values().iterator();
        while (iterator.hasNext()) {
            Thread thread = (Thread)iterator.next();
            if (!thread.isAlive()) continue;
            return true;
        }
        return false;
    }

    public void setMonitorPlugin(MonitorPlugin monitorPlugin) throws TooManyListenersException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "setMonitorPlugin", monitorPlugin);
        }
        if (this.monitorPlugin != null && !this.monitorPlugin.equals(monitorPlugin)) {
            throw new TooManyListenersException("INTERNAL ERROR: ThreadPool.MonitorPlugin already set.");
        }
        this.monitorPlugin = monitorPlugin;
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "setMonitorPlugin", monitorPlugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAllThreads() {
        if (this.monitorPlugin == null) {
            return;
        }
        long l = 0L;
        Iterator iterator = this.threads_.values().iterator();
        while (iterator.hasNext()) {
            Worker worker;
            Worker worker2 = worker = (Worker)iterator.next();
            synchronized (worker2) {
                if (worker.getStartTime() > 0L) {
                    if (l == 0L) {
                        l = System.currentTimeMillis();
                    }
                    if (this.monitorPlugin.checkThread(worker.getName(), worker.threadNumber, l - worker.getStartTime())) {
                        worker.isHung = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetThreadHangState(Thread thread) {
        if (thread instanceof Worker) {
            Thread thread2 = thread;
            synchronized (thread2) {
                ((Worker)thread).setStartTime(0L);
            }
        } else {
            throw new IllegalArgumentException("Thread " + thread.getName() + " is not a managed thread.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            threadLocalsField = (class$java$lang$Thread == null ? (class$java$lang$Thread = ThreadPool.class$("java.lang.Thread")) : class$java$lang$Thread).getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.util.ThreadPool", "485");
        }
        ZERO_OBJECTS = new Object[0];
    }

    class Worker
    extends Thread {
        protected Runnable firstTask_;
        private String id = null;
        protected Map threadLocalsMap;
        private volatile long startTime = 0L;
        private volatile boolean isHung = false;
        private int threadNumber = -1;
        Object[] wsThreadLocals = ZERO_OBJECTS;

        private synchronized long getStartTime() {
            return this.startTime;
        }

        private synchronized void setStartTime(long l) {
            this.startTime = l;
        }

        protected Worker(Runnable runnable, int n) {
            super(ThreadPool.this.name + " : " + n);
            this.firstTask_ = runnable;
            this.setPriority(ThreadPool.this.getThreadPriority());
            this.setDaemon(true);
            this.threadNumber = this.hashCode();
            this.initThreadLocal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            Runnable runnable = this.firstTask_;
            try {
                this.firstTask_ = null;
                do {
                    Object object22222;
                    Object var3_2;
                    if (runnable == null) continue;
                    ThreadPool.this.fireThreadStarted(ThreadPool.this.activeThreads, ThreadPool.this.maximumPoolSize_);
                    if (ThreadPool.this.monitorPlugin != null) {
                        this.setStartTime(System.currentTimeMillis());
                        this.isHung = false;
                    }
                    try {
                        runnable.run();
                        var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        var3_2 = null;
                        if (ThreadPool.this.monitorPlugin != null) {
                            object22222 = this;
                            synchronized (object22222) {
                                if (this.isHung) {
                                    ThreadPool.this.monitorPlugin.clearThread(this.getName(), this.threadNumber, System.currentTimeMillis() - this.getStartTime());
                                }
                                this.setStartTime(0L);
                                this.isHung = false;
                            }
                        }
                        ThreadPool.this.fireThreadReturned(ThreadPool.this.activeThreads, ThreadPool.this.maximumPoolSize_);
                        if (this.threadLocalsMap != null) {
                            if (this.threadLocalsMap == Collections.EMPTY_MAP) {
                                this.initThreadLocal();
                            }
                            this.threadLocalsMap.clear();
                        } else {
                            try {
                                threadLocalsField.set(this, null);
                            }
                            catch (IllegalAccessException object22222) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (ThreadPool.this.monitorPlugin != null) {
                        object22222 = this;
                        synchronized (object22222) {
                            if (this.isHung) {
                                ThreadPool.this.monitorPlugin.clearThread(this.getName(), this.threadNumber, System.currentTimeMillis() - this.getStartTime());
                            }
                            this.setStartTime(0L);
                            this.isHung = false;
                        }
                    }
                    ThreadPool.this.fireThreadReturned(ThreadPool.this.activeThreads, ThreadPool.this.maximumPoolSize_);
                    if (this.threadLocalsMap != null) {
                        if (this.threadLocalsMap == Collections.EMPTY_MAP) {
                            this.initThreadLocal();
                        }
                        this.threadLocalsMap.clear();
                        continue;
                    }
                    try {
                        threadLocalsField.set(this, null);
                    }
                    catch (IllegalAccessException object22222) {}
                } while ((runnable = ThreadPool.this.getTask()) != null);
                ThreadPool.this.workerDone(this, runnable != null);
            }
            catch (InterruptedException interruptedException) {
                ThreadPool.this.workerDone(this, runnable != null);
                catch (Throwable throwable) {
                    ThreadPool.this.workerDone(this, runnable != null);
                    throw throwable;
                }
            }
        }

        private void initThreadLocal() {
            try {
                Object object = threadLocalsField.get(this);
                if (object instanceof Map) {
                    this.threadLocalsMap = (Map)object;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.util.ThreadPool.Worker", "504", this);
            }
        }
    }

    public static interface MonitorPlugin {
        public boolean checkThread(String var1, int var2, long var3);

        public void clearThread(String var1, int var2, long var3);
    }

    public class ThreadPoolQueueIsFullException
    extends WsException {
        public ThreadPoolQueueIsFullException() {
        }

        public ThreadPoolQueueIsFullException(String string) {
            super(string);
        }

        public ThreadPoolQueueIsFullException(Throwable throwable) {
            super(throwable);
        }

        public ThreadPoolQueueIsFullException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

