/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;

public class WsObjectInputStream
extends ObjectInputStream {
    private static final HashMap primClasses = new HashMap(8, 1.0f);
    protected ClassLoader classloader;
    protected String name;
    PrivilegedExceptionAction loadAction = new PrivilegedExceptionAction(){

        public Object run() throws Exception {
            try {
                return Class.forName(WsObjectInputStream.this.name, true, WsObjectInputStream.this.classloader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Class clazz = (Class)primClasses.get(WsObjectInputStream.this.name);
                if (clazz != null) {
                    return clazz;
                }
                throw classNotFoundException;
            }
        }
    };

    public WsObjectInputStream(InputStream inputStream) throws IOException {
        this(inputStream, Thread.currentThread().getContextClassLoader());
    }

    public WsObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException {
        super(inputStream);
        this.classloader = classLoader;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        try {
            this.name = objectStreamClass.getName();
            return (Class)AccessController.doPrivileged(this.loadAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)exception;
            }
            throw new ClassNotFoundException(this.name);
        }
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }
}

