/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util.config;

import com.ibm.ws.util.config.ConfigParams;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;

public class ConfigInstance {
    static final String create = "-create";
    static final String delete = "-delete";
    static final String host = "-host";
    static final String startPort = "-startingPort";
    static final String name = "-name";
    static final String path = "-path";
    static final String mqPath = "-mqpath";
    static final String embdpath = "-embeddedPath";
    static final String readOnly = "-readOnly";
    static String buildFile = "instance.xml";
    static String[] newArgs = new String[]{"-buildfile", "instance.xml", "create", "-quiet"};
    static /* synthetic */ Class array$Ljava$lang$String;

    public static void main(String[] stringArray) {
        ConfigParams configParams;
        if (stringArray.length < 2) {
            ConfigInstance.usage();
        }
        if ((configParams = ConfigInstance.processArgs(stringArray)) != null) {
            if (configParams.action == null || configParams.hostName == null) {
                ConfigInstance.usage();
                return;
            }
            ConfigInstance.runAnt(configParams);
        }
    }

    static ConfigParams processArgs(String[] stringArray) {
        try {
            ConfigParams configParams = new ConfigParams();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase(create)) {
                    configParams.action = "create";
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(delete)) {
                    configParams.action = "delete";
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(host)) {
                    configParams.hostName = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(startPort)) {
                    configParams.startPort = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(name)) {
                    configParams.instanceName = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(path)) {
                    configParams.instancePath = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(embdpath)) {
                    configParams.embeddedLocation = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(mqPath)) {
                    configParams.mqLocation = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(readOnly)) {
                    configParams.readOnly = "true";
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-buildfile")) {
                    buildFile = stringArray[i + 1];
                    ConfigInstance.newArgs[1] = stringArray[i + 1];
                    continue;
                }
                if (!stringArray[i].equalsIgnoreCase("-debug")) continue;
                ConfigInstance.newArgs[3] = "-debug";
            }
            return configParams;
        }
        catch (Throwable throwable) {
            ConfigInstance.usage();
            System.exit(0);
            return null;
        }
    }

    static String getCellName(String string) {
        String string2 = null;
        try {
            if (string != null) {
                File file = new File(string + "/bin/wsinstance/configdefaults/cells");
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    if (!fileArray[i].isDirectory()) continue;
                    string2 = fileArray[i].getName();
                }
            }
        }
        catch (Throwable throwable) {
            ConfigInstance.usage();
            System.exit(0);
        }
        return string2;
    }

    static String getNodeName(String string, String string2) {
        String string3 = null;
        try {
            if (string != null && string2 != null) {
                File file = new File(string + "/bin/wsinstance/configdefaults/cells/" + string2 + "/nodes/");
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    if (!fileArray[i].isDirectory()) continue;
                    string3 = fileArray[i].getName();
                }
            }
        }
        catch (Throwable throwable) {
            ConfigInstance.usage();
            System.exit(0);
        }
        return string3;
    }

    static void runAnt(ConfigParams configParams) {
        try {
            Serializable serializable;
            String string;
            Object object;
            String string2 = System.getProperty("was.root");
            if (string2 != null) {
                object = new File(string2);
                string = ((File)object).getCanonicalPath();
                System.setProperty("was.root", string);
                System.setProperty("was.root.forwardslashes", string.replace('\\', '/'));
                serializable = new File(string + File.separator + "properties");
                if (!((File)serializable).canWrite()) {
                    configParams.readOnly = "true";
                }
            }
            if (configParams.instancePath != null) {
                object = new File(configParams.instancePath);
                configParams.instancePath = ((File)object).getCanonicalPath();
            }
            object = null;
            string = null;
            if (string2 != null && (object = ConfigInstance.getCellName(string2)) != null) {
                string = ConfigInstance.getNodeName(string2, (String)object);
            }
            if (string != null && object != null) {
                System.setProperty("old.node.name", string);
                System.setProperty("old.cell.name", (String)object);
            }
            System.setProperty("new.host.name", configParams.hostName);
            System.setProperty("instance.name", configParams.instanceName);
            System.setProperty("new.instance.root", configParams.instancePath);
            if (configParams.startPort != null) {
                System.setProperty("start.port", configParams.startPort);
            }
            if (configParams.embeddedLocation != null) {
                System.setProperty("embed.location", configParams.embeddedLocation);
            }
            if (configParams.mqLocation != null) {
                System.setProperty("mq.location", configParams.mqLocation);
            }
            if (configParams.readOnly != null) {
                System.setProperty("isReadOnly", configParams.readOnly);
            }
            ConfigInstance.newArgs[2] = configParams.action;
            serializable = Class.forName("org.apache.tools.ant.Main");
            Method method = ((Class)serializable).getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = ConfigInstance.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            Object object2 = method.invoke(null, new Object[]{newArgs});
        }
        catch (Throwable throwable) {
            ConfigInstance.usage();
            System.exit(0);
        }
    }

    static void usage() {
        System.out.println("Usage:");
        System.out.println("wsinstance.bat(sh) -name instanceName -path instancePath -host hostName [-readOnly] [-startingPort startingPort] -create|-delete  [-debug]");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

