/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.tivoli.jmx.BooleanValueExp;
import com.tivoli.jmx.DoubleValueExp;
import com.tivoli.jmx.FloatValueExp;
import com.tivoli.jmx.IntegerValueExp;
import com.tivoli.jmx.LongValueExp;
import com.tivoli.jmx.NumberValueExp;
import com.tivoli.jmx.utils.logging.LogUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.management.AttributeNotFoundException;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.StringValueExp;
import javax.management.ValueExp;

public class AttributeValueExp
implements ValueExp {
    private String val = null;
    protected transient MBeanServer mBeanServer = null;

    public AttributeValueExp() {
    }

    public AttributeValueExp(String val) {
        this.val = val;
    }

    public String getAttributeName() {
        if (this.val == null) {
            LogUtil.core.message(4L, "AttributeValueExp", "getAttributeName", "JMXcr0015E");
        }
        return this.val;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ValueExp apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        ValueExp valueExpResult = null;
        Object valueResult = null;
        if (this.val == null) {
            LogUtil.core.message(4L, "AttributeValueExp", "apply", "JMXcr0015E");
            throw new BadAttributeValueExpException(new AttributeValueExp(this.val));
        }
        if (name == null) {
            LogUtil.core.message(4L, "AttributeValueExp", "apply", "JMXcr0016E");
            throw new InvalidApplicationException(name);
        }
        if (this.mBeanServer == null) {
            LogUtil.core.message(4L, "AttributeValueExp", "apply", "JMXcr0021E");
            throw new InvalidApplicationException(this.mBeanServer);
        }
        if (!this.mBeanServer.isRegistered(name)) {
            LogUtil.core.message(4L, "AttributeValueExp", "apply", "JMXcr0017E");
            return valueExpResult;
        }
        try {
            valueResult = this.mBeanServer.getAttribute(name, this.val);
            return this.createValueExp(valueResult);
        }
        catch (MBeanException mbe) {
            LogUtil.core.log(4L, "AttributeValueExp", "apply", mbe.toString());
            throw new InvalidApplicationException((Object)this.val);
        }
        catch (AttributeNotFoundException anfe) {
            LogUtil.core.log(4L, "AttributeValueExp", "apply", anfe.toString());
            throw new BadAttributeValueExpException(new AttributeValueExp(this.val));
        }
        catch (InstanceNotFoundException infe) {
            LogUtil.core.log(4L, "AttributeValueExp", "apply", infe.toString());
            throw new InvalidApplicationException(name);
        }
        catch (ReflectionException re) {
            LogUtil.core.log(4L, "AttributeValueExp", "apply", re.toString());
            throw new InvalidApplicationException((Object)this.val);
        }
    }

    public String toString() {
        String stringResult = "";
        if (this.val != null) {
            stringResult = this.val;
        } else {
            LogUtil.core.message(4L, "AttributeValueExp", "toString", "JMXcr0015E");
        }
        return stringResult;
    }

    public void setMBeanServer(MBeanServer s) {
        if (s != null) {
            this.mBeanServer = s;
        } else {
            LogUtil.core.message(4L, "AttributeValueExp", "setMBeanServer", "JMXcr0021E");
        }
    }

    protected Object getAttribute(ObjectName name) {
        Object objResult = null;
        if (this.val != null) {
            if (name != null) {
                if (this.mBeanServer.isRegistered(name)) {
                    try {
                        objResult = this.mBeanServer.getAttribute(name, this.val);
                    }
                    catch (MBeanException mbe) {
                        LogUtil.core.log(4L, "AttributeValueExp", "getAttribute", mbe.toString());
                    }
                    catch (AttributeNotFoundException anfe) {
                        LogUtil.core.log(4L, "AttributeValueExp", "getAttribute", anfe.toString());
                    }
                    catch (InstanceNotFoundException infe) {
                        LogUtil.core.log(4L, "AttributeValueExp", "getAttribute", infe.toString());
                    }
                    catch (ReflectionException re) {
                        LogUtil.core.log(4L, "AttributeValueExp", "getAttribute", re.toString());
                    }
                } else {
                    LogUtil.core.message(4L, "AttributeValueExp", "getAttribute", "JMXcr0017E");
                }
            } else {
                LogUtil.core.message(4L, "AttributeValueExp", "getAttribute", "JMXcr0016E");
            }
        } else {
            LogUtil.core.message(4L, "AttributeValueExp", "getAttribute", "JMXcr0015E");
        }
        return objResult;
    }

    private ValueExp createValueExp(Object valueResult) throws BadAttributeValueExpException {
        ValueExp valueExpResult = null;
        if (valueResult instanceof Integer) {
            valueExpResult = new IntegerValueExp((Integer)valueResult);
        } else if (valueResult instanceof Float) {
            valueExpResult = new FloatValueExp(((Float)valueResult).floatValue());
        } else if (valueResult instanceof Double) {
            valueExpResult = new DoubleValueExp((Double)valueResult);
        } else if (valueResult instanceof Long) {
            valueExpResult = new LongValueExp((Long)valueResult);
        } else if (valueResult instanceof Boolean) {
            valueExpResult = new BooleanValueExp((Boolean)valueResult);
        } else if (valueResult instanceof String) {
            valueExpResult = new StringValueExp((String)valueResult);
        } else if (valueResult instanceof Byte || valueResult instanceof Short || valueResult instanceof BigInteger || valueResult instanceof BigDecimal) {
            valueExpResult = new NumberValueExp((Number)valueResult);
        } else {
            LogUtil.core.message(4L, "AttributeValueExp", "createValueExp", "JMXcr0014E");
            throw new BadAttributeValueExpException(new AttributeValueExp(this.val));
        }
        return valueExpResult;
    }
}

