/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.tivoli.jmx.Introspector;
import com.tivoli.jmx.ParameterTypes;
import com.tivoli.jmx.utils.logging.CatUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.management.IntrospectionException;
import javax.management.MBeanFeatureInfo;

public class MBeanAttributeInfo
extends MBeanFeatureInfo
implements Serializable,
Cloneable {
    private String attributeType;
    private boolean is;
    private boolean isRead;
    private boolean isWrite;

    public MBeanAttributeInfo(String name, String type, String description, boolean isReadable, boolean isWritable, boolean isIs) {
        super(name, description);
        this.attributeType = type;
        this.isRead = isReadable;
        this.isWrite = isWritable;
        this.is = isIs;
    }

    public MBeanAttributeInfo(String name, String description, Method getter, Method setter) throws IntrospectionException {
        super(name, description);
        String errorMessage = CatUtil.core.getMessage("JMXcr0051E", name);
        if (getter == null && setter == null) {
            throw new IntrospectionException(errorMessage);
        }
        if (getter != null) {
            if (!Introspector.isGetter(getter)) {
                if (!Introspector.isIs(getter)) {
                    throw new IntrospectionException(errorMessage);
                }
                this.is = true;
            } else if (!Introspector.getAttributeName(getter).equals(name)) {
                throw new IntrospectionException(errorMessage);
            }
            this.isRead = true;
            this.attributeType = ParameterTypes.nameType(getter.getReturnType());
        }
        if (setter != null) {
            if (!Introspector.isSetter(setter)) {
                throw new IntrospectionException(errorMessage);
            }
            if (!Introspector.getAttributeName(setter).equals(name)) {
                throw new IntrospectionException(errorMessage);
            }
            this.isWrite = true;
            String setterType = ParameterTypes.nameType(setter.getParameterTypes()[0]);
            if (this.attributeType == null) {
                this.attributeType = setterType;
            } else if (!setterType.equals(this.attributeType)) {
                throw new IntrospectionException(errorMessage);
            }
        }
    }

    public String getType() {
        return this.attributeType;
    }

    public boolean isReadable() {
        return this.isRead;
    }

    public boolean isWritable() {
        return this.isWrite;
    }

    public boolean isIs() {
        return this.is;
    }

    public Object clone() {
        MBeanAttributeInfo cloned = null;
        try {
            cloned = (MBeanAttributeInfo)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return cloned;
    }
}

