/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.tivoli.jmx.ParameterTypes;
import com.tivoli.jmx.utils.logging.CatUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanParameterInfo;
import javax.management.RuntimeOperationsException;

public class MBeanOperationInfo
extends MBeanFeatureInfo
implements Serializable,
Cloneable {
    public static final int UNKNOWN = 0;
    public static final int ACTION = 1;
    public static final int INFO = 2;
    public static final int ACTION_INFO = 3;
    private String type;
    private MBeanParameterInfo[] signature;
    private int impact;

    public MBeanOperationInfo(String name, String description, MBeanParameterInfo[] signature, String returnType, int impact) {
        super(name, description);
        this.signature = signature != null ? (MBeanParameterInfo[])signature.clone() : null;
        this.type = returnType;
        if (impact != 2 && impact != 1 && impact != 3 && impact != 0) {
            Object[] parameters = new Integer[]{new Integer(2), new Integer(1), new Integer(3), new Integer(0)};
            String message = CatUtil.core.getMessage("JMXcr0059E", parameters);
            IllegalArgumentException iae = new IllegalArgumentException(message);
            throw new RuntimeOperationsException(iae);
        }
        this.impact = impact;
    }

    public MBeanOperationInfo(String description, Method method) {
        super(method != null ? method.getName() : "", description != null ? description : "");
        if (method != null) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            this.signature = new MBeanParameterInfo[parameterTypes.length];
            int i = 0;
            while (i < parameterTypes.length) {
                Integer ii = new Integer(i);
                String parameterName = CatUtil.core.getMessage("JMXcr0031I", ii);
                String parameterDescription = CatUtil.core.getMessage("JMXcr0032I", method.getName());
                this.signature[i] = new MBeanParameterInfo(parameterName, ParameterTypes.nameType(parameterTypes[i]), parameterDescription);
                ++i;
            }
            this.type = ParameterTypes.nameType(method.getReturnType());
            this.impact = 0;
        } else {
            this.type = null;
            this.signature = null;
            this.impact = 0;
        }
    }

    public String getReturnType() {
        return this.type;
    }

    public MBeanParameterInfo[] getSignature() {
        return this.signature != null ? (MBeanParameterInfo[])this.signature.clone() : new MBeanParameterInfo[]{};
    }

    public int getImpact() {
        return this.impact;
    }

    public Object clone() {
        MBeanOperationInfo cloned = null;
        try {
            cloned = (MBeanOperationInfo)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return cloned;
    }
}

