/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.tivoli.jmx.utils.logging.CatUtil;
import com.tivoli.jmx.utils.logging.LogUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerDelegateMBean;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class MBeanServerDelegate
implements MBeanServerDelegateMBean,
NotificationBroadcaster {
    private NotificationBroadcasterSupport notificationBroadcasterSupport;
    private MBeanNotificationInfo[] mBeanNotificationInfo;
    private long sequenceNumber = 0L;
    private String mbeanServerId = MBeanServerDelegate.createMBeanServerId();

    public MBeanServerDelegate() {
        this.mBeanNotificationInfo = this.createNotifcationInfo();
        this.notificationBroadcasterSupport = new NotificationBroadcasterSupport();
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handBack) throws IllegalArgumentException {
        this.notificationBroadcasterSupport.addNotificationListener(listener, filter, handBack);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.mBeanNotificationInfo;
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.notificationBroadcasterSupport.removeNotificationListener(listener);
    }

    public void sendNotification(Notification notification) {
        this.notificationBroadcasterSupport.sendNotification(notification);
    }

    public String getImplementationName() {
        String message = CatUtil.core.getMessage("JMXcr0034I");
        return message;
    }

    public String getImplementationVendor() {
        String message = CatUtil.core.getMessage("JMXcr0035I");
        return message;
    }

    public String getImplementationVersion() {
        String message = CatUtil.core.getMessage("JMXcr0036I");
        return message;
    }

    public String getMBeanServerId() {
        return this.mbeanServerId;
    }

    public String getSpecificationName() {
        String message = CatUtil.core.getMessage("JMXcr0037I");
        return message;
    }

    public String getSpecificationVendor() {
        String message = CatUtil.core.getMessage("JMXcr0038I");
        return message;
    }

    public String getSpecificationVersion() {
        String message = CatUtil.core.getMessage("JMXcr0039I");
        return message;
    }

    private static String createMBeanServerId() {
        String localHost = null;
        Date date = new Date();
        String timeStamp = "";
        try {
            localHost = InetAddress.getLocalHost().getHostAddress();
            Long time = new Long(date.getTime());
            timeStamp = time.toString();
        }
        catch (UnknownHostException e) {
            LogUtil.core.message(2L, "MBeanServerDelegate", "createMBeanServerId", "JMXcr0015W");
        }
        return localHost + ":" + timeStamp;
    }

    private MBeanNotificationInfo[] createNotifcationInfo() {
        MBeanNotificationInfo[] notificationInfo = new MBeanNotificationInfo[1];
        String[] notifsType = new String[]{"JMX.mbean.registered", "JMX.mbean.unregistered"};
        String message = CatUtil.core.getMessage("JMXcr0040I");
        notificationInfo[0] = new MBeanNotificationInfo(notifsType, "MBeanServerNotification", message);
        return notificationInfo;
    }
}

