/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.tivoli.jmx.JMXSecurity;
import com.tivoli.jmx.MBeanServerImpl;
import com.tivoli.jmx.utils.logging.CatUtil;
import com.tivoli.jmx.utils.logging.LogUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class MBeanServerFactory {
    private static Map mBeanServers = Collections.synchronizedMap(new HashMap());

    private MBeanServerFactory() {
    }

    public static MBeanServer createMBeanServer() {
        JMXSecurity.checkPermission("MBeanServerFactory.createMBeanServer");
        MBeanServerImpl mbs = new MBeanServerImpl("DefaultDomain");
        MBeanServerFactory.putMBeanServer(mbs);
        MBeanServerFactory.loadfromBootstrap(mbs);
        return mbs;
    }

    public static MBeanServer createMBeanServer(String domain) {
        JMXSecurity.checkPermission("MBeanServerFactory.createMBeanServer");
        MBeanServerImpl mbs = new MBeanServerImpl(domain);
        MBeanServerFactory.putMBeanServer(mbs);
        MBeanServerFactory.loadfromBootstrap(mbs);
        return mbs;
    }

    public static ArrayList findMBeanServer(String AgentId) {
        JMXSecurity.checkPermission("MBeanServerFactory.findMBeanServer");
        ArrayList list = new ArrayList();
        if (AgentId != null) {
            list.add(mBeanServers.get(AgentId));
        } else {
            list.addAll(mBeanServers.values());
        }
        return list;
    }

    public static MBeanServer newMBeanServer() {
        JMXSecurity.checkPermission("MBeanServerFactory.newMBeanServer");
        MBeanServerImpl mbs = new MBeanServerImpl("DefaultDomain");
        MBeanServerFactory.loadfromBootstrap(mbs);
        return mbs;
    }

    public static MBeanServer newMBeanServer(String domain) {
        JMXSecurity.checkPermission("MBeanServerFactory.newMBeanServer");
        MBeanServerImpl mbs = new MBeanServerImpl(domain);
        MBeanServerFactory.loadfromBootstrap(mbs);
        return mbs;
    }

    public static void releaseMBeanServer(MBeanServer mbeanServer) throws IllegalArgumentException {
        JMXSecurity.checkPermission("MBeanServerFactory.releaseMBeanServer");
        Set entries = mBeanServers.entrySet();
        Map map = mBeanServers;
        synchronized (map) {
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (mbeanServer != (MBeanServer)entry.getValue()) continue;
                if (mBeanServers.remove(entry.getKey()) == null) {
                    throw new IllegalArgumentException(CatUtil.core.getMessage("JMXcr0050E"));
                }
                return;
            }
        }
    }

    private static void loadfromBootstrap(final MBeanServer mbs) {
        block4: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Object[] params = new Object[1];
                        String[] types = new String[1];
                        ObjectName objBootStrap = new ObjectName(":type=BootstrapService");
                        mbs.createMBean("com.tivoli.jmx.BootstrapService", objBootStrap, null);
                        URL fromUrl = MBeanServerFactory.getURLfromProps();
                        if (fromUrl != null) {
                            params[0] = fromUrl;
                            types[0] = "java.net.URL";
                            mbs.invoke(objBootStrap, "loadMBeans", params, types);
                        }
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                if (ex instanceof MBeanException) {
                    LogUtil.core.message(2L, (Object)"MBeanServerFactory", "loadfromBootstrap", "JMXcr0044E", ((MBeanException)ex).getTargetException().getMessage());
                }
                if (ex instanceof RuntimeMBeanException) {
                    LogUtil.core.message(2L, (Object)"MBeanServerFactory", "loadfromBootstrap", "JMXcr0044E", ((RuntimeMBeanException)ex).getTargetException().getMessage());
                }
                LogUtil.core.message(2L, (Object)"MBeanServerFactory", "loadfromBootstrap", "JMXcr0044E", ex.getMessage());
                if (!(ex instanceof RuntimeOperationsException)) break block4;
                throw (RuntimeOperationsException)ex;
            }
        }
    }

    private static URL getURLfromProps() throws MalformedURLException {
        ResourceBundle rb = null;
        String bootProps = null;
        URL fromUrl = null;
        try {
            rb = ResourceBundle.getBundle("jmx");
            bootProps = rb.getString("BootstrapPropsURL");
        }
        catch (MissingResourceException mre) {
            LogUtil.core.message(2L, "MBeanServerFactory", "getURLfromProps", "JMXcr0012W", "jmx", "BootstrapPropsURL");
        }
        if (bootProps != null) {
            fromUrl = new URL(bootProps);
        }
        return fromUrl;
    }

    private static void putMBeanServer(final MBeanServer mbs) {
        try {
            final ObjectName delegateObjectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            String mBeanServerId = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return mbs.getAttribute(delegateObjectName, "MBeanServerId");
                }
            });
            mBeanServers.put(mBeanServerId, mbs);
        }
        catch (RuntimeOperationsException roe) {
            throw roe;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

