/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.tivoli.jmx.CollectableListener;
import com.tivoli.jmx.utils.logging.CatUtil;
import com.tivoli.jmx.utils.logging.LogUtil;
import java.util.HashSet;
import java.util.Iterator;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class NotificationBroadcasterSupport
implements NotificationBroadcaster {
    private HashSet listeners = new HashSet();

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handBack) throws IllegalArgumentException {
        boolean isFound = false;
        if (listener == null) {
            throw new IllegalArgumentException(CatUtil.core.getMessage("JMXcr0026E", "listener"));
        }
        CollectableListener listenerToBeRegistered = new CollectableListener(listener, filter, handBack);
        HashSet hashSet = this.listeners;
        synchronized (hashSet) {
            if (filter == null) {
                this.removeDuplicates(listenerToBeRegistered);
                this.listeners.add(listenerToBeRegistered);
            } else {
                Iterator e = this.listeners.iterator();
                while (e.hasNext() && !isFound) {
                    CollectableListener listenerToBeTested = (CollectableListener)e.next();
                    if (!listenerToBeTested.equals(listenerToBeRegistered)) continue;
                    isFound = true;
                    LogUtil.core.message(2L, this, "addNotificationListener", "JMXcr0011W");
                }
                if (!isFound) {
                    this.listeners.add(listenerToBeRegistered);
                }
            }
        }
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.removeNotificationListener(listener, null);
    }

    private void removeNotificationListener(NotificationListener listener, Object handBack) throws ListenerNotFoundException {
        boolean isFound = false;
        CollectableListener listenerToBeDeregistered = new CollectableListener(listener, null, handBack);
        HashSet hashSet = this.listeners;
        synchronized (hashSet) {
            Iterator e = this.listeners.iterator();
            while (e.hasNext()) {
                CollectableListener listenerToBeTested = (CollectableListener)e.next();
                if (!listenerToBeTested.isRemovable(listenerToBeDeregistered)) continue;
                e.remove();
                if (isFound) continue;
                isFound = true;
            }
        }
        if (!isFound) {
            throw new ListenerNotFoundException(CatUtil.core.getMessage("JMXcr0025E"));
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return null;
    }

    public void sendNotification(Notification notification) {
        HashSet hashSet = this.listeners;
        synchronized (hashSet) {
            HashSet lc = (HashSet)this.listeners.clone();
            Iterator e = lc.iterator();
            while (e.hasNext()) {
                CollectableListener listener = (CollectableListener)e.next();
                NotificationFilter filter = listener.getNotificationFilter();
                if (filter != null && !filter.isNotificationEnabled(notification)) continue;
                listener.getNotificationListener().handleNotification(notification, listener.getHandBack());
            }
        }
    }

    void removeDuplicates(CollectableListener listenerToBeAdded) {
        boolean isFound = false;
        HashSet hashSet = this.listeners;
        synchronized (hashSet) {
            Iterator e = this.listeners.iterator();
            while (e.hasNext() && !isFound) {
                CollectableListener listenerToBeTested = (CollectableListener)e.next();
                if (!listenerToBeTested.isDuplicate(listenerToBeAdded)) continue;
                e.remove();
            }
        }
    }
}

