/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.tivoli.jmx.HashCodeUtility;
import com.tivoli.jmx.utils.logging.CatUtil;
import com.tivoli.jmx.utils.logging.LogUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.management.MalformedObjectNameException;

public class ObjectName
implements Serializable {
    private String domain = null;
    private Hashtable propertyList = new Hashtable();
    private String propertyListString = null;
    private String canonicalName = null;
    private boolean pattern;
    private boolean propertyPattern;

    public ObjectName(String domainName, Hashtable table) throws MalformedObjectNameException {
        if (table == null) {
            throw new MalformedObjectNameException(CatUtil.core.getMessage("JMXcr0003E"));
        }
        this.insertDomainName(domainName);
        if (table.isEmpty()) {
            throw new MalformedObjectNameException(CatUtil.core.getMessage("JMXcr0027E"));
        }
        StringBuffer keyPropertyList = new StringBuffer();
        keyPropertyList.append(this.domain);
        keyPropertyList.append(":");
        Enumeration keys = table.keys();
        Enumeration elements = table.elements();
        while (keys.hasMoreElements()) {
            String element;
            String key;
            try {
                key = new String((String)keys.nextElement());
                element = new String((String)elements.nextElement());
            }
            catch (ClassCastException e) {
                throw new MalformedObjectNameException(CatUtil.core.getMessage("JMXcr0003E"));
            }
            String property = key.equals("*") && element.equals("") ? new String("*") : new String(key + "=" + element);
            this.insertKeyProperty(property);
            keyPropertyList.append(property);
            if (!keys.hasMoreElements()) continue;
            keyPropertyList.append(",");
        }
        LogUtil.core.message(1L, (Object)"ObjectName", "constructor", "JMXcr0026I", keyPropertyList.toString());
    }

    public ObjectName(String domainName, String key, String value) throws MalformedObjectNameException {
        this.insertDomainName(domainName);
        this.insertKeyProperty(key + "=" + value);
        LogUtil.core.message(1L, (Object)"ObjectName", "constructor", "JMXcr0026I", domainName + ":" + key + "=" + value);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ObjectName(String objectNameString) throws MalformedObjectNameException {
        if (objectNameString == null || objectNameString.equals("")) {
            this.domain = "*";
            if (this.propertyList.get("*") == null) {
                this.propertyList.put("*", "");
            }
            this.propertyListString = "*";
            return;
        }
        LogUtil.core.message(1L, (Object)"ObjectName", "constructor", "JMXcr0026I", objectNameString);
        StringTokenizer st = null;
        if (objectNameString.lastIndexOf(",") == objectNameString.length() - 1 || objectNameString.indexOf(",,") != -1) {
            throw new MalformedObjectNameException(CatUtil.core.getMessage("JMXcr0028E", "coma"));
        }
        int position = objectNameString.indexOf(":");
        if (position == -1) {
            throw new MalformedObjectNameException(CatUtil.core.getMessage("JMXcr0028E", "colon"));
        }
        if (position == 0) {
            this.setDefaultDomain();
        } else {
            String domainName = objectNameString.substring(0, position);
            this.insertDomainName(domainName);
        }
        if (objectNameString.length() <= position) {
            throw new MalformedObjectNameException(CatUtil.core.getMessage("JMXcr0027E"));
        }
        st = new StringTokenizer(objectNameString.substring(position + 1), ",");
        while (st.hasMoreTokens()) {
            this.insertKeyProperty(st.nextToken());
        }
    }

    public String toString() {
        StringBuffer kpl = new StringBuffer();
        kpl.append(this.domain);
        kpl.append(":");
        kpl.append(this.getKeyPropertyListString());
        return kpl.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        ObjectName on = (ObjectName)object;
        boolean isEqual = false;
        if (this.domain == null) {
            if (on.domain != null) return false;
            isEqual = true;
        } else {
            if (on.domain == null) {
                return false;
            }
            isEqual = this.domain.equals(on.domain);
        }
        if (!isEqual) {
            return false;
        }
        if (this.propertyList == null) {
            return on.propertyList == null;
        }
        if (on.propertyList == null) {
            return false;
        }
        Hashtable onpl = (Hashtable)on.propertyList.clone();
        return this.propertyList.equals(onpl);
    }

    public int hashCode() {
        int result = 0;
        result = HashCodeUtility.hashCode(result, this.domain);
        result = HashCodeUtility.hashCode(result, this.propertyList);
        return result;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getCanonicalKeyPropertyListString() {
        StringBuffer propBuf = new StringBuffer();
        Enumeration e = this.propertyList.keys();
        ArrayList sortedElements = new ArrayList();
        while (e.hasMoreElements()) {
            sortedElements.add(e.nextElement());
        }
        Collections.sort(sortedElements);
        Iterator i = sortedElements.iterator();
        while (i.hasNext()) {
            String value = (String)i.next();
            if (value.equals("*")) {
                propBuf.append("*");
                if (!i.hasNext()) continue;
                propBuf.append(",");
                continue;
            }
            propBuf.append(value);
            propBuf.append("=");
            propBuf.append((String)this.propertyList.get(value));
            if (!i.hasNext()) continue;
            propBuf.append(",");
        }
        return propBuf.toString();
    }

    public String getCanonicalName() {
        this.canonicalName = this.domain + ":" + this.getCanonicalKeyPropertyListString();
        return this.canonicalName;
    }

    public String getKeyProperty(String property) {
        String val = null;
        if (property != null && property != "") {
            val = (String)this.propertyList.get(property);
        }
        return val;
    }

    public Hashtable getKeyPropertyList() {
        Hashtable clonedTable = new Hashtable();
        clonedTable = (Hashtable)this.propertyList.clone();
        return clonedTable;
    }

    public String getKeyPropertyListString() {
        StringBuffer kpl = new StringBuffer();
        if (this.propertyListString != null) {
            kpl.append(this.propertyListString);
        } else {
            Enumeration e = this.propertyList.keys();
            ArrayList elements = new ArrayList();
            while (e.hasMoreElements()) {
                elements.add(e.nextElement());
            }
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                String value = (String)i.next();
                if (value.equals("*")) {
                    kpl.append("*");
                    if (!i.hasNext()) continue;
                    kpl.append(",");
                    continue;
                }
                kpl.append(value);
                kpl.append("=");
                kpl.append((String)this.propertyList.get(value));
                if (!i.hasNext()) continue;
                kpl.append(",");
            }
        }
        return kpl.toString();
    }

    public boolean isPattern() {
        String objNameStr = new String(this.toString());
        this.pattern = this.hasWildCards(objNameStr);
        return this.pattern;
    }

    public boolean isPropertyPattern() {
        String props = new String(this.getKeyPropertyListString());
        this.propertyPattern = this.hasWildCards(props);
        return this.propertyPattern;
    }

    private void setDomainName(String domainName) throws MalformedObjectNameException {
        if (domainName != null && !domainName.equals("")) {
            if (this.invalidDomain(domainName)) {
                throw new MalformedObjectNameException();
            }
            this.domain = domainName;
        } else {
            this.setDefaultDomain();
        }
    }

    private void setDefaultDomain() throws MalformedObjectNameException {
        this.domain = "";
    }

    private boolean invalidDomain(String domain) {
        return domain.indexOf(":") != -1 || domain.indexOf(",") != -1 || domain.indexOf("=") != -1;
    }

    private boolean hasWildCards(String expr) {
        return expr.indexOf("*") != -1 || expr.indexOf("?") != -1;
    }

    private void insertKeyProperty(String pair) throws MalformedObjectNameException {
        String key = null;
        String value = null;
        if (pair != null) {
            if (pair.equals("*")) {
                if (this.propertyList.get("*") != null) {
                    throw new MalformedObjectNameException(CatUtil.core.getMessage("JMXcr0028E", "star"));
                }
                this.updatePropertyStringList("*", "");
                this.propertyList.put("*", "");
                return;
            }
            int positionProperty = pair.indexOf("=");
            if (positionProperty < 1 || positionProperty == pair.length() - 1 || positionProperty != pair.lastIndexOf("=")) {
                throw new MalformedObjectNameException(CatUtil.core.getMessage("JMXcr0029E"));
            }
            if (pair.indexOf("*") != -1 || pair.indexOf(",") != -1) {
                throw new MalformedObjectNameException(CatUtil.core.getMessage("JMXcr0030E", "ObjectName"));
            }
            key = pair.substring(0, positionProperty);
            value = pair.substring(positionProperty + 1);
            this.updatePropertyStringList(key, value);
            this.propertyList.put(key, value);
            return;
        }
        throw new MalformedObjectNameException();
    }

    private void updatePropertyStringList(String key, String value) {
        if (key != null && value != null) {
            String update = null;
            update = key.equals("*") ? "*" : new String(key + "=" + value);
            this.propertyListString = this.propertyList.size() > 0 ? this.propertyListString + "," + update : update;
        }
    }

    private void insertDomainName(String domainName) throws MalformedObjectNameException {
        if (domainName != null && (domainName.indexOf(",") != -1 || domainName.indexOf("=") != -1 || domainName.indexOf(":") != -1)) {
            throw new MalformedObjectNameException(CatUtil.core.getMessage("JMXcr0030E", "DomainName"));
        }
        this.setDomainName(domainName);
    }
}

