/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import com.tivoli.jmx.ParameterTypes;
import com.tivoli.jmx.loading.MLetException;
import com.tivoli.jmx.loading.MLetInfo;
import com.tivoli.jmx.loading.MLetParser;
import com.tivoli.jmx.utils.logging.CatUtil;
import com.tivoli.jmx.utils.logging.LogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.security.CodeSource;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.ServiceNotFoundException;
import javax.management.loading.DefaultLoaderRepository;
import javax.management.loading.MLetMBean;

public class MLet
extends URLClassLoader
implements MLetMBean,
MBeanRegistration,
Externalizable {
    private MBeanServer server;
    private ObjectName thisObjectName;
    private String libraryDirectory;
    private ClassLoader parent;
    private final String MLET = "MLet";
    static /* synthetic */ Class class$java$lang$String;

    public MLet() {
        super(new URL[0]);
    }

    public MLet(URL[] urls) {
        super(urls);
    }

    public MLet(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.parent = parent;
    }

    public MLet(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
        this.parent = parent;
    }

    private final void logException(String methodName, Throwable exc) {
        LogUtil.loading.log(4L, "MLet", methodName, exc.toString());
    }

    private final void logInfo(String methodName, String msg) {
        LogUtil.loading.message(1L, "MLet", methodName, msg);
    }

    private final void logInfo(String methodName, String msg, Object p1) {
        LogUtil.loading.message(1L, (Object)"MLet", methodName, msg, p1 != null ? p1 : "null");
    }

    private final void logInfo(String method, String msg, Object p1, Object p2) {
        LogUtil.loading.message(1L, "MLet", method, msg, p1 != null ? p1 : "null", p2 != null ? p2 : "null");
    }

    public void addURL(String url) throws ServiceNotFoundException {
        try {
            super.addURL(new URL(url));
        }
        catch (MalformedURLException e) {
            ServiceNotFoundException snfe = new ServiceNotFoundException(e.toString());
            this.logException("addURL", snfe);
            throw snfe;
        }
    }

    public void addURL(URL url) {
        super.addURL(url);
    }

    public URL[] getURLs() {
        return super.getURLs();
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class result = this.findClass0(name);
        if (result != null) {
            this.logInfo("findClass", "JMXlg0002I", name);
            return result;
        }
        try {
            result = DefaultLoaderRepository.loadClassWithout(this, name);
            this.logInfo("findClass", "JMXlg0003I", name);
            return result;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe = new ClassNotFoundException(CatUtil.loading.getMessage("JMXlg0001E", name));
            this.logException("findClass", cnfe);
            throw cnfe;
        }
    }

    private Class findClass0(String name) throws ClassNotFoundException {
        Class<?> result = null;
        try {
            result = super.findClass(name);
            return result;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    Class loadClass0(String name) throws ClassNotFoundException {
        Class<?> result;
        int i;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (i = name.lastIndexOf(46)) != -1) {
            securityManager.checkPackageAccess(name.substring(0, i));
        }
        if ((result = this.findLoadedClass(name)) != null) {
            return result;
        }
        if (this.parent != null) {
            try {
                result = this.parent.loadClass(name);
                if (result != null) {
                    return result;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((result = this.findClass0(name)) != null) {
            return result;
        }
        throw new ClassNotFoundException();
    }

    protected synchronized String findLibrary(String libname) {
        Object result = null;
        if (this.libraryDirectory == null) {
            return null;
        }
        String mappedLibname = System.mapLibraryName(libname);
        String localLibPathName = this.libraryDirectory + File.separator + mappedLibname;
        File localLibFile = new File(localLibPathName);
        if (localLibFile.exists()) {
            return localLibPathName;
        }
        if (!new File(this.libraryDirectory).canWrite()) {
            return null;
        }
        URL libURL = this.getResource(mappedLibname);
        if (libURL == null) {
            String osName = System.getProperty("os.name");
            String osArch = System.getProperty("os.arch");
            String osVersion = System.getProperty("os.version");
            String fullPathLibname = osName + "/" + osArch + "/" + osVersion + "/lib/" + mappedLibname;
            libURL = this.getResource(fullPathLibname);
        }
        if (libURL == null) {
            return null;
        }
        String fullLibURL = libURL.getFile();
        String jarFileURL = fullLibURL.substring(0, fullLibURL.indexOf("!"));
        String libPathInsideJar = fullLibURL.substring(fullLibURL.indexOf("!") + 2);
        try {
            localLibFile.createNewFile();
            FileOutputStream localLibFileOutputStream = new FileOutputStream(localLibFile);
            boolean gotit = this.readAndStoreTargetFromJarFile(new URL(jarFileURL), libPathInsideJar, localLibFileOutputStream);
            localLibFileOutputStream.flush();
            localLibFileOutputStream.close();
            if (gotit) {
                Object[] infoParams = new String[]{mappedLibname, jarFileURL, localLibPathName};
                LogUtil.loading.message(1L, (Object)"MLet", "findLibrary", "JMXlg0007I", infoParams);
                return localLibPathName;
            }
        }
        catch (IOException ioe) {
            this.logException("findLibrary", ioe);
        }
        return null;
    }

    public synchronized String getLibraryDirectory() {
        return this.libraryDirectory;
    }

    public synchronized void setLibraryDirectory(String libdir) {
        this.libraryDirectory = libdir;
    }

    public Set getMBeansFromURL(String url) throws ServiceNotFoundException {
        Set result = null;
        try {
            result = this.getMBeansFromURL(new URL(url));
        }
        catch (MalformedURLException mue) {
            ServiceNotFoundException snfe = new ServiceNotFoundException(CatUtil.loading.getMessage("JMXlg0002E", url));
            this.logException("getMBeansFromURL", snfe);
            throw snfe;
        }
        return result;
    }

    public Set getMBeansFromURL(URL url) throws ServiceNotFoundException {
        HashSet<Object> result = new HashSet<Object>();
        Object mletfile = null;
        Object mli = null;
        String fileName = url.getFile();
        String urlString = url.toString();
        try {
            InputStream is = url.openConnection().getInputStream();
            MLetInfo[] mletInfos = MLetParser.parse(is);
            int i = 0;
            while (i < mletInfos.length) {
                if (mletInfos[i].exception != null) {
                    result.add(mletInfos[i].exception);
                } else {
                    Object obj;
                    String[] archive = mletInfos[i].archive;
                    String[] paramsStringValues = mletInfos[i].paramsStringValues;
                    String[] signature = mletInfos[i].signature;
                    Object[] params = new Object[signature.length];
                    Throwable argThrowable = null;
                    if (signature != null) {
                        int j = 0;
                        while (j < params.length) {
                            String typeName = signature[j];
                            try {
                                Class cl = ParameterTypes.getPrimitiveWrapperClass(typeName);
                                if (cl == null) {
                                    cl = ParameterTypes.getClassType(typeName, this);
                                }
                                Class[] classTypes = new Class[]{class$java$lang$String == null ? MLet.class$("java.lang.String") : class$java$lang$String};
                                Object[] initValues = new String[]{paramsStringValues[j]};
                                params[j] = obj = cl.getConstructor(classTypes).newInstance(initValues);
                            }
                            catch (Exception e) {
                                LogUtil.loading.message(4L, (Object)"MLet", "getMBeansFromURL", "JMXlg0003E", e.toString());
                                argThrowable = e;
                                break;
                            }
                            catch (Error err) {
                                LogUtil.loading.message(4L, (Object)"MLet", "getMBeansFromURL", "JMXlg0004E", err.toString());
                                argThrowable = err;
                                break;
                            }
                            ++j;
                        }
                        mletInfos[i].params = params;
                    }
                    if (argThrowable != null) {
                        result.add(argThrowable);
                    } else {
                        String target = mletInfos[i].code;
                        if (mletInfos[i].code == null) {
                            target = mletInfos[i].object;
                        }
                        Throwable resultItem = null;
                        if (archive != null) {
                            Object preMBean = null;
                            boolean found = false;
                            int j = 0;
                            while (j < archive.length) {
                                block32: {
                                    URL jarFullPath = null;
                                    try {
                                        jarFullPath = mletInfos[i].codebase != null ? new URL(url, mletInfos[i].codebase + "/" + archive[j]) : new URL(url, archive[j]);
                                        this.logInfo("getMBeansFromURL", "JMXlg0004I", jarFullPath.toString());
                                        this.addURL(jarFullPath);
                                        if (!found) {
                                            preMBean = this.loadJarFileForTarget(jarFullPath, target);
                                        }
                                        found = true;
                                    }
                                    catch (MLetException mle) {
                                        resultItem = mle.getTargetThrowable();
                                        found = true;
                                    }
                                    catch (MalformedURLException mue) {
                                        LogUtil.loading.message(4L, (Object)"MLet", "getMBeansFromURL", "JMXlg0002E", jarFullPath);
                                        if (resultItem == null) {
                                            resultItem = mue;
                                        }
                                    }
                                    catch (ClassNotFoundException e) {
                                        if (resultItem == null) {
                                            resultItem = e;
                                        }
                                    }
                                    catch (Exception e) {
                                        if (resultItem == null) {
                                            resultItem = e;
                                        }
                                    }
                                    catch (Error err) {
                                        if (resultItem != null) break block32;
                                        resultItem = err;
                                    }
                                }
                                ++j;
                            }
                            if (preMBean != null) {
                                obj = this.instantiateRegisterMBean(mletInfos[i], preMBean);
                                if (obj instanceof Throwable) {
                                    this.logException("getMBeansFromURL", (Throwable)obj);
                                }
                                result.add(obj);
                            } else if (resultItem != null) {
                                LogUtil.loading.message(4L, "MLet", "getMBeansFromURL", "JMXlg0005E", target, resultItem.toString());
                                result.add(resultItem);
                            } else {
                                Exception e = new Exception(CatUtil.loading.getMessage("JMXlg0006E", target));
                                this.logException("getMBeansFromURL", e);
                                result.add(e);
                            }
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            ServiceNotFoundException snfex = new ServiceNotFoundException(CatUtil.loading.getMessage("JMXlg0015E", e.toString()));
            this.logException("getMBeansFromURL", snfex);
            throw snfex;
        }
        if (result.isEmpty()) {
            ServiceNotFoundException snfe = new ServiceNotFoundException(CatUtil.loading.getMessage("JMXlg0007E"));
            this.logException("getMBeansFromURL", snfe);
            throw snfe;
        }
        return result;
    }

    private Object loadJarFileForTarget(URL url, String target) throws Exception {
        JarInputStream jis = null;
        JarEntry je = null;
        jis = new JarInputStream(url.openConnection().getInputStream());
        if (jis != null) {
            while ((je = jis.getNextJarEntry()) != null) {
                String entryName = je.getName();
                if (entryName.endsWith(".class")) {
                    String className = entryName.substring(0, entryName.length() - 6).replace('/', '.');
                    if (className.equals(target)) {
                        Class<?> cl = null;
                        try {
                            cl = Class.forName(className, true, this);
                            return cl;
                        }
                        catch (ClassNotFoundException cnfe) {
                            byte[] buf = null;
                            try {
                                buf = this.readBytes(jis);
                            }
                            catch (IOException ioe) {
                                throw new MLetException(ioe);
                            }
                            try {
                                cl = this.defineClass(className, buf, 0, buf.length, (CodeSource)null);
                                this.logInfo("getMBeansFromURL", "JMXlg0005I", className);
                                return cl;
                            }
                            catch (ClassFormatError cfe) {
                                throw new MLetException(cfe);
                            }
                            catch (LinkageError le) {
                                throw new MLetException(le);
                            }
                            catch (Error err) {
                                throw new MLetException(err);
                            }
                            catch (Exception e) {
                                throw new MLetException(e);
                            }
                        }
                    }
                } else if (entryName.endsWith(".ser") && entryName.equals(target)) {
                    Object obj = null;
                    try {
                        ObjectInputStream ois = new ObjectInputStream(jis);
                        obj = ois.readObject();
                    }
                    catch (IOException ioe) {
                        IOException ioex = new IOException(CatUtil.loading.getMessage("JMXlg0014E", target, ioe.toString()));
                        throw new MLetException(ioex);
                    }
                    catch (ClassNotFoundException cnfe) {
                        ClassNotFoundException cnfex = new ClassNotFoundException(CatUtil.loading.getMessage("JMXlg0008E", target, cnfe.toString()));
                        throw new MLetException(cnfex);
                    }
                    return obj;
                }
                jis.closeEntry();
            }
        }
        throw new ClassNotFoundException(CatUtil.loading.getMessage("JMXlg0009E", target));
    }

    private Object instantiateRegisterMBean(MLetInfo mli, Object preMBean) {
        Object cl = null;
        ObjectInstance oi = null;
        if (mli.exception != null) {
            return mli.exception;
        }
        try {
            if (mli.code != null) {
                oi = this.server.createMBean(mli.code, mli.name, this.thisObjectName, mli.params, mli.signature);
                this.logInfo("getMBeansFromURL", "JMXlg0006I", mli.name != null ? mli.name.toString() : "''", mli.code);
                return oi;
            }
            if (mli.object != null) {
                if (preMBean != null) {
                    oi = this.server.registerMBean(preMBean, mli.name);
                    this.logInfo("getMBeansFromURL", "JMXlg0006I", mli.name != null ? mli.name.toString() : "''", mli.object);
                    return oi;
                }
                IOException ioe = new IOException(CatUtil.loading.getMessage("JMXlg0012E", mli.object));
                return ioe;
            }
            ServiceNotFoundException snfe = new ServiceNotFoundException(CatUtil.loading.getMessage("JMXlg0013E"));
            return snfe;
        }
        catch (RuntimeMBeanException rmbe) {
            return rmbe;
        }
        catch (RuntimeOperationsException roe) {
            return roe;
        }
        catch (MBeanException mbe) {
            return mbe;
        }
        catch (ReflectionException re) {
            return re;
        }
        catch (JMException jme) {
            return jme;
        }
        catch (Error err) {
            return err;
        }
        catch (Exception e) {
            return e;
        }
    }

    private byte[] readBytes(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean eof = false;
        BufferedInputStream bis = new BufferedInputStream(is);
        while (!eof) {
            int i = bis.read();
            if (i == -1) {
                eof = true;
                continue;
            }
            baos.write(i);
        }
        return baos.toByteArray();
    }

    private boolean readAndStoreTargetFromJarFile(URL url, String target, OutputStream outStream) throws IOException {
        JarInputStream jis = null;
        JarEntry je = null;
        jis = new JarInputStream(url.openConnection().getInputStream());
        if (jis != null) {
            while ((je = jis.getNextJarEntry()) != null) {
                String entryName = je.getName();
                if (entryName.equals(target)) {
                    byte[] buf = new byte[4096];
                    BufferedInputStream in = new BufferedInputStream(jis);
                    BufferedOutputStream out = new BufferedOutputStream(outStream);
                    int numBytes = in.read(buf);
                    while (numBytes != -1) {
                        out.write(buf, 0, numBytes);
                        numBytes = in.read(buf);
                    }
                    return true;
                }
                jis.closeEntry();
            }
        }
        return false;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) {
        ObjectName result = name;
        this.server = server;
        if (name == null) {
            try {
                result = new ObjectName(":type=MLet");
            }
            catch (Exception e) {
                throw new RuntimeException("Exception during MLet registration: " + e.getClass() + " : " + e.getMessage());
            }
        }
        this.thisObjectName = result;
        return result;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.thisObjectName = (ObjectName)in.readObject();
        URL[] deSerializedUrls = (URL[])in.readObject();
        int i = 0;
        while (i < deSerializedUrls.length) {
            this.addURL(deSerializedUrls[i]);
            ++i;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.thisObjectName);
        out.writeObject(this.getURLs());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

