/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import com.tivoli.jmx.modelmbean.DescriptorHashMap;
import com.tivoli.jmx.modelmbean.DescriptorNamesManager;
import com.tivoli.jmx.modelmbean.DescriptorValidator;
import com.tivoli.jmx.modelmbean.DescriptorValidatorFactory;
import com.tivoli.jmx.modelmbean.MMBConverter;
import com.tivoli.jmx.utils.logging.CatUtil;
import com.tivoli.jmx.utils.logging.LogUtil;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.XMLParseException;

public class DescriptorSupport
implements Descriptor,
Cloneable {
    private static final int initialCapacity = 20;
    private HashMap descriptor;
    public String currClass;

    public DescriptorSupport() {
        this.descriptor = new DescriptorHashMap(20);
    }

    public DescriptorSupport(int initNumFields) throws MBeanException, RuntimeOperationsException {
        if (initNumFields <= 0) {
            new RuntimeOperationsException(new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0015E", "initNumFields")));
        }
        this.descriptor = new DescriptorHashMap(initNumFields);
    }

    public DescriptorSupport(DescriptorSupport inDescr) {
        if (inDescr == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0014E", "DescriptorSupport")));
        }
        this.descriptor = (DescriptorHashMap)inDescr.descriptor.clone();
        this.currClass = inDescr.currClass;
    }

    public DescriptorSupport(String inStr) throws MBeanException, RuntimeOperationsException, XMLParseException {
    }

    public DescriptorSupport(String[] fieldNames, Object[] fieldValues) throws RuntimeOperationsException {
        if (fieldNames == null && fieldValues == null) {
            this.descriptor = new DescriptorHashMap(20);
        } else {
            if (fieldNames == null || fieldValues == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0001E", "Parameters")));
            }
            if (fieldNames.length != fieldValues.length) {
                throw new RuntimeOperationsException(new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0016E")));
            }
            int numElements = fieldValues.length;
            int i = 0;
            while (i < numElements) {
                if (fieldNames[i] == null) {
                    throw new RuntimeOperationsException(new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0001E", "fieldNames")));
                }
                ++i;
            }
            this.descriptor = new DescriptorHashMap(fieldValues.length);
            int i2 = 0;
            while (i2 < numElements) {
                String name = DescriptorNamesManager.normalize(fieldNames[i2]);
                try {
                    Object value = fieldValues[i2];
                    if (fieldValues[i2] instanceof String) {
                        value = MMBConverter.getInstance(name, (String)fieldValues[i2]);
                    }
                    this.descriptor.put(name, value);
                }
                catch (IllegalArgumentException iae) {
                    RuntimeOperationsException e = new RuntimeOperationsException(iae);
                    LogUtil.model.log(2L, "DescriptorSupport", "DescriptorSupport", e.toString());
                    throw e;
                }
                ++i2;
            }
        }
    }

    public DescriptorSupport(String[] fields) {
        if (fields == null || fields.length < 1) {
            throw new RuntimeOperationsException(new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0014E", "parameter")));
        }
        int index = 0;
        this.descriptor = new DescriptorHashMap(fields.length);
        while (index < fields.length) {
            int equalsPosition = fields[index].indexOf(61);
            if (equalsPosition < 1) {
                throw new RuntimeOperationsException(new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0017E")));
            }
            String name = fields[index].substring(0, equalsPosition).trim();
            if (equalsPosition == fields[index].length() - 1) {
                this.descriptor.put(DescriptorNamesManager.normalize(name), null);
            } else {
                try {
                    name = DescriptorNamesManager.normalize(name);
                    Object value = MMBConverter.getInstance(name, fields[index].substring(equalsPosition + 1).trim());
                    this.descriptor.put(name, value);
                }
                catch (IllegalArgumentException iae) {
                    RuntimeOperationsException e = new RuntimeOperationsException(iae);
                    LogUtil.model.log(2L, "DescriptorSupport", "DescriptorSupport", e.toString());
                    throw e;
                }
            }
            ++index;
        }
    }

    public Object getFieldValue(String inFieldName) throws RuntimeOperationsException {
        if (inFieldName == null || inFieldName.equals("")) {
            throw new RuntimeOperationsException(new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0018E")));
        }
        String name = DescriptorNamesManager.normalize(inFieldName);
        return this.descriptor.get(name);
    }

    public void setField(String inFieldName, Object fieldValue) throws RuntimeOperationsException {
        DescriptorValidator dv = DescriptorValidatorFactory.getDescriptorSupportValidator();
        if (inFieldName == null || inFieldName.equals("")) {
            throw new RuntimeOperationsException(new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0018E")));
        }
        Object value = fieldValue;
        String name = DescriptorNamesManager.normalize(inFieldName);
        try {
            if (fieldValue instanceof String) {
                value = MMBConverter.getInstance(name, (String)fieldValue);
            }
        }
        catch (IllegalArgumentException iae) {
            RuntimeOperationsException e = new RuntimeOperationsException(iae);
            LogUtil.model.log(2L, "DescriptorSupport", "DescriptorSupport", e.toString());
            throw e;
        }
        this.descriptor.put(name, value);
    }

    public String[] getFields() {
        String[] fields = new String[this.descriptor.keySet().size()];
        Iterator iterator = this.descriptor.keySet().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            fields[index] = (String)iterator.next();
            Object fieldValue = this.descriptor.get(fields[index]);
            fields[index] = fieldValue instanceof String ? fields[index] + "=" + fieldValue : fields[index] + "=(" + fieldValue + ")";
            ++index;
        }
        return fields;
    }

    public String[] getFieldNames() {
        String[] fields = new String[this.descriptor.keySet().size()];
        Iterator iterator = this.descriptor.keySet().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            fields[index] = (String)iterator.next();
            ++index;
        }
        return fields;
    }

    public Object[] getFieldValues(String[] fieldNames) {
        if (fieldNames == null) {
            return this.descriptor.values().toArray();
        }
        Object[] values = new Object[fieldNames.length];
        int index = 0;
        while (index < fieldNames.length) {
            String name = DescriptorNamesManager.normalize(fieldNames[index]);
            values[index] = this.descriptor.get(name);
            ++index;
        }
        return values;
    }

    public void setFields(String[] fieldNames, Object[] fieldValues) throws RuntimeOperationsException {
        DescriptorValidator dv = DescriptorValidatorFactory.getDescriptorSupportValidator();
        if (fieldNames == null || fieldValues == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0018E")));
        }
        if (fieldNames.length != fieldValues.length) {
            throw new RuntimeOperationsException(new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0016E")));
        }
        int index = 0;
        while (index < fieldNames.length) {
            String name = DescriptorNamesManager.normalize(fieldNames[index]);
            this.descriptor.put(name, fieldValues[index]);
            ++index;
        }
    }

    public Object clone() throws RuntimeOperationsException {
        try {
            DescriptorSupport dsc = (DescriptorSupport)super.clone();
            dsc.descriptor = (HashMap)this.descriptor.clone();
            return dsc;
        }
        catch (CloneNotSupportedException e) {
            LogUtil.model.log(2L, "DescriptorSupport", "clone", e.toString());
            return null;
        }
        catch (RuntimeException e) {
            RuntimeOperationsException ex = new RuntimeOperationsException(new RuntimeException(e.toString()));
            LogUtil.model.log(2L, "DescriptorSupport", "clone", ex.toString());
            throw ex;
        }
    }

    public void removeField(String fieldName) {
        String name = DescriptorNamesManager.normalize(fieldName);
        this.descriptor.remove(name);
    }

    public boolean isValid() throws RuntimeOperationsException {
        try {
            return DescriptorValidatorFactory.getDescriptorSupportValidator().isValidDescriptor(this);
        }
        catch (RuntimeException e) {
            RuntimeOperationsException ex = new RuntimeOperationsException(e);
            LogUtil.model.log(2L, "DescriptorSupport", "isValid", ex.toString());
            throw e;
        }
    }

    public String toXMLString() {
        return null;
    }

    public String toString() {
        String[] fields = this.getFields();
        if (fields.length > 0) {
            StringBuffer sb = new StringBuffer(fields[0]);
            int i = 1;
            while (i < fields.length) {
                sb.append(",");
                sb.append(fields[i]);
                ++i;
            }
            return sb.toString();
        }
        return "";
    }
}

