/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import com.tivoli.jmx.modelmbean.DefaultDescriptorFactory;
import com.tivoli.jmx.modelmbean.DescriptorValidatorFactory;
import com.tivoli.jmx.modelmbean.Reflector;
import com.tivoli.jmx.utils.logging.CatUtil;
import java.lang.reflect.Constructor;
import javax.management.Descriptor;
import javax.management.DescriptorAccess;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.DescriptorSupport;

public class ModelMBeanConstructorInfo
extends MBeanConstructorInfo
implements DescriptorAccess,
Cloneable {
    Descriptor consDescriptor;
    String currClass;

    public ModelMBeanConstructorInfo(String description, Constructor constructorMethod) {
        super(description, constructorMethod);
        this.currClass = Reflector.getClassName(constructorMethod);
        this.consDescriptor = DefaultDescriptorFactory.createDefaultConstructorDescriptorInstance(this.getName());
    }

    public ModelMBeanConstructorInfo(String description, Constructor constructorMethod, Descriptor descriptor) {
        super(description, constructorMethod);
        this.currClass = Reflector.getClassName(constructorMethod);
        this.consDescriptor = descriptor == null || !descriptor.isValid() || !DescriptorValidatorFactory.getConstructorDescriptorValidator().isValidDescriptor((DescriptorSupport)descriptor) || !descriptor.getFieldValue("name").equals(this.getName()) ? DefaultDescriptorFactory.createDefaultConstructorDescriptorInstance(this.getName()) : (Descriptor)descriptor.clone();
    }

    public ModelMBeanConstructorInfo(String name, String description, MBeanParameterInfo[] signature) {
        super(name, description, signature);
        this.currClass = null;
        this.consDescriptor = DefaultDescriptorFactory.createDefaultConstructorDescriptorInstance(name);
    }

    public ModelMBeanConstructorInfo(String name, String description, MBeanParameterInfo[] signature, Descriptor descriptor) {
        super(name, description, signature);
        if (descriptor != null && descriptor.isValid() && DescriptorValidatorFactory.getConstructorDescriptorValidator().isValidDescriptor((DescriptorSupport)descriptor) && descriptor.getFieldValue("name").equals(name)) {
            this.consDescriptor = (Descriptor)descriptor.clone();
            Object cn = descriptor.getFieldValue("class");
            if (cn instanceof String) {
                this.currClass = (String)cn;
            }
        } else {
            this.consDescriptor = DefaultDescriptorFactory.createDefaultConstructorDescriptorInstance(name);
        }
    }

    public Object clone() {
        return (ModelMBeanConstructorInfo)super.clone();
    }

    public Descriptor getDescriptor() {
        return (Descriptor)this.consDescriptor.clone();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDescriptor(Descriptor inDescriptor) {
        if (inDescriptor != null) {
            if (!inDescriptor.isValid() || !DescriptorValidatorFactory.getConstructorDescriptorValidator().isValidDescriptor((DescriptorSupport)inDescriptor) || !inDescriptor.getFieldValue("name").equals(this.getName())) throw new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0014E", "Descriptor"));
            this.consDescriptor = (Descriptor)inDescriptor.clone();
            Object cn = inDescriptor.getFieldValue("class");
            if (!(cn instanceof String)) return;
            this.currClass = (String)cn;
            return;
        } else {
            this.consDescriptor = DefaultDescriptorFactory.createDefaultConstructorDescriptorInstance(this.getName());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("description=" + this.getDescription());
        String descriptor_str = ((DescriptorSupport)this.consDescriptor).toString();
        if (descriptor_str.length() > 0) {
            sb.append("," + descriptor_str);
        }
        return sb.toString();
    }
}

