/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import com.tivoli.jmx.modelmbean.DefaultDescriptorFactory;
import com.tivoli.jmx.modelmbean.DescriptorFiller;
import com.tivoli.jmx.modelmbean.DescriptorValidatorFactory;
import com.tivoli.jmx.modelmbean.MMBMetadataBuilder;
import com.tivoli.jmx.utils.logging.CatUtil;
import java.io.Serializable;
import javax.management.Descriptor;
import javax.management.DescriptorAccess;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class ModelMBeanInfoSupport
extends MBeanInfo
implements ModelMBeanInfo,
Serializable {
    String currClass;
    MBeanAttributeInfo[] mmbAttributes;
    MBeanConstructorInfo[] mmbConstructors;
    MBeanNotificationInfo[] mmbNotifications;
    MBeanOperationInfo[] mmbOperations;
    Descriptor modelMBeanDescriptor;

    public ModelMBeanInfoSupport(ModelMBeanInfo mbi) {
        super(mbi != null ? mbi.getClassName() : null, mbi != null ? mbi.getDescription() : null, null, null, null, null);
        this.mmbConstructors = mbi != null ? mbi.getConstructors() : null;
        this.mmbAttributes = mbi != null ? mbi.getAttributes() : null;
        this.mmbNotifications = mbi != null ? mbi.getNotifications() : null;
        this.mmbOperations = mbi != null ? mbi.getOperations() : null;
        try {
            this.modelMBeanDescriptor = mbi != null ? mbi.getMBeanDescriptor() : null;
        }
        catch (MBeanException mBeanException) {
            // empty catch block
        }
    }

    public ModelMBeanInfoSupport(String className, String description, ModelMBeanAttributeInfo[] attributes, ModelMBeanConstructorInfo[] constructors, ModelMBeanOperationInfo[] operations, ModelMBeanNotificationInfo[] notifications) {
        super(className, description, null, null, null, null);
        this.cloneHelper(this, attributes, constructors, operations, notifications);
        this.modelMBeanDescriptor = DefaultDescriptorFactory.createDefaultModelMBeanInfoSupportDescriptorInstance(className, className);
    }

    public ModelMBeanInfoSupport(String className, String description, ModelMBeanAttributeInfo[] attributes, ModelMBeanConstructorInfo[] constructors, ModelMBeanOperationInfo[] operations, ModelMBeanNotificationInfo[] notifications, Descriptor mbeandescriptor) {
        super(className, description, null, null, null, null);
        if (mbeandescriptor == null || !mbeandescriptor.isValid() || !DescriptorValidatorFactory.getModelMBeanInfoSupportValidator().isValidDescriptor((DescriptorSupport)mbeandescriptor)) {
            this.modelMBeanDescriptor = DefaultDescriptorFactory.createDefaultModelMBeanInfoSupportDescriptorInstance(className, className);
        } else {
            this.modelMBeanDescriptor = (Descriptor)mbeandescriptor.clone();
            DescriptorFiller.fill(this.modelMBeanDescriptor, className, className);
        }
        this.cloneHelper(this, attributes, constructors, operations, notifications);
    }

    public Object clone() {
        ModelMBeanInfoSupport mmbisCloned = (ModelMBeanInfoSupport)super.clone();
        this.cloneHelper(mmbisCloned, this.mmbAttributes, this.mmbConstructors, this.mmbOperations, this.mmbNotifications);
        return mmbisCloned;
    }

    public Descriptor[] getDescriptors(String inDescriptorType) throws MBeanException, RuntimeOperationsException {
        int i;
        boolean getAll;
        int dalength = 0;
        boolean bl = getAll = inDescriptorType == null || inDescriptorType.equals("");
        if (this.mmbAttributes != null && (getAll || inDescriptorType.equals("attribute"))) {
            dalength += this.mmbAttributes.length;
        }
        if (this.mmbConstructors != null && (getAll || inDescriptorType.equals("operation"))) {
            dalength += this.mmbConstructors.length;
        }
        if (this.mmbOperations != null && (getAll || inDescriptorType.equals("operation"))) {
            dalength += this.mmbOperations.length;
        }
        if (this.mmbNotifications != null && (getAll || inDescriptorType.equals("notification"))) {
            dalength += this.mmbNotifications.length;
        }
        if (this.mmbNotifications != null && (getAll || inDescriptorType.equals("mbean"))) {
            ++dalength;
        }
        if (dalength == 0) {
            return null;
        }
        Descriptor[] da = new Descriptor[dalength];
        int offset = 0;
        if (this.mmbAttributes != null && (getAll || inDescriptorType.equals("attribute"))) {
            i = 0;
            while (i < this.mmbAttributes.length) {
                da[offset] = ((ModelMBeanAttributeInfo)this.mmbAttributes[i]).getDescriptor();
                ++i;
                ++offset;
            }
        }
        if (this.mmbConstructors != null && (getAll || inDescriptorType.equals("operation"))) {
            i = 0;
            while (i < this.mmbConstructors.length) {
                da[offset] = ((ModelMBeanConstructorInfo)this.mmbConstructors[i]).getDescriptor();
                ++i;
                ++offset;
            }
        }
        if (this.mmbOperations != null && (getAll || inDescriptorType.equals("operation"))) {
            i = 0;
            while (i < this.mmbOperations.length) {
                da[offset] = ((ModelMBeanOperationInfo)this.mmbOperations[i]).getDescriptor();
                ++i;
                ++offset;
            }
        }
        if (this.mmbNotifications != null && (getAll || inDescriptorType.equals("notification"))) {
            i = 0;
            while (i < this.mmbNotifications.length) {
                da[offset] = ((ModelMBeanNotificationInfo)this.mmbNotifications[i]).getDescriptor();
                ++i;
                ++offset;
            }
        }
        if (this.modelMBeanDescriptor != null && (getAll || inDescriptorType.equals("mbean"))) {
            da[offset] = (Descriptor)this.modelMBeanDescriptor.clone();
        }
        return da;
    }

    public void setDescriptors(Descriptor[] inDescriptors) throws MBeanException, RuntimeOperationsException {
        if (inDescriptors == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0001E", "Parameter")));
        }
        int index = 0;
        while (index < inDescriptors.length) {
            if (inDescriptors[index] != null && !inDescriptors[index].isValid()) {
                throw new RuntimeOperationsException(new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0001E", "Parameter")));
            }
            ++index;
        }
        index = 0;
        while (index < inDescriptors.length) {
            if (inDescriptors[index] != null) {
                this.setDescriptor(inDescriptors[index], null);
            }
            ++index;
        }
    }

    public Descriptor getDescriptor(String inDescriptorName) throws MBeanException, RuntimeOperationsException {
        int index;
        if (inDescriptorName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0014E", "DescriptorName")));
        }
        if (this.mmbAttributes != null) {
            index = 0;
            while (index < this.mmbAttributes.length) {
                if (((ModelMBeanAttributeInfo)this.mmbAttributes[index]).getDescriptor().getFieldValue("name").equals(inDescriptorName)) {
                    return ((ModelMBeanAttributeInfo)this.mmbAttributes[index]).getDescriptor();
                }
                ++index;
            }
        }
        if (this.mmbConstructors != null) {
            index = 0;
            while (index < this.mmbConstructors.length) {
                if (((ModelMBeanConstructorInfo)this.mmbConstructors[index]).getDescriptor().getFieldValue("name").equals(inDescriptorName)) {
                    return ((ModelMBeanConstructorInfo)this.mmbConstructors[index]).getDescriptor();
                }
                ++index;
            }
        }
        if (this.mmbNotifications != null) {
            index = 0;
            while (index < this.mmbNotifications.length) {
                if (((ModelMBeanNotificationInfo)this.mmbNotifications[index]).getDescriptor().getFieldValue("name").equals(inDescriptorName)) {
                    return ((ModelMBeanNotificationInfo)this.mmbNotifications[index]).getDescriptor();
                }
                ++index;
            }
        }
        if (this.mmbOperations != null) {
            index = 0;
            while (index < this.mmbOperations.length) {
                if (((ModelMBeanOperationInfo)this.mmbOperations[index]).getDescriptor().getFieldValue("name").equals(inDescriptorName)) {
                    return ((ModelMBeanOperationInfo)this.mmbOperations[index]).getDescriptor();
                }
                ++index;
            }
        }
        if (this.modelMBeanDescriptor.getFieldValue("name").equals(inDescriptorName)) {
            return (Descriptor)this.modelMBeanDescriptor.clone();
        }
        return null;
    }

    public Descriptor getDescriptor(String inDescriptorName, String inDescriptorType) throws MBeanException, RuntimeOperationsException {
        if (inDescriptorName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0014E", "DescriptorName")));
        }
        if (inDescriptorType == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0014E", "DescriptorType")));
        }
        if (inDescriptorType.equals("mbean")) {
            if (this.modelMBeanDescriptor.getFieldValue("name").equals(inDescriptorName)) {
                return (Descriptor)this.modelMBeanDescriptor.clone();
            }
            return null;
        }
        if (inDescriptorType.equals("attribute")) {
            return this.getAttribute(inDescriptorName).getDescriptor();
        }
        if (inDescriptorType.equals("operation")) {
            Descriptor od = this.getOperation(inDescriptorName).getDescriptor();
            if (od == null) {
                return this.getConstructor(inDescriptorName).getDescriptor();
            }
            return od;
        }
        if (inDescriptorType.equals("notification")) {
            return this.getNotification(inDescriptorName).getDescriptor();
        }
        return null;
    }

    public void setDescriptor(Descriptor inDescriptor, String inDescriptorType) throws MBeanException, RuntimeOperationsException {
        ModelMBeanInfoSupport modelMBeanInfoSupport = this;
        synchronized (modelMBeanInfoSupport) {
            if (inDescriptor != null) {
                String type;
                if (inDescriptor.getFieldValue("name") == null || inDescriptor.getFieldValue("descriptorType") == null) {
                    throw new RuntimeOperationsException(new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0014E", "Descriptor")));
                }
                if (inDescriptorType != null && !inDescriptorType.equals(inDescriptor.getFieldValue("descriptorType"))) {
                    throw new RuntimeOperationsException(new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0019E")));
                }
                String string = type = inDescriptorType != null ? inDescriptorType : (String)inDescriptor.getFieldValue("descriptorType");
                if (type.equals("attribute")) {
                    DescriptorAccess da;
                    if (this.mmbAttributes == null) {
                        this.mmbAttributes = new MBeanAttributeInfo[0];
                    }
                    if ((da = MMBMetadataBuilder.isContained(inDescriptor, this.mmbAttributes)) == null) {
                        ModelMBeanAttributeInfo[] mmbTemp = new ModelMBeanAttributeInfo[this.mmbAttributes.length + 1];
                        System.arraycopy(this.mmbAttributes, 0, mmbTemp, 0, this.mmbAttributes.length);
                        mmbTemp[this.mmbAttributes.length] = MMBMetadataBuilder.createMMBAttributeInfo(inDescriptor, this);
                        this.mmbAttributes = mmbTemp;
                    } else {
                        da.setDescriptor(inDescriptor);
                    }
                    return;
                }
                if (type.equals("operation") && inDescriptor.getFieldValue("role").equals("constructor")) {
                    DescriptorAccess da;
                    if (this.mmbConstructors == null) {
                        this.mmbConstructors = new MBeanConstructorInfo[0];
                    }
                    if ((da = MMBMetadataBuilder.isContained(inDescriptor, this.mmbConstructors)) == null) {
                        ModelMBeanConstructorInfo[] mmbTemp = new ModelMBeanConstructorInfo[this.mmbConstructors.length + 1];
                        System.arraycopy(this.mmbConstructors, 0, mmbTemp, 0, this.mmbConstructors.length);
                        mmbTemp[this.mmbConstructors.length] = MMBMetadataBuilder.createMMBConstructorInfo(inDescriptor);
                        this.mmbConstructors = mmbTemp;
                    } else {
                        da.setDescriptor(inDescriptor);
                    }
                    return;
                }
                if (type.equals("operation") && !inDescriptor.getFieldValue("role").equals("constructor")) {
                    DescriptorAccess da;
                    if (this.mmbOperations == null) {
                        this.mmbOperations = new MBeanOperationInfo[0];
                    }
                    if ((da = MMBMetadataBuilder.isContained(inDescriptor, this.mmbOperations)) == null) {
                        ModelMBeanOperationInfo[] mmbTemp = new ModelMBeanOperationInfo[this.mmbOperations.length + 1];
                        System.arraycopy(this.mmbOperations, 0, mmbTemp, 0, this.mmbOperations.length);
                        mmbTemp[this.mmbOperations.length] = MMBMetadataBuilder.createMMBOperationInfo(inDescriptor);
                        this.mmbOperations = mmbTemp;
                    } else {
                        da.setDescriptor(inDescriptor);
                    }
                    return;
                }
                if (type.equals("notification")) {
                    DescriptorAccess da;
                    if (this.mmbNotifications == null) {
                        this.mmbNotifications = new MBeanNotificationInfo[0];
                    }
                    if ((da = MMBMetadataBuilder.isContained(inDescriptor, this.mmbNotifications)) == null) {
                        ModelMBeanNotificationInfo[] mmbTemp = new ModelMBeanNotificationInfo[this.mmbNotifications.length + 1];
                        System.arraycopy(this.mmbNotifications, 0, mmbTemp, 0, this.mmbNotifications.length);
                        mmbTemp[this.mmbNotifications.length] = MMBMetadataBuilder.createMMBNotificationInfo(inDescriptor);
                        this.mmbNotifications = mmbTemp;
                    } else {
                        da.setDescriptor(inDescriptor);
                    }
                    return;
                }
                if (type.equals("mbean")) {
                    this.setMBeanDescriptor(inDescriptor);
                    return;
                }
                throw new RuntimeOperationsException(new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0014E", "type")));
            }
        }
    }

    public ModelMBeanAttributeInfo getAttribute(String inName) throws MBeanException, RuntimeOperationsException {
        if (this.mmbAttributes != null) {
            int index = 0;
            while (index < this.mmbAttributes.length) {
                if (this.mmbAttributes[index].getName().equals(inName)) {
                    return (ModelMBeanAttributeInfo)this.mmbAttributes[index].clone();
                }
                ++index;
            }
        }
        return null;
    }

    public ModelMBeanOperationInfo getOperation(String inName) throws MBeanException, RuntimeOperationsException {
        if (this.mmbOperations != null) {
            int index = 0;
            while (index < this.mmbOperations.length) {
                if (this.mmbOperations[index].getName().equals(inName)) {
                    return (ModelMBeanOperationInfo)this.mmbOperations[index].clone();
                }
                ++index;
            }
        }
        return null;
    }

    public ModelMBeanConstructorInfo getConstructor(String inName) throws MBeanException, RuntimeOperationsException {
        if (this.mmbConstructors != null) {
            int index = 0;
            while (index < this.mmbConstructors.length) {
                if (this.mmbConstructors[index].getName().equals(inName)) {
                    return (ModelMBeanConstructorInfo)this.mmbConstructors[index].clone();
                }
                ++index;
            }
        }
        return null;
    }

    public ModelMBeanNotificationInfo getNotification(String inName) throws MBeanException, RuntimeOperationsException {
        if (this.mmbNotifications != null) {
            int index = 0;
            while (index < this.mmbNotifications.length) {
                if (this.mmbNotifications[index].getName().equals(inName)) {
                    return (ModelMBeanNotificationInfo)this.mmbNotifications[index].clone();
                }
                ++index;
            }
        }
        return null;
    }

    public MBeanAttributeInfo[] getAttributes() {
        if (this.mmbAttributes == null) {
            return null;
        }
        MBeanAttributeInfo[] mmbTemp = (MBeanAttributeInfo[])this.mmbAttributes.clone();
        int index = 0;
        while (index < this.mmbAttributes.length) {
            mmbTemp[index] = (MBeanAttributeInfo)this.mmbAttributes[index].clone();
            ++index;
        }
        return mmbTemp;
    }

    public MBeanOperationInfo[] getOperations() {
        if (this.mmbOperations == null) {
            return null;
        }
        MBeanOperationInfo[] mmbTemp = (MBeanOperationInfo[])this.mmbOperations.clone();
        int index = 0;
        while (index < this.mmbOperations.length) {
            mmbTemp[index] = (MBeanOperationInfo)this.mmbOperations[index].clone();
            ++index;
        }
        return mmbTemp;
    }

    public MBeanConstructorInfo[] getConstructors() {
        if (this.mmbConstructors == null) {
            return null;
        }
        MBeanConstructorInfo[] mmbTemp = (MBeanConstructorInfo[])this.mmbConstructors.clone();
        int index = 0;
        while (index < this.mmbConstructors.length) {
            mmbTemp[index] = (MBeanConstructorInfo)this.mmbConstructors[index].clone();
            ++index;
        }
        return mmbTemp;
    }

    public MBeanNotificationInfo[] getNotifications() {
        if (this.mmbNotifications == null) {
            return null;
        }
        MBeanNotificationInfo[] mmbTemp = (MBeanNotificationInfo[])this.mmbNotifications.clone();
        int index = 0;
        while (index < this.mmbNotifications.length) {
            mmbTemp[index] = (MBeanNotificationInfo)this.mmbNotifications[index].clone();
            ++index;
        }
        return mmbTemp;
    }

    public Descriptor getMBeanDescriptor() throws MBeanException, RuntimeOperationsException {
        if (this.modelMBeanDescriptor == null) {
            return null;
        }
        Descriptor mmbDescriptorTemp = (Descriptor)this.modelMBeanDescriptor.clone();
        DescriptorFiller.fill(mmbDescriptorTemp, this.getClassName(), this.getClassName());
        return mmbDescriptorTemp;
    }

    public void setMBeanDescriptor(Descriptor inMBeanDescriptor) throws MBeanException, RuntimeOperationsException {
        if (!DescriptorValidatorFactory.getModelMBeanInfoSupportValidator().isValidDescriptor((DescriptorSupport)inMBeanDescriptor)) {
            this.modelMBeanDescriptor = DefaultDescriptorFactory.createDefaultModelMBeanInfoSupportDescriptorInstance(this.getClassName(), this.getClassName());
        } else {
            Descriptor inMBeanDescriptorTemp = (Descriptor)inMBeanDescriptor.clone();
            DescriptorFiller.fill(inMBeanDescriptorTemp, this.getClassName(), this.getClassName());
            this.modelMBeanDescriptor = inMBeanDescriptorTemp;
        }
    }

    private void cloneHelper(ModelMBeanInfoSupport mmbis, MBeanAttributeInfo[] attributes, MBeanConstructorInfo[] constructors, MBeanOperationInfo[] operations, MBeanNotificationInfo[] notifications) {
        int i;
        if (attributes != null) {
            mmbis.mmbAttributes = new ModelMBeanAttributeInfo[attributes.length];
            i = 0;
            while (i < attributes.length) {
                mmbis.mmbAttributes[i] = attributes[i] != null ? (ModelMBeanAttributeInfo)attributes[i].clone() : null;
                ++i;
            }
        } else {
            mmbis.mmbAttributes = null;
        }
        if (constructors != null) {
            mmbis.mmbConstructors = new ModelMBeanConstructorInfo[constructors.length];
            i = 0;
            while (i < constructors.length) {
                mmbis.mmbConstructors[i] = constructors[i] != null ? (ModelMBeanConstructorInfo)constructors[i].clone() : null;
                ++i;
            }
        } else {
            mmbis.mmbConstructors = null;
        }
        if (operations != null) {
            mmbis.mmbOperations = new ModelMBeanOperationInfo[operations.length];
            i = 0;
            while (i < operations.length) {
                mmbis.mmbOperations[i] = operations[i] != null ? (MBeanOperationInfo)operations[i].clone() : null;
                ++i;
            }
        } else {
            mmbis.mmbOperations = null;
        }
        if (notifications != null) {
            mmbis.mmbNotifications = new ModelMBeanNotificationInfo[notifications.length];
            i = 0;
            while (i < notifications.length) {
                mmbis.mmbNotifications[i] = notifications[i] != null ? (MBeanNotificationInfo)notifications[i].clone() : null;
                ++i;
            }
        } else {
            mmbis.mmbNotifications = null;
        }
    }
}

