/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import com.tivoli.jmx.modelmbean.DefaultDescriptorFactory;
import com.tivoli.jmx.modelmbean.DescriptorValidatorFactory;
import com.tivoli.jmx.modelmbean.Reflector;
import com.tivoli.jmx.utils.logging.CatUtil;
import java.lang.reflect.Method;
import javax.management.Descriptor;
import javax.management.DescriptorAccess;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.DescriptorSupport;

public class ModelMBeanOperationInfo
extends MBeanOperationInfo
implements DescriptorAccess {
    String currClass;
    Descriptor operDescriptor;

    public ModelMBeanOperationInfo(String description, Method operationMethod) {
        super(description, operationMethod);
        this.currClass = Reflector.getClassName(operationMethod);
        this.operDescriptor = DefaultDescriptorFactory.createDefaultOperationDescriptorInstance(this.getName());
    }

    public ModelMBeanOperationInfo(String description, Method operationMethod, Descriptor descriptor) {
        super(description, operationMethod);
        this.currClass = Reflector.getClassName(operationMethod);
        if (!(descriptor != null && descriptor.isValid() && DescriptorValidatorFactory.getOperationDescriptorValidator().isValidDescriptor((DescriptorSupport)descriptor) && descriptor.getFieldValue("name").equals(this.getName()))) {
            this.operDescriptor = DefaultDescriptorFactory.createDefaultOperationDescriptorInstance(this.getName());
            this.currClass = Reflector.getClassName(operationMethod);
        } else {
            this.operDescriptor = (Descriptor)descriptor.clone();
        }
    }

    public ModelMBeanOperationInfo(String name, String description, MBeanParameterInfo[] signature, String type, int impact) {
        super(name, description, signature, type, impact);
        this.currClass = null;
        this.operDescriptor = DefaultDescriptorFactory.createDefaultOperationDescriptorInstance(name);
    }

    public ModelMBeanOperationInfo(String name, String description, MBeanParameterInfo[] signature, String type, int impact, Descriptor descriptor) {
        super(name, description, signature, type, impact);
        if (!(descriptor != null && descriptor.isValid() && DescriptorValidatorFactory.getOperationDescriptorValidator().isValidDescriptor((DescriptorSupport)descriptor) && descriptor.getFieldValue("name").equals(name))) {
            this.operDescriptor = DefaultDescriptorFactory.createDefaultOperationDescriptorInstance(name);
        } else {
            this.operDescriptor = (Descriptor)descriptor.clone();
            String cn = (String)descriptor.getFieldValue("class");
            if (cn instanceof String) {
                this.currClass = cn;
            }
        }
    }

    public ModelMBeanOperationInfo(ModelMBeanOperationInfo inInfo) {
        this(inInfo != null ? inInfo.getName() : null, inInfo != null ? inInfo.getDescription() : null, inInfo != null ? inInfo.getSignature() : null, inInfo != null ? inInfo.getReturnType() : null, inInfo != null ? inInfo.getImpact() : 0, inInfo != null ? inInfo.getDescriptor() : null);
    }

    public Object clone() {
        return (ModelMBeanOperationInfo)super.clone();
    }

    public Descriptor getDescriptor() {
        return (Descriptor)this.operDescriptor.clone();
    }

    public void setDescriptor(Descriptor inDescriptor) {
        if (inDescriptor == null) {
            this.operDescriptor = DefaultDescriptorFactory.createDefaultOperationDescriptorInstance(this.getName());
        } else if (inDescriptor.isValid() && DescriptorValidatorFactory.getOperationDescriptorValidator().isValidDescriptor((DescriptorSupport)inDescriptor) && inDescriptor.getFieldValue("name").equals(this.getName())) {
            this.operDescriptor = (Descriptor)inDescriptor.clone();
            Object cn = inDescriptor.getFieldValue("class");
            if (cn instanceof String) {
                this.currClass = (String)cn;
            }
        } else {
            throw new IllegalArgumentException(CatUtil.model.getMessage("JMXmd0014E", "Descriptor"));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("returnType=" + this.getReturnType() + ",");
        sb.append("impact=(" + this.getImpact() + "),");
        sb.append("description=" + this.getDescription());
        String descriptor_str = ((DescriptorSupport)this.operDescriptor).toString();
        if (descriptor_str.length() > 0) {
            sb.append("," + descriptor_str);
        }
        return sb.toString();
    }
}

