/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.tivoli.jmx.monitor.ActionEvent;
import com.tivoli.jmx.monitor.AttributeMonitor;
import com.tivoli.jmx.monitor.CounterObserver;
import com.tivoli.jmx.monitor.MonitorQueue;
import com.tivoli.jmx.monitor.NumberOperations;
import com.tivoli.jmx.utils.logging.CatUtil;
import com.tivoli.jmx.utils.logging.LogUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import javax.management.MBeanNotificationInfo;
import javax.management.monitor.CounterMonitorMBean;
import javax.management.monitor.Monitor;

public class CounterMonitor
extends Monitor
implements CounterMonitorMBean {
    private static final transient String monitorType = "Counter";
    private boolean differenceMode;
    private boolean notify;
    private Number offset;
    private Number modulus;
    private Number threshold;
    static /* synthetic */ Class class$java$lang$String;

    public CounterMonitor() {
        this.attributeObserver = new CounterObserver();
        this.attributeObserver.addActionListener(new CounterNotifier());
        this.notify = true;
    }

    public void preDeregister() throws Exception {
        super.preDeregister();
        this.threshold = null;
    }

    public Number getDerivedGauge() {
        return ((CounterObserver)this.attributeObserver).getDerivedGauge();
    }

    public long getDerivedGaugeTimeStamp() {
        return ((CounterObserver)this.attributeObserver).getDerivedGaugeTimeStamp();
    }

    public boolean getDifferenceMode() {
        return this.differenceMode;
    }

    public Number getModulus() {
        return this.modulus;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] notificationInfo = new MBeanNotificationInfo[1];
        String[] notifsType = new String[]{"jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.mbean", "jmx.monitor.error.runtime", "jmx.monitor.error.threshold", "jmx.monitor.counter.threshold"};
        notificationInfo[0] = new MBeanNotificationInfo(notifsType, "javax.management.monitor.MonitorNotification", "");
        return notificationInfo;
    }

    public boolean getNotify() {
        return this.notify;
    }

    public Number getOffset() {
        return this.offset;
    }

    public Number getThreshold() {
        Number actualThreshold = this.active ? (Number)((CounterObserver)this.attributeObserver).getThreshold() : (Number)this.threshold;
        return actualThreshold;
    }

    public void setDifferenceMode(boolean differenceMode) {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            this.differenceMode = differenceMode;
            if (this.active) {
                this.attributeMonitor.disable();
                ((CounterObserver)this.attributeObserver).setDifferenceMode(this.differenceMode);
                this.attributeMonitor = new AttributeMonitor(this.attributeObserver);
                this.attributeMonitor.enable();
                MonitorQueue.instance().enqueue(this.attributeMonitor);
            }
        }
    }

    public void setModulus(Number modulus) throws IllegalArgumentException {
        if (modulus == null || NumberOperations.isNegative(modulus)) {
            throw new IllegalArgumentException(CatUtil.monitor.getMessage("JMXmn0007E"));
        }
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            this.modulus = modulus;
            if (this.active) {
                this.attributeMonitor.disable();
                ((CounterObserver)this.attributeObserver).setModulus(this.modulus);
                this.attributeMonitor = new AttributeMonitor(this.attributeObserver);
                this.attributeMonitor.enable();
                MonitorQueue.instance().enqueue(this.attributeMonitor);
            }
        }
    }

    public void setNotify(boolean notify) {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            this.notify = notify;
            if (this.active) {
                this.attributeMonitor.disable();
                ((CounterObserver)this.attributeObserver).setNotify(this.notify);
                this.attributeMonitor = new AttributeMonitor(this.attributeObserver);
                this.attributeMonitor.enable();
                MonitorQueue.instance().enqueue(this.attributeMonitor);
            }
        }
    }

    public void setOffset(Number offset) throws IllegalArgumentException {
        if (offset == null || NumberOperations.isNegative(offset)) {
            throw new IllegalArgumentException(CatUtil.monitor.getMessage("JMXmn0008E"));
        }
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            this.offset = offset;
            if (this.active) {
                this.attributeMonitor.disable();
                ((CounterObserver)this.attributeObserver).setOffset(this.offset);
                this.attributeMonitor = new AttributeMonitor(this.attributeObserver);
                this.attributeMonitor.enable();
                MonitorQueue.instance().enqueue(this.attributeMonitor);
            }
        }
    }

    public void setThreshold(Number threshold) throws IllegalArgumentException {
        if (threshold == null || NumberOperations.isNegative(threshold)) {
            throw new IllegalArgumentException(CatUtil.monitor.getMessage("JMXmn0009E"));
        }
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            this.threshold = threshold;
            if (this.active) {
                this.attributeMonitor.disable();
                this.attributeMonitor = new AttributeMonitor(this.attributeObserver);
                this.notificationNumber = 0L;
                this.attributeObserver.initialize();
                this.alreadyNotified = 0;
                ((CounterObserver)this.attributeObserver).setThreshold(this.threshold);
                this.attributeMonitor.enable();
                MonitorQueue.instance().enqueue(this.attributeMonitor);
            }
        }
    }

    public void start() {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            if (this.server == null || this.threshold == null) {
                throw new IllegalStateException(CatUtil.monitor.getMessage("JMXmn0013E"));
            }
            if (!this.isActive()) {
                CounterObserver counterObserver = (CounterObserver)this.attributeObserver;
                this.notificationNumber = 0L;
                counterObserver.initialize();
                this.alreadyNotified = 0;
                counterObserver.setGranularityPeriod(this.getGranularityPeriod());
                counterObserver.setObservedObject(this.getObservedObject());
                counterObserver.setObservedAttribute(this.getObservedAttribute());
                counterObserver.setDifferenceMode(this.differenceMode);
                counterObserver.setNotify(this.notify);
                counterObserver.setThreshold(this.threshold);
                this.setDefaultValue();
                counterObserver.setModulus(this.modulus);
                counterObserver.setOffset(this.offset);
                this.attributeMonitor = new AttributeMonitor(counterObserver);
                this.attributeMonitor.enable();
                MonitorQueue.instance().enqueue(this.attributeMonitor);
                this.active = true;
                LogUtil.monitor.message(1L, (Object)"CounterMonitor", "start", "JMXmn0008I", monitorType);
            } else {
                LogUtil.monitor.message(2L, (Object)"CounterMonitor", "start", "JMXmn0001W", monitorType);
            }
        }
    }

    private void setDefaultValue() {
        if (this.modulus == null || this.offset == null) {
            try {
                Class<?> thresholdClass = this.threshold.getClass();
                if (this.modulus == null) {
                    Field maxValueField = thresholdClass.getField("MAX_VALUE");
                    Object maxValue = maxValueField.get(null);
                    this.modulus = (Number)maxValue;
                }
                if (this.offset == null) {
                    Constructor<?> constructor = thresholdClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = CounterMonitor.class$("java.lang.String")) : class$java$lang$String);
                    this.offset = (Number)constructor.newInstance(new String("0"));
                }
            }
            catch (Exception e) {
                LogUtil.monitor.log(2L, "CounterMonitor", "setDefaultValue", e.toString());
            }
        }
    }

    public void stop() {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            if (this.isActive()) {
                this.attributeMonitor.disable();
                this.active = false;
                this.threshold = ((CounterObserver)this.attributeObserver).getThreshold();
                LogUtil.monitor.message(1L, (Object)"CounterMonitor", "stop", "JMXmn0009I", monitorType);
            } else {
                LogUtil.monitor.message(2L, (Object)"CounterMonitor", "stop", "JMXmn0002W", monitorType);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CounterNotifier
    extends Monitor.Notifier {
        private CounterNotifier() {
            super(CounterMonitor.this);
        }

        public void actionPerformed(ActionEvent event) {
            String notificationType = event.getActionCommand();
            if (notificationType.equals("jmx.monitor.error.threshold")) {
                this.sendThresholdErrorNotification();
                LogUtil.monitor.message(1L, "CounterNotifier", "actionPerformed", "JMXmn0010I", CounterMonitor.monitorType, notificationType);
            } else if (notificationType.equals("jmx.monitor.counter.threshold")) {
                this.sendThresholdExceedNotification();
                LogUtil.monitor.message(1L, "CounterNotifier", "actionPerformed", "JMXmn0010I", CounterMonitor.monitorType, notificationType);
            } else {
                super.actionPerformed(event);
            }
        }

        private void sendThresholdErrorNotification() {
            int notified = 16;
            String type = "jmx.monitor.error.threshold";
            String message = CatUtil.monitor.getMessage("JMXmn0014I");
            this.sendErrorMonitorNotification(notified, type, message);
        }

        private void sendThresholdExceedNotification() {
            String type = "jmx.monitor.counter.threshold";
            String message = CatUtil.monitor.getMessage("JMXmn0015I");
            Number trigger = ((CounterObserver)CounterMonitor.this.attributeObserver).getThreshold();
            Number value = ((CounterObserver)CounterMonitor.this.attributeObserver).getDerivedGauge();
            this.sendMonitorNotification(type, message, trigger, value);
        }
    }
}

