/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.tivoli.jmx.monitor.ActionEvent;
import com.tivoli.jmx.monitor.AttributeMonitor;
import com.tivoli.jmx.monitor.GaugeObserver;
import com.tivoli.jmx.monitor.MonitorQueue;
import com.tivoli.jmx.monitor.NumberOperations;
import com.tivoli.jmx.utils.logging.CatUtil;
import com.tivoli.jmx.utils.logging.LogUtil;
import javax.management.MBeanNotificationInfo;
import javax.management.monitor.GaugeMonitorMBean;
import javax.management.monitor.Monitor;

public class GaugeMonitor
extends Monitor
implements GaugeMonitorMBean {
    private static final transient String monitorType = "Gauge";
    private boolean differenceMode;
    private boolean notifyHigh;
    private boolean notifyLow;
    private Number highThreshold;
    private Number lowThreshold;
    private transient Number lastGauge;

    public GaugeMonitor() {
        this.attributeObserver = new GaugeObserver();
        this.attributeObserver.addActionListener(new GaugeNotifier());
        this.notifyHigh = true;
        this.notifyLow = true;
    }

    public Number getDerivedGauge() {
        return ((GaugeObserver)this.attributeObserver).getDerivedGauge();
    }

    public long getDerivedGaugeTimeStamp() {
        return ((GaugeObserver)this.attributeObserver).getDerivedGaugeTimeStamp();
    }

    public boolean getDifferenceMode() {
        return this.differenceMode;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] notificationInfo = new MBeanNotificationInfo[1];
        String[] notifsType = new String[]{"jmx.monitor.gauge.high", "jmx.monitor.gauge.low", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.mbean", "jmx.monitor.error.runtime", "jmx.monitor.error.threshold"};
        notificationInfo[0] = new MBeanNotificationInfo(notifsType, "javax.management.monitor.MonitorNotification", "");
        return notificationInfo;
    }

    public boolean getNotifyHigh() {
        return this.notifyHigh;
    }

    public boolean getNotifyLow() {
        return this.notifyLow;
    }

    public Number getHighThreshold() {
        return this.highThreshold;
    }

    public Number getLowThreshold() {
        return this.lowThreshold;
    }

    public void setDifferenceMode(boolean value) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.differenceMode = value;
            if (this.active) {
                this.attributeMonitor.disable();
                ((GaugeObserver)this.attributeObserver).setDifferenceMode(value);
                this.attributeMonitor = new AttributeMonitor(this.attributeObserver);
                this.attributeMonitor.enable();
                MonitorQueue.instance().enqueue(this.attributeMonitor);
            }
        }
    }

    public void setNotifyHigh(boolean value) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.notifyHigh = value;
            if (this.active) {
                this.attributeMonitor.disable();
                ((GaugeObserver)this.attributeObserver).setNotifyHigh(value);
                this.attributeMonitor = new AttributeMonitor(this.attributeObserver);
                this.attributeMonitor.enable();
                MonitorQueue.instance().enqueue(this.attributeMonitor);
            }
        }
    }

    public void setNotifyLow(boolean value) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.notifyLow = value;
            if (this.active) {
                this.attributeMonitor.disable();
                ((GaugeObserver)this.attributeObserver).setNotifyLow(value);
                this.attributeMonitor = new AttributeMonitor(this.attributeObserver);
                this.attributeMonitor.enable();
                MonitorQueue.instance().enqueue(this.attributeMonitor);
            }
        }
    }

    public void setThresholds(Number highValue, Number lowValue) throws IllegalArgumentException {
        if (highValue == null || lowValue == null || NumberOperations.isSubNegative(highValue, lowValue) || highValue.getClass() != lowValue.getClass()) {
            throw new IllegalArgumentException(CatUtil.monitor.getMessage("JMXmn0006E"));
        }
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.highThreshold = highValue;
            this.lowThreshold = lowValue;
            if (this.active) {
                this.attributeMonitor.disable();
                ((GaugeObserver)this.attributeObserver).setThresholds(highValue, lowValue);
                this.alreadyNotified = 0;
                this.notificationNumber = 0L;
                this.attributeObserver.initialize();
                this.attributeMonitor = new AttributeMonitor(this.attributeObserver);
                this.attributeMonitor.enable();
                MonitorQueue.instance().enqueue(this.attributeMonitor);
            }
        }
    }

    public void start() {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            if (this.server == null || this.highThreshold == null || this.lowThreshold == null) {
                throw new IllegalStateException(CatUtil.monitor.getMessage("JMXmn0013E"));
            }
            if (!this.isActive()) {
                GaugeObserver gaugeObserver = (GaugeObserver)this.attributeObserver;
                this.alreadyNotified = 0;
                this.notificationNumber = 0L;
                gaugeObserver.initialize();
                gaugeObserver.setGranularityPeriod(this.getGranularityPeriod());
                gaugeObserver.setObservedObject(this.getObservedObject());
                gaugeObserver.setObservedAttribute(this.getObservedAttribute());
                gaugeObserver.setDifferenceMode(this.differenceMode);
                gaugeObserver.setThresholds(this.highThreshold, this.lowThreshold);
                gaugeObserver.setNotifyHigh(this.notifyHigh);
                gaugeObserver.setNotifyLow(this.notifyLow);
                this.attributeMonitor = new AttributeMonitor(gaugeObserver);
                this.attributeMonitor.enable();
                MonitorQueue.instance().enqueue(this.attributeMonitor);
                this.active = true;
                LogUtil.monitor.message(1L, (Object)"GaugeMonitor", "start", "JMXmn0008I", monitorType);
            } else {
                LogUtil.monitor.message(2L, (Object)"GaugeMonitor", "start", "JMXmn0001W", monitorType);
            }
        }
    }

    public void stop() {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            if (this.isActive()) {
                this.attributeMonitor.disable();
                this.active = false;
                LogUtil.monitor.message(1L, (Object)"GaugeMonitor", "stop", "JMXmn0009I", monitorType);
            } else {
                LogUtil.monitor.message(2L, (Object)"GaugeMonitor", "stop", "JMXmn0002W", monitorType);
            }
        }
    }

    private class GaugeNotifier
    extends Monitor.Notifier {
        private GaugeNotifier() {
        }

        public void actionPerformed(ActionEvent event) {
            String notificationType = event.getActionCommand();
            if (notificationType.equals("jmx.monitor.error.threshold")) {
                this.sendThresholdErrorNotification();
                LogUtil.monitor.message(1L, "GaugeNotifier", "actionPerformed", "JMXmn0010I", GaugeMonitor.monitorType, notificationType);
            } else if (notificationType.equals("jmx.monitor.gauge.high")) {
                this.sendHighValueNotification();
                LogUtil.monitor.message(1L, "GaugeNotifier", "actionPerformed", "JMXmn0010I", GaugeMonitor.monitorType, notificationType);
            } else if (notificationType.equals("jmx.monitor.gauge.low")) {
                this.sendLowValueNotification();
                LogUtil.monitor.message(1L, "GaugeNotifier", "actionPerformed", "JMXmn0010I", GaugeMonitor.monitorType, notificationType);
            } else {
                super.actionPerformed(event);
            }
        }

        private void sendThresholdErrorNotification() {
            int notified = 16;
            String type = "jmx.monitor.error.threshold";
            String message = CatUtil.monitor.getMessage("JMXmn0011I");
            this.sendErrorMonitorNotification(notified, type, message);
        }

        private void sendHighValueNotification() {
            String type = "jmx.monitor.gauge.high";
            String message = CatUtil.monitor.getMessage("JMXmn0012I");
            Number trigger = GaugeMonitor.this.highThreshold;
            Number value = ((GaugeObserver)GaugeMonitor.this.attributeObserver).getDerivedGauge();
            this.sendMonitorNotification(type, message, trigger, value);
        }

        private void sendLowValueNotification() {
            String type = "jmx.monitor.gauge.low";
            String message = CatUtil.monitor.getMessage("JMXmn0013I");
            Number trigger = GaugeMonitor.this.lowThreshold;
            Number value = ((GaugeObserver)GaugeMonitor.this.attributeObserver).getDerivedGauge();
            this.sendMonitorNotification(type, message, trigger, value);
        }
    }
}

