/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.tivoli.jmx.monitor.ActionEvent;
import com.tivoli.jmx.monitor.ActionListener;
import com.tivoli.jmx.monitor.AttributeMonitor;
import com.tivoli.jmx.monitor.AttributeObserver;
import com.tivoli.jmx.monitor.MonitorQueue;
import com.tivoli.jmx.utils.logging.CatUtil;
import com.tivoli.jmx.utils.logging.LogUtil;
import java.io.Serializable;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.monitor.MonitorMBean;
import javax.management.monitor.MonitorNotification;

public abstract class Monitor
extends NotificationBroadcasterSupport
implements MonitorMBean,
MBeanRegistration,
Serializable {
    static transient int monitorNumber = 0;
    private static final transient String monitorType = "";
    transient AttributeMonitor attributeMonitor;
    transient AttributeObserver attributeObserver;
    transient ObjectName objectName;
    transient long notificationNumber = 0L;
    transient boolean active;
    protected int alreadyNotified;
    protected String dbgTag;
    protected static final int RESET_FLAGS_ALREADY_NOTIFIED = 0;
    protected static final int OBSERVED_ATTRIBUTE_ERROR_NOTIFIED = 1;
    protected static final int OBSERVED_ATTRIBUTE_TYPE_ERROR_NOTIFIED = 2;
    protected static final int OBSERVED_OBJECT_ERROR_NOTIFIED = 4;
    protected static final int RUNTIME_ERROR_NOTIFIED = 8;
    static final int THRESHOLD_ERROR_NOTIFIED = 16;
    private ObjectName observedObject;
    private long granularityPeriod = 10000L;
    private String observedAttribute;
    protected MBeanServer server;

    String createName() {
        return this.server.getDefaultDomain() + ":name=Monitor" + monitorNumber;
    }

    private long getNotificationNumber() {
        long actualSequenceNumber = this.notificationNumber;
        this.notificationNumber = this.notificationNumber == Long.MAX_VALUE ? 0L : ++this.notificationNumber;
        return actualSequenceNumber;
    }

    public long getGranularityPeriod() {
        return this.granularityPeriod;
    }

    public String getObservedAttribute() {
        return this.observedAttribute;
    }

    public ObjectName getObservedObject() {
        return this.observedObject;
    }

    public boolean isActive() {
        return this.active;
    }

    public void postDeregister() {
        this.server = null;
    }

    public void postRegister(Boolean registrationDone) {
        if (registrationDone.equals(new Boolean(true))) {
            this.attributeObserver.setServer(this.server);
        } else {
            this.server = null;
        }
    }

    public void preDeregister() throws Exception {
        if (this.isActive()) {
            this.stop();
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        ++monitorNumber;
        this.server = server;
        this.objectName = name == null ? new ObjectName(this.createName()) : name;
        return this.objectName;
    }

    private void resetAlreadyNotified() {
        this.alreadyNotified = 0;
    }

    public void setGranularityPeriod(long granularityPeriod) throws IllegalArgumentException {
        if (granularityPeriod <= 0L) {
            throw new IllegalArgumentException(CatUtil.monitor.getMessage("JMXmn0001E"));
        }
        Monitor monitor = this;
        synchronized (monitor) {
            this.granularityPeriod = granularityPeriod;
            if (this.active) {
                this.attributeMonitor.disable();
                this.attributeObserver.setGranularityPeriod(granularityPeriod);
                this.attributeMonitor = new AttributeMonitor(this.attributeObserver);
                this.attributeMonitor.enable();
                MonitorQueue.instance().enqueue(this.attributeMonitor);
            }
        }
    }

    public void setObservedAttribute(String observedAttribute) throws IllegalArgumentException {
        if (observedAttribute == null) {
            throw new IllegalArgumentException(CatUtil.monitor.getMessage("JMXmn0002E"));
        }
        Monitor monitor = this;
        synchronized (monitor) {
            this.observedAttribute = observedAttribute;
            if (this.active) {
                this.attributeMonitor.disable();
                this.notificationNumber = 0L;
                this.resetAlreadyNotified();
                this.attributeObserver.initialize();
                this.attributeObserver.setObservedAttribute(observedAttribute);
                this.attributeMonitor = new AttributeMonitor(this.attributeObserver);
                this.attributeMonitor.enable();
                MonitorQueue.instance().enqueue(this.attributeMonitor);
            }
        }
    }

    public void setObservedObject(ObjectName observedObject) throws IllegalArgumentException {
        if (observedObject == null) {
            throw new IllegalArgumentException(CatUtil.monitor.getMessage("JMXmn0003E"));
        }
        Monitor monitor = this;
        synchronized (monitor) {
            this.observedObject = observedObject;
            if (this.active) {
                this.attributeMonitor.disable();
                this.notificationNumber = 0L;
                this.resetAlreadyNotified();
                this.attributeObserver.initialize();
                this.attributeObserver.setObservedObject(observedObject);
                this.attributeMonitor = new AttributeMonitor(this.attributeObserver);
                this.attributeMonitor.enable();
                MonitorQueue.instance().enqueue(this.attributeMonitor);
            }
        }
    }

    public abstract void start();

    public abstract void stop();

    class Notifier
    implements ActionListener {
        Notifier() {
        }

        public void actionPerformed(ActionEvent event) {
            String notificationType = event.getActionCommand();
            if (notificationType.equals("jmx.monitor.error.attribute")) {
                this.sendAttributeErrorNotification();
                LogUtil.monitor.message(1L, "Notifier", "actionPerformed", "JMXmn0010I", Monitor.monitorType, "jmx.monitor.error.attribute");
            } else if (notificationType.equals("jmx.monitor.error.type")) {
                this.sendAttributeTypeErrorNotification();
                LogUtil.monitor.message(1L, "Notifier", "actionPerformed", "JMXmn0010I", Monitor.monitorType, "jmx.monitor.error.type");
            } else if (notificationType.equals("jmx.monitor.error.mbean")) {
                this.sendObjectErrorNotification();
                LogUtil.monitor.message(1L, "Notifier", "actionPerformed", "JMXmn0010I", Monitor.monitorType, "jmx.monitor.error.mbean");
            } else if (notificationType.equals("jmx.monitor.error.runtime")) {
                this.sendRuntimeErrorNotification(event.getID());
                LogUtil.monitor.message(1L, "Notifier", "actionPerformed", "JMXmn0010I", Monitor.monitorType, "jmx.monitor.error.runtime");
            } else if (notificationType.equals("jmx.monitor.value")) {
                Monitor.this.resetAlreadyNotified();
                LogUtil.monitor.message(1L, "Notifier", "actionPerformed", "JMXmn0010I", Monitor.monitorType, "jmx.monitor.value");
            }
        }

        private void sendAttributeErrorNotification() {
            int notified = 1;
            String type = "jmx.monitor.error.attribute";
            String message = CatUtil.monitor.getMessage("JMXmn0001I");
            this.sendErrorMonitorNotification(notified, type, message);
        }

        private void sendAttributeTypeErrorNotification() {
            int notified = 2;
            String type = "jmx.monitor.error.type";
            String message = CatUtil.monitor.getMessage("JMXmn0002I");
            this.sendErrorMonitorNotification(notified, type, message);
        }

        private void sendObjectErrorNotification() {
            int notified = 4;
            String type = "jmx.monitor.error.mbean";
            String message = CatUtil.monitor.getMessage("JMXmn0003I");
            this.sendErrorMonitorNotification(notified, type, message);
        }

        private void sendRuntimeErrorNotification(int runTimeErrorType) {
            int notified = 8;
            String type = "jmx.monitor.error.runtime";
            String message = runTimeErrorType == 1 ? CatUtil.monitor.getMessage("JMXmn0004I") : CatUtil.monitor.getMessage("JMXmn0005I");
            this.sendErrorMonitorNotification(notified, type, message);
        }

        protected void sendErrorMonitorNotification(int notified, String type, String message) {
            if ((Monitor.this.alreadyNotified & notified) == 0) {
                Monitor source = Monitor.this;
                long sequenceNumber = Monitor.this.getNotificationNumber();
                long timeStamp = System.currentTimeMillis();
                MonitorNotification mn = new MonitorNotification(type, source, sequenceNumber, timeStamp, message);
                mn.setUserData(Monitor.this.attributeObserver.getException());
                Monitor.this.sendNotification(mn);
                Monitor.this.alreadyNotified = 0;
                Monitor.this.alreadyNotified |= notified;
            }
        }

        protected void sendMonitorNotification(String type, String message, Object trigger, Object value) {
            Monitor source = Monitor.this;
            long sequenceNumber = Monitor.this.getNotificationNumber();
            long timeStamp = System.currentTimeMillis();
            MonitorNotification mn = new MonitorNotification(type, source, sequenceNumber, timeStamp, message, trigger, value);
            Monitor.this.alreadyNotified = 0;
            Monitor.this.sendNotification(mn);
        }
    }
}

