/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.tivoli.jmx.monitor.ActionEvent;
import com.tivoli.jmx.monitor.AttributeMonitor;
import com.tivoli.jmx.monitor.MonitorQueue;
import com.tivoli.jmx.monitor.StringObserver;
import com.tivoli.jmx.utils.logging.CatUtil;
import com.tivoli.jmx.utils.logging.LogUtil;
import javax.management.MBeanNotificationInfo;
import javax.management.monitor.Monitor;
import javax.management.monitor.StringMonitorMBean;

public class StringMonitor
extends Monitor
implements StringMonitorMBean {
    private static final transient String monitorType = "String";
    private boolean notifyDiffer;
    private boolean notifyMatch;
    private String stringToCompare;

    public StringMonitor() {
        this.attributeObserver = new StringObserver();
        this.attributeObserver.addActionListener(new StringNotifier());
        this.notifyDiffer = true;
        this.notifyMatch = true;
    }

    public String getDerivedGauge() {
        return ((StringObserver)this.attributeObserver).getDerivedGauge();
    }

    public long getDerivedGaugeTimeStamp() {
        return ((StringObserver)this.attributeObserver).getDerivedGaugeTimeStamp();
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] notificationInfo = new MBeanNotificationInfo[1];
        String[] notifsType = new String[]{"jmx.monitor.string.differs", "jmx.monitor.string.matches", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.mbean", "jmx.monitor.error.runtime"};
        notificationInfo[0] = new MBeanNotificationInfo(notifsType, "javax.management.monitor.MonitorNotification", "");
        return notificationInfo;
    }

    public boolean getNotifyDiffer() {
        return this.notifyDiffer;
    }

    public boolean getNotifyMatch() {
        return this.notifyMatch;
    }

    public String getStringToCompare() {
        return this.stringToCompare;
    }

    public void setNotifyDiffer(boolean value) {
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            this.notifyDiffer = value;
            if (this.active) {
                this.attributeMonitor.disable();
                ((StringObserver)this.attributeObserver).setNotifyDiffer(value);
                this.attributeMonitor = new AttributeMonitor(this.attributeObserver);
                this.attributeMonitor.enable();
                MonitorQueue.instance().enqueue(this.attributeMonitor);
            }
        }
    }

    public void setNotifyMatch(boolean value) {
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            this.notifyMatch = value;
            if (this.active) {
                this.attributeMonitor.disable();
                ((StringObserver)this.attributeObserver).setNotifyMatch(value);
                this.attributeMonitor = new AttributeMonitor(this.attributeObserver);
                this.attributeMonitor.enable();
                MonitorQueue.instance().enqueue(this.attributeMonitor);
            }
        }
    }

    public void setStringToCompare(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(CatUtil.monitor.getMessage("JMXmn0004E"));
        }
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            this.stringToCompare = value;
            if (this.active) {
                this.attributeMonitor.disable();
                ((StringObserver)this.attributeObserver).setStringToCompare(value);
                this.alreadyNotified = 0;
                this.notificationNumber = 0L;
                this.attributeObserver.initialize();
                this.attributeMonitor = new AttributeMonitor(this.attributeObserver);
                this.attributeMonitor.enable();
                MonitorQueue.instance().enqueue(this.attributeMonitor);
            }
        }
    }

    public void start() {
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            if (this.server == null || this.stringToCompare == null) {
                throw new IllegalStateException(CatUtil.monitor.getMessage("JMXmn0005E"));
            }
            if (!this.isActive()) {
                StringObserver stringObserver = (StringObserver)this.attributeObserver;
                this.alreadyNotified = 0;
                stringObserver.initialize();
                this.notificationNumber = 0L;
                stringObserver.setGranularityPeriod(this.getGranularityPeriod());
                stringObserver.setObservedObject(this.getObservedObject());
                stringObserver.setObservedAttribute(this.getObservedAttribute());
                stringObserver.setStringToCompare(this.stringToCompare);
                stringObserver.setNotifyDiffer(this.notifyDiffer);
                stringObserver.setNotifyMatch(this.notifyMatch);
                this.attributeMonitor = new AttributeMonitor(stringObserver);
                this.attributeMonitor.enable();
                MonitorQueue.instance().enqueue(this.attributeMonitor);
                this.active = true;
                LogUtil.monitor.message(1L, (Object)"StringMonitor", "start", "JMXmn0008I", monitorType);
            } else {
                LogUtil.monitor.message(2L, (Object)"StringMonitor", "start", "JMXmn0001W", monitorType);
            }
        }
    }

    public void stop() {
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            if (this.isActive()) {
                this.attributeMonitor.disable();
                this.active = false;
                LogUtil.monitor.message(1L, (Object)"StringMonitor", "stop", "JMXmn0009I", monitorType);
            } else {
                LogUtil.monitor.message(2L, (Object)"StringMonitor", "stop", "JMXmn0002W", monitorType);
            }
        }
    }

    private class StringNotifier
    extends Monitor.Notifier {
        private StringNotifier() {
        }

        public void actionPerformed(ActionEvent event) {
            String notificationType = event.getActionCommand();
            if (notificationType.equals("jmx.monitor.string.matches")) {
                this.sendStringMatchedNotification();
                LogUtil.monitor.message(1L, "StringNotifier", "actionPerformed", "JMXmn0010I", StringMonitor.monitorType, notificationType);
            } else if (notificationType.equals("jmx.monitor.string.differs")) {
                this.sendStringDifferedNotification();
                LogUtil.monitor.message(1L, "StringNotifier", "actionPerformed", "JMXmn0010I", StringMonitor.monitorType, notificationType);
            } else {
                super.actionPerformed(event);
            }
        }

        private void sendStringMatchedNotification() {
            String type = "jmx.monitor.string.matches";
            String message = CatUtil.monitor.getMessage("JMXmn0006I");
            String trigger = StringMonitor.this.stringToCompare;
            String value = ((StringObserver)StringMonitor.this.attributeObserver).getDerivedGauge();
            this.sendMonitorNotification(type, message, trigger, value);
        }

        private void sendStringDifferedNotification() {
            String type = "jmx.monitor.string.differs";
            String message = CatUtil.monitor.getMessage("JMXmn0007I");
            String trigger = StringMonitor.this.stringToCompare;
            String value = ((StringObserver)StringMonitor.this.attributeObserver).getDerivedGauge();
            this.sendMonitorNotification(type, message, trigger, value);
        }
    }
}

