/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.tivoli.jmx.utils.logging.CatUtil;
import java.util.Vector;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;

public class MBeanServerNotificationFilter
extends NotificationFilterSupport {
    private Vector myDeselectObjNameList = new Vector();
    private Vector mySelectObjNameList = null;

    public MBeanServerNotificationFilter() {
        this.enableType("JMX.mbean.unregistered");
        this.enableType("JMX.mbean.registered");
    }

    public void disableAllObjectNames() {
        this.myDeselectObjNameList = null;
        if (this.mySelectObjNameList != null) {
            this.mySelectObjNameList.removeAllElements();
        } else {
            this.mySelectObjNameList = new Vector();
        }
    }

    public void disableObjectName(ObjectName theObjName) throws IllegalArgumentException {
        if (theObjName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0027E");
            throw new IllegalArgumentException(message);
        }
        if (this.myDeselectObjNameList != null) {
            if (!this.myDeselectObjNameList.contains(theObjName)) {
                this.myDeselectObjNameList.add(theObjName);
            }
        } else {
            this.mySelectObjNameList.remove(theObjName);
        }
    }

    public void enableAllObjectNames() {
        this.mySelectObjNameList = null;
        if (this.myDeselectObjNameList != null) {
            this.myDeselectObjNameList.removeAllElements();
        } else {
            this.myDeselectObjNameList = new Vector();
        }
    }

    public void enableObjectName(ObjectName theObjName) throws IllegalArgumentException {
        if (theObjName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0027E");
            throw new IllegalArgumentException(message);
        }
        if (this.mySelectObjNameList != null) {
            if (!this.mySelectObjNameList.contains(theObjName)) {
                this.mySelectObjNameList.add(theObjName);
            }
        } else {
            this.myDeselectObjNameList.remove(theObjName);
        }
    }

    public Vector getEnabledObjectNames() {
        return this.mySelectObjNameList;
    }

    public Vector getDisabledObjectNames() {
        return this.myDeselectObjNameList;
    }

    public boolean isNotificationEnabled(Notification theNtf) throws IllegalArgumentException {
        if (theNtf == null) {
            String message = CatUtil.relation.getMessage("JMXrl0018E");
            throw new IllegalArgumentException(message);
        }
        if (!super.isNotificationEnabled(theNtf)) {
            return false;
        }
        if (this.myDeselectObjNameList != null) {
            return !this.myDeselectObjNameList.contains(((MBeanServerNotification)theNtf).getMBeanName());
        }
        return this.mySelectObjNameList.contains(((MBeanServerNotification)theNtf).getMBeanName());
    }
}

