/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.tivoli.jmx.relation.ConsistencyChecker;
import com.tivoli.jmx.relation.ExternalRelation;
import com.tivoli.jmx.relation.NotificationFilterManager;
import com.tivoli.jmx.relation.Utility;
import com.tivoli.jmx.utils.logging.CatUtil;
import com.tivoli.jmx.utils.logging.LogUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.relation.InvalidRelationIdException;
import javax.management.relation.InvalidRelationServiceException;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.InvalidRoleValueException;
import javax.management.relation.Relation;
import javax.management.relation.RelationNotFoundException;
import javax.management.relation.RelationNotification;
import javax.management.relation.RelationServiceMBean;
import javax.management.relation.RelationServiceNotRegisteredException;
import javax.management.relation.RelationSupport;
import javax.management.relation.RelationType;
import javax.management.relation.RelationTypeNotFoundException;
import javax.management.relation.RelationTypeSupport;
import javax.management.relation.Role;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;
import javax.management.relation.RoleList;
import javax.management.relation.RoleNotFoundException;
import javax.management.relation.RoleResult;

public class RelationService
extends NotificationBroadcasterSupport
implements RelationServiceMBean,
MBeanRegistration,
NotificationListener {
    private Map relRepository;
    private Map relTypeRepository;
    private Map mbeansRelationsMap;
    private MBeanServer mbeanServer;
    private MBeanServer relServiceMBeanServer;
    private ObjectName objName;
    private ObjectName relServiceObjName;
    private NotificationFilterManager filterManager;
    private ConsistencyChecker consistencyChecker;
    private Purger purger;
    private Notifier notifier;
    private static int relationServiceNumber = 0;
    private boolean immediatePurgeFlg;

    public RelationService(boolean theImmediatePurgeFlg) {
        this.immediatePurgeFlg = theImmediatePurgeFlg;
        this.createRepository();
        this.notifier = new Notifier();
    }

    private void createRepository() {
        this.relRepository = Collections.synchronizedMap(new HashMap());
        this.relTypeRepository = Collections.synchronizedMap(new HashMap());
        this.mbeansRelationsMap = Collections.synchronizedMap(new HashMap());
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.notifier.getNotificationInfo();
    }

    public void isActive() throws RelationServiceNotRegisteredException {
        if (this.relServiceMBeanServer == null) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
    }

    public boolean getPurgeFlag() {
        return this.immediatePurgeFlg;
    }

    public void setPurgeFlag(boolean thePurgeFlg) {
        this.logInfo("setPurgeFlag", "JMXrl0010I", new Boolean(thePurgeFlg));
        this.immediatePurgeFlg = thePurgeFlg;
    }

    public void createRelationType(String theRelTypeName, RoleInfo[] theRoleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        this.logInfo("createRelationType", "JMXrl0011I", theRelTypeName);
        if (this.relTypeRepository.containsKey(theRelTypeName)) {
            String message = CatUtil.relation.getMessage("JMXrl0002E");
            throw new InvalidRelationTypeException(message);
        }
        RelationTypeSupport relationType = new RelationTypeSupport(theRelTypeName, theRoleInfoArray);
        this.relTypeRepository.put(theRelTypeName, relationType);
    }

    public void addRelationType(RelationType theRelTypeObj) throws IllegalArgumentException, InvalidRelationTypeException {
        this.logInfo("addRelationType", "JMXrl0012I");
        if (theRelTypeObj == null) {
            String message = CatUtil.relation.getMessage("JMXrl0025E");
            throw new IllegalArgumentException(message);
        }
        String relTypeName = theRelTypeObj.getRelationTypeName();
        Object[] roleInfosObj = theRelTypeObj.getRoleInfos().toArray();
        int size = roleInfosObj.length;
        RoleInfo[] roleInfos = new RoleInfo[size];
        int i = 0;
        while (i < size) {
            roleInfos[i] = (RoleInfo)roleInfosObj[i];
            ++i;
        }
        this.createRelationType(relTypeName, roleInfos);
    }

    public List getAllRelationTypeNames() {
        return new ArrayList(this.relTypeRepository.keySet());
    }

    public List getRoleInfos(String theRelTypeName) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (theRelTypeName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0008E");
            throw new IllegalArgumentException(message);
        }
        Object obj = this.relTypeRepository.get(theRelTypeName);
        if (obj != null) {
            return ((RelationType)obj).getRoleInfos();
        }
        String message = CatUtil.relation.getMessage("JMXrl0004E", theRelTypeName);
        throw new RelationTypeNotFoundException(message);
    }

    public RoleInfo getRoleInfo(String theRelTypeName, String theRoleInfoName) throws IllegalArgumentException, RelationTypeNotFoundException, RoleInfoNotFoundException {
        if (theRoleInfoName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0005E");
            throw new IllegalArgumentException(message);
        }
        ArrayList roleInfos = (ArrayList)this.getRoleInfos(theRelTypeName);
        Iterator iterator = ((AbstractList)roleInfos).iterator();
        while (iterator.hasNext()) {
            RoleInfo roleInfo = (RoleInfo)iterator.next();
            if (!theRoleInfoName.equals(roleInfo.getName())) continue;
            return roleInfo;
        }
        String message = CatUtil.relation.getMessage("JMXrl0006E", theRoleInfoName, theRelTypeName);
        throw new RoleInfoNotFoundException(message);
    }

    public void removeRelationType(String theRelTypeName) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationTypeNotFoundException {
        this.logInfo("removeRelationType", "JMXrl0011I", theRelTypeName);
        if (theRelTypeName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0008E");
            throw new IllegalArgumentException(message);
        }
        if (this.relServiceMBeanServer == null) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        if (this.relServiceObjName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        if (this.relTypeRepository.remove(theRelTypeName) == null) {
            String message = CatUtil.relation.getMessage("JMXrl0004E", theRelTypeName);
            throw new RelationTypeNotFoundException(message);
        }
        this.removeRelations(theRelTypeName);
    }

    private void removeRelations(String theRelTypeName) {
        Set entries = this.relRepository.entrySet();
        Map map = this.relRepository;
        synchronized (map) {
            Iterator iter = entries.iterator();
            ArrayList<String> relationsToRemove = new ArrayList<String>();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Relation val = (Relation)entry.getValue();
                if (!val.getRelationTypeName().equals(theRelTypeName)) continue;
                relationsToRemove.add((String)entry.getKey());
            }
            int i = 0;
            while (i < relationsToRemove.size()) {
                this.purger.handleRelationUnregistration((String)relationsToRemove.get(i));
                ++i;
            }
        }
    }

    public void createRelation(String theRelId, String theRelTypeName, RoleList theRoleList) throws RelationServiceNotRegisteredException, IllegalArgumentException, RoleNotFoundException, InvalidRelationIdException, RelationTypeNotFoundException, InvalidRoleValueException {
        this.logInfo("createRelation", "JMXrl0013I", theRelId, theRelTypeName);
        if (theRelId == null) {
            String message = CatUtil.relation.getMessage("JMXrl0007E");
            throw new IllegalArgumentException(message);
        }
        if (theRelTypeName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0008E");
            throw new IllegalArgumentException(message);
        }
        if (this.relServiceMBeanServer == null) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        if (this.relRepository.containsKey(theRelId)) {
            String message = CatUtil.relation.getMessage("JMXrl0014E", theRelId);
            throw new InvalidRelationIdException(message);
        }
        RelationType relationType = (RelationType)this.relTypeRepository.get(theRelTypeName);
        if (relationType == null) {
            String message = CatUtil.relation.getMessage("JMXrl0004E", theRelTypeName);
            throw new RelationTypeNotFoundException(message);
        }
        RoleList roleList = this.consistencyChecker.checkConsistency((ArrayList)relationType.getRoleInfos(), theRoleList);
        RelationSupport relation = new RelationSupport(theRelId, this.relServiceObjName, this.relServiceMBeanServer, theRelTypeName, roleList);
        this.storeRelation(relation, theRelTypeName, theRelId, roleList);
        relation.setRelationServiceManagementFlag(new Boolean("true"));
        this.notifier.sendRelationCreationNotification("Relation Basic Creation", "", theRelId, theRelTypeName, null);
    }

    private void storeRelation(Relation relation, String relTypeName, String relId, RoleList roleList) throws RoleNotFoundException, InvalidRoleValueException {
        this.relRepository.put(relId, relation);
        this.putRoleValuesMbeanMap(relId, roleList);
        this.filterManager.enableRoleList(roleList);
    }

    private void putRoleValuesMbeanMap(String theRelId, RoleList roleList) {
        Iterator roleListItr = ((AbstractList)roleList).iterator();
        while (roleListItr.hasNext()) {
            List roleValue = ((Role)roleListItr.next()).getRoleValue();
            this.putRoleValueMbeanMap(theRelId, roleValue);
        }
    }

    private void putRoleValueMbeanMap(String theRelId, List roleValue) {
        Iterator valueItr = roleValue.iterator();
        while (valueItr.hasNext()) {
            ObjectName objName = (ObjectName)valueItr.next();
            Utility.put(this.mbeansRelationsMap, objName, theRelId);
        }
    }

    public void addRelation(ObjectName theRelObjectName) throws IllegalArgumentException, RelationServiceNotRegisteredException, NoSuchMethodException, InvalidRelationIdException, InstanceNotFoundException, InvalidRelationServiceException, RelationTypeNotFoundException, RoleNotFoundException, InvalidRoleValueException {
        this.logInfo("addRelation", "JMXrl0014I", theRelObjectName);
        if (theRelObjectName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0026E");
            throw new IllegalArgumentException(message);
        }
        if (this.relServiceMBeanServer == null) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        if (!this.relServiceMBeanServer.isRegistered(theRelObjectName)) {
            String message = CatUtil.relation.getMessage("JMXrl0010E", theRelObjectName);
            throw new InstanceNotFoundException(message);
        }
        if (!this.relServiceMBeanServer.isInstanceOf(theRelObjectName, "javax.management.relation.Relation")) {
            String message = CatUtil.relation.getMessage("JMXrl0011E", theRelObjectName);
            throw new NoSuchMethodException(message);
        }
        ExternalRelation relation = new ExternalRelation(theRelObjectName, this.relServiceMBeanServer);
        ObjectName objName = relation.getRelationServiceName();
        if (objName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0028E", theRelObjectName);
            throw new InvalidRelationServiceException(message);
        }
        if (!objName.equals(this.relServiceObjName)) {
            String message = CatUtil.relation.getMessage("JMXrl0012E", theRelObjectName);
            throw new InvalidRelationServiceException(message);
        }
        String theRelId = relation.getRelationId();
        if (theRelId == null) {
            String message = CatUtil.relation.getMessage("JMXrl0013E", theRelObjectName);
            throw new InvalidRelationIdException(message);
        }
        if (this.relRepository.containsKey(theRelId)) {
            String message = CatUtil.relation.getMessage("JMXrl0014E", theRelId);
            throw new InvalidRelationIdException(message);
        }
        String theRelTypeName = relation.getRelationTypeName();
        if (theRelTypeName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0015E", theRelObjectName);
            throw new RelationTypeNotFoundException(message);
        }
        RelationType relationType = (RelationType)this.relTypeRepository.get(theRelTypeName);
        if (relationType == null) {
            String message = CatUtil.relation.getMessage("JMXrl0016E", theRelTypeName, theRelObjectName);
            throw new RelationTypeNotFoundException(message);
        }
        RoleList roleList = relation.retrieveAllRoles();
        roleList = this.consistencyChecker.checkConsistency((ArrayList)relationType.getRoleInfos(), roleList);
        this.filterManager.enableObjectName(theRelObjectName);
        this.storeRelation(relation, theRelTypeName, theRelId, roleList);
        relation.setRelationServiceManagementFlag(new Boolean("true"));
        this.notifier.sendRelationCreationNotification("Relation MBean Creation", "", theRelId, theRelTypeName, theRelObjectName);
    }

    public ObjectName isRelationMBean(String theRelId) throws IllegalArgumentException, RelationNotFoundException {
        if (theRelId == null) {
            String message = CatUtil.relation.getMessage("JMXrl0007E");
            throw new IllegalArgumentException(message);
        }
        Object obj = this.relRepository.get(theRelId);
        if (obj == null) {
            String message = CatUtil.relation.getMessage("JMXrl0009E", theRelId);
            throw new RelationNotFoundException(message);
        }
        if (obj instanceof ExternalRelation) {
            return ((ExternalRelation)obj).getObjectName();
        }
        return null;
    }

    public String isRelation(ObjectName theObjName) throws IllegalArgumentException {
        if (theObjName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0021E");
            throw new IllegalArgumentException(message);
        }
        Set entries = this.relRepository.entrySet();
        Map map = this.relRepository;
        synchronized (map) {
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String relId = (String)entry.getKey();
                Object val = entry.getValue();
                if (!(val instanceof ExternalRelation) || !((ExternalRelation)val).getObjectName().equals(theObjName)) continue;
                String string = relId;
                return string;
            }
        }
        return null;
    }

    public Boolean hasRelation(String theRelId) throws IllegalArgumentException {
        if (theRelId == null) {
            String message = CatUtil.relation.getMessage("JMXrl0007E");
            throw new IllegalArgumentException(message);
        }
        return new Boolean(this.relRepository.containsKey(theRelId));
    }

    public List getAllRelationIds() {
        return new ArrayList(this.relRepository.keySet());
    }

    public Integer checkRoleReading(String theRoleName, String theRelTypeName) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (theRoleName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0017E");
            throw new IllegalArgumentException(message);
        }
        if (theRelTypeName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0008E");
            throw new IllegalArgumentException(message);
        }
        Object obj = this.relTypeRepository.get(theRelTypeName);
        if (obj == null) {
            String message = CatUtil.relation.getMessage("JMXrl0004E", theRelTypeName);
            throw new RelationTypeNotFoundException(message);
        }
        RoleInfo roleInfo = null;
        try {
            roleInfo = ((RelationTypeSupport)obj).getRoleInfo(theRoleName);
        }
        catch (RoleInfoNotFoundException e) {
            return new Integer(3);
        }
        if (!roleInfo.isReadable()) {
            return new Integer(6);
        }
        return new Integer(0);
    }

    public Integer checkRoleWriting(Role theRole, String theRelTypeName, Boolean theInitFlg) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (theRole == null) {
            String message = CatUtil.relation.getMessage("JMXrl0017E");
            throw new IllegalArgumentException(message);
        }
        if (theRelTypeName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0008E");
            throw new IllegalArgumentException(message);
        }
        if (theInitFlg == null) {
            String message = CatUtil.relation.getMessage("JMXrl0017E");
            throw new IllegalArgumentException(message);
        }
        Object obj = this.relTypeRepository.get(theRelTypeName);
        if (obj == null) {
            String message = CatUtil.relation.getMessage("JMXrl0004E", theRelTypeName);
            throw new RelationTypeNotFoundException(message);
        }
        RoleInfo roleInfo = null;
        try {
            roleInfo = ((RelationTypeSupport)obj).getRoleInfo(theRole.getRoleName());
        }
        catch (RoleInfoNotFoundException e) {
            return new Integer(3);
        }
        return this.consistencyChecker.checkRoleWriting(roleInfo, theRole, theInitFlg);
    }

    public void sendRelationCreationNotification(String theRelId) throws IllegalArgumentException, RelationNotFoundException {
        this.notifier.sendRelationCreationNotification(theRelId);
        this.logInfo("sendRelationCreationNotification", "JMXrl0009I", theRelId);
    }

    public void sendRoleUpdateNotification(String theRelId, Role theNewRole, List theOldRoleValue) throws IllegalArgumentException, RelationNotFoundException {
        this.notifier.sendRoleUpdateNotification(theRelId, theNewRole, theOldRoleValue);
        this.logInfo("sendRoleUpdateNotification", "JMXrl0008I", theRelId);
    }

    public void sendRelationRemovalNotification(String theRelId, List theUnregMBeanList) throws IllegalArgumentException, RelationNotFoundException {
        this.notifier.sendRelationRemovalNotification(theRelId, theUnregMBeanList);
        this.logInfo("sendRelationRemovalNotification", "JMXrl0007I", theRelId);
    }

    public void updateRoleMap(String theRelId, Role theNewRole, List theOldRoleValue) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException {
        this.logInfo("updateRoleMap", "JMXrl0015I", theRelId);
        if (theRelId == null) {
            String message = CatUtil.relation.getMessage("JMXrl0007E");
            throw new IllegalArgumentException(message);
        }
        if (theNewRole == null) {
            String message = CatUtil.relation.getMessage("JMXrl0017E");
            throw new IllegalArgumentException(message);
        }
        if (theOldRoleValue == null) {
            String message = CatUtil.relation.getMessage("JMXrl0020E");
            throw new IllegalArgumentException(message);
        }
        if (this.relServiceMBeanServer == null) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        if (!this.relRepository.containsKey(theRelId)) {
            String message = CatUtil.relation.getMessage("JMXrl0009E", theRelId);
            throw new RelationNotFoundException(message);
        }
        this.updateMBeansRelationsMap(theRelId, theNewRole, theOldRoleValue);
        this.filterManager.updateRole(theNewRole.getRoleValue(), theOldRoleValue);
    }

    private void updateMBeansRelationsMap(String theRelId, Role theNewRole, List theOldRoleValue) {
        this.removeRoleValuesMbeanMap(theRelId, theOldRoleValue);
        this.putRoleValueMbeanMap(theRelId, theNewRole.getRoleValue());
    }

    private void removeRoleValuesMbeanMap(String theRelId, List theOldRoleValue) {
        Iterator itr = theOldRoleValue.iterator();
        while (itr.hasNext()) {
            ObjectName objName = (ObjectName)itr.next();
            if (this.isMBeanInOtherRoles(theRelId, objName)) continue;
            List relIdList = (List)this.mbeansRelationsMap.get(objName);
            relIdList.remove(theRelId);
        }
    }

    private boolean isMBeanInOtherRoles(String theRelId, ObjectName objName) {
        Relation relation = (Relation)this.relRepository.get(theRelId);
        Map mbeanMap = relation.getReferencedMBeans();
        return mbeanMap.containsKey(objName);
    }

    public void removeRelation(String theRelId) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException {
        this.logInfo("removeRelation", "JMXrl0015I", theRelId);
        if (theRelId == null) {
            String message = CatUtil.relation.getMessage("JMXrl0007E");
            throw new IllegalArgumentException(message);
        }
        if (this.relServiceMBeanServer == null) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        if (!this.relRepository.containsKey(theRelId)) {
            String message = CatUtil.relation.getMessage("JMXrl0009E", theRelId);
            throw new RelationNotFoundException(message);
        }
        this.purger.handleRelationUnregistration(theRelId);
    }

    public void purgeRelations() throws RelationServiceNotRegisteredException {
        if (this.relServiceMBeanServer == null) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        this.purger.purgeRelations();
    }

    public Map findAssociatedMBeans(ObjectName theMBeanName, String theRelTypeName, String theRoleName) throws IllegalArgumentException {
        if (theMBeanName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0021E");
            throw new IllegalArgumentException(message);
        }
        HashMap associatedMBeans = new HashMap();
        Set entries = this.relRepository.entrySet();
        Map map = this.relRepository;
        synchronized (map) {
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                boolean mbeanReferenced;
                Map.Entry entry = iter.next();
                String relId = (String)entry.getKey();
                String relTypeNameRetrived = ((Relation)this.relRepository.get(relId)).getRelationTypeName();
                boolean relationTypeFilter = theRelTypeName == null || theRelTypeName != null && theRelTypeName.equals(relTypeNameRetrived);
                List currentList = (List)this.mbeansRelationsMap.get(theMBeanName);
                boolean bl = mbeanReferenced = currentList.contains(relId);
                if (!relationTypeFilter || !mbeanReferenced) continue;
                Relation val = (Relation)entry.getValue();
                this.findAssociatedMBeans(theMBeanName, val, theRoleName, associatedMBeans);
            }
        }
        return associatedMBeans;
    }

    private void findAssociatedMBeans(ObjectName theMBeanName, Relation theRelation, String theRoleName, Map associatedMBeans) {
        RoleList roleList = theRelation.retrieveAllRoles();
        String relId = theRelation.getRelationId();
        int countRole = 0;
        Role reflectRole = null;
        int i = 0;
        while (i < roleList.size()) {
            Role currentRole = (Role)roleList.get(i);
            String currentRoleName = currentRole.getRoleName();
            if (theRoleName == null || theRoleName.equals(currentRoleName)) {
                List value = currentRole.getRoleValue();
                if (!value.contains(theMBeanName) || countRole > 1) {
                    this.putValues(value, relId, associatedMBeans);
                } else {
                    if (countRole == 0) {
                        reflectRole = currentRole;
                    }
                    ++countRole;
                }
            }
            ++i;
        }
        if (countRole > 1) {
            this.putValues(reflectRole.getRoleValue(), relId, associatedMBeans);
        }
    }

    private void putValues(List theRoleValue, String relId, Map associatedMBeans) {
        int j = 0;
        while (j < theRoleValue.size()) {
            ObjectName currentObjectName = (ObjectName)theRoleValue.get(j);
            ArrayList<String> relIds = (ArrayList<String>)associatedMBeans.get(currentObjectName);
            if (relIds != null) {
                if (!relIds.contains(relId)) {
                    relIds.add(relId);
                }
            } else {
                relIds = new ArrayList<String>();
                relIds.add(relId);
                associatedMBeans.put(currentObjectName, relIds);
            }
            ++j;
        }
    }

    public Map findReferencingRelations(ObjectName theMBeanName, String theRelTypeName, String theRoleName) throws IllegalArgumentException {
        if (theMBeanName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0021E");
            throw new IllegalArgumentException(message);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        Set entries = this.relRepository.entrySet();
        Map map2 = this.relRepository;
        synchronized (map2) {
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Relation val;
                Map objName_roles;
                List roles;
                Map.Entry entry = iter.next();
                String relId = (String)entry.getKey();
                String relTypeNameRetrived = ((Relation)this.relRepository.get(relId)).getRelationTypeName();
                if (theRelTypeName != null && (theRelTypeName == null || !theRelTypeName.equals(relTypeNameRetrived)) || (roles = (List)(objName_roles = (val = (Relation)entry.getValue()).getReferencedMBeans()).get(theMBeanName)) == null) continue;
                if (theRoleName != null) {
                    int i = 0;
                    while (i < roles.size()) {
                        String currentRole = (String)roles.get(i);
                        if (!currentRole.equals(theRoleName)) {
                            roles.remove(currentRole);
                        }
                        ++i;
                    }
                }
                if (roles.size() == 0) continue;
                map.put(relId, roles);
            }
        }
        return map;
    }

    public List findRelationsOfType(String theRelTypeName) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (theRelTypeName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0008E");
            throw new IllegalArgumentException(message);
        }
        if (!this.relTypeRepository.containsKey(theRelTypeName)) {
            String message = CatUtil.relation.getMessage("JMXrl0004E");
            throw new RelationTypeNotFoundException(message);
        }
        ArrayList<String> list = new ArrayList<String>();
        Set entries = this.relRepository.entrySet();
        Map map = this.relRepository;
        synchronized (map) {
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String relTypeNameRetrived = ((Relation)entry.getValue()).getRelationTypeName();
                if (!relTypeNameRetrived.equals(theRelTypeName)) continue;
                String relId = (String)entry.getKey();
                list.add(relId);
            }
        }
        return list;
    }

    public List getRole(String theRelId, String theRoleName) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException, RoleNotFoundException {
        if (this.relServiceMBeanServer == null) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        if (theRelId == null) {
            String message = CatUtil.relation.getMessage("JMXrl0007E");
            throw new IllegalArgumentException(message);
        }
        if (theRoleName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0017E");
            throw new IllegalArgumentException(message);
        }
        Object obj = this.relRepository.get(theRelId);
        if (obj == null) {
            String message = CatUtil.relation.getMessage("JMXrl0009E", theRelId);
            throw new RelationNotFoundException(message);
        }
        return ((Relation)obj).getRole(theRoleName);
    }

    public RoleResult getRoles(String theRelId, String[] theRoleNameArray) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException {
        if (this.relServiceMBeanServer == null) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        if (theRelId == null) {
            String message = CatUtil.relation.getMessage("JMXrl0007E");
            throw new IllegalArgumentException(message);
        }
        if (theRoleNameArray == null) {
            String message = CatUtil.relation.getMessage("JMXrl0022E");
            throw new IllegalArgumentException(message);
        }
        Object obj = this.relRepository.get(theRelId);
        if (obj == null) {
            String message = CatUtil.relation.getMessage("JMXrl0009E", theRelId);
            throw new RelationNotFoundException(message);
        }
        return ((Relation)obj).getRoles(theRoleNameArray);
    }

    public RoleResult getAllRoles(String theRelId) throws IllegalArgumentException, RelationNotFoundException, RelationServiceNotRegisteredException {
        if (this.relServiceMBeanServer == null) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        if (theRelId == null) {
            String message = CatUtil.relation.getMessage("JMXrl0007E");
            throw new IllegalArgumentException(message);
        }
        Object obj = this.relRepository.get(theRelId);
        if (obj == null) {
            String message = CatUtil.relation.getMessage("JMXrl0009E", theRelId);
            throw new RelationNotFoundException(message);
        }
        return ((Relation)obj).getAllRoles();
    }

    public Integer getRoleCardinality(String theRelId, String theRoleName) throws IllegalArgumentException, RelationNotFoundException, RoleNotFoundException {
        if (theRelId == null) {
            String message = CatUtil.relation.getMessage("JMXrl0007E");
            throw new IllegalArgumentException(message);
        }
        if (theRoleName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0017E");
            throw new IllegalArgumentException(message);
        }
        Object obj = this.relRepository.get(theRelId);
        if (obj == null) {
            String message = CatUtil.relation.getMessage("JMXrl0009E", theRelId);
            throw new RelationNotFoundException(message);
        }
        return ((Relation)obj).getRoleCardinality(theRoleName);
    }

    public void setRole(String theRelId, Role theRole) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException, RoleNotFoundException, InvalidRoleValueException {
        if (theRelId == null) {
            String message = CatUtil.relation.getMessage("JMXrl0007E");
            throw new IllegalArgumentException(message);
        }
        if (theRole == null) {
            String message = CatUtil.relation.getMessage("JMXrl0023E");
            throw new IllegalArgumentException(message);
        }
        if (this.relServiceMBeanServer == null) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        Object obj = this.relRepository.get(theRelId);
        if (obj == null) {
            String message = CatUtil.relation.getMessage("JMXrl0009E", theRelId);
            throw new RelationNotFoundException(message);
        }
        try {
            ((Relation)obj).setRole(theRole);
        }
        catch (RelationTypeNotFoundException e) {
            LogUtil.relation.log(4L, "RelationService", "setRole", e.toString());
        }
    }

    public RoleResult setRoles(String theRelId, RoleList theRoleList) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException {
        if (theRelId == null) {
            String message = CatUtil.relation.getMessage("JMXrl0007E");
            throw new IllegalArgumentException(message);
        }
        if (theRoleList == null) {
            String message = CatUtil.relation.getMessage("JMXrl0024E");
            throw new IllegalArgumentException(message);
        }
        if (this.relServiceMBeanServer == null) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        Object obj = this.relRepository.get(theRelId);
        if (obj == null) {
            String message = CatUtil.relation.getMessage("JMXrl0009E", theRelId);
            throw new RelationNotFoundException(message);
        }
        RoleResult roleResult = null;
        try {
            roleResult = ((Relation)obj).setRoles(theRoleList);
        }
        catch (RelationTypeNotFoundException e) {
            LogUtil.relation.log(4L, "RelationService", "setRoles", e.toString());
        }
        return roleResult;
    }

    public Map getReferencedMBeans(String theRelId) throws IllegalArgumentException, RelationNotFoundException {
        if (theRelId == null) {
            String message = CatUtil.relation.getMessage("JMXrl0007E");
            throw new IllegalArgumentException(message);
        }
        Object val = this.relRepository.get(theRelId);
        if (val == null) {
            String message = CatUtil.relation.getMessage("JMXrl0009E", theRelId);
            throw new RelationNotFoundException(message);
        }
        return ((Relation)val).getReferencedMBeans();
    }

    public String getRelationTypeName(String theRelId) throws IllegalArgumentException, RelationNotFoundException {
        if (theRelId == null) {
            String message = CatUtil.relation.getMessage("JMXrl0007E");
            throw new IllegalArgumentException(message);
        }
        Object obj = this.relRepository.get(theRelId);
        if (obj == null) {
            String message = CatUtil.relation.getMessage("JMXrl0009E", theRelId);
            throw new RelationNotFoundException(message);
        }
        return ((Relation)obj).getRelationTypeName();
    }

    public void handleNotification(Notification theNtf, Object theHandback) {
        if (theNtf.getType().equals("JMX.mbean.unregistered")) {
            ObjectName objName = ((MBeanServerNotification)theNtf).getMBeanName();
            this.purger.addDeregistrationList(objName);
            this.filterManager.disableObjectName(objName);
        }
        if (this.immediatePurgeFlg) {
            this.purger.purgeRelations();
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        ++relationServiceNumber;
        this.mbeanServer = server;
        this.objName = name == null ? new ObjectName(this.createName()) : name;
        return this.objName;
    }

    private String createName() {
        return this.relServiceMBeanServer.getDefaultDomain() + ":name=RelationService" + relationServiceNumber;
    }

    public void postRegister(Boolean registrationDone) {
        if (registrationDone.equals(new Boolean(true))) {
            this.relServiceMBeanServer = this.mbeanServer;
            this.relServiceObjName = this.objName;
            this.consistencyChecker = new ConsistencyChecker(this.relServiceMBeanServer);
            this.filterManager = new NotificationFilterManager();
            this.purger = new Purger();
            this.addAsMBeanServerListener();
        }
    }

    private void addAsMBeanServerListener() {
        try {
            ObjectName delegate = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            this.mbeanServer.addNotificationListener(delegate, this, (NotificationFilter)this.filterManager.getNotificationFilter(), null);
        }
        catch (MalformedObjectNameException e) {
            LogUtil.relation.log(4L, "RelationService", "postRegister", e.toString());
        }
        catch (InstanceNotFoundException e) {
            LogUtil.relation.log(4L, "RelationService", "postRegister", e.toString());
        }
    }

    public void preDeregister() throws Exception {
        ObjectName delegate = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        this.mbeanServer.removeNotificationListener(delegate, this);
    }

    public void postDeregister() {
        this.relServiceMBeanServer = null;
        this.relServiceObjName = null;
    }

    private final void logInfo(String methodName, String msg) {
        LogUtil.relation.message(1L, "RelationService", methodName, msg);
    }

    private final void logInfo(String methodName, String msg, Object p1) {
        LogUtil.relation.message(1L, (Object)"RelationService", methodName, msg, p1 != null ? p1 : "null");
    }

    private final void logInfo(String method, String msg, Object p1, Object p2) {
        LogUtil.relation.message(1L, "RelationService", method, msg, p1 != null ? p1 : "null", p2 != null ? p2 : "null");
    }

    private class Notifier {
        private long notifSeqNbr = 0L;
        private MBeanNotificationInfo[] notificationInfo;

        private Notifier() {
        }

        private long getNextNotifSeqNbr() {
            this.notifSeqNbr = this.notifSeqNbr == Long.MAX_VALUE ? 0L : ++this.notifSeqNbr;
            return this.notifSeqNbr;
        }

        public void sendRelationCreationNotification(String theRelId) throws IllegalArgumentException, RelationNotFoundException {
            ObjectName theRelObjName = RelationService.this.isRelationMBean(theRelId);
            String theRelTypeName = ((Relation)RelationService.this.relRepository.get(theRelId)).getRelationTypeName();
            String theMsg = null;
            long theTimeStamp = System.currentTimeMillis();
            String theNtfType = null;
            if (theRelObjName == null) {
                theNtfType = "Relation Basic Creation";
                theMsg = CatUtil.relation.getMessage("JMXrl0001I");
            } else {
                theNtfType = "Relation MBean Creation";
                theMsg = CatUtil.relation.getMessage("JMXrl0002I");
            }
            this.sendRelationCreationNotification(theNtfType, theMsg, theRelId, theRelTypeName, theRelObjName);
        }

        public void sendRelationCreationNotification(String theNtfType, String theMsg, String theRelId, String theRelTypeName, ObjectName theRelObjName) {
            long theTimeStamp = System.currentTimeMillis();
            RelationNotification relationNotification = new RelationNotification(theNtfType, RelationService.this, this.getNextNotifSeqNbr(), theTimeStamp, theMsg, theRelId, theRelTypeName, theRelObjName, null);
            RelationService.this.sendNotification(relationNotification);
        }

        public void sendRoleUpdateNotification(String theRelId, Role theNewRole, List theOldRoleValue) throws IllegalArgumentException, RelationNotFoundException {
            ObjectName theRelObjName = RelationService.this.isRelationMBean(theRelId);
            String theRelTypeName = ((Relation)RelationService.this.relRepository.get(theRelId)).getRelationTypeName();
            String theMsg = null;
            String theNtfType = null;
            if (theRelObjName == null) {
                theNtfType = "Relation Basic Update";
                theMsg = CatUtil.relation.getMessage("JMXrl0003I");
            } else {
                theNtfType = "Relation MBean Update";
                theMsg = CatUtil.relation.getMessage("JMXrl0004I");
            }
            this.sendRoleUpdateNotification(theNtfType, theMsg, theRelId, theRelTypeName, theRelObjName, theNewRole, theOldRoleValue);
        }

        public void sendRoleUpdateNotification(String theNtfType, String theMsg, String theRelId, String theRelTypeName, ObjectName theRelObjName, Role theNewRole, List theOldRoleValue) {
            long theTimeStamp = System.currentTimeMillis();
            RelationNotification relationNotification = new RelationNotification(theNtfType, RelationService.this, this.getNextNotifSeqNbr(), theTimeStamp, theMsg, theRelId, theRelTypeName, theRelObjName, theNewRole.getRoleName(), theNewRole.getRoleValue(), theOldRoleValue);
            RelationService.this.sendNotification(relationNotification);
        }

        public void sendRelationRemovalNotification(String theRelId, List theUnregMBeanList) throws IllegalArgumentException, RelationNotFoundException {
            ObjectName theRelObjName = RelationService.this.isRelationMBean(theRelId);
            String theRelTypeName = ((Relation)RelationService.this.relRepository.get(theRelId)).getRelationTypeName();
            String theMsg = null;
            String theNtfType = null;
            if (theRelObjName == null) {
                theNtfType = "Relation Basic Removal";
                theMsg = CatUtil.relation.getMessage("JMXrl0005I");
            } else {
                theNtfType = "Relation MBean Removal";
                theMsg = CatUtil.relation.getMessage("JMXrl0006I");
            }
            this.sendRelationRemovalNotification(theNtfType, theMsg, theRelId, theRelTypeName, theRelObjName, theUnregMBeanList);
        }

        public void sendRelationRemovalNotification(String theNtfType, String theMsg, String theRelId, String theRelTypeName, ObjectName theRelObjName, List theUnregMBeanList) {
            long theTimeStamp = System.currentTimeMillis();
            RelationNotification relationNotification = new RelationNotification(theNtfType, RelationService.this, this.getNextNotifSeqNbr(), theTimeStamp, theMsg, theRelId, theRelTypeName, theRelObjName, theUnregMBeanList);
            RelationService.this.sendNotification(relationNotification);
        }

        public MBeanNotificationInfo[] getNotificationInfo() {
            if (this.notificationInfo == null) {
                this.createNotificationInfo();
            }
            return this.notificationInfo;
        }

        private void createNotificationInfo() {
            MBeanNotificationInfo mbni;
            this.notificationInfo = new MBeanNotificationInfo[1];
            String name = "RelationNotification";
            String description = "";
            String[] notifsType = new String[]{"Relation Basic Creation", "Relation Basic Removal", "Relation Basic Update", "Relation MBean Creation", "Relation MBean Removal", "Relation MBean Update"};
            this.notificationInfo[0] = mbni = new MBeanNotificationInfo(notifsType, name, description);
        }
    }

    private class Purger {
        private List deregistrationList = Collections.synchronizedList(new ArrayList());

        public void purgeRelations() {
            while (this.deregistrationList.size() != 0) {
                int last = this.deregistrationList.size() - 1;
                ObjectName objName = (ObjectName)this.deregistrationList.remove(last);
                RelationService.this.filterManager.disableObjectName(objName);
                String relId = RelationService.this.isRelation(objName);
                if (relId != null) {
                    this.handleRelationUnregistration(relId);
                    continue;
                }
                this.handleRoleMBeanUnregistration(objName);
            }
        }

        private void handleRelationUnregistration(String theRelId) {
            try {
                ObjectName theRelObjectName = RelationService.this.isRelationMBean(theRelId);
                if (theRelObjectName != null && RelationService.this.mbeansRelationsMap.containsKey(theRelObjectName)) {
                    RelationService.this.filterManager.disableObjectName(theRelObjectName);
                    this.handleRoleMBeanUnregistration(theRelObjectName);
                }
            }
            catch (RelationNotFoundException e) {
                LogUtil.relation.log(4L, "RelationService", "handleRelationUnregistration", e.toString());
            }
            List list = Utility.removeFromLists(RelationService.this.mbeansRelationsMap, theRelId);
            if (list != null) {
                ArrayList<ObjectName> relations = new ArrayList<ObjectName>();
                int i = 0;
                while (i < list.size()) {
                    ObjectName objName = (ObjectName)list.get(i);
                    if (RelationService.this.isRelation(objName) == null) {
                        RelationService.this.filterManager.disableObjectName(objName);
                    } else {
                        relations.add(objName);
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < relations.size()) {
                    list.remove(relations.get(i2));
                    ++i2;
                }
            }
            try {
                RelationService.this.sendRelationRemovalNotification(theRelId, list);
            }
            catch (RelationNotFoundException e) {
                LogUtil.relation.log(4L, "RelationService", "handleRelationUnregistration", e.toString());
            }
            Relation relation = (Relation)RelationService.this.relRepository.remove(theRelId);
            if (relation instanceof ExternalRelation) {
                Boolean flg = new Boolean("false");
                ((ExternalRelation)relation).setRelationServiceManagementFlag(flg);
            }
        }

        private void handleRoleMBeanUnregistration(ObjectName objName) {
            List relations = (List)RelationService.this.mbeansRelationsMap.remove(objName);
            if (relations != null) {
                int i = 0;
                while (i < relations.size()) {
                    String relId = (String)relations.get(i);
                    this.purgeRelation(relId, objName);
                    ++i;
                }
            }
        }

        private void purgeRelation(String theRelId, ObjectName objName) {
            RoleList roles;
            Relation relation = (Relation)RelationService.this.relRepository.get(theRelId);
            if (relation != null && (roles = relation.retrieveAllRoles()) != null) {
                String relTypeName = relation.getRelationTypeName();
                RelationType relType = (RelationType)RelationService.this.relTypeRepository.get(relTypeName);
                int i = 0;
                while (i < roles.size()) {
                    Role role = (Role)roles.get(i);
                    String roleName = role.getRoleName();
                    if (this.isMBeanInRole(objName, role)) {
                        RoleInfo roleInfo = null;
                        try {
                            roleInfo = relType.getRoleInfo(roleName);
                        }
                        catch (RoleInfoNotFoundException e) {
                            LogUtil.relation.log(4L, "RelationService", "handleRelationUnregistration", e.toString());
                        }
                        RelationService.this.consistencyChecker;
                        if (ConsistencyChecker.checkCardinalityExpected(roleInfo, role)) {
                            try {
                                relation.handleMBeanUnregistration(objName, roleName);
                            }
                            catch (Exception e) {
                                LogUtil.relation.log(4L, "RelationService", "handleRelationUnregistration", e.toString());
                            }
                        } else {
                            this.handleRelationUnregistration(theRelId);
                        }
                    }
                    ++i;
                }
            }
        }

        private boolean isMBeanInRole(ObjectName objName, Role role) {
            ArrayList roleValue = (ArrayList)role.getRoleValue();
            int size = roleValue.size();
            int i = 0;
            while (i < size) {
                ObjectName objNameRetrived = (ObjectName)roleValue.get(i);
                if (objName.equals(objNameRetrived)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void addDeregistrationList(ObjectName objName) {
            this.deregistrationList.add(objName);
        }
    }
}

