/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.tivoli.jmx.relation.ConsistencyChecker;
import com.tivoli.jmx.relation.RelationServiceProxy;
import com.tivoli.jmx.relation.Utility;
import com.tivoli.jmx.utils.logging.CatUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.relation.InvalidRoleValueException;
import javax.management.relation.RelationNotFoundException;
import javax.management.relation.RelationServiceNotRegisteredException;
import javax.management.relation.RelationSupportMBean;
import javax.management.relation.RelationTypeNotFoundException;
import javax.management.relation.Role;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;
import javax.management.relation.RoleList;
import javax.management.relation.RoleNotFoundException;
import javax.management.relation.RoleResult;
import javax.management.relation.RoleUnresolved;
import javax.management.relation.RoleUnresolvedList;

public class RelationSupport
implements RelationSupportMBean,
MBeanRegistration {
    private String relId;
    private ObjectName relServiceName;
    private ObjectName relObjectName;
    private String relTypeName;
    private HashMap roleMap;
    private MBeanServer relServiceMBeanServer;
    private RelationServiceProxy relationServiceProxy;
    private Boolean relationServiceManagementFlag = new Boolean("false");
    private static int relationSupportNumber = 0;

    public RelationSupport(String theRelId, ObjectName theRelServiceName, String theRelTypeName, RoleList theRoleList) throws InvalidRoleValueException, IllegalArgumentException {
        if (theRelId == null) {
            String message = CatUtil.relation.getMessage("JMXrl0007E");
            throw new IllegalArgumentException(message);
        }
        if (theRelServiceName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0032E");
            throw new IllegalArgumentException(message);
        }
        if (theRelTypeName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0008E");
            throw new IllegalArgumentException(message);
        }
        this.relId = theRelId;
        this.relServiceName = theRelServiceName;
        this.relTypeName = theRelTypeName;
        this.roleMap = this.createRoleMap(theRoleList);
    }

    private HashMap createRoleMap(RoleList theRoleList) throws InvalidRoleValueException {
        HashMap<String, Role> map = new HashMap<String, Role>();
        if (theRoleList != null && theRoleList.size() != 0) {
            Iterator iterator = ((AbstractList)theRoleList).iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object instanceof Role) {
                    Role role = (Role)object;
                    Role roleCloned = (Role)role.clone();
                    String key = role.getRoleName();
                    object = map.put(key, roleCloned);
                    if (object == null) continue;
                    String message = CatUtil.relation.getMessage("JMXrl0033E");
                    throw new InvalidRoleValueException(message);
                }
                if (object == null) continue;
                String message = CatUtil.relation.getMessage("JMXrl0034E");
                throw new InvalidRoleValueException(message);
            }
        }
        return map;
    }

    public RelationSupport(String theRelId, ObjectName theRelServiceName, MBeanServer theRelServiceMBeanServer, String theRelTypeName, RoleList theRoleList) throws InvalidRoleValueException, IllegalArgumentException {
        this(theRelId, theRelServiceName, theRelTypeName, theRoleList);
        if (theRelServiceMBeanServer == null) {
            String message = CatUtil.relation.getMessage("JMXrl0035E");
            throw new IllegalArgumentException(message);
        }
        this.relServiceMBeanServer = theRelServiceMBeanServer;
        this.relationServiceProxy = new RelationServiceProxy(this.relServiceMBeanServer, this.relServiceName, this.relTypeName);
    }

    public RoleResult getAllRoles() throws RelationServiceNotRegisteredException {
        if (this.relServiceMBeanServer == null) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        if (!this.relServiceMBeanServer.isRegistered(this.relServiceName)) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        if (this.relationServiceProxy == null) {
            String message = CatUtil.relation.getMessage("JMXrl0036E");
            throw new IllegalStateException(message);
        }
        RoleList roleList = new RoleList();
        RoleUnresolvedList roleUnrList = new RoleUnresolvedList();
        Set set = this.roleMap.entrySet();
        Iterator mapIterator = set.iterator();
        while (mapIterator.hasNext()) {
            Role role = (Role)mapIterator.next().getValue();
            this.checkRoleReading(role, roleList, roleUnrList);
        }
        return new RoleResult(roleList, roleUnrList);
    }

    private void checkRoleReading(Role role, RoleList roleList, RoleUnresolvedList roleUnrList) throws RelationServiceNotRegisteredException {
        String roleName = role.getRoleName();
        List roleValue = role.getRoleValue();
        int pbType = this.relationServiceProxy.checkRoleReading(roleName);
        if (pbType == 0) {
            roleList.add(role.clone());
        } else {
            roleUnrList.add(new RoleUnresolved(roleName, roleValue, pbType));
        }
    }

    public List getRole(String theRoleName) throws IllegalArgumentException, RoleNotFoundException, RelationServiceNotRegisteredException {
        if (theRoleName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0017E");
            throw new IllegalArgumentException(message);
        }
        if (this.relServiceMBeanServer == null) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        if (!this.relServiceMBeanServer.isRegistered(this.relServiceName)) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        Object role = this.roleMap.get(theRoleName);
        if (role == null) {
            String message = CatUtil.relation.getMessage("JMXrl0037E");
            throw new RoleNotFoundException(message);
        }
        if (this.relationServiceProxy == null) {
            String message = CatUtil.relation.getMessage("JMXrl0036E");
            throw new IllegalStateException(message);
        }
        if (this.relationServiceProxy.checkRoleReading(theRoleName) != 0) {
            String message = CatUtil.relation.getMessage("JMXrl0038E");
            throw new RoleNotFoundException(message);
        }
        return ((Role)role).getRoleValue();
    }

    public RoleResult getRoles(String[] theRoleNameArray) throws IllegalArgumentException, RelationServiceNotRegisteredException {
        if (theRoleNameArray == null) {
            String message = CatUtil.relation.getMessage("JMXrl0022E");
            throw new IllegalArgumentException(message);
        }
        if (this.relServiceMBeanServer == null) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        if (!this.relServiceMBeanServer.isRegistered(this.relServiceName)) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        RoleList roleList = new RoleList();
        RoleUnresolvedList roleUnrList = new RoleUnresolvedList();
        int size = theRoleNameArray.length;
        int i = 0;
        while (i < size) {
            Role role = (Role)this.roleMap.get(theRoleNameArray[i]);
            if (role == null) {
                roleUnrList.add(new RoleUnresolved(theRoleNameArray[i], new ArrayList(), 3));
            } else {
                this.checkRoleReading(role, roleList, roleUnrList);
            }
            ++i;
        }
        return new RoleResult(roleList, roleUnrList);
    }

    public Integer getRoleCardinality(String theRoleName) throws IllegalArgumentException, RoleNotFoundException {
        if (theRoleName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0017E");
            throw new IllegalArgumentException(message);
        }
        Role role = (Role)this.roleMap.get(theRoleName);
        if (role == null) {
            String message = CatUtil.relation.getMessage("JMXrl0037E");
            throw new RoleNotFoundException(message);
        }
        List roleValue = role.getRoleValue();
        return new Integer(roleValue.size());
    }

    public RoleList retrieveAllRoles() {
        return new RoleList(new ArrayList(this.roleMap.values()));
    }

    public void setRole(Role theRole) throws IllegalArgumentException, RoleNotFoundException, RelationTypeNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationNotFoundException {
        if (theRole == null) {
            String message = CatUtil.relation.getMessage("JMXrl0023E");
            throw new IllegalArgumentException(message);
        }
        if (this.relServiceMBeanServer == null) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        if (!this.relServiceMBeanServer.isRegistered(this.relServiceName)) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        if (this.relationServiceProxy == null) {
            String message = CatUtil.relation.getMessage("JMXrl0036E");
            throw new IllegalStateException(message);
        }
        Integer result = this.relationServiceProxy.checkRoleWriting(theRole, new Boolean(false));
        if (result != 0) {
            this.throwException(result);
        } else {
            this.update(theRole);
        }
    }

    private void throwException(Integer result) throws RoleNotFoundException, InvalidRoleValueException {
        switch (result) {
            case 3: {
                String message = CatUtil.relation.getMessage("JMXrl0037E");
                throw new RoleNotFoundException(message);
            }
            case 7: {
                String message = CatUtil.relation.getMessage("JMXrl0039E");
                throw new RoleNotFoundException(message);
            }
            case 5: {
                String message = CatUtil.relation.getMessage("JMXrl0040E");
                throw new InvalidRoleValueException(message);
            }
            case 4: {
                String message = CatUtil.relation.getMessage("JMXrl0041E");
                throw new InvalidRoleValueException(message);
            }
            case 2: {
                String message = CatUtil.relation.getMessage("JMXrl0042E");
                throw new InvalidRoleValueException(message);
            }
            case 1: {
                String message = CatUtil.relation.getMessage("JMXrl0043E");
                throw new InvalidRoleValueException(message);
            }
        }
    }

    private void update(Role newRole) throws RelationServiceNotRegisteredException, RelationNotFoundException {
        String key = newRole.getRoleName();
        Object role = this.roleMap.remove(key);
        Role oldRole = null;
        if (role != null) {
            oldRole = (Role)role;
        }
        if (this.relationServiceProxy == null) {
            String message = CatUtil.relation.getMessage("JMXrl0036E");
            throw new IllegalStateException(message);
        }
        List oldValue = oldRole.getRoleValue();
        this.roleMap.put(key, newRole.clone());
        this.relationServiceProxy.updateRoleMap(this.relId, newRole, oldValue);
        this.relationServiceProxy.sendRoleUpdateNotification(this.relId, newRole, oldValue);
    }

    /*
     * Unable to fully structure code
     */
    public RoleResult setRoles(RoleList theRoleList) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        if (theRoleList == null) {
            message = CatUtil.relation.getMessage("JMXrl0024E");
            throw new IllegalArgumentException(message);
        }
        if (this.relServiceMBeanServer == null) {
            message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        if (!this.relServiceMBeanServer.isRegistered(this.relServiceName)) {
            message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        roleList = new RoleList();
        roleUnrList = new RoleUnresolvedList();
        itr = theRoleList.iterator();
        if (this.relationServiceProxy != null) ** GOTO lbl26
        message = CatUtil.relation.getMessage("JMXrl0036E");
        throw new IllegalStateException(message);
lbl-1000:
        // 1 sources

        {
            obj = itr.next();
            if (!(obj instanceof Role)) continue;
            role = (Role)obj;
            pbType = this.relationServiceProxy.checkRoleWriting(role, new Boolean(false));
            if (pbType != 0) {
                roleUnrList.add(new RoleUnresolved(role.getRoleName(), role.getRoleValue(), pbType));
                continue;
            }
            roleList.add(role.clone());
            this.update(role);
lbl26:
            // 4 sources

            ** while (itr.hasNext())
        }
lbl27:
        // 1 sources

        return new RoleResult(roleList, roleUnrList);
    }

    public void handleMBeanUnregistration(ObjectName theObjName, String theRoleName) throws IllegalArgumentException, RoleNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        if (theObjName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0027E");
            throw new IllegalArgumentException(message);
        }
        if (theRoleName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0017E");
            throw new IllegalArgumentException(message);
        }
        if (this.relServiceMBeanServer == null) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        if (!this.relServiceMBeanServer.isRegistered(this.relServiceName)) {
            String message = CatUtil.relation.getMessage("JMXrl0001E");
            throw new RelationServiceNotRegisteredException(message);
        }
        if (this.relObjectName != null && !this.relationServiceProxy.hasRelation(this.relId)) {
            String message = CatUtil.relation.getMessage("JMXrl0062E");
            throw new RelationNotFoundException(message);
        }
        Role role = (Role)this.roleMap.get(theRoleName);
        if (role == null) {
            String message = CatUtil.relation.getMessage("JMXrl0057E");
            throw new RoleNotFoundException(message);
        }
        this.modifyRole(role, theObjName);
        this.roleMap.remove(theRoleName);
        this.roleMap.put(theRoleName, role);
    }

    private void modifyRole(Role role, ObjectName objName) throws InvalidRoleValueException, RelationTypeNotFoundException {
        RoleInfo roleInfo = null;
        try {
            roleInfo = this.relationServiceProxy.getRoleInfo(role.getRoleName());
        }
        catch (RoleInfoNotFoundException e) {
            String message = CatUtil.relation.getMessage("JMXrl0066E");
            throw new InvalidRoleValueException(message);
        }
        boolean consistent = ConsistencyChecker.checkCardinalityExpected(roleInfo, role);
        if (!consistent) {
            String message = CatUtil.relation.getMessage("JMXrl0067E");
            throw new InvalidRoleValueException(message);
        }
        ArrayList roleValue = (ArrayList)role.getRoleValue();
        if (this.removeObjName(roleValue, objName) == null) {
            String message = CatUtil.relation.getMessage("JMXrl0068E", objName, role.getRoleName());
            throw new InvalidRoleValueException(message);
        }
        role.setRoleValue(roleValue);
    }

    private ObjectName removeObjName(ArrayList roleValue, ObjectName objName) {
        int size = roleValue.size();
        int i = 0;
        while (i < size) {
            ObjectName objNameRetrived = (ObjectName)roleValue.get(i);
            if (objName.equals(objNameRetrived)) {
                return (ObjectName)roleValue.remove(i);
            }
            ++i;
        }
        return null;
    }

    public Map getReferencedMBeans() {
        HashMap mbeansMap = new HashMap();
        Set set = this.roleMap.entrySet();
        Iterator mapIterator = set.iterator();
        while (mapIterator.hasNext()) {
            Role role = (Role)mapIterator.next().getValue();
            String roleName = role.getRoleName();
            List roleValue = role.getRoleValue();
            Iterator roleValueIterator = roleValue.iterator();
            while (roleValueIterator.hasNext()) {
                ObjectName objectName = (ObjectName)roleValueIterator.next();
                Utility.put(mbeansMap, objectName, roleName);
            }
        }
        return mbeansMap;
    }

    public String getRelationTypeName() {
        return this.relTypeName;
    }

    public ObjectName getRelationServiceName() {
        return this.relServiceName;
    }

    public String getRelationId() {
        return this.relId;
    }

    public Boolean isInRelationService() {
        return this.relationServiceManagementFlag;
    }

    public void setRelationServiceManagementFlag(Boolean theFlg) throws IllegalArgumentException {
        if (theFlg == null) {
            String message = CatUtil.relation.getMessage("JMXrl0019E");
            throw new IllegalArgumentException(message);
        }
        this.relationServiceManagementFlag = theFlg;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        ++relationSupportNumber;
        this.relServiceMBeanServer = server;
        ObjectName objectName = name == null ? new ObjectName(this.createName()) : name;
        this.relObjectName = objectName;
        return objectName;
    }

    private String createName() {
        return this.relServiceMBeanServer.getDefaultDomain() + ":name=RelationSupport" + relationSupportNumber;
    }

    public void postRegister(Boolean registrationDone) {
        if (registrationDone.equals(new Boolean(true)) && this.relationServiceProxy == null) {
            this.relationServiceProxy = new RelationServiceProxy(this.relServiceMBeanServer, this.relServiceName, this.relTypeName);
        }
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.relServiceMBeanServer = null;
    }
}

