/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.tivoli.jmx.utils.logging.CatUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.RelationType;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;

public class RelationTypeSupport
implements RelationType {
    boolean myIsInRelServFlg;
    HashMap myRoleName2InfoMap;
    String myTypeName;

    public RelationTypeSupport(String theRelTypeName, RoleInfo[] theRoleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (theRelTypeName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0008E");
            throw new IllegalArgumentException(message);
        }
        if (theRoleInfoArray == null || theRoleInfoArray.length == 0) {
            String message = CatUtil.relation.getMessage("JMXrl0044E");
            throw new InvalidRelationTypeException(message);
        }
        HashMap<String, RoleInfo> map = new HashMap<String, RoleInfo>();
        int i = 0;
        while (i < theRoleInfoArray.length) {
            RoleInfo roleInfo = theRoleInfoArray[i];
            if (roleInfo != null) {
                String key = theRoleInfoArray[i].getName();
                RoleInfo obj = map.put(key, roleInfo);
                if (obj != null) {
                    String message = CatUtil.relation.getMessage("JMXrl0033E");
                    throw new InvalidRelationTypeException(message);
                }
            } else {
                String message = CatUtil.relation.getMessage("JMXrl0045E");
                throw new InvalidRelationTypeException(message);
            }
            ++i;
        }
        this.myTypeName = theRelTypeName;
        this.myRoleName2InfoMap = map;
    }

    protected RelationTypeSupport(String theRelTypeName) {
        this.myTypeName = theRelTypeName;
        this.myRoleName2InfoMap = new HashMap();
    }

    public String getRelationTypeName() {
        return this.myTypeName;
    }

    public List getRoleInfos() {
        Collection collection = this.myRoleName2InfoMap.values();
        return new ArrayList(collection);
    }

    public RoleInfo getRoleInfo(String theRoleInfoName) throws IllegalArgumentException, RoleInfoNotFoundException {
        if (theRoleInfoName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0005E");
            throw new IllegalArgumentException(message);
        }
        RoleInfo roleInfo = (RoleInfo)this.myRoleName2InfoMap.get(theRoleInfoName);
        if (roleInfo == null) {
            String message = CatUtil.relation.getMessage("JMXrl0046E");
            throw new RoleInfoNotFoundException(message);
        }
        return roleInfo;
    }

    protected void addRoleInfo(RoleInfo theRoleInfo) throws IllegalArgumentException, InvalidRelationTypeException {
        if (theRoleInfo == null) {
            String message = CatUtil.relation.getMessage("JMXrl0047E");
            throw new IllegalArgumentException(message);
        }
        String key = theRoleInfo.getName();
        if (this.myRoleName2InfoMap.get(key) != null) {
            String message = CatUtil.relation.getMessage("JMXrl0033E");
            throw new InvalidRelationTypeException(message);
        }
        this.myRoleName2InfoMap.put(key, theRoleInfo);
    }
}

