/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.tivoli.jmx.MBeanIntrospector;
import com.tivoli.jmx.utils.logging.CatUtil;
import java.io.Serializable;
import javax.management.NotCompliantMBeanException;
import javax.management.loading.DefaultLoaderRepository;
import javax.management.relation.InvalidRoleInfoException;

public class RoleInfo
implements Serializable {
    private String myDescription;
    private boolean myIsReadableFlg;
    private boolean myIsWritableFlg;
    private int myMaxDegree;
    private int myMinDegree;
    private String myName;
    private String myRefMBeanClassName;
    public static int ROLE_CARDINALITY_INFINITY = -1;

    public RoleInfo(String theName, String theRefMBeanClassName, boolean theIsReadable, boolean theIsWritable, int theMinDegree, int theMaxDegree, String theDescription) throws IllegalArgumentException, InvalidRoleInfoException, ClassNotFoundException, NotCompliantMBeanException {
        if (theName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0050E");
            throw new IllegalArgumentException(message);
        }
        if (theMinDegree == ROLE_CARDINALITY_INFINITY) {
            String message = CatUtil.relation.getMessage("JMXrl0069E");
            throw new InvalidRoleInfoException(message);
        }
        if (theMinDegree > theMaxDegree && theMaxDegree != ROLE_CARDINALITY_INFINITY) {
            String message = CatUtil.relation.getMessage("JMXrl0052E");
            throw new InvalidRoleInfoException(message);
        }
        Class cl = null;
        try {
            cl = Class.forName(theRefMBeanClassName);
        }
        catch (ClassNotFoundException cnfe) {
            cl = DefaultLoaderRepository.loadClass(theRefMBeanClassName);
        }
        MBeanIntrospector.testMBean(cl);
        this.myDescription = theDescription;
        this.myIsReadableFlg = theIsReadable;
        this.myIsWritableFlg = theIsWritable;
        this.myMaxDegree = theMaxDegree;
        this.myMinDegree = theMinDegree;
        this.myName = theName;
        this.myRefMBeanClassName = theRefMBeanClassName;
    }

    public RoleInfo(String theName, String theRefMBeanClassName, boolean theIsReadable, boolean theIsWritable) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException {
        if (theName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0050E");
            throw new IllegalArgumentException(message);
        }
        if (theRefMBeanClassName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0053E");
            throw new IllegalArgumentException(message);
        }
        Class cl = null;
        try {
            cl = Class.forName(theRefMBeanClassName);
        }
        catch (ClassNotFoundException cnfe) {
            cl = DefaultLoaderRepository.loadClass(theRefMBeanClassName);
        }
        MBeanIntrospector.testMBean(cl);
        this.myDescription = null;
        this.myMaxDegree = 1;
        this.myMinDegree = 1;
        this.myIsReadableFlg = this.myIsReadableFlg;
        this.myIsWritableFlg = theIsWritable;
        this.myName = theName;
        this.myRefMBeanClassName = theRefMBeanClassName;
    }

    public RoleInfo(String theName, String theRefMBeanClassName) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException {
        if (theName == null) {
            String message = CatUtil.relation.getMessage("JMXrl0050E");
            throw new IllegalArgumentException(message);
        }
        Class<?> cl = Class.forName(theRefMBeanClassName);
        MBeanIntrospector.testMBean(cl);
        this.myDescription = null;
        this.myIsReadableFlg = true;
        this.myIsWritableFlg = true;
        this.myMaxDegree = 1;
        this.myMinDegree = 1;
        this.myName = theName;
        this.myRefMBeanClassName = theRefMBeanClassName;
    }

    public RoleInfo(RoleInfo theRoleInfo) throws IllegalArgumentException {
        if (theRoleInfo == null) {
            String message = CatUtil.relation.getMessage("JMXrl0047E");
            throw new IllegalArgumentException(message);
        }
        this.myName = theRoleInfo.myName;
        this.myRefMBeanClassName = theRoleInfo.myRefMBeanClassName;
        this.myDescription = theRoleInfo.myDescription;
        this.myIsWritableFlg = theRoleInfo.myIsWritableFlg;
        this.myIsReadableFlg = theRoleInfo.myIsReadableFlg;
        this.myMinDegree = theRoleInfo.myMinDegree;
        this.myMaxDegree = theRoleInfo.myMaxDegree;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isReadable() {
        return this.myIsReadableFlg;
    }

    public boolean isWritable() {
        return this.myIsWritableFlg;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public int getMinDegree() {
        return this.myMinDegree;
    }

    public int getMaxDegree() {
        return this.myMaxDegree;
    }

    public String getRefMBeanClassName() {
        return this.myRefMBeanClassName;
    }

    public boolean checkMinDegree(int theValue) {
        return theValue >= this.myMinDegree;
    }

    public boolean checkMaxDegree(int theValue) {
        if (this.myMaxDegree == ROLE_CARDINALITY_INFINITY) {
            return true;
        }
        return theValue <= this.myMaxDegree;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{").append("Name = " + this.myName).append(", ").append("MBeanClassName = " + this.myRefMBeanClassName).append(", ").append("IsReadable = " + this.myIsReadableFlg).append(", ").append("IsWritable = " + this.myIsWritableFlg).append(", ").append("MinDegree = " + this.myMinDegree).append(", ").append("MaxDegree = " + this.myMaxDegree).append(", ").append("Description = " + this.myDescription).append("}");
        return stringBuffer.toString();
    }
}

