/*
 * Decompiled with CFR 0.152.
 */
package javax.management.timer;

import com.tivoli.jmx.utils.logging.LogUtil;
import java.io.Serializable;
import java.util.LinkedList;
import javax.management.timer.Timer;
import javax.management.timer.TimerNotification;

class RunnableTimer
implements Runnable,
Serializable {
    transient boolean active;
    Timer timer;
    LinkedList timerNotifications;

    RunnableTimer(Timer timer) {
        this.timer = timer;
        this.timerNotifications = timer.getTimerNotifications();
    }

    synchronized void start() {
        if (this.active) {
            LogUtil.core.message(2L, this, "start", "JMXcr0001W");
        } else {
            Thread thread = new Thread((Runnable)this, "RunnableTimer");
            try {
                thread.setDaemon(true);
            }
            catch (SecurityException e) {
                LogUtil.timer.log(4L, this, "start", e.toString());
            }
            this.active = true;
            this.checkExpiredNotifications();
            thread.start();
            LogUtil.core.message(1L, this, "start", "JMXcr0003I");
        }
    }

    synchronized void stop() {
        if (this.active) {
            this.active = false;
            this.notify();
            LogUtil.core.message(1L, this, "stop", "JMXcr0002I");
        } else {
            LogUtil.core.message(2L, this, "stop", "JMXcr0002W");
        }
    }

    public synchronized void run() {
        try {
            while (this.active) {
                long timeToWait = this.emitNotification();
                if (timeToWait >= 0L) {
                    this.wait(timeToWait);
                    continue;
                }
                LogUtil.timer.message(4L, this, "run", "JMXtm0001E");
                this.active = false;
            }
        }
        catch (InterruptedException ie) {
            LogUtil.timer.log(4L, this, "run", ie.toString());
        }
    }

    private long emitNotification() {
        long timeToWait = 0L;
        do {
            try {
                this.wait(1L);
                if (this.timerNotifications.isEmpty()) {
                    LogUtil.timer.message(1L, this, "emitNotification", "JMXtm0004I");
                    timeToWait = 0L;
                    break;
                }
                TimerNotification firstNotification = (TimerNotification)this.timerNotifications.getFirst();
                long currentTime = System.currentTimeMillis();
                timeToWait = firstNotification.getEmissionDate().getTime() - currentTime;
                if (timeToWait > 0L) continue;
                String value = firstNotification.getType();
                LogUtil.timer.message(1L, (Object)this, "emitNotification", "JMXtm0010I", value);
                this.timer.sendNotification(firstNotification);
                this.timer.removeNotification(firstNotification);
                boolean toBeAdded = firstNotification.isToBeReAdded();
                if (toBeAdded) {
                    firstNotification.update();
                    LogUtil.timer.message(1L, this, "emitNotification", "JMXtm0011I");
                    this.timer.addNotification(firstNotification);
                    continue;
                }
                LogUtil.timer.message(1L, (Object)this, "emitNotification", "JMXtm0017I", firstNotification.getNotificationID());
            }
            catch (InterruptedException e) {
                LogUtil.timer.log(4L, this, "emitNotification", e.toString());
            }
        } while (timeToWait <= 0L);
        return timeToWait;
    }

    synchronized void wakeUp() {
        this.notify();
    }

    private synchronized void checkExpiredNotifications() {
        if (!this.timerNotifications.isEmpty()) {
            if (this.timer.getSendPastNotifications()) {
                this.sendExpiredNotification();
            } else {
                this.removeExpiredNotifications();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void sendExpiredNotification() {
        LogUtil.timer.message(1L, this, "sendExpiredNotification", "JMXtm0003I");
        firstNotification = (TimerNotification)this.timerNotifications.getFirst();
        if (firstNotification != null) ** GOTO lbl23
        LogUtil.timer.message(1L, this, "sendExpiredNotification", "JMXtm0004I");
        return;
lbl-1000:
        // 1 sources

        {
            timesToUpdate = firstNotification.timesToUpdate();
            toBeAdded = firstNotification.isToBeAdded();
            this.timer.removeNotification(firstNotification);
            this.timer.sendNotification(firstNotification);
            i = 1;
            while ((long)i < timesToUpdate) {
                firstNotification.update();
                this.timer.sendNotification(firstNotification);
                ++i;
            }
            if (toBeAdded) {
                firstNotification.update();
                this.timer.addNotification(firstNotification);
            }
            if (this.timerNotifications.isEmpty()) {
                LogUtil.timer.message(1L, this, "sendExpiredNotification", "JMXtm0004I");
                break;
            }
            firstNotification = (TimerNotification)this.timerNotifications.getFirst();
lbl23:
            // 2 sources

            ** while (firstNotification.getEmissionDate().getTime() < System.currentTimeMillis())
        }
lbl24:
        // 2 sources

        LogUtil.timer.message(1L, this, "sendExpiredNotification", "JMXtm0005I");
    }

    private void removeExpiredNotifications() {
        LogUtil.timer.message(1L, this, "removeExpiredNotifications", "JMXtm0006I");
        TimerNotification firstNotification = (TimerNotification)this.timerNotifications.getFirst();
        while (firstNotification.getEmissionDate().getTime() < System.currentTimeMillis()) {
            this.timer.removeNotification(firstNotification);
            if (firstNotification.tryToUpdate()) {
                this.timer.addNotification(firstNotification);
            }
            if (this.timerNotifications.isEmpty()) {
                LogUtil.timer.message(1L, this, "removeExpiredNotifications", "JMXtm0004I");
                break;
            }
            firstNotification = (TimerNotification)this.timerNotifications.getFirst();
        }
        LogUtil.timer.message(1L, this, "removeExpiredNotifications", "JMXtm0005I");
    }
}

