/*
 * Decompiled with CFR 0.152.
 */
package javax.management.timer;

import com.tivoli.jmx.utils.logging.CatUtil;
import com.tivoli.jmx.utils.logging.LogUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.timer.RunnableTimer;
import javax.management.timer.TimerMBean;
import javax.management.timer.TimerNotification;

public class Timer
extends NotificationBroadcasterSupport
implements TimerMBean,
MBeanRegistration,
Serializable {
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;
    RunnableTimer timerThread;
    private LinkedList timerNotifications = new LinkedList();
    private int identifier = 0;
    private long sequenceNumber = 0L;
    private boolean sendPastNotifications = false;

    public Timer() {
        this.timerThread = new RunnableTimer(this);
        this.timerThread.active = false;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (server == null || name == null) {
            throw new Exception();
        }
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        RunnableTimer runnableTimer = this.timerThread;
        synchronized (runnableTimer) {
            if (this.timerThread.active) {
                LogUtil.timer.message(1L, "Timer", "preDeregister", "JMXtm0002I");
            }
            this.stop();
        }
    }

    public void postDeregister() {
    }

    public void start() {
        LogUtil.timer.message(1L, "Timer", "start", "JMXtm0001I");
        this.timerThread.start();
    }

    public void stop() {
        LogUtil.timer.message(1L, "Timer", "stop", "JMXtm0002I");
        this.timerThread.stop();
    }

    LinkedList getTimerNotifications() {
        return this.timerNotifications;
    }

    public boolean isActive() {
        RunnableTimer runnableTimer = this.timerThread;
        synchronized (runnableTimer) {
            boolean bl = this.timerThread.active;
            return bl;
        }
    }

    public boolean isEmpty() {
        RunnableTimer runnableTimer = this.timerThread;
        synchronized (runnableTimer) {
            boolean bl = this.timerNotifications.isEmpty();
            return bl;
        }
    }

    public int getNbNotifications() {
        RunnableTimer runnableTimer = this.timerThread;
        synchronized (runnableTimer) {
            int n = this.timerNotifications.size();
            return n;
        }
    }

    public void setSendPastNotifications(boolean sendPastNotifications) {
        this.sendPastNotifications = sendPastNotifications;
        String value = "" + this.sendPastNotifications;
        LogUtil.timer.message(1L, (Object)this, "setSendPastNotifications", "JMXtm0007I", value);
    }

    public boolean getSendPastNotifications() {
        return this.sendPastNotifications;
    }

    public Integer addNotification(String type, String message, Object userData, Date date) throws IllegalArgumentException {
        LogUtil.timer.message(1L, this, "addNotification", "JMXtm0008I");
        if (date == null || date.getTime() < System.currentTimeMillis()) {
            throw new IllegalArgumentException(CatUtil.timer.getMessage("JMXtm0002E"));
        }
        ++this.identifier;
        Integer id = new Integer(this.identifier);
        ++this.sequenceNumber;
        TimerNotification timerNotification = new TimerNotification(type, this, this.sequenceNumber, message, date, id);
        timerNotification.setUserData(userData);
        this.addNotification(timerNotification);
        return id;
    }

    public Integer addNotification(String type, String message, Object userData, Date date, long period) throws IllegalArgumentException {
        LogUtil.timer.message(1L, this, "addNotification", "JMXtm0008I");
        if (period < 0L || date == null) {
            throw new IllegalArgumentException(CatUtil.timer.getMessage("JMXtm0002E"));
        }
        ++this.identifier;
        Integer id = new Integer(this.identifier);
        ++this.sequenceNumber;
        TimerNotification timerNotification = new TimerNotification(type, this, this.sequenceNumber, message, date, id, period);
        timerNotification.setUserData(userData);
        if (timerNotification.isExpired()) {
            --this.identifier;
            --this.sequenceNumber;
            throw new IllegalArgumentException(CatUtil.timer.getMessage("JMXtm0003E"));
        }
        this.addNotification(timerNotification);
        return id;
    }

    public Integer addNotification(String type, String message, Object userData, Date date, long period, long nbOccurrences) throws IllegalArgumentException {
        LogUtil.timer.message(1L, this, "addNotification", "JMXtm0008I");
        if (period < 0L || nbOccurrences < 0L || date == null) {
            throw new IllegalArgumentException(CatUtil.timer.getMessage("JMXtm0002E"));
        }
        ++this.identifier;
        Integer id = new Integer(this.identifier);
        ++this.sequenceNumber;
        TimerNotification timerNotification = new TimerNotification(type, this, this.sequenceNumber, message, date, id, period, nbOccurrences);
        timerNotification.setUserData(userData);
        if (timerNotification.isExpired()) {
            --this.identifier;
            --this.sequenceNumber;
            throw new IllegalArgumentException(CatUtil.timer.getMessage("JMXtm0003E"));
        }
        this.addNotification(timerNotification);
        return id;
    }

    /*
     * Unable to fully structure code
     */
    void addNotification(TimerNotification timerNotification) {
        var2_2 = this.timerThread;
        synchronized (var2_2) {
            block9: {
                size = this.timerNotifications.size();
                isFound = false;
                testDate = timerNotification.getEmissionDate();
                index = 0;
                if (!this.timerNotifications.isEmpty()) ** GOTO lbl21
                this.timerNotifications.add(index, timerNotification);
                ind = new Integer(index);
                LogUtil.timer.message(1L, (Object)this, "addNotification", "JMXtm0009I", ind);
                break block9;
lbl-1000:
                // 1 sources

                {
                    nextNotification = (TimerNotification)this.timerNotifications.get(index);
                    nextNotificationDate = nextNotification.getEmissionDate();
                    if (testDate.compareTo(nextNotificationDate) < 0) {
                        isFound = true;
                        this.timerNotifications.add(index, timerNotification);
                        ind = new Integer(index);
                        LogUtil.timer.message(1L, (Object)this, "addNotification", "JMXtm0009I", ind);
                    }
                    ++index;
lbl21:
                    // 2 sources

                    ** while (index < size && !isFound)
                }
lbl22:
                // 1 sources

                if (!isFound) {
                    this.timerNotifications.addLast(timerNotification);
                    ind = new Integer(index);
                    LogUtil.timer.message(1L, (Object)this, "addNotification", "JMXtm0009I", ind);
                }
            }
            if (index < 1) {
                if (this.timerThread == null || !this.timerThread.active) {
                    LogUtil.core.message(1L, this, "addNotification", "JMXcr0004I");
                } else {
                    this.timerThread.wakeUp();
                }
            }
        }
    }

    void removeNotification(TimerNotification notification) {
        RunnableTimer runnableTimer = this.timerThread;
        synchronized (runnableTimer) {
            TimerNotification firstNotification = (TimerNotification)this.timerNotifications.getFirst();
            this.timerNotifications.remove(notification);
            if (firstNotification == notification) {
                this.timerThread.wakeUp();
            }
        }
    }

    public void removeNotification(Integer id) throws InstanceNotFoundException {
        int index = 0;
        LogUtil.timer.message(1L, (Object)this, "removeNotification", "JMXtm0018I", id.toString());
        RunnableTimer runnableTimer = this.timerThread;
        synchronized (runnableTimer) {
            int size = this.timerNotifications.size();
            boolean isFound = false;
            while (index < size && !isFound) {
                TimerNotification nextNotification = (TimerNotification)this.timerNotifications.get(index);
                if (nextNotification.isEqual(id)) {
                    this.timerNotifications.remove(nextNotification);
                    isFound = true;
                    --index;
                    --size;
                }
                ++index;
            }
            if (!isFound) {
                throw new InstanceNotFoundException(CatUtil.timer.getMessage("JMXtm0004E", id));
            }
            LogUtil.timer.message(1L, this, "removeNotification", "JMXtm0012I");
        }
    }

    public void removeNotifications(String type) throws InstanceNotFoundException {
        int index = 0;
        LogUtil.timer.message(1L, (Object)this, "removeNotifications", "JMXtm0014I", type);
        RunnableTimer runnableTimer = this.timerThread;
        synchronized (runnableTimer) {
            int size = this.timerNotifications.size();
            boolean isFound = false;
            while (index < size) {
                TimerNotification nextNotification = (TimerNotification)this.timerNotifications.get(index);
                if (nextNotification.isEqual(type)) {
                    this.timerNotifications.remove(nextNotification);
                    isFound = true;
                    --index;
                    --size;
                }
                ++index;
            }
            if (!isFound) {
                throw new InstanceNotFoundException(CatUtil.timer.getMessage("JMXtm0005E", type));
            }
            LogUtil.timer.message(1L, this, "removeNotifications", "JMXtm0015I");
        }
    }

    public void removeAllNotifications() {
        LogUtil.timer.message(1L, this, "removeAllNotifications", "JMXtm0016I");
        RunnableTimer runnableTimer = this.timerThread;
        synchronized (runnableTimer) {
            this.timerNotifications.clear();
            this.identifier = 0;
            this.timerThread.wakeUp();
        }
        LogUtil.timer.message(1L, this, "removeAllNotifications", "JMXtm0015I");
    }

    public Long getPeriod(Integer id) {
        int index = 0;
        boolean found = false;
        RunnableTimer runnableTimer = this.timerThread;
        synchronized (runnableTimer) {
            int size = this.timerNotifications.size();
            Long period = null;
            while (index < size) {
                TimerNotification nextNotification = (TimerNotification)this.timerNotifications.get(index);
                if (nextNotification.isEqual(id)) {
                    period = nextNotification.getPeriod();
                    found = true;
                    break;
                }
                ++index;
            }
            if (!found) {
                throw new IllegalArgumentException(CatUtil.timer.getMessage("JMXtm0004E", id));
            }
            Long l = period;
            return l;
        }
    }

    public Object getNotificationUserData(Integer id) {
        int index = 0;
        boolean found = false;
        RunnableTimer runnableTimer = this.timerThread;
        synchronized (runnableTimer) {
            int size = this.timerNotifications.size();
            Object userData = null;
            while (index < size) {
                TimerNotification nextNotification = (TimerNotification)this.timerNotifications.get(index);
                if (nextNotification.isEqual(id)) {
                    userData = nextNotification.getUserData();
                    found = true;
                    break;
                }
                ++index;
            }
            if (!found) {
                throw new IllegalArgumentException(CatUtil.timer.getMessage("JMXtm0004E", id));
            }
            Object object = userData;
            return object;
        }
    }

    public String getNotificationType(Integer id) {
        int index = 0;
        boolean found = false;
        RunnableTimer runnableTimer = this.timerThread;
        synchronized (runnableTimer) {
            int size = this.timerNotifications.size();
            String notificationType = null;
            while (index < size) {
                TimerNotification nextNotification = (TimerNotification)this.timerNotifications.get(index);
                if (nextNotification.isEqual(id)) {
                    notificationType = nextNotification.getType();
                    found = true;
                    break;
                }
                ++index;
            }
            if (!found) {
                throw new IllegalArgumentException(CatUtil.timer.getMessage("JMXtm0004E", id));
            }
            String string = notificationType;
            return string;
        }
    }

    public String getNotificationMessage(Integer id) {
        int index = 0;
        boolean found = false;
        RunnableTimer runnableTimer = this.timerThread;
        synchronized (runnableTimer) {
            int size = this.timerNotifications.size();
            String notificationMessage = null;
            while (index < size) {
                TimerNotification nextNotification = (TimerNotification)this.timerNotifications.get(index);
                if (nextNotification.isEqual(id)) {
                    notificationMessage = nextNotification.getMessage();
                    found = true;
                    break;
                }
                ++index;
            }
            if (!found) {
                throw new IllegalArgumentException(CatUtil.timer.getMessage("JMXtm0004E", id));
            }
            String string = notificationMessage;
            return string;
        }
    }

    public Date getDate(Integer id) {
        int index = 0;
        boolean found = false;
        RunnableTimer runnableTimer = this.timerThread;
        synchronized (runnableTimer) {
            int size = this.timerNotifications.size();
            Date date = null;
            while (index < size) {
                TimerNotification nextNotification = (TimerNotification)this.timerNotifications.get(index);
                if (nextNotification.isEqual(id)) {
                    date = (Date)nextNotification.getEmissionDate().clone();
                    found = true;
                    break;
                }
                ++index;
            }
            if (!found) {
                throw new IllegalArgumentException(CatUtil.timer.getMessage("JMXtm0004E", id));
            }
            Date date2 = date;
            return date2;
        }
    }

    public Long getNbOccurences(Integer id) {
        int index = 0;
        boolean found = false;
        RunnableTimer runnableTimer = this.timerThread;
        synchronized (runnableTimer) {
            int size = this.timerNotifications.size();
            Long nbOccurences = null;
            while (index < size) {
                TimerNotification nextNotification = (TimerNotification)this.timerNotifications.get(index);
                if (nextNotification.isEqual(id)) {
                    nbOccurences = nextNotification.getNumberOccurrences();
                    found = true;
                    break;
                }
                ++index;
            }
            if (!found) {
                throw new IllegalArgumentException(CatUtil.timer.getMessage("JMXtm0004E", id));
            }
            Long l = nbOccurences;
            return l;
        }
    }

    public Vector getAllNotificationIDs() {
        int index = 0;
        RunnableTimer runnableTimer = this.timerThread;
        synchronized (runnableTimer) {
            int size = this.timerNotifications.size();
            Vector<Integer> allNotificationIDs = new Vector<Integer>(size);
            while (index < size) {
                TimerNotification nextNotification = (TimerNotification)this.timerNotifications.get(index);
                Integer notificationIDs = nextNotification.getNotificationID();
                allNotificationIDs.addElement(notificationIDs);
                ++index;
            }
            if (allNotificationIDs.size() == 0) {
                LogUtil.timer.message(1L, this, "getAllNotificationIDs", "JMXtm0004I");
            }
            Vector<Integer> vector = allNotificationIDs;
            return vector;
        }
    }

    public Vector getNotificationIDs(String type) {
        int index = 0;
        RunnableTimer runnableTimer = this.timerThread;
        synchronized (runnableTimer) {
            int size = this.timerNotifications.size();
            Vector<Integer> allNotificationIDs = new Vector<Integer>();
            while (index < size) {
                TimerNotification nextNotification = (TimerNotification)this.timerNotifications.get(index);
                if (nextNotification.isEqual(type)) {
                    Integer notificationIDs = nextNotification.getNotificationID();
                    allNotificationIDs.addElement(notificationIDs);
                }
                ++index;
            }
            if (allNotificationIDs.size() == 0) {
                LogUtil.timer.message(4L, (Object)this, "getNotificationIDs", "JMXtm0005E", type);
            }
            Vector<Integer> vector = allNotificationIDs;
            return vector;
        }
    }
}

