/*
 * Decompiled with CFR 0.152.
 */
package javax.management.timer;

import com.tivoli.jmx.utils.logging.LogUtil;
import java.util.Date;
import javax.management.Notification;

public class TimerNotification
extends Notification {
    private transient boolean isPeriodic = false;
    private transient boolean isSingleShot = false;
    private Integer notificationID;
    private transient Date emissionDate;
    private transient Long period = null;
    private transient Long numberOccurrences = null;

    private void initialize(Date emissionDate, Integer notificationID) {
        this.emissionDate = emissionDate;
        this.setTimeStamp(System.currentTimeMillis());
        this.notificationID = notificationID;
    }

    private void checkParameters() {
        if (this.period == 0L) {
            this.isSingleShot = true;
        } else if (this.numberOccurrences == null || this.numberOccurrences == 0L) {
            this.isPeriodic = true;
        }
    }

    TimerNotification(String type, Object source, long sequenceNumber, String message, Date emissionDate, Integer notificationID) {
        super(type, source, sequenceNumber, message);
        this.initialize(emissionDate, notificationID);
        this.isSingleShot = true;
    }

    TimerNotification(String type, Object source, long sequenceNumber, String message, Date emissionDate, Integer notificationID, long period) {
        super(type, source, sequenceNumber, message);
        this.initialize(emissionDate, notificationID);
        this.period = new Long(period);
        this.checkParameters();
    }

    TimerNotification(String type, Object source, long sequenceNumber, String message, Date emissionDate, Integer notificationID, long period, long numberOccurrences) {
        super(type, source, sequenceNumber, message);
        this.initialize(emissionDate, notificationID);
        this.period = new Long(period);
        this.numberOccurrences = new Long(numberOccurrences);
        this.checkParameters();
    }

    public Integer getNotificationID() {
        if (this.notificationID == null) {
            LogUtil.timer.message(2L, (Object)this, "getNotificationID", "JMXtm0001W", "notificationID");
        }
        return this.notificationID;
    }

    Date getEmissionDate() {
        if (this.emissionDate == null) {
            LogUtil.timer.message(2L, (Object)this, "getEmissionDate", "JMXtm0001W", "emissionDate");
        }
        return this.emissionDate;
    }

    Long getPeriod() {
        if (this.period == null) {
            LogUtil.timer.message(2L, (Object)this, "getPeriod", "JMXtm0001W", "period");
        }
        return this.period;
    }

    Long getNumberOccurrences() {
        if (this.numberOccurrences == null) {
            LogUtil.timer.message(2L, (Object)this, "getNumberOccurrences", "JMXtm0001W", "numberOccurrences");
        }
        return this.numberOccurrences;
    }

    boolean isEqual(Integer notificationID) {
        return this.notificationID == notificationID;
    }

    boolean isEqual(String type) {
        return super.getType() == type;
    }

    boolean isExpired() {
        if (this.emissionDate.getTime() <= System.currentTimeMillis()) {
            return !this.tryToUpdate();
        }
        return false;
    }

    boolean tryToUpdate() {
        if (this.isSingleShot) {
            return false;
        }
        double numInc = Math.ceil(((double)System.currentTimeMillis() - (double)this.emissionDate.getTime()) / (double)this.period.longValue());
        long increment = (long)numInc;
        if (this.isPeriodic) {
            this.emissionDate = new Date(this.emissionDate.getTime() + increment * this.period);
            return true;
        }
        if (this.numberOccurrences - increment > 0L) {
            this.emissionDate = new Date(this.emissionDate.getTime() + increment * this.period);
            this.numberOccurrences = new Long(this.numberOccurrences - increment);
            return true;
        }
        this.emissionDate = new Date(this.emissionDate.getTime() + this.numberOccurrences * this.period);
        this.numberOccurrences = new Long(0L);
        return false;
    }

    boolean isToBeReAdded() {
        if (this.isSingleShot) {
            return false;
        }
        if (this.isPeriodic) {
            return true;
        }
        long number = this.numberOccurrences;
        return number > 1L;
    }

    void update() {
        this.setTimeStamp(this.emissionDate.getTime());
        this.emissionDate = new Date(this.emissionDate.getTime() + this.period);
        if (!this.isPeriodic) {
            long number = this.numberOccurrences;
            this.numberOccurrences = new Long(--number);
        }
    }

    boolean isToBeAdded() {
        if (this.isSingleShot) {
            return false;
        }
        if (this.isPeriodic) {
            return true;
        }
        double numInc = Math.ceil(((double)System.currentTimeMillis() - (double)this.emissionDate.getTime()) / (double)this.period.longValue());
        long increment = (long)numInc;
        return increment < this.numberOccurrences;
    }

    long timesToUpdate() {
        if (this.isSingleShot) {
            return 1L;
        }
        double numInc = Math.ceil(((double)System.currentTimeMillis() - (double)this.emissionDate.getTime()) / (double)this.period.longValue());
        long increment = (long)numInc;
        if (this.isPeriodic) {
            return increment;
        }
        if (increment >= this.numberOccurrences) {
            return this.numberOccurrences;
        }
        return increment;
    }
}

