/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.ReceiverConfig;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.SoapSecuritySender;
import com.ibm.xml.soapsec.dsig.SignatureReceiver;
import com.ibm.xml.soapsec.dsig.SignatureResult;
import com.ibm.xml.soapsec.dsig.SignedPartChecker;
import com.ibm.xml.soapsec.enc.EncryptedPartChecker;
import com.ibm.xml.soapsec.enc.EncryptionReceiver;
import com.ibm.xml.soapsec.proxy.FaultProxy;
import com.ibm.xml.soapsec.proxy.MessageContextProxy;
import com.ibm.xml.soapsec.proxy.MessageFactory;
import com.ibm.xml.soapsec.proxy.MessageProxy;
import com.ibm.xml.soapsec.proxy.SOAPEnvelopeProxy;
import com.ibm.xml.soapsec.proxy.SOAPHeaderElementProxy;
import com.ibm.xml.soapsec.time.TimestampChecker;
import com.ibm.xml.soapsec.time.TimestampReceiver;
import com.ibm.xml.soapsec.token.BinaryTokenReceiver;
import com.ibm.xml.soapsec.token.ReceiverLogin;
import com.ibm.xml.soapsec.token.ReceiverLoginComponent;
import com.ibm.xml.soapsec.token.UsernameTokenReceiver;
import com.ibm.xml.soapsec.token.XMLTokenReceiver;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.SetupJCEProviders;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class SoapSecurityReceiver {
    public static final String CONFIG_KEY;
    private ThreadLocal _messageConfig = new ThreadLocal();
    private Map handlerOption = new HashMap();
    private static final TraceComponent tc;
    private static final String comp = "security.wssecurity";
    private static final String clsName;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$ReceiverConfig;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$dsig$SignatureReceiverConfig;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$TokenReceiverConfig;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$enc$EncryptionReceiverConfig;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$time$TimestampReceiverConfig;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$dsig$SignatureReceiver;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$dsig$SignedPartChecker;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$UsernameTokenReceiver;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$BinaryTokenReceiver;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$XMLTokenReceiver;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$ReceiverLoginComponent;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$time$TimestampReceiver;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$time$TimestampChecker;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$enc$EncryptionReceiver;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$enc$EncryptedPartChecker;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$LoginResult;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$dsig$SignatureResult;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$TokenResult$X509;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$WriteBackResult;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$SoapSecurityReceiver;

    public void setHandlerOption(String string, Object object) {
        this.handlerOption.put(string, object);
    }

    public Object getHandlerOption(String string) {
        return this.handlerOption.get(string);
    }

    private Map getHandlerOptions() {
        return this.handlerOption;
    }

    private final void clear() {
        this._messageConfig.set(null);
    }

    private Map getMessageConfig() {
        HashMap hashMap = (HashMap)this._messageConfig.get();
        if (hashMap == null) {
            hashMap = new HashMap();
            this._messageConfig.set(hashMap);
        }
        return hashMap;
    }

    public void setMessageOption(String string, Object object) {
        this.getMessageConfig().put(string, object);
    }

    public Object getMessageOption(String string) {
        return this.getMessageConfig().get(string);
    }

    public Map getMessageOptions() {
        return this.getMessageConfig();
    }

    public void init() {
    }

    protected void initConfig(MessageContextProxy messageContextProxy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initConfig(" + messageContextProxy + ")");
        }
        SignatureReceiver signatureReceiver = new SignatureReceiver();
        SignedPartChecker signedPartChecker = new SignedPartChecker();
        UsernameTokenReceiver usernameTokenReceiver = new UsernameTokenReceiver();
        BinaryTokenReceiver binaryTokenReceiver = new BinaryTokenReceiver();
        XMLTokenReceiver xMLTokenReceiver = new XMLTokenReceiver();
        ReceiverLoginComponent receiverLoginComponent = this.createLoginComponent();
        TimestampReceiver timestampReceiver = new TimestampReceiver();
        TimestampChecker timestampChecker = new TimestampChecker();
        EncryptionReceiver encryptionReceiver = new EncryptionReceiver();
        EncryptedPartChecker encryptedPartChecker = new EncryptedPartChecker();
        ReceiverConfig receiverConfig = (ReceiverConfig)this.getMessageOption(CONFIG_KEY);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Configuration object is as follows:", new Object[]{receiverConfig});
        }
        try {
            HashMap<Class, Object> hashMap = new HashMap<Class, Object>();
            hashMap.put(class$com$ibm$xml$soapsec$ReceiverConfig == null ? (class$com$ibm$xml$soapsec$ReceiverConfig = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.ReceiverConfig")) : class$com$ibm$xml$soapsec$ReceiverConfig, receiverConfig);
            hashMap.put(class$com$ibm$xml$soapsec$dsig$SignatureReceiverConfig == null ? (class$com$ibm$xml$soapsec$dsig$SignatureReceiverConfig = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.dsig.SignatureReceiverConfig")) : class$com$ibm$xml$soapsec$dsig$SignatureReceiverConfig, receiverConfig.getSignatureConfig());
            hashMap.put(class$com$ibm$xml$soapsec$token$TokenReceiverConfig == null ? (class$com$ibm$xml$soapsec$token$TokenReceiverConfig = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.token.TokenReceiverConfig")) : class$com$ibm$xml$soapsec$token$TokenReceiverConfig, receiverConfig.getTokenConfig());
            hashMap.put(class$com$ibm$xml$soapsec$enc$EncryptionReceiverConfig == null ? (class$com$ibm$xml$soapsec$enc$EncryptionReceiverConfig = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.enc.EncryptionReceiverConfig")) : class$com$ibm$xml$soapsec$enc$EncryptionReceiverConfig, receiverConfig.getDecryptionConfig());
            hashMap.put(class$com$ibm$xml$soapsec$time$TimestampReceiverConfig == null ? (class$com$ibm$xml$soapsec$time$TimestampReceiverConfig = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.time.TimestampReceiverConfig")) : class$com$ibm$xml$soapsec$time$TimestampReceiverConfig, receiverConfig.getTimestampConfig());
            signatureReceiver.init(hashMap);
            signedPartChecker.init(hashMap);
            usernameTokenReceiver.init(hashMap);
            binaryTokenReceiver.init(hashMap);
            xMLTokenReceiver.init(hashMap);
            receiverLoginComponent.init(hashMap);
            timestampReceiver.init(hashMap);
            timestampChecker.init(hashMap);
            encryptionReceiver.init(hashMap);
            encryptedPartChecker.init(hashMap);
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".initConfig", "137", this);
            Tr.error(tc, "security.wssecurity.SoapSecurityReceiver.initConfig", exception);
            throw new RuntimeException(exception.getMessage());
        }
        this.setMessageOption((class$com$ibm$xml$soapsec$dsig$SignatureReceiver == null ? (class$com$ibm$xml$soapsec$dsig$SignatureReceiver = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.dsig.SignatureReceiver")) : class$com$ibm$xml$soapsec$dsig$SignatureReceiver).getName(), signatureReceiver);
        this.setMessageOption((class$com$ibm$xml$soapsec$dsig$SignedPartChecker == null ? (class$com$ibm$xml$soapsec$dsig$SignedPartChecker = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.dsig.SignedPartChecker")) : class$com$ibm$xml$soapsec$dsig$SignedPartChecker).getName(), signedPartChecker);
        this.setMessageOption((class$com$ibm$xml$soapsec$token$UsernameTokenReceiver == null ? (class$com$ibm$xml$soapsec$token$UsernameTokenReceiver = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.token.UsernameTokenReceiver")) : class$com$ibm$xml$soapsec$token$UsernameTokenReceiver).getName(), usernameTokenReceiver);
        this.setMessageOption((class$com$ibm$xml$soapsec$token$BinaryTokenReceiver == null ? (class$com$ibm$xml$soapsec$token$BinaryTokenReceiver = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.token.BinaryTokenReceiver")) : class$com$ibm$xml$soapsec$token$BinaryTokenReceiver).getName(), binaryTokenReceiver);
        this.setMessageOption((class$com$ibm$xml$soapsec$token$XMLTokenReceiver == null ? (class$com$ibm$xml$soapsec$token$XMLTokenReceiver = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.token.XMLTokenReceiver")) : class$com$ibm$xml$soapsec$token$XMLTokenReceiver).getName(), xMLTokenReceiver);
        this.setMessageOption((class$com$ibm$xml$soapsec$token$ReceiverLoginComponent == null ? (class$com$ibm$xml$soapsec$token$ReceiverLoginComponent = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.token.ReceiverLoginComponent")) : class$com$ibm$xml$soapsec$token$ReceiverLoginComponent).getName(), receiverLoginComponent);
        this.setMessageOption((class$com$ibm$xml$soapsec$time$TimestampReceiver == null ? (class$com$ibm$xml$soapsec$time$TimestampReceiver = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.time.TimestampReceiver")) : class$com$ibm$xml$soapsec$time$TimestampReceiver).getName(), timestampReceiver);
        this.setMessageOption((class$com$ibm$xml$soapsec$time$TimestampChecker == null ? (class$com$ibm$xml$soapsec$time$TimestampChecker = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.time.TimestampChecker")) : class$com$ibm$xml$soapsec$time$TimestampChecker).getName(), timestampChecker);
        this.setMessageOption((class$com$ibm$xml$soapsec$enc$EncryptionReceiver == null ? (class$com$ibm$xml$soapsec$enc$EncryptionReceiver = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.enc.EncryptionReceiver")) : class$com$ibm$xml$soapsec$enc$EncryptionReceiver).getName(), encryptionReceiver);
        this.setMessageOption((class$com$ibm$xml$soapsec$enc$EncryptedPartChecker == null ? (class$com$ibm$xml$soapsec$enc$EncryptedPartChecker = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.enc.EncryptedPartChecker")) : class$com$ibm$xml$soapsec$enc$EncryptedPartChecker).getName(), encryptedPartChecker);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initConfig(MessageContext context)");
        }
    }

    protected boolean adjustContext(MessageContextProxy messageContextProxy, Map map) throws FaultProxy {
        return false;
    }

    protected boolean backContext(MessageContextProxy messageContextProxy, Map map) throws FaultProxy {
        return false;
    }

    protected ReceiverLoginComponent createLoginComponent() {
        return new ReceiverLogin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(MessageContextProxy messageContextProxy) throws FaultProxy {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + messageContextProxy + ")");
        }
        this.clear();
        try {
            Object object;
            Document document;
            boolean bl = false;
            MessageProxy messageProxy = messageContextProxy.getCurrentMessage();
            this.initConfig(messageContextProxy);
            ReceiverConfig receiverConfig = (ReceiverConfig)this.getMessageOption(CONFIG_KEY);
            try {
                receiverConfig.validate();
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, clsName + ".invoke", "198", this);
                Tr.error(tc, "security.wssecurity.config.invalid", (Object)soapSecurityException);
                throw FaultProxy.makeFault(soapSecurityException);
            }
            SOAPHeaderElementProxy sOAPHeaderElementProxy = NamespaceUtil.getWsseHeaderByName(messageProxy.getSOAPEnvelope(), "Security", true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invoke wsse:Security found: " + sOAPHeaderElementProxy);
            }
            if (sOAPHeaderElementProxy != null) {
                bl = sOAPHeaderElementProxy.getMustUnderstand();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invoke wsse:Security.mustUnderstand: " + bl);
            }
            if (!(receiverConfig.isSignatureRequired() || receiverConfig.isLoginRequired() || receiverConfig.isDecryptionRequired() || receiverConfig.getTimestampConfig() != null && receiverConfig.getTimestampConfig().addReceivedTimestamp() || bl)) {
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "invoke(MessageContextProxy context)");
                return;
            }
            try {
                document = messageProxy.getDocument();
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, clsName + "invoke", "239", this);
                Tr.error(tc, "security.wssecuritymessage.getDocument", exception);
                throw FaultProxy.makeFault(exception);
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ResultPool.initialize(hashMap);
            this.adjustContext(messageContextProxy, hashMap);
            String string = (String)messageContextProxy.getConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace");
            boolean bl2 = string != null && string.length() != 0;
            try {
                Result[] resultArray;
                Object object2;
                Result[] resultArray2;
                object = SoapSecurityReceiver.getSecurityHeader(document, receiverConfig.getMyActor());
                if (!bl2) {
                    if (object != null) {
                        String string2 = object.getNamespaceURI();
                        if (string2 == null || string2.length() == 0 || !NamespaceUtil.isWsse(string2)) throw new SoapSecurityException("Namespace " + string2 + " is not supported");
                        messageContextProxy.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace", string2);
                        resultArray2 = NamespaceUtil.getCorrespondingWSUNS(string2);
                        if (resultArray2 != null && resultArray2.length() != 0) {
                            messageContextProxy.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", resultArray2);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No wsu namespace found for " + string2);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Incoming namespaces, wsse = " + string2 + ", wsu = " + (String)resultArray2);
                        }
                    } else {
                        Element element;
                        messageContextProxy.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace", Constants.NS_WSSE);
                        Object var12_16 = null;
                        resultArray2 = null;
                        object2 = null;
                        Element element2 = TimestampReceiver.getTimestampHeader(document, true);
                        if (element2 != null) {
                            resultArray2 = element2.getNamespaceURI();
                        }
                        if ((element = TimestampReceiver.getTimestampHeader(document, false)) != null) {
                            object2 = element.getNamespaceURI();
                        }
                        if (!(resultArray2 != null && resultArray2.length() != 0 || object2 != null && ((String)object2).length() != 0)) {
                            messageContextProxy.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", Constants.NS_WSU);
                        } else if (resultArray2 == null || resultArray2.length() == 0) {
                            if (!NamespaceUtil.isWsu((String)object2)) throw new SoapSecurityException("Namespace " + (String)object2 + " is not supported");
                            messageContextProxy.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", object2);
                        } else if (object2 == null || ((String)object2).length() == 0) {
                            if (!NamespaceUtil.isWsu((String)resultArray2)) throw new SoapSecurityException("Namespace " + (String)resultArray2 + " is not supported");
                            messageContextProxy.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", resultArray2);
                        } else {
                            if (resultArray2.compareTo((String)object2) != 0) throw new SoapSecurityException("WS-Security Utility namespace " + (String)resultArray2 + " and " + (String)object2 + " are not matching");
                            if (!NamespaceUtil.isWsu((String)resultArray2)) throw new SoapSecurityException("Namespace " + (String)resultArray2 + " is not supported");
                            messageContextProxy.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", resultArray2);
                        }
                    }
                    if (!NamespaceUtil.validate(messageContextProxy)) {
                        String string3 = (String)messageContextProxy.getConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace");
                        resultArray2 = (String)messageContextProxy.getConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace");
                        throw new SoapSecurityException("WS-Security namespaces (wsse=" + string3 + ", wsu=" + (String)resultArray2 + " are not matching");
                    }
                }
                hashMap.put("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace", messageContextProxy.getConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace"));
                hashMap.put("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", messageContextProxy.getConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace"));
                this.invokeComponent(document, SoapSecuritySender.getHeader(document), hashMap, class$com$ibm$xml$soapsec$time$TimestampReceiver == null ? (class$com$ibm$xml$soapsec$time$TimestampReceiver = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.time.TimestampReceiver")) : class$com$ibm$xml$soapsec$time$TimestampReceiver);
                if (object != null) {
                    void var12_22;
                    Element element = DOMUtil.getFirstChildElement((Node)object);
                    while (var12_22 != null) {
                        resultArray2 = var12_22.getNamespaceURI();
                        object2 = var12_22.getLocalName();
                        if (Constants.NS_DSIG.equals(resultArray2) && ((String)object2).equals("Signature")) {
                            if (receiverConfig.isSignatureReady()) {
                                this.invokeComponent(document, (Element)var12_22, hashMap, class$com$ibm$xml$soapsec$dsig$SignatureReceiver == null ? SoapSecurityReceiver.class$("com.ibm.xml.soapsec.dsig.SignatureReceiver") : class$com$ibm$xml$soapsec$dsig$SignatureReceiver);
                            } else {
                                try {
                                    this.invokeComponent(document, (Element)var12_22, hashMap, class$com$ibm$xml$soapsec$dsig$SignatureReceiver == null ? SoapSecurityReceiver.class$("com.ibm.xml.soapsec.dsig.SignatureReceiver") : class$com$ibm$xml$soapsec$dsig$SignatureReceiver);
                                }
                                catch (Exception exception) {
                                    Tr.processException((Throwable)exception, clsName + ".invoke", "276", this);
                                    Tr.error(tc, "security.wssecurity.invaliddsig.ignore", exception);
                                }
                            }
                        } else if (NamespaceUtil.isWsse((String)resultArray2) && ((String)object2).equals("UsernameToken")) {
                            this.invokeComponent(document, (Element)var12_22, hashMap, class$com$ibm$xml$soapsec$token$UsernameTokenReceiver == null ? SoapSecurityReceiver.class$("com.ibm.xml.soapsec.token.UsernameTokenReceiver") : class$com$ibm$xml$soapsec$token$UsernameTokenReceiver);
                        } else if (NamespaceUtil.isWsse((String)resultArray2) && ((String)object2).equals("BinarySecurityToken")) {
                            this.invokeComponent(document, (Element)var12_22, hashMap, class$com$ibm$xml$soapsec$token$BinaryTokenReceiver == null ? SoapSecurityReceiver.class$("com.ibm.xml.soapsec.token.BinaryTokenReceiver") : class$com$ibm$xml$soapsec$token$BinaryTokenReceiver);
                        } else if (Constants.NS_ENC.equals(resultArray2) && (((String)object2).equals("EncryptedKey") || ((String)object2).equals("ReferenceList"))) {
                            this.invokeComponent(document, (Element)var12_22, hashMap, class$com$ibm$xml$soapsec$enc$EncryptionReceiver == null ? SoapSecurityReceiver.class$("com.ibm.xml.soapsec.enc.EncryptionReceiver") : class$com$ibm$xml$soapsec$enc$EncryptionReceiver);
                        } else {
                            this.invokeComponent(document, (Element)var12_22, hashMap, class$com$ibm$xml$soapsec$token$XMLTokenReceiver == null ? SoapSecurityReceiver.class$("com.ibm.xml.soapsec.token.XMLTokenReceiver") : class$com$ibm$xml$soapsec$token$XMLTokenReceiver);
                        }
                        Element element3 = DOMUtil.getNextElement((Node)var12_22);
                    }
                }
                if (receiverConfig.isSignatureRequired()) {
                    this.invokeComponent(document, null, hashMap, class$com$ibm$xml$soapsec$dsig$SignedPartChecker == null ? (class$com$ibm$xml$soapsec$dsig$SignedPartChecker = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.dsig.SignedPartChecker")) : class$com$ibm$xml$soapsec$dsig$SignedPartChecker);
                }
                if (receiverConfig.isDecryptionRequired()) {
                    this.invokeComponent(document, null, hashMap, class$com$ibm$xml$soapsec$enc$EncryptedPartChecker == null ? (class$com$ibm$xml$soapsec$enc$EncryptedPartChecker = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.enc.EncryptedPartChecker")) : class$com$ibm$xml$soapsec$enc$EncryptedPartChecker);
                }
                if (receiverConfig.isLoginRequired()) {
                    this.invokeComponent(document, null, hashMap, class$com$ibm$xml$soapsec$token$ReceiverLoginComponent == null ? (class$com$ibm$xml$soapsec$token$ReceiverLoginComponent = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.token.ReceiverLoginComponent")) : class$com$ibm$xml$soapsec$token$ReceiverLoginComponent);
                }
                this.invokeComponent(document, null, hashMap, class$com$ibm$xml$soapsec$time$TimestampChecker == null ? (class$com$ibm$xml$soapsec$time$TimestampChecker = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.time.TimestampChecker")) : class$com$ibm$xml$soapsec$time$TimestampChecker);
                Result[] resultArray3 = ResultPool.get(hashMap, class$com$ibm$xml$soapsec$token$LoginResult == null ? (class$com$ibm$xml$soapsec$token$LoginResult = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.token.LoginResult")) : class$com$ibm$xml$soapsec$token$LoginResult);
                resultArray2 = ResultPool.get(hashMap, class$com$ibm$xml$soapsec$dsig$SignatureResult == null ? (class$com$ibm$xml$soapsec$dsig$SignatureResult = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.dsig.SignatureResult")) : class$com$ibm$xml$soapsec$dsig$SignatureResult);
                object2 = receiverConfig.getTokenConfig();
                List list = object2.getAuthMethods();
                Result[] resultArray4 = ResultPool.get(hashMap, class$com$ibm$xml$soapsec$token$TokenResult$X509 == null ? (class$com$ibm$xml$soapsec$token$TokenResult$X509 = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.token.TokenResult$X509")) : class$com$ibm$xml$soapsec$token$TokenResult$X509);
                this.processCertificateResults(resultArray2, resultArray4, messageContextProxy);
                if (resultArray3.length != 0) {
                    this.processLoginResults(resultArray3, messageContextProxy);
                }
                if ((resultArray = ResultPool.get(hashMap, class$com$ibm$xml$soapsec$dsig$SignatureResult == null ? (class$com$ibm$xml$soapsec$dsig$SignatureResult = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.dsig.SignatureResult")) : class$com$ibm$xml$soapsec$dsig$SignatureResult)).length != 0) {
                    messageContextProxy.setConfig("com.ibm.xml.soapsec.RequestCert", ((SignatureResult)resultArray[0]).getCertificate());
                }
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, clsName + ".invoke", "321", this);
                Tr.error(tc, "security.wssecurity.invoke.exception", exception);
                throw FaultProxy.makeFault(exception);
            }
            if (ResultPool.get(hashMap, class$com$ibm$xml$soapsec$WriteBackResult == null ? (class$com$ibm$xml$soapsec$WriteBackResult = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.WriteBackResult")) : class$com$ibm$xml$soapsec$WriteBackResult).length > 0) {
                try {
                    object = MessageFactory.getInstance().create(document, messageProxy);
                    messageContextProxy.setCurrentMessage((MessageProxy)object);
                }
                catch (Exception exception) {
                    throw FaultProxy.makeFault(exception);
                }
            }
            this.backContext(messageContextProxy, hashMap);
            object = messageContextProxy.getCurrentMessage().getSOAPEnvelope();
            sOAPHeaderElementProxy = NamespaceUtil.getWsseHeaderByName((SOAPEnvelopeProxy)object, "Security", false);
            if (sOAPHeaderElementProxy != null) {
                sOAPHeaderElementProxy.setProcessed(true);
            }
            if ((sOAPHeaderElementProxy = NamespaceUtil.getWsuHeaderByName((SOAPEnvelopeProxy)object, "Timestamp", true)) != null) {
                sOAPHeaderElementProxy.setProcessed(true);
            }
            ResultPool.finalize(hashMap);
        }
        finally {
            this.clear();
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "invoke(MessageContextProxy context)");
    }

    public void onFault(MessageContextProxy messageContextProxy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onFault(" + messageContextProxy + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onFault(MessageContextProxy context)");
        }
    }

    protected void processLoginResults(Result[] resultArray, MessageContextProxy messageContextProxy) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processLoginResults(" + resultArray + "," + messageContextProxy + ")");
            Tr.exit(tc, "processLoginResults(Result[] results, MessageContext context)");
        }
    }

    protected void processCertificateResults(Result[] resultArray, Result[] resultArray2, MessageContextProxy messageContextProxy) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processCertificateResults(" + resultArray + "," + resultArray2 + "," + messageContextProxy + ")");
            Tr.exit(tc, "processCertificateResults(Result[] resultSign, Result [] resultToken, MessageContext context)");
        }
    }

    private void invokeComponent(Document document, Element element, Map map, Class clazz) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeComponent(" + document + "," + element + "," + map + "," + clazz + ")");
        }
        SoapSecurityComponent soapSecurityComponent = this.getComponent(clazz);
        soapSecurityComponent.invoke(document, element, map);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeComponent(Document doc, Element target, Map context, Class cl)");
        }
    }

    private SoapSecurityComponent getComponent(Class clazz) {
        return (SoapSecurityComponent)this.getMessageOption(clazz.getName());
    }

    private static Element getSecurityHeader(Document document, String string) {
        Element element;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityHeader(" + document + "," + string + ")");
        }
        if ((element = DOMUtil.getFirstChildElement(document.getDocumentElement(), "http://schemas.xmlsoap.org/soap/envelope/", "Header")) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSecurityHeader(Document doc, String actor) returns null");
            }
            return null;
        }
        Element element2 = DOMUtil.getFirstChildElement(element);
        while (element2 != null) {
            if (NamespaceUtil.isWsse(element2.getNamespaceURI()) && "Security".equals(element2.getLocalName())) {
                String string2 = null;
                if (element2.getAttributeNodeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor") != null) {
                    string2 = element2.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor");
                }
                if (string == null && string2 == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSecurityHeader(Document doc, String  actor) returns " + element2);
                    }
                    return element2;
                }
                if (string != null && string2 != null && string.equals(string2)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSecurityHeader(Document doc, String actor) returns " + element2);
                    }
                    return element2;
                }
            }
            element2 = DOMUtil.getNextElement(element2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityHeader(Document doc, String actor) returns null");
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (System.getProperty("setup-jce") != null) {
            SetupJCEProviders.setup();
        }
        CONFIG_KEY = (class$com$ibm$xml$soapsec$ReceiverConfig == null ? (class$com$ibm$xml$soapsec$ReceiverConfig = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.ReceiverConfig")) : class$com$ibm$xml$soapsec$ReceiverConfig).getName();
        tc = Tr.register(class$com$ibm$xml$soapsec$SoapSecurityReceiver == null ? (class$com$ibm$xml$soapsec$SoapSecurityReceiver = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.SoapSecurityReceiver")) : class$com$ibm$xml$soapsec$SoapSecurityReceiver, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
        clsName = (class$com$ibm$xml$soapsec$SoapSecurityReceiver == null ? (class$com$ibm$xml$soapsec$SoapSecurityReceiver = SoapSecurityReceiver.class$("com.ibm.xml.soapsec.SoapSecurityReceiver")) : class$com$ibm$xml$soapsec$SoapSecurityReceiver).getName();
    }
}

