/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.SenderConfig;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.dsig.SignatureSender;
import com.ibm.xml.soapsec.enc.EncryptionSender;
import com.ibm.xml.soapsec.proxy.FaultProxy;
import com.ibm.xml.soapsec.proxy.MessageContextProxy;
import com.ibm.xml.soapsec.proxy.MessageFactory;
import com.ibm.xml.soapsec.proxy.MessageProxy;
import com.ibm.xml.soapsec.time.TimestampSender;
import com.ibm.xml.soapsec.token.BinaryTokenSender;
import com.ibm.xml.soapsec.token.SenderLogin;
import com.ibm.xml.soapsec.token.SenderLoginComponent;
import com.ibm.xml.soapsec.token.UsernameTokenSender;
import com.ibm.xml.soapsec.token.XMLTokenSender;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.SetupJCEProviders;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SoapSecuritySender {
    public static final String CONFIG_KEY;
    private ThreadLocal _messageConfig = new ThreadLocal();
    private Map handlerOption = new HashMap();
    protected static final String MESSAGE_CONTEXT = "com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.messageContext";
    private static final TraceComponent tc;
    private static final String comp = "security.wssecurity";
    private static final String clsName;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$SenderConfig;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$dsig$SignatureSenderConfig;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$TokenSenderConfig;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$enc$EncryptionSenderConfig;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$time$TimestampSenderConfig;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$dsig$SignatureSender;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$SenderLoginComponent;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$UsernameTokenSender;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$BinaryTokenSender;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$XMLTokenSender;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$time$TimestampSender;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$enc$EncryptionSender;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$TokenRequest$Username;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$TokenRequest$Binary;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$TokenRequest$XML;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$dsig$SignatureRequest;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$enc$EncryptionRequest;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$SoapSecuritySender;

    public void setHandlerOption(String string, Object object) {
        this.handlerOption.put(string, object);
    }

    public Object getHandlerOption(String string) {
        return this.handlerOption.get(string);
    }

    private final void clear() {
        this._messageConfig.set(null);
    }

    private Map getMessageConfig() {
        HashMap hashMap = (HashMap)this._messageConfig.get();
        if (hashMap == null) {
            hashMap = new HashMap();
            this._messageConfig.set(hashMap);
        }
        return hashMap;
    }

    public void setMessageOption(String string, Object object) {
        this.getMessageConfig().put(string, object);
    }

    public Object getMessageOption(String string) {
        return this.getMessageConfig().get(string);
    }

    public Map getMessageOptions() {
        return this.getMessageConfig();
    }

    public void init() {
    }

    protected void initConfig(MessageContextProxy messageContextProxy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initConfig(" + messageContextProxy + ")");
        }
        SignatureSender signatureSender = new SignatureSender();
        SenderLoginComponent senderLoginComponent = this.createLoginComponent(messageContextProxy);
        UsernameTokenSender usernameTokenSender = new UsernameTokenSender();
        BinaryTokenSender binaryTokenSender = new BinaryTokenSender();
        XMLTokenSender xMLTokenSender = new XMLTokenSender();
        TimestampSender timestampSender = new TimestampSender();
        EncryptionSender encryptionSender = new EncryptionSender();
        SenderConfig senderConfig = (SenderConfig)this.getMessageOption(CONFIG_KEY);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Configuration object is as follows:", new Object[]{senderConfig});
        }
        try {
            HashMap<Class, Object> hashMap = new HashMap<Class, Object>();
            hashMap.put(class$com$ibm$xml$soapsec$SenderConfig == null ? (class$com$ibm$xml$soapsec$SenderConfig = SoapSecuritySender.class$("com.ibm.xml.soapsec.SenderConfig")) : class$com$ibm$xml$soapsec$SenderConfig, senderConfig);
            hashMap.put(class$com$ibm$xml$soapsec$dsig$SignatureSenderConfig == null ? (class$com$ibm$xml$soapsec$dsig$SignatureSenderConfig = SoapSecuritySender.class$("com.ibm.xml.soapsec.dsig.SignatureSenderConfig")) : class$com$ibm$xml$soapsec$dsig$SignatureSenderConfig, senderConfig.getSignatureConfig());
            hashMap.put(class$com$ibm$xml$soapsec$token$TokenSenderConfig == null ? (class$com$ibm$xml$soapsec$token$TokenSenderConfig = SoapSecuritySender.class$("com.ibm.xml.soapsec.token.TokenSenderConfig")) : class$com$ibm$xml$soapsec$token$TokenSenderConfig, senderConfig.getTokenConfig());
            hashMap.put(class$com$ibm$xml$soapsec$enc$EncryptionSenderConfig == null ? (class$com$ibm$xml$soapsec$enc$EncryptionSenderConfig = SoapSecuritySender.class$("com.ibm.xml.soapsec.enc.EncryptionSenderConfig")) : class$com$ibm$xml$soapsec$enc$EncryptionSenderConfig, senderConfig.getEncryptionConfig());
            hashMap.put(class$com$ibm$xml$soapsec$time$TimestampSenderConfig == null ? (class$com$ibm$xml$soapsec$time$TimestampSenderConfig = SoapSecuritySender.class$("com.ibm.xml.soapsec.time.TimestampSenderConfig")) : class$com$ibm$xml$soapsec$time$TimestampSenderConfig, senderConfig.getTimestampConfig());
            signatureSender.init(hashMap);
            senderLoginComponent.init(hashMap);
            usernameTokenSender.init(hashMap);
            binaryTokenSender.init(hashMap);
            xMLTokenSender.init(hashMap);
            timestampSender.init(hashMap);
            encryptionSender.init(hashMap);
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".initConfig", "118", this);
            Tr.error(tc, "security.wssecurity.SoapSecuritySender.initConfig", exception);
            throw new RuntimeException(exception.getMessage());
        }
        this.setMessageOption((class$com$ibm$xml$soapsec$dsig$SignatureSender == null ? (class$com$ibm$xml$soapsec$dsig$SignatureSender = SoapSecuritySender.class$("com.ibm.xml.soapsec.dsig.SignatureSender")) : class$com$ibm$xml$soapsec$dsig$SignatureSender).getName(), signatureSender);
        this.setMessageOption((class$com$ibm$xml$soapsec$token$SenderLoginComponent == null ? (class$com$ibm$xml$soapsec$token$SenderLoginComponent = SoapSecuritySender.class$("com.ibm.xml.soapsec.token.SenderLoginComponent")) : class$com$ibm$xml$soapsec$token$SenderLoginComponent).getName(), senderLoginComponent);
        this.setMessageOption((class$com$ibm$xml$soapsec$token$UsernameTokenSender == null ? (class$com$ibm$xml$soapsec$token$UsernameTokenSender = SoapSecuritySender.class$("com.ibm.xml.soapsec.token.UsernameTokenSender")) : class$com$ibm$xml$soapsec$token$UsernameTokenSender).getName(), usernameTokenSender);
        this.setMessageOption((class$com$ibm$xml$soapsec$token$BinaryTokenSender == null ? (class$com$ibm$xml$soapsec$token$BinaryTokenSender = SoapSecuritySender.class$("com.ibm.xml.soapsec.token.BinaryTokenSender")) : class$com$ibm$xml$soapsec$token$BinaryTokenSender).getName(), binaryTokenSender);
        this.setMessageOption((class$com$ibm$xml$soapsec$token$XMLTokenSender == null ? (class$com$ibm$xml$soapsec$token$XMLTokenSender = SoapSecuritySender.class$("com.ibm.xml.soapsec.token.XMLTokenSender")) : class$com$ibm$xml$soapsec$token$XMLTokenSender).getName(), xMLTokenSender);
        this.setMessageOption((class$com$ibm$xml$soapsec$time$TimestampSender == null ? (class$com$ibm$xml$soapsec$time$TimestampSender = SoapSecuritySender.class$("com.ibm.xml.soapsec.time.TimestampSender")) : class$com$ibm$xml$soapsec$time$TimestampSender).getName(), timestampSender);
        this.setMessageOption((class$com$ibm$xml$soapsec$enc$EncryptionSender == null ? (class$com$ibm$xml$soapsec$enc$EncryptionSender = SoapSecuritySender.class$("com.ibm.xml.soapsec.enc.EncryptionSender")) : class$com$ibm$xml$soapsec$enc$EncryptionSender).getName(), encryptionSender);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initConfig(MessageContextProxy context)");
        }
    }

    protected SenderLoginComponent createLoginComponent(MessageContextProxy messageContextProxy) {
        return new SenderLogin();
    }

    protected boolean adjustContext(MessageContextProxy messageContextProxy, Map map) throws FaultProxy {
        return false;
    }

    protected boolean backContext(MessageContextProxy messageContextProxy, Map map) throws FaultProxy {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContextProxy messageContextProxy) throws FaultProxy {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + messageContextProxy + ")");
        }
        this.clear();
        try {
            Document document;
            MessageProxy messageProxy;
            boolean bl;
            this.initConfig(messageContextProxy);
            SenderConfig senderConfig = (SenderConfig)this.getMessageOption(CONFIG_KEY);
            try {
                senderConfig.validate();
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, clsName + ".invoke", "173", this);
                Tr.error(tc, "security.wssecurity.config.invalid", (Object)soapSecurityException);
                throw FaultProxy.makeFault(soapSecurityException);
            }
            boolean bl2 = senderConfig.isTimestampEnabled();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            RequestPool.initialize(hashMap);
            boolean bl3 = this.adjustContext(messageContextProxy, hashMap);
            boolean bl4 = bl = senderConfig.isTokenEnabled() || senderConfig.isSignatureEnabled() || senderConfig.isEncryptionEnabled() || bl3;
            if (!bl2 && !bl) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "_invoke(MessageContext context)");
                }
                return;
            }
            try {
                messageProxy = messageContextProxy.getCurrentMessage();
                document = messageProxy.getDocument();
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, clsName + ".invoke", "197", this);
                Tr.error(tc, "security.wssecurity.message.getDocument", exception);
                throw FaultProxy.makeFault(exception);
            }
            try {
                this.setMessageOption("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress", messageContextProxy.getTargetEndpointAddress());
                this.setMessageOption(MESSAGE_CONTEXT, messageContextProxy);
                hashMap.put("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace", Constants.getWSSENS(messageContextProxy));
                hashMap.put("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", Constants.getWSUNS(messageContextProxy));
                if (bl2) {
                    Element element = SoapSecuritySender.getHeader(document);
                    this.invokeComponent(document, element, hashMap, class$com$ibm$xml$soapsec$time$TimestampSender == null ? (class$com$ibm$xml$soapsec$time$TimestampSender = SoapSecuritySender.class$("com.ibm.xml.soapsec.time.TimestampSender")) : class$com$ibm$xml$soapsec$time$TimestampSender);
                }
                if (bl) {
                    Element element = SoapSecuritySender.addSecurityHeader(document, Constants.getWSSENS(hashMap), senderConfig.getTargetActor(), "1");
                    if (senderConfig.isTokenEnabled()) {
                        this.invokeComponent(document, element, hashMap, class$com$ibm$xml$soapsec$token$SenderLoginComponent == null ? (class$com$ibm$xml$soapsec$token$SenderLoginComponent = SoapSecuritySender.class$("com.ibm.xml.soapsec.token.SenderLoginComponent")) : class$com$ibm$xml$soapsec$token$SenderLoginComponent);
                    }
                    int n = RequestPool.get(hashMap, class$com$ibm$xml$soapsec$token$TokenRequest$Username == null ? (class$com$ibm$xml$soapsec$token$TokenRequest$Username = SoapSecuritySender.class$("com.ibm.xml.soapsec.token.TokenRequest$Username")) : class$com$ibm$xml$soapsec$token$TokenRequest$Username).length;
                    if (senderConfig.isTokenEnabled() && n > 0) {
                        this.invokeComponent(document, element, hashMap, class$com$ibm$xml$soapsec$token$UsernameTokenSender == null ? (class$com$ibm$xml$soapsec$token$UsernameTokenSender = SoapSecuritySender.class$("com.ibm.xml.soapsec.token.UsernameTokenSender")) : class$com$ibm$xml$soapsec$token$UsernameTokenSender);
                    }
                    if (RequestPool.get(hashMap, class$com$ibm$xml$soapsec$token$TokenRequest$Binary == null ? (class$com$ibm$xml$soapsec$token$TokenRequest$Binary = SoapSecuritySender.class$("com.ibm.xml.soapsec.token.TokenRequest$Binary")) : class$com$ibm$xml$soapsec$token$TokenRequest$Binary).length > 0) {
                        this.invokeComponent(document, element, hashMap, class$com$ibm$xml$soapsec$token$BinaryTokenSender == null ? (class$com$ibm$xml$soapsec$token$BinaryTokenSender = SoapSecuritySender.class$("com.ibm.xml.soapsec.token.BinaryTokenSender")) : class$com$ibm$xml$soapsec$token$BinaryTokenSender);
                    }
                    if (RequestPool.get(hashMap, class$com$ibm$xml$soapsec$token$TokenRequest$XML == null ? (class$com$ibm$xml$soapsec$token$TokenRequest$XML = SoapSecuritySender.class$("com.ibm.xml.soapsec.token.TokenRequest$XML")) : class$com$ibm$xml$soapsec$token$TokenRequest$XML).length > 0) {
                        this.invokeComponent(document, element, hashMap, class$com$ibm$xml$soapsec$token$XMLTokenSender == null ? (class$com$ibm$xml$soapsec$token$XMLTokenSender = SoapSecuritySender.class$("com.ibm.xml.soapsec.token.XMLTokenSender")) : class$com$ibm$xml$soapsec$token$XMLTokenSender);
                    }
                    n = RequestPool.get(hashMap, class$com$ibm$xml$soapsec$dsig$SignatureRequest == null ? (class$com$ibm$xml$soapsec$dsig$SignatureRequest = SoapSecuritySender.class$("com.ibm.xml.soapsec.dsig.SignatureRequest")) : class$com$ibm$xml$soapsec$dsig$SignatureRequest).length;
                    if (senderConfig.isSignatureEnabled() || n > 0) {
                        this.invokeComponent(document, element, hashMap, class$com$ibm$xml$soapsec$dsig$SignatureSender == null ? (class$com$ibm$xml$soapsec$dsig$SignatureSender = SoapSecuritySender.class$("com.ibm.xml.soapsec.dsig.SignatureSender")) : class$com$ibm$xml$soapsec$dsig$SignatureSender);
                    }
                    if (RequestPool.get(hashMap, class$com$ibm$xml$soapsec$token$TokenRequest$Binary == null ? (class$com$ibm$xml$soapsec$token$TokenRequest$Binary = SoapSecuritySender.class$("com.ibm.xml.soapsec.token.TokenRequest$Binary")) : class$com$ibm$xml$soapsec$token$TokenRequest$Binary).length > 0) {
                        this.invokeComponent(document, element, hashMap, class$com$ibm$xml$soapsec$token$BinaryTokenSender == null ? (class$com$ibm$xml$soapsec$token$BinaryTokenSender = SoapSecuritySender.class$("com.ibm.xml.soapsec.token.BinaryTokenSender")) : class$com$ibm$xml$soapsec$token$BinaryTokenSender);
                    }
                    n = RequestPool.get(hashMap, class$com$ibm$xml$soapsec$enc$EncryptionRequest == null ? (class$com$ibm$xml$soapsec$enc$EncryptionRequest = SoapSecuritySender.class$("com.ibm.xml.soapsec.enc.EncryptionRequest")) : class$com$ibm$xml$soapsec$enc$EncryptionRequest).length;
                    if (senderConfig.isEncryptionEnabled() || n > 0) {
                        hashMap.put("com.ibm.xml.soapsec.RequestCert", messageContextProxy.getConfig("com.ibm.xml.soapsec.RequestCert"));
                        this.invokeComponent(document, element, hashMap, class$com$ibm$xml$soapsec$enc$EncryptionSender == null ? (class$com$ibm$xml$soapsec$enc$EncryptionSender = SoapSecuritySender.class$("com.ibm.xml.soapsec.enc.EncryptionSender")) : class$com$ibm$xml$soapsec$enc$EncryptionSender);
                    }
                    if (!senderConfig.doIndentation()) {
                        DOMUtil.removeIndentation(element);
                    }
                }
                MessageProxy messageProxy2 = MessageFactory.getInstance().create(document, messageProxy);
                messageContextProxy.setCurrentMessage(messageProxy2);
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, clsName + ".invoke", "264", this);
                Tr.error(tc, "security.wssecurity.invoke.exception", exception);
                FaultProxy faultProxy = FaultProxy.makeFault(exception);
                if (messageContextProxy.getPastPivot()) {
                    messageContextProxy.setCurrentMessage(new MessageProxy(faultProxy));
                }
                throw faultProxy;
            }
            this.backContext(messageContextProxy, hashMap);
            RequestPool.finalize(hashMap);
        }
        finally {
            this.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(MessageContextProxy context)");
        }
    }

    private void invokeComponent(Document document, Element element, Map map, Class clazz) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeComponent(" + document + "," + map + "," + clazz + ")");
        }
        SoapSecurityComponent soapSecurityComponent = this.getComponent(clazz);
        soapSecurityComponent.invoke(document, element, map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeComponent(Document doc, Element security, Map context, Class cl)");
        }
    }

    public void onFault(MessageContextProxy messageContextProxy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onFault(" + messageContextProxy + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onFault(MessageContextProxy context)");
        }
    }

    private SoapSecurityComponent getComponent(Class clazz) {
        return (SoapSecurityComponent)this.getMessageOption(clazz.getName());
    }

    private static Element searchForSecurityHeader(Element element, String string, String string2) {
        Element element2 = DOMUtil.getFirstChildElement(element);
        while (element2 != null) {
            String string3 = element2.getNamespaceURI();
            String string4 = element2.getLocalName();
            if (NamespaceUtil.isWsse(string3) && "Security".equals(string4) && !(string != null && string.length() != 0 ? !string.equals(element2.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor")) : element2.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor").length() != 0)) {
                String string5;
                if (string2 != null && !string2.equals(string5 = element2.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand"))) {
                    Tr.error(tc, "security.wssecurity.SoapSecurityReceiver.sss03", new Object[]{string5, string2});
                }
                return element2;
            }
            element2 = DOMUtil.getNextElement(element2);
        }
        return null;
    }

    public static Element getHeader(Document document) {
        Element element = document.getDocumentElement();
        Element element2 = DOMUtil.getFirstChildElement(element, "http://schemas.xmlsoap.org/soap/envelope/", "Header");
        if (element2 == null) {
            String string = element.getPrefix();
            if (string == null) {
                string = "";
            } else if (string.length() > 0) {
                string = string + ":";
            }
            element2 = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", string + "Header");
            element.insertBefore(element2, element.getFirstChild());
        }
        return element2;
    }

    private static Element addSecurityHeader(Document document, String string, String string2, String string3) {
        String string4;
        Element element;
        Element element2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSecurityHeader(" + document + "," + string2 + "," + string3 + ")");
        }
        if ((element2 = SoapSecuritySender.searchForSecurityHeader(element = SoapSecuritySender.getHeader(document), string2, string3)) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addSecurityHeader Uses existing wsse:Security element");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addSecurityHeader(Document factory, String actor, String must)");
            }
            return element2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addSecurityHeader Creates new wsse:Security element");
        }
        element2 = document.createElementNS(string, "wsse:Security");
        element2.setAttributeNS(Constants.NS_XMLNS, "xmlns:wsse", string);
        if (string2 != null) {
            string4 = element.getPrefix();
            if (string4 == null || string4.length() <= 0) {
                element2.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "env:actor", string2);
                element2.setAttributeNS(Constants.NS_XMLNS, "xmlns:env", "http://schemas.xmlsoap.org/soap/envelope/");
            } else {
                element2.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", string4 + ":actor", string2);
            }
        }
        if (string3 != null) {
            string4 = element.getPrefix();
            if (string4 == null || string4.length() <= 0) {
                element2.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "env:mustUnderstand", string3);
                element2.setAttributeNS(Constants.NS_XMLNS, "xmlns:env", "http://schemas.xmlsoap.org/soap/envelope/");
            } else {
                element2.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", string4 + ":mustUnderstand", string3);
            }
        }
        element.insertBefore(element2, element.getFirstChild());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSecurityHeader(Document factory, String actor, String must)");
        }
        return element2;
    }

    public static void prependSecurityElement(Element element, Element element2) {
        element.insertBefore(element2, element.getFirstChild());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (System.getProperty("setup-jce") != null) {
            SetupJCEProviders.setup();
        }
        CONFIG_KEY = (class$com$ibm$xml$soapsec$SenderConfig == null ? (class$com$ibm$xml$soapsec$SenderConfig = SoapSecuritySender.class$("com.ibm.xml.soapsec.SenderConfig")) : class$com$ibm$xml$soapsec$SenderConfig).getName();
        tc = Tr.register(class$com$ibm$xml$soapsec$SoapSecuritySender == null ? (class$com$ibm$xml$soapsec$SoapSecuritySender = SoapSecuritySender.class$("com.ibm.xml.soapsec.SoapSecuritySender")) : class$com$ibm$xml$soapsec$SoapSecuritySender, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
        clsName = (class$com$ibm$xml$soapsec$SoapSecuritySender == null ? (class$com$ibm$xml$soapsec$SoapSecuritySender = SoapSecuritySender.class$("com.ibm.xml.soapsec.SoapSecuritySender")) : class$com$ibm$xml$soapsec$SoapSecuritySender).getName();
    }
}

