/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.confimpl;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.xml.soapsec.SenderConfig;
import com.ibm.xml.soapsec.dsig.SignatureSenderConfig;
import com.ibm.xml.soapsec.dsig.TemplateModifier;
import com.ibm.xml.soapsec.enc.EncryptionSenderConfig;
import com.ibm.xml.soapsec.enc.EncryptionSettings;
import com.ibm.xml.soapsec.time.TimestampSenderConfig;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.token.TokenSenderConfig;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Duration;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class PrivateSenderConfig
implements SenderConfig {
    private static final TraceComponent tc = Tr.register(class$com$ibm$xml$soapsec$confimpl$PrivateSenderConfig == null ? (class$com$ibm$xml$soapsec$confimpl$PrivateSenderConfig = PrivateSenderConfig.class$("com.ibm.xml.soapsec.confimpl.PrivateSenderConfig")) : class$com$ibm$xml$soapsec$confimpl$PrivateSenderConfig, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    protected String myactor = null;
    protected String targetactor = null;
    protected final Set integralParts = new HashSet();
    protected String keyName = null;
    protected KeyLocator keyLocator = null;
    protected String c14nMethod;
    protected String signatureMethod;
    protected String digestMethod;
    protected final List templateModifiers = new LinkedList();
    protected boolean isSecTokenSigned = false;
    protected boolean prec14n = false;
    protected boolean indentation = true;
    protected String dumpPath = null;
    protected final SignatureSenderConfig signatureSenderConfig = new SignatureSenderConfig(){

        public Set getIntegralParts() {
            return PrivateSenderConfig.this.integralParts;
        }

        public String getKeyName() {
            return PrivateSenderConfig.this.keyName;
        }

        public KeyLocator getKeyLocator() {
            return PrivateSenderConfig.this.keyLocator;
        }

        public boolean getPreC14n() {
            return PrivateSenderConfig.this.prec14n;
        }

        public void setPreC14n(boolean bl) {
            PrivateSenderConfig.this.prec14n = bl;
        }

        public String getDumpPath() {
            return PrivateSenderConfig.this.dumpPath;
        }

        public void setDumpPath(String string) {
            PrivateSenderConfig.this.dumpPath = string;
        }

        public String getCanonicalizationMethod() {
            return PrivateSenderConfig.this.c14nMethod;
        }

        public String getSignatureMethod() {
            return PrivateSenderConfig.this.signatureMethod;
        }

        public String getDigestMethod() {
            return PrivateSenderConfig.this.digestMethod;
        }

        public List getTemplateModifiers() {
            return PrivateSenderConfig.this.templateModifiers;
        }

        public String toString() {
            return "SignatureSenderConfig(integralParts=" + PrivateSenderConfig.this.integralParts + " keyName=" + PrivateSenderConfig.this.keyName + " keyLocator=" + PrivateSenderConfig.this.keyLocator + " c14n=" + PrivateSenderConfig.this.c14nMethod + " signature=" + PrivateSenderConfig.this.signatureMethod + " digest=" + PrivateSenderConfig.this.digestMethod + " templateModifiers=" + PrivateSenderConfig.this.templateModifiers + ")";
        }
    };
    protected String authMethod = null;
    protected String idType = null;
    protected String trustMode = null;
    protected QName tokenValueType = null;
    protected CallbackHandler callbackHandler = null;
    protected boolean addNonce = false;
    protected boolean addNonceTimestamp = false;
    protected QName nonceEncodingType = null;
    protected NonceManager nonceManager = null;
    protected final TokenSenderConfig tokenSenderConfig = new TokenSenderConfig(){

        public String getAuthMethod() {
            return PrivateSenderConfig.this.authMethod;
        }

        public String getIdType() {
            return PrivateSenderConfig.this.idType;
        }

        public String getTrustMode() {
            return PrivateSenderConfig.this.trustMode;
        }

        public QName getTokenValueType() {
            return PrivateSenderConfig.this.tokenValueType;
        }

        public CallbackHandler getCallbackHandler() {
            return PrivateSenderConfig.this.callbackHandler;
        }

        public boolean isIntegral() {
            return PrivateSenderConfig.this.isSecTokenSigned;
        }

        public boolean isConfidential() {
            return PrivateSenderConfig.this.isUsernameTokenEncrypted;
        }

        public EncryptionSettings getEncryptionSettings() {
            return PrivateSenderConfig.this.encryptionSettings;
        }

        public boolean isNonceAdded() {
            return PrivateSenderConfig.this.addNonce;
        }

        public QName getEncodingType() {
            return PrivateSenderConfig.this.nonceEncodingType;
        }

        public NonceManager getNonceManager() {
            return PrivateSenderConfig.this.nonceManager;
        }

        public boolean isNonceTimestampAdded() {
            return PrivateSenderConfig.this.addNonceTimestamp;
        }

        public String toString() {
            return "TokenSenderConfig(authMethod=" + PrivateSenderConfig.this.authMethod + " idType=" + PrivateSenderConfig.this.idType + " trustMode=" + PrivateSenderConfig.this.trustMode + " tokenValueType=" + PrivateSenderConfig.this.tokenValueType + " callbackHandler=" + PrivateSenderConfig.this.callbackHandler + " isConfidential=" + this.isConfidential() + " encryptionSettings=" + PrivateSenderConfig.this.encryptionSettings + " isNonceAdded=" + PrivateSenderConfig.this.addNonce + " nonceEncodingType=" + PrivateSenderConfig.this.nonceEncodingType + " nonceManager=" + PrivateSenderConfig.this.nonceManager + " isNonceTimestampAdded=" + PrivateSenderConfig.this.addNonceTimestamp + ")";
        }
    };
    protected final Set confidentialParts = new HashSet();
    protected EncryptionSettings encryptionSettings = null;
    protected boolean isUsernameTokenEncrypted = false;
    protected EncryptionSenderConfig encryptionSenderConfig = new EncryptionSenderConfig(){

        public Set getConfidentialParts() {
            return PrivateSenderConfig.this.confidentialParts;
        }

        public EncryptionSettings getEncryptionSettings() {
            return PrivateSenderConfig.this.encryptionSettings;
        }

        public String toString() {
            return "EncryptionSenderConfig(confidentialParts=" + PrivateSenderConfig.this.confidentialParts + " encryptionSettings=" + PrivateSenderConfig.this.encryptionSettings + ")";
        }
    };
    protected boolean enableCreatedTimestamp;
    protected Duration duration;
    protected TimestampSenderConfig timestampSenderConfig = new TimestampSenderConfig(){

        public String getMyActor() {
            return PrivateSenderConfig.this.myactor;
        }

        public boolean addCreatedTimestamp() {
            return PrivateSenderConfig.this.enableCreatedTimestamp;
        }

        public boolean signTimestamp() {
            return PrivateSenderConfig.this.integralParts.contains("timestamp");
        }

        public Duration getDuration() {
            return PrivateSenderConfig.this.duration;
        }

        public String toString() {
            return "TimestampSenderConfig(addCreatedTimestamp=" + this.addCreatedTimestamp() + " signTimestamp=" + this.signTimestamp() + " duration=" + PrivateSenderConfig.this.duration + ")";
        }
    };
    static /* synthetic */ Class class$com$ibm$xml$soapsec$confimpl$PrivateSenderConfig;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$dsig$TemplateModifier;

    protected void processPrivateConfig(Document document) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processPrivateConfig(" + document + ")");
        }
        NodeList nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "TemplateModifier");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            String string = DOMUtil.getAttribute(element, "class");
            Map map = ConfigUtil.getProperties(element);
            TemplateModifier templateModifier = (TemplateModifier)ConfigUtil.instantiate(string, class$com$ibm$xml$soapsec$dsig$TemplateModifier == null ? PrivateSenderConfig.class$("com.ibm.xml.soapsec.dsig.TemplateModifier") : class$com$ibm$xml$soapsec$dsig$TemplateModifier, map);
            this.templateModifiers.add(templateModifier);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processPrivateConfig(Document privateConfig)");
        }
    }

    public String getTargetActor() {
        return this.targetactor;
    }

    public String getMyActor() {
        return this.myactor;
    }

    public boolean doIndentation() {
        return this.indentation;
    }

    public void setIndentation(boolean bl) {
        this.indentation = bl;
    }

    public boolean isSignatureEnabled() {
        return this.integralParts.size() > 0;
    }

    public boolean isTokenEnabled() {
        return this.authMethod != null;
    }

    public boolean isEncryptionEnabled() {
        return this.confidentialParts.size() > 0;
    }

    public boolean isTimestampEnabled() {
        return this.enableCreatedTimestamp || this.integralParts.contains("timestamp");
    }

    public void validate() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate()");
        }
        Iterator iterator = this.integralParts.iterator();
        Object object = null;
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof String)) {
                throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.rconf02", (String)object.toString());
            }
            if ("body".equals(object) || "timestamp".equals(object) || "securitytoken".equals(object)) continue;
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.rconf02", (String)object.toString());
        }
        iterator = this.confidentialParts.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof String)) {
                throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.confPart", (String)object.toString());
            }
            if ("bodycontent".equals(object) || "usernametoken".equals(object)) continue;
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.confPart", (String)object.toString());
        }
        if (this.trustMode != null && !"Signature".equals(this.trustMode) && !"BasicAuth".equals(this.trustMode)) {
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.s08", (String)this.trustMode);
        }
        if (!(this.idType == null || "Username".equals(this.idType) || "DN".equals(this.idType) || "X509Certificate".equals(this.idType))) {
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.s31", (String)this.idType);
        }
        if ("Signature".equals(this.authMethod)) {
            if (this.integralParts.size() == 0) {
                throw SoapSecurityException.format((String)"security.wssecurity.PrivateSenderConfig.s30");
            }
            if (this.integralParts.contains("securitytoken")) {
                throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.sigWithSec");
            }
        }
        if ("IDAssertion".equals(this.authMethod) && this.idType == null) {
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.s32");
        }
        if (this.callbackHandler == null && ("BasicAuth".equals(this.authMethod) || "IDAssertion".equals(this.authMethod) && !"Signature".equals(this.trustMode))) {
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateSenderConfig.s33");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate()");
        }
    }

    private boolean isNullOrZero(String string) {
        return string == null || string.length() == 0;
    }

    public SignatureSenderConfig getSignatureConfig() {
        return this.signatureSenderConfig;
    }

    public TokenSenderConfig getTokenConfig() {
        return this.tokenSenderConfig;
    }

    public EncryptionSenderConfig getEncryptionConfig() {
        return this.encryptionSenderConfig;
    }

    public TimestampSenderConfig getTimestampConfig() {
        return this.timestampSenderConfig;
    }

    public String toString() {
        return this.getClass().getName() + "(" + "signatureSenderConfig=" + this.signatureSenderConfig + " tokenSenderConfig=" + this.tokenSenderConfig + " encryptionSenderConfig=" + this.encryptionSenderConfig + ")";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

