/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.dsig;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.dsig.IDResolver;
import com.ibm.xml.dsig.KeyInfo;
import com.ibm.xml.dsig.ResourceShower;
import com.ibm.xml.dsig.SignatureContext;
import com.ibm.xml.dsig.Validity;
import com.ibm.xml.dsig.XSignatureException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.dsig.KeyInfoResolver;
import com.ibm.xml.soapsec.dsig.SignatureReceiverConfig;
import com.ibm.xml.soapsec.dsig.SignatureResult;
import com.ibm.xml.soapsec.dsig.VerificationResult;
import com.ibm.xml.soapsec.dsig.VerificationResultHandler;
import com.ibm.xml.soapsec.dsig.VerificationSettings;
import com.ibm.xml.soapsec.token.BinaryTokenReceiver;
import com.ibm.xml.soapsec.token.TokenReceiverConfig;
import com.ibm.xml.soapsec.token.TokenResult;
import com.ibm.xml.soapsec.util.CertificateUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SignatureReceiver
implements SoapSecurityComponent {
    SignatureReceiverConfig config;
    TokenReceiverConfig tconfig;
    private IdUtil idResolver;
    private static final String[] ELEMENTS_TO_BE_CHECKED = new String[]{"CanonicalizationMethod", "SignatureMethod", "DigestMethod", "Transform"};
    private static final TraceComponent tc = Tr.register(class$com$ibm$xml$soapsec$dsig$SignatureReceiver == null ? (class$com$ibm$xml$soapsec$dsig$SignatureReceiver = SignatureReceiver.class$("com.ibm.xml.soapsec.dsig.SignatureReceiver")) : class$com$ibm$xml$soapsec$dsig$SignatureReceiver, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = (class$com$ibm$xml$soapsec$dsig$SignatureReceiver == null ? (class$com$ibm$xml$soapsec$dsig$SignatureReceiver = SignatureReceiver.class$("com.ibm.xml.soapsec.dsig.SignatureReceiver")) : class$com$ibm$xml$soapsec$dsig$SignatureReceiver).getName();
    static /* synthetic */ Class class$com$ibm$xml$soapsec$dsig$SignatureReceiverConfig;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$TokenReceiverConfig;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$TokenResult$X509;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$dsig$SignatureReceiver;

    public void init(Map map) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(" + map + ")");
        }
        this.config = (SignatureReceiverConfig)map.get(class$com$ibm$xml$soapsec$dsig$SignatureReceiverConfig == null ? (class$com$ibm$xml$soapsec$dsig$SignatureReceiverConfig = SignatureReceiver.class$("com.ibm.xml.soapsec.dsig.SignatureReceiverConfig")) : class$com$ibm$xml$soapsec$dsig$SignatureReceiverConfig);
        this.tconfig = (TokenReceiverConfig)map.get(class$com$ibm$xml$soapsec$token$TokenReceiverConfig == null ? (class$com$ibm$xml$soapsec$token$TokenReceiverConfig = SignatureReceiver.class$("com.ibm.xml.soapsec.token.TokenReceiverConfig")) : class$com$ibm$xml$soapsec$token$TokenReceiverConfig);
        this.idResolver = new IdUtil();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public void invoke(Document document, Element element, Map map) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + document + "," + element + "," + map + ")");
        }
        boolean bl = false;
        Exception exception = null;
        List list = this.config.getVerificationSettingsList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                this.invoke0(document, element, map, (VerificationSettings)iterator.next());
                bl = true;
                break;
            }
            catch (Exception exception2) {
                Tr.processException((Throwable)exception2, clsName + ".invoke", "104", this);
                exception = exception2;
            }
        }
        if (!bl) {
            throw SoapSecurityException.format((String)"security.wssecurity.SignatureReceiver.dsig21", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target, Map context)");
        }
    }

    private void invoke0(Document document, Element element, Map map, VerificationSettings verificationSettings) throws Exception {
        VerificationResult verificationResult;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke0(" + document + "," + element + "," + map + "," + verificationSettings + ")");
        }
        try {
            X509Certificate x509Certificate = this.verify(element, map, verificationSettings);
            verificationResult = new VerificationResult(map, element, x509Certificate);
        }
        catch (SoapSecurityException soapSecurityException) {
            Tr.processException((Throwable)soapSecurityException, clsName + ".invoke", "126", this);
            Tr.error(tc, "security.wssecurity.SignatureReceiver.invoke", (Object)soapSecurityException);
            verificationResult = new VerificationResult(map, element, soapSecurityException);
        }
        this.callVerificationResultHandlers(verificationResult);
        if (!verificationResult.getResult()) {
            throw verificationResult.getReason();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke0(Document doc, Element target, Map context, VerificationSettings settings)");
        }
    }

    private void callVerificationResultHandlers(VerificationResult verificationResult) throws SoapSecurityException {
        List list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callVerificationResultHandlers(" + verificationResult + ")");
        }
        if ((list = this.config.getVerificationResultHandlers()).isEmpty()) {
            SoapSecurityException soapSecurityException = verificationResult.getReason();
            if (soapSecurityException != null) {
                throw soapSecurityException;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "callVerificationResultHandlers(VerificationResult result)");
            }
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((VerificationResultHandler)iterator.next()).verificationDone(verificationResult);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callVerificationResultHandlers(VerificationResult result)");
        }
    }

    private X509Certificate verify(Element element, Map map, VerificationSettings verificationSettings) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verify(" + element + "," + map + verificationSettings + ")");
        }
        this.checkAlgorithms(element, verificationSettings, map);
        Set set = this.checkCertpathValidity(element, map, verificationSettings);
        SignatureResult signatureResult = this.analyzeSignedParts(element, verificationSettings);
        X509Certificate x509Certificate = this.checkCoreValidity(element, set);
        if (x509Certificate != null) {
            signatureResult.setCertificate(x509Certificate);
            ResultPool.add(map, signatureResult);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verify(Element sig, Map context, VerificationSettings settings) returns " + x509Certificate);
        }
        return x509Certificate;
    }

    private SignatureResult analyzeSignedParts(Element element, VerificationSettings verificationSettings) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "analyzeSignedParts(" + element + "," + verificationSettings + ")");
        }
        SignatureResult signatureResult = new SignatureResult();
        Element element2 = null;
        Element element3 = DOMUtil.getFirstChildElement(element, Constants.NS_DSIG, "SignedInfo");
        if (element3 != null) {
            element2 = DOMUtil.getFirstChildElement(element3);
        }
        while (element2 != null) {
            if (Constants.NS_DSIG.equals(element2.getNamespaceURI()) && "Reference".equals(element2.getLocalName())) {
                Object object;
                Object object2;
                String string = element2.getAttribute("URI");
                if (element2.getAttributeNode("URI") == null) {
                    throw SoapSecurityException.format((String)"security.wssecurity.SignatureReceiver.dsig03");
                }
                if (string.equals("")) {
                    Element element4 = DOMUtil.getFirstChildElement(element2, Constants.NS_DSIG, "Transforms");
                    if (element4 == null) {
                        Tr.error(tc, "security.wssecurity.SignatureReceiver.dsig04", string);
                    } else if ((element4 = DOMUtil.getFirstChildElement(element4)) == null) {
                        Tr.error(tc, "security.wssecurity.SignatureReceiver.dsig04", string);
                    } else {
                        object2 = element4.getAttribute("Algorithm");
                        if (!((String)object2).equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
                            Tr.error(tc, "security.wssecurity.SignatureReceiver.dsig05", new Object[]{string, object2});
                        } else {
                            object = DOMUtil.getStringValue(DOMUtil.getFirstChildElement(element4, Constants.NS_DSIG, "XPath"));
                            if (!((String)object).equals("count(/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::node() | /*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::*/@* | /*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::*/namespace::*) = count(/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::node() | /*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::*/@* | /*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::*/namespace::* | .)")) {
                                Tr.error(tc, "security.wssecurity.SignatureReceiver.dsig06", object);
                            } else if ((element4 = DOMUtil.getNextElement(element4)) != null && !verificationSettings.getC14nMethod().equals(element4.getAttribute("Algorithm"))) {
                                Tr.error(tc, "security.wssecurity.SignatureReceiver.dsig05", new Object[]{string, object2});
                            } else {
                                signatureResult.setBodySigned(true);
                            }
                        }
                    }
                } else if (string.length() < 2 || string.charAt(0) != '#') {
                    Tr.error(tc, "security.wssecurity.SignatureReceiver.dsig07", string);
                } else {
                    boolean bl = true;
                    object = null;
                    object2 = DOMUtil.getFirstChildElement(element2, Constants.NS_DSIG, "Transforms");
                    if (object2 != null) {
                        object = DOMUtil.getFirstChildElement((Node)object2);
                    }
                    while (object != null) {
                        if (Constants.NS_DSIG.equals(object.getNamespaceURI()) && "Transform".equals(object.getLocalName()) && !verificationSettings.getC14nMethod().equals(object.getAttribute("Algorithm"))) {
                            bl = false;
                            break;
                        }
                        object = DOMUtil.getNextElement((Node)object);
                    }
                    if (bl) {
                        signatureResult.addSignedId(string.substring(1));
                    }
                }
            }
            element2 = DOMUtil.getNextElement(element2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "analyzeSignedParts(Element sig, VerificationSettings settings) returns " + signatureResult);
        }
        return signatureResult;
    }

    private X509Certificate checkCoreValidity(Element element, Set set) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCoreValidity(" + element + "," + set + ")");
        }
        Element element2 = KeyInfo.searchForKeyInfo((Element)element);
        Iterator iterator = this.config.getKeyInfoResolvers().iterator();
        while (iterator.hasNext()) {
            ((KeyInfoResolver)iterator.next()).resolve(element2);
        }
        iterator = set.iterator();
        String string = null;
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            PublicKey publicKey = x509Certificate.getPublicKey();
            string = this.verify(element, publicKey);
            if (string != null) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCoreValidity(Element sig, Set certs) returns " + x509Certificate);
            }
            return x509Certificate;
        }
        throw SoapSecurityException.format((String)"security.wssecurity.SignatureReceiver.dsig22", string);
    }

    private String verify(Element element, Key key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verify(" + element + "," + key + ")");
        }
        SignatureContext signatureContext = new SignatureContext();
        if (this.config.getDumpPath() != null) {
            signatureContext.setResourceShower((ResourceShower)new ShowerImpl(this.config.getDumpPath()));
        }
        if (this.idResolver != null) {
            signatureContext.setIDResolver((IDResolver)this.idResolver);
        }
        Validity validity = signatureContext.verify(element, key);
        boolean bl = validity.getCoreValidity();
        String string = null;
        if (!bl || tc.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Core validity=");
            stringBuffer.append(bl);
            stringBuffer.append(" Signed info validity=");
            stringBuffer.append(validity.getSignedInfoValidity());
            stringBuffer.append(" Signed info message='");
            stringBuffer.append(validity.getSignedInfoMessage());
            stringBuffer.append("'");
            int n = validity.getNumberOfReferences();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(" Ref[");
                stringBuffer.append(i);
                stringBuffer.append("](validity=");
                stringBuffer.append(validity.getReferenceValidity(i));
                stringBuffer.append(" message='");
                stringBuffer.append(validity.getReferenceMessage(i));
                stringBuffer.append("' uri='");
                stringBuffer.append(validity.getReferenceURI(i));
                stringBuffer.append("' type='");
                stringBuffer.append(validity.getReferenceType(i));
                stringBuffer.append("')");
            }
            string = stringBuffer.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string);
            }
            if (bl) {
                string = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verify(Element sig, Key key) returns " + string);
        }
        return string;
    }

    private void parseTokenReference(Set set, Node node, Map map, VerificationSettings verificationSettings) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseTokenReference(" + set + "," + node + "," + map + "," + verificationSettings + ")");
        }
        Element element = DOMUtil.getFirstChildElement(node);
        while (element != null) {
            block7: {
                Object object;
                TokenResult.X509 x509;
                String string;
                block9: {
                    Element element2;
                    block8: {
                        string = null;
                        x509 = null;
                        if (!NamespaceUtil.isWsse(element.getNamespaceURI())) break block7;
                        if (!"Reference".equals(element.getLocalName())) break block8;
                        String string2 = element.getAttribute("URI");
                        if (string2 == null || string2.length() < 1) break block7;
                        if (!string2.startsWith("#")) {
                            String string3 = Constants.getWSSENS(map);
                            throw SoapSecurityException.format((QName)Constants.getQName(string3, "SecurityTokenUnavailable"), (String)"security.wssecurity.SignatureReceiver.dsig09", (String)string2);
                        }
                        string = string2.substring(1);
                        break block9;
                    }
                    if ("Embedded".equals(element.getLocalName()) && (element2 = NamespaceUtil.getFirstChildWsseElement(element, "BinarySecurityToken")) != null) {
                        object = new BinaryTokenReceiver(this.tconfig);
                        ((BinaryTokenReceiver)object).invoke(element2.getOwnerDocument(), element2, map);
                    }
                }
                Result[] resultArray = ResultPool.get(map, class$com$ibm$xml$soapsec$token$TokenResult$X509 == null ? SignatureReceiver.class$("com.ibm.xml.soapsec.token.TokenResult$X509") : class$com$ibm$xml$soapsec$token$TokenResult$X509);
                for (int i = 0; i < resultArray.length; ++i) {
                    boolean bl;
                    x509 = (TokenResult.X509)resultArray[i];
                    object = verificationSettings.getTrustAnchorRef();
                    String string4 = verificationSettings.getCertStoreRef();
                    String string5 = x509.getTrustAnchorRef();
                    String string6 = x509.getCertStoreRef();
                    boolean bl2 = verificationSettings.getTrustAnyCertificate() && x509.getTrustAnyCertificate();
                    boolean bl3 = object != null && ((String)object).equals(string5);
                    boolean bl4 = bl = string4 != null && string4.equals(string6) || string4 == null && string6 == null;
                    if ((string == null || string.equals(x509.getIdName())) && (bl2 || bl3 && bl)) break;
                    x509 = null;
                }
                if (x509 == null) {
                    String string7 = Constants.getWSSENS(map);
                    throw SoapSecurityException.format((QName)Constants.getQName(string7, "SecurityTokenUnavailable"), (String)"security.wssecurity.SignatureReceiver.dsig10", (String)(string == null ? "<Embedded>" : string));
                }
                x509.setUsed(true);
                set.add(x509.getCertificate());
            }
            element = DOMUtil.getNextElement(element);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseTokenReference(Set certs, Node tokenref, Map context, VerificationSettings settings)");
        }
    }

    private Set checkCertpathValidity(Element element, Map map, VerificationSettings verificationSettings) throws SoapSecurityException {
        CertificateUtil.X509DataUtil[] x509DataUtilArray;
        HashSet hashSet;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCertpathValidity(" + element + "," + map + "," + verificationSettings + ")");
        }
        HashSet<X509Certificate> hashSet2 = new HashSet<X509Certificate>();
        Element element2 = KeyInfo.searchForKeyInfo((Element)element);
        if (element2 != null) {
            hashSet = NamespaceUtil.getWsseElementsByTagName(element2, "SecurityTokenReference");
            for (int i = 0; i < hashSet.getLength(); ++i) {
                this.parseTokenReference(hashSet2, hashSet.item(i), map, verificationSettings);
            }
        }
        if (verificationSettings.getTrustAnyCertificate()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCertpathValidity(Element sig, Map context)");
            }
            return hashSet2;
        }
        try {
            x509DataUtilArray = CertificateUtil.getX509Data(element);
        }
        catch (XSignatureException xSignatureException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to retreive valid X.509 data (should be embedded in BST) from Signature element.", new Object[]{xSignatureException});
            }
            x509DataUtilArray = new CertificateUtil.X509DataUtil[]{};
        }
        if (x509DataUtilArray.length > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling CertificateUtil.verify()");
            }
            PKIXBuilderParameters pKIXBuilderParameters = (PKIXBuilderParameters)verificationSettings.getPKIXBuilderParameters().clone();
            hashSet = verificationSettings.getEeCerts();
            if (hashSet == null) {
                hashSet = new HashSet();
            }
            Provider provider = verificationSettings.getCertPathProvider();
            CertStore certStore = null;
            try {
                certStore = provider == null ? CertStore.getInstance("Collection", new CollectionCertStoreParameters(hashSet)) : CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(hashSet), provider);
            }
            catch (Exception exception) {
                throw new SoapSecurityException((Throwable)exception);
            }
            pKIXBuilderParameters.addCertStore(certStore);
            for (int i = 0; i < x509DataUtilArray.length; ++i) {
                try {
                    X509CertSelector x509CertSelector = x509DataUtilArray[i].createSelector();
                    Date date = new Date();
                    x509CertSelector.setCertificateValid(date);
                    pKIXBuilderParameters.setDate(date);
                    pKIXBuilderParameters.setTargetCertConstraints(x509CertSelector);
                    hashSet2.add(x509DataUtilArray[i].validateAndGetCert(pKIXBuilderParameters));
                    continue;
                }
                catch (XSignatureException xSignatureException) {
                    Tr.processException((Throwable)xSignatureException, clsName + ".checkCertpathValidity", "503", this);
                    Tr.error(tc, "security.wssecurity.SignatureReceiver.exception", (Object)xSignatureException);
                    continue;
                }
                catch (IOException iOException) {
                    Tr.processException((Throwable)iOException, clsName + ".checkCertpathValidity", "507", this);
                    Tr.error(tc, "security.wssecurity.SignatureReceiver.exception", iOException);
                }
            }
        }
        if (!hashSet2.isEmpty()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCertpathValidity(Element sig, Map context, VerificationSettings settings) returns " + hashSet2);
            }
            return hashSet2;
        }
        throw SoapSecurityException.format((String)"security.wssecurity.SignatureReceiver.s28", (Throwable)new Exception());
    }

    private void checkAlgorithms(Element element, VerificationSettings verificationSettings, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAlgorithms(" + element + "," + verificationSettings + "," + map + ")");
        }
        for (int i = 0; i < ELEMENTS_TO_BE_CHECKED.length; ++i) {
            this.checkAlgorithm(element, i, verificationSettings, map);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAlgorithms(Element, VerificationSettings, Map");
        }
    }

    private void checkAlgorithm(Element element, int n, VerificationSettings verificationSettings, Map map) throws SoapSecurityException {
        NodeList nodeList = element.getElementsByTagNameNS(Constants.NS_DSIG, ELEMENTS_TO_BE_CHECKED[n]);
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("Algorithm");
            boolean bl = false;
            if (n == 0) {
                if (!verificationSettings.getC14nMethod().equals(string)) {
                    bl = true;
                }
            } else if (n == 1) {
                if (!verificationSettings.getSignatureMethod().equals(string)) {
                    bl = true;
                }
            } else if (n == 2) {
                if (!verificationSettings.getDigestMethod().equals(string)) {
                    bl = true;
                }
            } else if (n == 3 && !this.config.getAllowedTransforms().contains(string)) {
                bl = true;
            }
            if (!bl) continue;
            String string2 = Constants.getWSSENS(map);
            throw SoapSecurityException.format((QName)Constants.getQName(string2, "UnsupportedAlgorithm"), (String)"security.wssecurity.SignatureReceiver.s26", (String)string, (String)ELEMENTS_TO_BE_CHECKED[n]);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ShowerImpl
    implements ResourceShower {
        String path;

        ShowerImpl(String string) {
            this.path = string;
        }

        public void showSignedResource(Element element, int n, String string, String string2, byte[] byArray, String string3) {
            try {
                String string4 = n < 0 ? this.path + File.separator + "verify-SignedInfo" : (string == null || string.length() == 0 ? this.path + File.separator + "verify-resource_" + n : this.path + File.separator + "verify-" + string);
                System.err.println("ResourceShower: save to " + string4);
                FileOutputStream fileOutputStream = new FileOutputStream(string4);
                ((OutputStream)fileOutputStream).write(byArray);
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

