/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.dsig;

import com.ibm.dom.util.XPathCanonicalizer;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.xml.dsig.IDResolver;
import com.ibm.xml.dsig.Reference;
import com.ibm.xml.dsig.ResourceShower;
import com.ibm.xml.dsig.SignatureContext;
import com.ibm.xml.dsig.TemplateGenerator;
import com.ibm.xml.dsig.util.Base64;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.Request;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.SenderConfig;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.dsig.SignatureRequest;
import com.ibm.xml.soapsec.dsig.SignatureSenderConfig;
import com.ibm.xml.soapsec.dsig.SignerRequest;
import com.ibm.xml.soapsec.dsig.TemplateModifier;
import com.ibm.xml.soapsec.token.TokenRequest;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SignatureSender
implements SoapSecurityComponent {
    static boolean USE_XPATH = false;
    static boolean USE_EMBEDDED = false;
    private static final String SIGNATURE_PREFIX = "ds";
    private static final TraceComponent tc = Tr.register(class$com$ibm$xml$soapsec$dsig$SignatureSender == null ? (class$com$ibm$xml$soapsec$dsig$SignatureSender = SignatureSender.class$("com.ibm.xml.soapsec.dsig.SignatureSender")) : class$com$ibm$xml$soapsec$dsig$SignatureSender, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    SenderConfig gconfig;
    SignatureSenderConfig config;
    private IdUtil idResolver;
    private static final String BODY = "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']";
    static final String BODY_XPATH = "count(/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::node() | /*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::*/@* | /*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::*/namespace::*) = count(/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::node() | /*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::*/@* | /*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::*/namespace::* | .)";
    static /* synthetic */ Class class$com$ibm$xml$soapsec$dsig$SignatureSender;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$SenderConfig;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$dsig$SignatureSenderConfig;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$dsig$SignerRequest;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$dsig$SignatureRequest;

    public void init(Map map) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(" + map + ")");
        }
        this.gconfig = (SenderConfig)map.get(class$com$ibm$xml$soapsec$SenderConfig == null ? (class$com$ibm$xml$soapsec$SenderConfig = SignatureSender.class$("com.ibm.xml.soapsec.SenderConfig")) : class$com$ibm$xml$soapsec$SenderConfig);
        this.config = (SignatureSenderConfig)map.get(class$com$ibm$xml$soapsec$dsig$SignatureSenderConfig == null ? (class$com$ibm$xml$soapsec$dsig$SignatureSenderConfig = SignatureSender.class$("com.ibm.xml.soapsec.dsig.SignatureSenderConfig")) : class$com$ibm$xml$soapsec$dsig$SignatureSenderConfig);
        this.idResolver = new IdUtil();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    private static boolean matchClass(Class clazz, String string) {
        if (clazz.getName().equals(string)) {
            return true;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null && SignatureSender.matchClass(clazz2, string)) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!SignatureSender.matchClass(classArray[i], string)) continue;
            return true;
        }
        return false;
    }

    private static boolean instanceOf(Object object, String string) {
        return SignatureSender.matchClass(object.getClass(), string);
    }

    private static void addReferenceForBody(TemplateGenerator templateGenerator, Document document, SignatureSenderConfig signatureSenderConfig, String string) {
        Reference reference;
        if (USE_XPATH) {
            reference = templateGenerator.createReference("");
            reference.addXPathTransform(BODY_XPATH);
            reference.addTransform(signatureSenderConfig.getCanonicalizationMethod());
        } else {
            String string2 = null;
            Element element = document.getDocumentElement();
            String string3 = IdUtil.getIdAttributeName(element = DOMUtil.getFirstChildElement(element, "http://schemas.xmlsoap.org/soap/envelope/", "Body"));
            if (string3 != null) {
                string2 = element.getAttribute(string3);
            }
            if (string2 == null || string2.length() == 0) {
                string2 = DOMUtil.makeUniqueId(document, "wssecurity_body_id_");
                element.setAttributeNS(string, "wsu:Id", string2);
                element.setAttributeNS(Constants.NS_XMLNS, "xmlns:wsu", string);
            }
            reference = templateGenerator.createReference("#" + string2);
            String string4 = signatureSenderConfig.getCanonicalizationMethod();
            if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(string4) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(string4)) {
                Object object;
                HashSet<String> hashSet = new HashSet<String>();
                for (Node node = element; node != null && node.getNodeType() == 1; node = node.getParentNode()) {
                    object = node.getAttributes();
                    int n = object == null ? 0 : object.getLength();
                    for (int i = 0; i < n; ++i) {
                        String string5 = object.item(i).getNodeName();
                        if (string5.equals("xmlns")) {
                            hashSet.add("#default");
                            continue;
                        }
                        if (!string5.startsWith("xmlns:")) continue;
                        hashSet.add(string5.substring(6));
                    }
                }
                SignatureSender.scanNamespaceDecls(element, hashSet);
                Element element2 = document.createElementNS(Constants.NS_DSIG, "Transform");
                element2.setAttributeNS(null, "Algorithm", string4);
                if (hashSet.size() > 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    object = hashSet.iterator();
                    while (object.hasNext()) {
                        stringBuffer.append(object.next());
                        stringBuffer.append(" ");
                    }
                    Element element3 = document.createElementNS("http://www.w3.org/2001/10/xml-exc-c14n#", "ec:InclusiveNamespaces");
                    element3.setAttributeNS(Constants.NS_XMLNS, "xmlns:ec", "http://www.w3.org/2001/10/xml-exc-c14n#");
                    element3.setAttributeNS(null, "PrefixList", new String(stringBuffer));
                    element2.appendChild(element3);
                }
                reference.addTransform(element2);
            } else {
                reference.addTransform(string4);
            }
        }
        templateGenerator.addReference(reference);
    }

    private static void scanNamespaceDecls(Node node, Set set) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap == null ? 0 : namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            String string = namedNodeMap.item(i).getNodeName();
            if (string.equals("xmlns")) {
                set.add("#default");
                continue;
            }
            if (!string.startsWith("xmlns:")) continue;
            set.add(string.substring(6));
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            SignatureSender.scanNamespaceDecls(node2, set);
        }
    }

    public void invoke(Document document, Element element, Map map) throws Exception {
        Object object;
        Object object2;
        Object object3;
        X509Certificate x509Certificate;
        Key key;
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + document + "," + element + "," + map + ")");
        }
        String string = this.config.getSignatureMethod();
        String string2 = this.config.getKeyName();
        KeyLocator keyLocator = this.config.getKeyLocator();
        Request[] requestArray = RequestPool.get(map, class$com$ibm$xml$soapsec$dsig$SignerRequest == null ? (class$com$ibm$xml$soapsec$dsig$SignerRequest = SignatureSender.class$("com.ibm.xml.soapsec.dsig.SignerRequest")) : class$com$ibm$xml$soapsec$dsig$SignerRequest);
        if (requestArray.length == 0) {
            key = keyLocator.getSigningKey(string2);
            x509Certificate = (X509Certificate)keyLocator.getCertificate(string2);
        } else {
            if (requestArray.length > 1 && tc.isDebugEnabled()) {
                Tr.debug(tc, requestArray.length + " SignerRequests. Using the first one");
            }
            object3 = (SignerRequest)requestArray[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Switch signer to: " + ((SignerRequest)object3).getAlias());
            }
            key = keyLocator.getSigningKey(((SignerRequest)object3).getAlias());
            x509Certificate = (X509Certificate)keyLocator.getCertificate(((SignerRequest)object3).getAlias());
        }
        if (string == null) {
            if (SignatureSender.instanceOf(key, "java.security.interfaces.DSAPrivateKey")) {
                string = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            } else if (SignatureSender.instanceOf(key, "java.security.interfaces.RSAPrivateKey")) {
                string = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            } else {
                Tr.warning(tc, "security.wssecurity.SignatureSender.unknownKey", key.getClass().getName());
            }
        }
        TemplateGenerator templateGenerator = new TemplateGenerator(document, this.config.getDigestMethod(), this.config.getCanonicalizationMethod(), string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Examining signing parts.");
        }
        Iterator iterator = this.config.getIntegralParts().iterator();
        object3 = Constants.getWSUNS(map);
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string3.equals("body")) continue;
            SignatureSender.addReferenceForBody(templateGenerator, document, this.config, (String)object3);
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Examining RequestPool.");
        }
        requestArray = RequestPool.get(map, class$com$ibm$xml$soapsec$dsig$SignatureRequest == null ? (class$com$ibm$xml$soapsec$dsig$SignatureRequest = SignatureSender.class$("com.ibm.xml.soapsec.dsig.SignatureRequest")) : class$com$ibm$xml$soapsec$dsig$SignatureRequest);
        for (int i = 0; i < requestArray.length; ++i) {
            object2 = (SignatureRequest)requestArray[i];
            if (((SignatureRequest)object2).isBodyRequest()) {
                throw SoapSecurityException.format((String)"security.wssecurity.SignatureSender.dsig02");
            }
            object = templateGenerator.createReference("#" + ((SignatureRequest)object2).getIdName());
            object.addTransform(this.config.getCanonicalizationMethod());
            templateGenerator.addReference(object);
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Generating a template.");
        }
        if (!bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke(Document doc, Element security, Map context)");
            }
            return;
        }
        Element element2 = templateGenerator.getSignatureElement();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Apply TemplateModifiers.");
        }
        iterator = this.config.getTemplateModifiers().iterator();
        while (iterator.hasNext()) {
            ((TemplateModifier)iterator.next()).modifyTemplate(element2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Starting to Sign.");
        }
        object2 = null;
        element.insertBefore(element2, element.getFirstChild());
        if (this.config.getPreC14n()) {
            SignatureSender.preC14n(document, element2);
        }
        if (this.gconfig.doIndentation()) {
            element.insertBefore(document.createTextNode("\n      "), element2);
        } else {
            DOMUtil.removeIndentation(element);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Template: " + new String(XPathCanonicalizer.serializeSubset((Node)element2, (boolean)true)));
        }
        SignatureContext signatureContext = new SignatureContext();
        if (this.config.getDumpPath() != null) {
            signatureContext.setResourceShower((ResourceShower)new ShowerImpl(this.config.getDumpPath()));
        }
        signatureContext.setIDResolver((IDResolver)this.idResolver);
        object = Constants.getWSSENS(map);
        if (USE_EMBEDDED) {
            SignatureSender.insertEmbedded(element2, x509Certificate.getEncoded(), (String)object);
        } else {
            object2 = DOMUtil.makeUniqueId(document, "wssecurity_binary_security_token_id_");
            SignatureSender.insertTokenReference(element2, (String)object2, (String)object);
        }
        if (this.gconfig.doIndentation()) {
            DOMUtil.indent(element2, 6, 2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Signing started.");
        }
        signatureContext.sign(element2, key);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Signing done.");
        }
        if (!USE_EMBEDDED) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Requesting a BinarySecurityToken for the signer certificate");
            }
            TokenRequest.Binary binary = new TokenRequest.Binary(Constants.getQName((String)object, "X509v3"), x509Certificate.getEncoded(), (String)object2, null);
            RequestPool.add(map, binary);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element security, Map context)");
        }
    }

    private static void insertTokenReference(Element element, String string, String string2) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(string2, "wsse:Reference");
        element2.setAttribute("URI", "#" + string);
        Element element3 = SignatureSender.insertSTR(element, string2);
        element3.appendChild(element2);
    }

    private static void insertEmbedded(Element element, byte[] byArray, String string) throws SoapSecurityException {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(string, "wsse:BinarySecurityToken");
        element2.appendChild(document.createTextNode(Base64.encode((byte[])byArray)));
        Element element3 = document.createElementNS(string, "wsse:Embedded");
        element3.appendChild(element2);
        Element element4 = SignatureSender.insertSTR(element, string);
        element4.appendChild(element3);
        DOMUtil.setQNameAttr(element2, null, "ValueType", Constants.getQName(string, "X509v3"));
        DOMUtil.setQNameAttr(element2, null, "EncodingType", Constants.getQName(string, "Base64Binary"));
    }

    private static Element insertSTR(Element element, String string) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(string, "wsse:SecurityTokenReference");
        element2.setAttributeNS(Constants.NS_XMLNS, "xmlns:wsse", string);
        String string2 = "KeyInfo";
        if (element.getPrefix() != null) {
            string2 = element.getPrefix() + ":KeyInfo";
        }
        Element element3 = document.createElementNS(Constants.NS_DSIG, string2);
        string2 = "xmlns";
        if (element.getPrefix() != null) {
            string2 = "xmlns:" + element.getPrefix();
        }
        element3.setAttributeNS(Constants.NS_XMLNS, string2, Constants.NS_DSIG);
        element3.appendChild(element2);
        element.appendChild(element3);
        return element2;
    }

    private static void preC14n(Document document, Element element) {
        Element element2 = DOMUtil.getFirstChildElement(document.getDocumentElement(), "http://schemas.xmlsoap.org/soap/envelope/", "Body");
        SignatureSender.setPrefix(element2, element2.getPrefix(), "S");
        element2.setAttributeNS(Constants.NS_XMLNS, "xmlns:S", "http://schemas.xmlsoap.org/soap/envelope/");
        String string = "xmlns";
        if (element.getPrefix() != null) {
            string = "xmlns:" + element.getPrefix();
        }
        element.removeAttribute(string);
        SignatureSender.setPrefix(element, element.getPrefix(), SIGNATURE_PREFIX);
        string = "xmlns";
        if (SIGNATURE_PREFIX != null) {
            string = "xmlns:ds";
        }
        element.setAttributeNS(Constants.NS_XMLNS, string, Constants.NS_DSIG);
        Element element3 = DOMUtil.getFirstChildElement(element, Constants.NS_DSIG, "SignedInfo");
        SignatureSender.setPrefix(element3, element3.getPrefix(), "Sig");
        element3.setAttributeNS(Constants.NS_XMLNS, "xmlns:Sig", Constants.NS_DSIG);
    }

    static void setPrefix(Element element, String string, String string2) {
        Object object;
        if (element.getPrefix() == null) {
            if (string == null) {
                element.setPrefix(string2);
            }
        } else if (element.getPrefix().equals(string)) {
            element.setPrefix(string2);
        }
        if (string != null) {
            object = element.getAttributes();
            for (int i = 0; i < object.getLength(); ++i) {
                Attr attr = (Attr)object.item(i);
                if (attr.getPrefix() == null || !attr.getPrefix().equals(string)) continue;
                attr.setPrefix(string2);
            }
        }
        object = DOMUtil.getFirstChild2(element);
        while (object != null) {
            switch (object.getNodeType()) {
                case 1: {
                    SignatureSender.setPrefix((Element)object, string, string2);
                }
            }
            object = DOMUtil.getNextSibling2((Node)object);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ShowerImpl
    implements ResourceShower {
        String path;

        ShowerImpl(String string) {
            this.path = string;
        }

        public void showSignedResource(Element element, int n, String string, String string2, byte[] byArray, String string3) {
            try {
                String string4 = n < 0 ? this.path + File.separator + "sign-SignedInfo" : (string == null || string.length() == 0 ? this.path + File.separator + "sign-resource_" + n : this.path + File.separator + "sign-" + string);
                System.err.println("ResourceShower: save to " + string4);
                FileOutputStream fileOutputStream = new FileOutputStream(string4);
                ((OutputStream)fileOutputStream).write(byArray);
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

