/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.enc;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.wsspi.wssecurity.config.KeyLocatorException;
import com.ibm.xml.dsig.IDResolver;
import com.ibm.xml.dsig.XSignatureException;
import com.ibm.xml.enc.AlgorithmFactoryExtn;
import com.ibm.xml.enc.DecryptionContext;
import com.ibm.xml.enc.KeyInfoResolver;
import com.ibm.xml.enc.KeyInfoResolvingException;
import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.DataReference;
import com.ibm.xml.enc.type.EncryptedData;
import com.ibm.xml.enc.type.EncryptedKey;
import com.ibm.xml.enc.type.KeyReference;
import com.ibm.xml.enc.type.ReferenceList;
import com.ibm.xml.enc.type.ReferenceType;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.enc.DecryptionResult;
import com.ibm.xml.soapsec.enc.EncryptionReceiverConfig;
import com.ibm.xml.soapsec.enc.EncryptionSettings;
import com.ibm.xml.soapsec.enc.KeyIdentifierKeyResolver;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EncryptionReceiver
implements SoapSecurityComponent {
    private static final TraceComponent tc = Tr.register(class$com$ibm$xml$soapsec$enc$EncryptionReceiver == null ? (class$com$ibm$xml$soapsec$enc$EncryptionReceiver = EncryptionReceiver.class$("com.ibm.xml.soapsec.enc.EncryptionReceiver")) : class$com$ibm$xml$soapsec$enc$EncryptionReceiver, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = (class$com$ibm$xml$soapsec$enc$EncryptionReceiver == null ? (class$com$ibm$xml$soapsec$enc$EncryptionReceiver = EncryptionReceiver.class$("com.ibm.xml.soapsec.enc.EncryptionReceiver")) : class$com$ibm$xml$soapsec$enc$EncryptionReceiver).getName();
    private EncryptionReceiverConfig fConfig;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$enc$EncryptionReceiver;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$enc$EncryptionReceiverConfig;

    private List getIds(Element element) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIds(" + element + ")");
        }
        Element element2 = null;
        if (EncryptedKey.isOfType((Element)element)) {
            element2 = DOMUtil.getChildElement(element, "http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
        } else if (ReferenceList.isOfType((Element)element)) {
            element2 = element;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (element2 != null) {
            ReferenceList referenceList = new ReferenceList(element2);
            Iterator iterator = referenceList.getReferences().iterator();
            while (iterator.hasNext()) {
                ReferenceType referenceType = (ReferenceType)iterator.next();
                if (referenceType instanceof DataReference) {
                    String string = ((DataReference)referenceType).getURI();
                    if (string == null) {
                        throw SoapSecurityException.format((String)"security.wssecurity.EncryptionReceiver.enc05");
                    }
                    if (string.length() <= 1 || string.charAt(0) != '#') continue;
                    arrayList.add(string.substring(1));
                    continue;
                }
                if (!(referenceType instanceof KeyReference)) continue;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIds(Element elem) returns " + arrayList);
        }
        return arrayList;
    }

    private DecryptionContext createDecryptionContext(KeyLocator keyLocator, IDResolver iDResolver, Map map) throws KeyLocatorException, KeyStoreException, NoSuchAlgorithmException, SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDecryptionContext(" + keyLocator + ", " + iDResolver + ")");
        }
        DecryptionContext decryptionContext = new DecryptionContext();
        decryptionContext.setAlgorithmFactory(new AlgorithmFactoryExtn());
        decryptionContext.setIdResolver(iDResolver);
        KeyIdentifierKeyResolver keyIdentifierKeyResolver = new KeyIdentifierKeyResolver(keyLocator, 2, map, false);
        decryptionContext.setKeyInfoResolver((KeyInfoResolver)keyIdentifierKeyResolver);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDecryptionContext(KeyLocator locator,  IDResolver reslvr) returns " + decryptionContext);
        }
        return decryptionContext;
    }

    private void checkEncryptionMethod(Element element, String string) throws SoapSecurityException {
        Element element2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkEncryptionMethod(" + element + "," + string + ")");
        }
        if ((element2 = DOMUtil.getChildElement(element, "http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod")) == null) {
            throw SoapSecurityException.format((String)"security.wssecurity.EncryptionReceiver.enc10");
        }
        if (!element2.hasAttribute("Algorithm")) {
            throw SoapSecurityException.format((String)"security.wssecurity.EncryptionReceiver.enc06");
        }
        String string2 = element2.getAttribute("Algorithm");
        if (!string2.equals(string)) {
            throw SoapSecurityException.format((String)"security.wssecurity.EncryptionReceiver.enc07", (String)string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkEncryptionMethod(Element encType, Set methods)");
        }
    }

    private void checkCipherData(Element element) throws SoapSecurityException {
        Element element2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCipherData(" + element + ")");
        }
        if ((element2 = DOMUtil.getChildElement(element, "http://www.w3.org/2001/04/xmlenc#", "CipherData")) == null) {
            Tr.error(tc, "security.wssecurity.WSEC5196E");
            throw SoapSecurityException.format((String)"security.wssecurity.WSEC5196E");
        }
        Element element3 = DOMUtil.getChildElement(element2, "http://www.w3.org/2001/04/xmlenc#", "CipherReference");
        if (element3 == null) {
            return;
        }
        if (!element3.hasAttribute("URI")) {
            Tr.error(tc, "security.wssecurity.WSEC5197E");
            throw SoapSecurityException.format((String)"security.wssecurity.WSEC5197E");
        }
        String string = element3.getAttribute("URI");
        if (string.length() < 2 || string.charAt(0) != '#') {
            Tr.error(tc, "security.wssecurity.WSEC5198E", string);
            throw SoapSecurityException.format((String)"security.wssecurity.WSEC5198E", (String)string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCipherData()");
        }
    }

    private Key decryptEncryptedKey(Element element, DecryptionContext decryptionContext, Element element2) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, XSignatureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decryptEncryptedKey(" + element + "," + decryptionContext + "," + element2 + ")");
        }
        decryptionContext.setEncryptedType(element, null, null, null);
        decryptionContext.setEncryptionMethod(DOMUtil.getChildElement(element2, "http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod"));
        decryptionContext.decrypt();
        Key key = (Key)decryptionContext.getData();
        decryptionContext.setEncryptionMethod(null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decryptEncryptedKey(Element encKey, DecryptionContext context, Element encData) returns " + key);
        }
        return key;
    }

    private DecryptionResult decryptEncryptedData(Element element, DecryptionContext decryptionContext) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, ParserConfigurationException, SAXException, StructureException, XSignatureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decryptEncryptedData(" + element + "," + decryptionContext + ")");
        }
        decryptionContext.setEncryptedType(element, null, null, null);
        decryptionContext.decrypt();
        decryptionContext.replace();
        NodeList nodeList = decryptionContext.getDataAsNodeList();
        String string = decryptionContext.getType();
        DecryptionResult decryptionResult = this.createDecryptionResult(nodeList, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decryptEncryptedData(Element encData, DecryptionContext context) returns " + decryptionResult);
        }
        return decryptionResult;
    }

    private DecryptionResult createDecryptionResult(NodeList nodeList, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDecryptionResult(" + nodeList + "," + string + ")");
        }
        DecryptionResult decryptionResult = new DecryptionResult();
        if (nodeList.getLength() > 0) {
            Node node = nodeList.item(0);
            if (string.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
                Element element = (Element)node;
                String string2 = this.getId(element);
                if (string2 != null) {
                    decryptionResult.setElement(string2, false);
                } else {
                    decryptionResult.setElement(element, false);
                }
            } else if (string.equals("http://www.w3.org/2001/04/xmlenc#Content") && (node = node.getParentNode()) != null && node.getNodeType() == 1) {
                if ("http://schemas.xmlsoap.org/soap/envelope/".equals(node.getNamespaceURI()) && "Body".equals(node.getLocalName())) {
                    decryptionResult.setBodyContent();
                } else {
                    Element element = (Element)node;
                    String string3 = this.getId(element);
                    if (string3 != null) {
                        decryptionResult.setElement(string3, true);
                    } else {
                        decryptionResult.setElement(element, true);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDecryptionResult(NodeList nodes, String type) returns " + decryptionResult);
        }
        return decryptionResult;
    }

    private String getId(Element element) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getId(" + element + ")");
        }
        String string = IdUtil.getIdAttributeName(element);
        String string2 = null;
        if (string != null) {
            string2 = element.getAttribute(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getId(Element elem) returns" + string2);
        }
        return string2;
    }

    private Exception unwrapException(Exception exception) {
        Exception exception2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unwrapException(" + exception + ")");
        }
        if (exception instanceof SAXException) {
            Exception exception3 = ((SAXException)exception).getException();
            if (exception3 != null) {
                exception = exception3;
            }
        } else if (exception instanceof XSignatureException && (exception2 = ((XSignatureException)((Object)exception)).getException()) != null) {
            exception = exception2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unwrapException(Exception exc) returns " + exception);
        }
        return exception;
    }

    public void init(Map map) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(" + map + ")");
        }
        this.fConfig = (EncryptionReceiverConfig)map.get(class$com$ibm$xml$soapsec$enc$EncryptionReceiverConfig == null ? (class$com$ibm$xml$soapsec$enc$EncryptionReceiverConfig = EncryptionReceiver.class$("com.ibm.xml.soapsec.enc.EncryptionReceiverConfig")) : class$com$ibm$xml$soapsec$enc$EncryptionReceiverConfig);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public void invoke(Document document, Element element, Map map) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + document + "," + element + "," + map + ")");
        }
        boolean bl = false;
        Exception exception = null;
        List list = this.fConfig.getEncryptionSettingsList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                this.invoke0(document, element, map, (EncryptionSettings)iterator.next());
                bl = true;
                break;
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        if (!bl) {
            Tr.error(tc, "security.wssecurity.EncryptionReceiver.exception", exception);
            throw SoapSecurityException.format((String)"security.wssecurity.EncryptionReceiver.enc14", (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target, Map context)");
        }
    }

    private void invoke0(Document document, Element element, Map map, EncryptionSettings encryptionSettings) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke0(" + document + "," + element + "," + map + "," + encryptionSettings + ")");
        }
        try {
            List list = this.getIds(element);
            IdUtil idUtil = new IdUtil();
            DecryptionContext decryptionContext = this.createDecryptionContext(encryptionSettings.getKeyLocator(), idUtil, map);
            Key key = null;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Element element2 = idUtil.resolveID(document, string);
                if (element2 == null) continue;
                if (EncryptedData.isOfType((Element)element2)) {
                    this.checkEncryptionMethod(element2, encryptionSettings.getDataEncryptionMethod());
                    this.checkCipherData(element2);
                    decryptionContext.setKey(null);
                    if (EncryptedKey.isOfType((Element)element)) {
                        if (key == null) {
                            this.checkEncryptionMethod(element, encryptionSettings.getKeyEncryptionMethod());
                            this.checkCipherData(element);
                            key = this.decryptEncryptedKey(element, decryptionContext, element2);
                        }
                        decryptionContext.setKey(key);
                    }
                    DecryptionResult decryptionResult = this.decryptEncryptedData(element2, decryptionContext);
                    ResultPool.add(map, decryptionResult);
                    continue;
                }
                throw SoapSecurityException.format((String)"security.wssecurity.EncryptionReceiver.enc13", (String)element2.getTagName());
            }
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".invoke", "381", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "An exception while decrypting the message: {0}", exception);
            }
            throw this.unwrapException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke0(Document doc, Element target, Map context, EncryptionSettings settings)");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

