/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.enc;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.wsspi.wssecurity.config.KeyLocatorException;
import com.ibm.xml.enc.AlgorithmFactoryExtn;
import com.ibm.xml.enc.EncryptionContext;
import com.ibm.xml.enc.KeyInfoResolver;
import com.ibm.xml.enc.KeyInfoResolvingException;
import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.CipherData;
import com.ibm.xml.enc.type.CipherValue;
import com.ibm.xml.enc.type.DataReference;
import com.ibm.xml.enc.type.EncryptedData;
import com.ibm.xml.enc.type.EncryptedKey;
import com.ibm.xml.enc.type.EncryptedType;
import com.ibm.xml.enc.type.EncryptionMethod;
import com.ibm.xml.enc.type.KeyInfo;
import com.ibm.xml.enc.type.ReferenceList;
import com.ibm.xml.soapsec.Request;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.enc.EncryptionRequest;
import com.ibm.xml.soapsec.enc.EncryptionSenderConfig;
import com.ibm.xml.soapsec.enc.EncryptionSettings;
import com.ibm.xml.soapsec.enc.KeyIdentifierKeyResolver;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EncryptionSender
implements SoapSecurityComponent {
    private static final TraceComponent tc = Tr.register(class$com$ibm$xml$soapsec$enc$EncryptionSender == null ? (class$com$ibm$xml$soapsec$enc$EncryptionSender = EncryptionSender.class$("com.ibm.xml.soapsec.enc.EncryptionSender")) : class$com$ibm$xml$soapsec$enc$EncryptionSender, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private EncryptionSenderConfig fConfig;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$enc$EncryptionSender;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$enc$EncryptionRequest;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$enc$EncryptionSenderConfig;

    private Map createEncryptionSettingsToRequestsMap(Set set, EncryptionSettings encryptionSettings, Map map) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEncryptionSettingsToRequestsMap(" + set + "," + encryptionSettings + "," + map + ")");
        }
        Request[] requestArray = set.iterator();
        while (requestArray.hasNext()) {
            object = (String)requestArray.next();
            if (((String)object).equals("bodycontent")) {
                RequestPool.add(map, new EncryptionRequest(encryptionSettings));
                continue;
            }
            if (((String)object).equals("usernametoken")) continue;
            throw SoapSecurityException.format((String)"security.wssecurity.EncryptionSender.enc03", (String)object);
        }
        requestArray = RequestPool.get(map, class$com$ibm$xml$soapsec$enc$EncryptionRequest == null ? (class$com$ibm$xml$soapsec$enc$EncryptionRequest = EncryptionSender.class$("com.ibm.xml.soapsec.enc.EncryptionRequest")) : class$com$ibm$xml$soapsec$enc$EncryptionRequest);
        object = new HashMap();
        for (int i = 0; i < requestArray.length; ++i) {
            EncryptionRequest encryptionRequest = (EncryptionRequest)requestArray[i];
            EncryptionSettings encryptionSettings2 = encryptionRequest.getEncryptionSettings();
            if (!object.containsKey(encryptionSettings2)) {
                object.put(encryptionSettings2, new ArrayList());
            }
            List list = (List)object.get(encryptionSettings2);
            list.add(encryptionRequest);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEncryptionSettingsToRequestsMap(Set parts, EncryptionSettings settings, Map context) returns " + object);
        }
        return object;
    }

    private EncryptionContext createEncryptionContext(KeyLocator keyLocator, Map map) throws KeyLocatorException, NoSuchAlgorithmException, SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEncryptionContext(" + keyLocator + ")");
        }
        EncryptionContext encryptionContext = new EncryptionContext();
        encryptionContext.setAlgorithmFactory(new AlgorithmFactoryExtn());
        encryptionContext.setKeyInfoResolver((KeyInfoResolver)new KeyIdentifierKeyResolver(keyLocator, 1, map, true));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEncryptionContext(KeyLocator locator) returns " + encryptionContext);
        }
        return encryptionContext;
    }

    private boolean isKeyGenerated(EncryptionSettings encryptionSettings) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKeyGenerated(" + encryptionSettings + ")");
        }
        boolean bl2 = bl = encryptionSettings.getKeyEncryptionMethod() != null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKeyGenerated(EncryptionSettings settings) returns " + bl);
        }
        return bl;
    }

    private EncryptedData createEncryptedData(EncryptionSettings encryptionSettings, boolean bl, KeyLocator keyLocator, Document document, Object object) throws KeyLocatorException, NoSuchAlgorithmException, SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEncryptedData(" + encryptionSettings + "," + bl + "," + keyLocator + "," + document + "," + object + ")");
        }
        EncryptedData encryptedData = new EncryptedData();
        this.setEncryptionMethod((EncryptedType)encryptedData, encryptionSettings.getDataEncryptionMethod());
        if (!bl) {
            this.setKeyInfo((EncryptedType)encryptedData, encryptionSettings.getKeyName(), keyLocator, document, object);
        }
        this.setCipherData((EncryptedType)encryptedData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEncryptedData(EncryptionSettings settings, boolean keyGen, KeyLocator locator,  Document factory, Object context) returns " + encryptedData);
        }
        return encryptedData;
    }

    private void setEncryptionMethod(EncryptedType encryptedType, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEncryptionMethod(" + encryptedType + "," + string + ")");
        }
        EncryptionMethod encryptionMethod = new EncryptionMethod();
        encryptionMethod.setAlgorithm(string);
        encryptedType.setEncryptionMethod(encryptionMethod);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEncryptionMethod(EncryptedType encType, String algorithm)");
        }
    }

    private void setKeyInfo(EncryptedType encryptedType, String string, KeyLocator keyLocator, Document document, Object object) throws KeyLocatorException, NoSuchAlgorithmException, SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKeyInfo(" + encryptedType + "," + string + "," + keyLocator + "," + document + "," + object + ")");
        }
        KeyInfo keyInfo = new KeyInfo();
        KeyIdentifierKeyResolver.addKeyId(keyInfo, keyLocator, string, document, null, null, object);
        encryptedType.setKeyInfo(keyInfo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKeyInfo(EncryptedType encType, String name, KeyLocator locator, Document factory, Object context)");
        }
    }

    private void setCipherData(EncryptedType encryptedType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCipherData(" + encryptedType + ")");
        }
        CipherValue cipherValue = new CipherValue();
        CipherData cipherData = new CipherData();
        cipherData.setCipherValue(cipherValue);
        encryptedType.setCipherData(cipherData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCipherData(EncryptedType encType)");
        }
    }

    private Key generateKey(EncryptionContext encryptionContext, EncryptedData encryptedData, Document document) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, StructureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateKey(" + encryptionContext + "," + encryptedData + "," + document + ")");
        }
        encryptionContext.setEncryptedType(encryptedData.createElement(document, true), null, null, null);
        Key key = encryptionContext.generateKey();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateKey(EncryptionContext context, EncryptedData encData, Document factory) returns " + key);
        }
        return key;
    }

    private List encryptData(List list, EncryptionContext encryptionContext, EncryptedData encryptedData, Document document) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, SoapSecurityException, StructureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptData(" + list + "," + encryptionContext + "," + encryptedData + "," + document + ")");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EncryptionRequest encryptionRequest = (EncryptionRequest)iterator.next();
            String string = this.encryptData(encryptionRequest, encryptionContext, encryptedData, document);
            arrayList.add(0, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptData(List requests, EncryptionContext context, EncryptedData encData, Document doc) returns " + arrayList);
        }
        return arrayList;
    }

    private String encryptData(EncryptionRequest encryptionRequest, EncryptionContext encryptionContext, EncryptedData encryptedData, Document document) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, SoapSecurityException, StructureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptData(" + encryptionRequest + "," + encryptionContext + "," + encryptedData + "," + document + ")");
        }
        Element element = null;
        String string = "http://www.w3.org/2001/04/xmlenc#Element";
        String string2 = null;
        if (encryptionRequest.isBodyContent()) {
            NodeList nodeList = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
            if (nodeList.getLength() <= 0) {
                throw SoapSecurityException.format((String)"security.wssecurity.EncryptionSender.enc02");
            }
            element = (Element)nodeList.item(0);
            string = "http://www.w3.org/2001/04/xmlenc#Content";
        } else {
            string2 = encryptionRequest.getId();
            if (string2 != null) {
                element = new IdUtil().resolveID(document, string2);
                if (element == null) {
                    throw SoapSecurityException.format((String)"security.wssecurity.EncryptionSender.enc08", (String)string2);
                }
                if (encryptionRequest.isContentOnly()) {
                    string = "http://www.w3.org/2001/04/xmlenc#Content";
                }
            }
        }
        string2 = DOMUtil.makeUniqueId(document, "wssecurity_encryption_id_");
        encryptedData.setId(string2);
        encryptedData.setType(string);
        this.encryptData(element, encryptionContext, encryptedData.createElement(document, true));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptData(EncryptionRequest request, EncryptionContext context, EncryptedData encData, Document doc) returns " + string2);
        }
        return string2;
    }

    private void encryptData(Element element, EncryptionContext encryptionContext, Element element2) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptData(" + element + "," + encryptionContext + "," + element2 + ")");
        }
        encryptionContext.setData(element);
        encryptionContext.setEncryptedType(element2, null, null, null);
        encryptionContext.encrypt();
        encryptionContext.replace();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptData(Element elem, EncryptionContext context, Element encData)");
        }
    }

    private EncryptedKey createEncryptedKey(EncryptionSettings encryptionSettings, KeyLocator keyLocator, Document document, List list, Object object) throws KeyLocatorException, NoSuchAlgorithmException, SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEncryptedKey(" + encryptionSettings + "," + keyLocator + "," + document + "," + list + "," + object + ")");
        }
        EncryptedKey encryptedKey = new EncryptedKey();
        this.setEncryptionMethod((EncryptedType)encryptedKey, encryptionSettings.getKeyEncryptionMethod());
        this.setKeyInfo((EncryptedType)encryptedKey, encryptionSettings.getKeyName(), keyLocator, document, object);
        this.setCipherData((EncryptedType)encryptedKey);
        encryptedKey.setReferenceList(this.createReferenceList(list));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEncryptedKey(EncryptionSettings settings, KeyLocator locator, Document factory, List ids, Object context) returns " + encryptedKey);
        }
        return encryptedKey;
    }

    private void encryptKey(Key key, EncryptionContext encryptionContext, Element element) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptKey(" + key + "," + encryptionContext + "," + element + ")");
        }
        encryptionContext.setData(key);
        encryptionContext.setEncryptedType(element, null, null, null);
        encryptionContext.encrypt();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptKey(Key key, EncryptionContext context, Element encKey)");
        }
    }

    private ReferenceList createReferenceList(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createReferenceList(" + list + ")");
        }
        ReferenceList referenceList = new ReferenceList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            DataReference dataReference = new DataReference();
            dataReference.setURI("#" + string);
            referenceList.addDataReference(dataReference);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createReferenceList(List ids) returns " + referenceList);
        }
        return referenceList;
    }

    public void init(Map map) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(" + map + ")");
        }
        this.fConfig = (EncryptionSenderConfig)map.get(class$com$ibm$xml$soapsec$enc$EncryptionSenderConfig == null ? (class$com$ibm$xml$soapsec$enc$EncryptionSenderConfig = EncryptionSender.class$("com.ibm.xml.soapsec.enc.EncryptionSenderConfig")) : class$com$ibm$xml$soapsec$enc$EncryptionSenderConfig);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public void invoke(Document document, Element element, Map map) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + document + "," + element + "," + map + ")");
        }
        Map map2 = map;
        Set set = this.fConfig.getConfidentialParts();
        EncryptionSettings encryptionSettings = this.fConfig.getEncryptionSettings();
        Map map3 = this.createEncryptionSettingsToRequestsMap(set, encryptionSettings, map);
        KeyLocator keyLocator = encryptionSettings.getKeyLocator();
        EncryptionContext encryptionContext = this.createEncryptionContext(keyLocator, map);
        if (map3.containsKey(encryptionSettings)) {
            boolean bl = this.isKeyGenerated(encryptionSettings);
            EncryptedData encryptedData = this.createEncryptedData(encryptionSettings, bl, keyLocator, document, map2);
            encryptionContext.setKey(null);
            Key key = null;
            if (bl) {
                key = this.generateKey(encryptionContext, encryptedData, document);
            }
            List list = (List)map3.get(encryptionSettings);
            List list2 = this.encryptData(list, encryptionContext, encryptedData, document);
            Element element2 = null;
            if (bl) {
                EncryptedKey encryptedKey = this.createEncryptedKey(encryptionSettings, keyLocator, document, list2, map2);
                element2 = encryptedKey.createElement(document, true);
                encryptionContext.setKey(null);
                this.encryptKey(key, encryptionContext, element2);
            } else {
                ReferenceList referenceList = this.createReferenceList(list2);
                element2 = referenceList.createElement(document, true);
            }
            element.insertBefore(element2, element.getFirstChild());
            element.insertBefore(document.createTextNode("\n      "), element2);
            DOMUtil.indent(element2, 6, 2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target, Map context)");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

